<?php

function GetVer() {
	global $script_version;
	return $script_version;
}

function Getinfo() {
	global $use_mysql, $mysql_charset;
	global $script_version;
	
	$result .= "MLM version: " . GetVer() . "<br>";
	$result .= "<br>";
	
	$result .= "PHP version: " . phpversion();
	
	if( ini_get('safe_mode') ) {
		$result .= " (Safe mode ON)" . "<br>";
	} else {
		$result .= " (Safe mode OFF)" . "<br>";
	}
	
	$result .= " max_execution_time  = " . ini_get('max_execution_time') . " seconds" . "<br>";  // Maximum execution time of each script, in seconds	
	$result .= " max_input_time      = " . ini_get('max_input_time') . " seconds" . "<br>";      // Maximum amount of time each script may spend parsing request data
	$result .= " memory_limit        = " . ini_get('memory_limit') . "<br>";                     // Maximum amount of memory a script may consume  
	$result .= " post_max_size       = " . ini_get('post_max_size') . "<br>";                    // Maximum size of POST data that PHP will accept.
	$result .= " upload_max_filesize = " . ini_get('upload_max_filesize') . "<br>";              // Maximum allowed size for uploaded files.
	
	$result .= " display_errors      = " . ini_get('display_errors') . "<br>";
	$result .= ' register_globals    = ' . ini_get('register_globals') . "<br>";
	
	$result .= "<br>";
	
	if ( $use_mysql == 1 ) {
	
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result .= "mySQL Host: " . mysql_get_host_info() . "<br>";
			$result .= "mySQL Server: " . mysql_get_server_info() . "<br>";
			$result .= "mySQL Client: " . mysql_get_client_info() . "<br>";
			$result .= "mySQL Protocol: " . mysql_get_proto_info() . "<br>";
			$result .= "mySQL Charset: " . $mysql_charset . "<br>";
		} else {
		 	// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = -1;
		}
		// ***** MYSQL STUFF HERE *****
		
	} else {
	
	}
	
	return $result;
}

function RemoveAll() {
	global $mlm_err, $use_mysql;
	global $path_to_lists, $path_to_requests, $path_to_mailqueue, $path_to_sqlqueue, $path_to_uploads;
	global $path_to_offlists, $path_to_traffic, $path_by_delivery, $path_by_recipient, $path_to_imports;
	global $path_to_templates;
	
	$result = true;
	
	if ( $use_mysql == 1 ) {
	
		// ***** MYSQL STUFF HERE *****
		$result = $result && RemoveDBTable( $tbname ) && RemoveDBTable( $tbname_req ) && RemoveDBTable( $tbname_off ) && RemoveDBTable( $tbname_clk );
		// ***** MYSQL STUFF HERE *****

	}
	
	if ( file_exists( $path_to_lists) ) { $result = $result && DeleteDirectory( $path_to_lists ); }
	if ( file_exists( $path_to_sqlqueue) ) { $result = $result && DeleteDirectory( $path_to_sqlqueue ); }
	if ( file_exists( $path_to_requests) ) { $result = $result && DeleteDirectory( $path_to_requests ); }
	if ( file_exists( $path_to_mailqueue) ) { $result = $result && DeleteDirectory( $path_to_mailqueue ); }
	if ( file_exists( $path_to_uploads) ) { $result = $result && DeleteDirectory( $path_to_uploads ); }
	
	if ( file_exists( $path_to_offlists) ) { $result = $result && DeleteDirectory( $path_to_offlists ); }
	if ( file_exists( $path_to_traffic) ) { $result = $result && DeleteDirectory( $path_to_traffic ); }
	if ( file_exists( $path_by_delivery) ) { $result = $result && DeleteDirectory( $path_by_delivery ); }
	if ( file_exists( $path_by_recipient) ) { $result = $result && DeleteDirectory( $path_by_recipient ); }
	if ( file_exists( $path_to_imports) ) { $result = $result && DeleteDirectory( $path_to_imports ); }
	//if ( file_exists( $path_to_templates) ) { $result = $result && DeleteDirectory( $path_to_templates ); } // <- Not allowed
	
	if ( $result == False ) { $mlm_err = "Error deleting MLM files/folders"; }
	
	return $result;
}

function UploadList() {
	global $path_to_uploads;
	global $upload_Name, $upload_Size, $upload_Temp, $upload_Mime_Type;

	CreateDirectory( $path_to_uploads );
	
	$uploadFile = $path_to_uploads . "/" . $upload_Name ;
	@chmod( dirname( $uploadFile ), 0777 );
	@move_uploaded_file( $upload_Temp , $uploadFile ); 
	@chmod( $uploadFile, 0644 );
	
	return ImportList( $uploadFile );

}

function ImportList( $filepath ) {
	global $use_mysql, $path_to_lists, $list, $dbname, $tbname, $mysql_link, $action;
	global $admin_name_full, $admin_address, $admin_err_addr;
	global $allowdups;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";

	$added = 0;
	$dup   = 0;
	$bad   = 0;

	$contents  = LoadFileContentsAsText( $filepath );
	$contents  = ReplaceLineEndings( $contents );
	$separator = "";
	
	$data = explode( "\n", $contents );
	
	if ( $use_mysql == 1 ) {	
		if ( ConnectToMySqlServer() ) {
			if ( $res = @mysql_select_db ( $dbname ) ) {

				switch ($action) {
				case "overwrite":
					$deletedrows = RemoveListFromDB();
					//SendMessage( $admin_err_addr, "[MLM] Deleted rows = $deletedrows", $deletedrows, $headers, "" );
					$query_insert_fields = "INSERT INTO `$tbname` ( `fld_list`, `fld_firstname`, `fld_lastname`, `fld_company`, `fld_email`,
					`fld_opt1`, `fld_opt2`, `fld_opt3`, `fld_opt4`, `fld_opt5`, `fld_opt6`, `fld_opt7`, `fld_opt8`, `fld_opt9`, `fld_opt10`,
					`fld_opt11`, `fld_opt12`, `fld_opt13`, `fld_opt14`, `fld_opt15`, `fld_opt16`, `fld_opt17`, `fld_opt18`, `fld_opt19`, `fld_opt20` )
					VALUES
					";
					break;
				case "append":
					$DupCheckTable = CreateDuplicateCheckerArray( $dbname, $tbname, $list );
					//SendMessage( $admin_err_addr, "[MLM] Dup Table", implode("\n", $DupCheckTable), $headers, "" );
					$query_insert_fields = "INSERT INTO `$tbname` ( `fld_list`, `fld_firstname`, `fld_lastname`, `fld_company`, `fld_email`,
					`fld_opt1`, `fld_opt2`, `fld_opt3`, `fld_opt4`, `fld_opt5`, `fld_opt6`, `fld_opt7`, `fld_opt8`, `fld_opt9`, `fld_opt10`,
					`fld_opt11`, `fld_opt12`, `fld_opt13`, `fld_opt14`, `fld_opt15`, `fld_opt16`, `fld_opt17`, `fld_opt18`, `fld_opt19`, `fld_opt20` )
					VALUES
					";
					break;
				case "delete":
					$query_delete_records = "DELETE LOW_PRIORITY FROM `$tbname` WHERE";
					break;
				case "unsubscribe":
					$query_unsub_records = "UPDATE `$tbname` SET `fld_sub` = '0' WHERE";
					break;
				case "update":
					// Do nothing
					break;				
				case "invite":
					// Do nothing
					break;
				}
			
				$count_before = GetListSizeDB( $list );

				while ( list ( $line_num, $line ) = each ( $data ) ) { // while there are elements in the array
							
					$line  = str_replace( "\n", "", $line );

					if ( $separator == "" ) {
						if ( strstr( $line, "\t" ) ) {
							$separator = "\t";
						} else if ( strstr( $line, "," ) ) {
							$separator = ",";
						} else if ( strstr( $line, ":" ) ) {
							$separator = ":";
						} else if ( strstr( $line, ";" ) ) {
							$separator = ";";
						} else {
							$separator = "\t";
						}
					}
					
					$field = explode( $separator, $line );
					$field = str_replace( '"', '', $field );

					if ( isEmailValid( $field[3] ) ) {
						$emailcol = 3;
					} else if ( isEmailValid( $field[2] ) ) { 
						$emailcol = 2;
					} else if ( isEmailValid( $field[1] ) ) { 	
						$emailcol = 1;
					} else if ( isEmailValid( $field[0] ) ) { 
						$emailcol = 0;
					} else {
						$emailcol = 3;
					}

					if ( !isEmailValid( $field[$emailcol] ) ) { 
									
						if ( trim( $field[$emailcol] ) <> "" ) {
							$bad++;
							if ( $thebadones <> "" ) { $thebadones .= "<BR>"; }
							$thebadones .= $field[$emailcol];
						}
						
					} else {
						
						if ( $emailcol == 3 ) {
							$firstname = mysql_real_escape_string( $field[0] );
							$lastname  = mysql_real_escape_string( $field[1] );
							$company   = mysql_real_escape_string( $field[2] );
							$email     = strtolower( mysql_real_escape_string( $field[3] ) );
							$opt1      = mysql_real_escape_string( $field[4] );
							$opt2      = mysql_real_escape_string( $field[5] );
							$opt3      = mysql_real_escape_string( $field[6] );
							$opt4      = mysql_real_escape_string( $field[7] );
							$opt5      = mysql_real_escape_string( $field[8] );
							$opt6      = mysql_real_escape_string( $field[9] );
							$opt7      = mysql_real_escape_string( $field[10] );
							$opt8      = mysql_real_escape_string( $field[11] );
							$opt9      = mysql_real_escape_string( $field[12] );
							$opt10     = mysql_real_escape_string( $field[13] );
							$opt11     = mysql_real_escape_string( $field[14] );
							$opt12     = mysql_real_escape_string( $field[15] );
							$opt13     = mysql_real_escape_string( $field[16] );
							$opt14     = mysql_real_escape_string( $field[17] );
							$opt15     = mysql_real_escape_string( $field[18] );
							$opt16     = mysql_real_escape_string( $field[19] );
							$opt17     = mysql_real_escape_string( $field[20] );
							$opt18     = mysql_real_escape_string( $field[21] );
							$opt19     = mysql_real_escape_string( $field[22] );
							$opt20     = mysql_real_escape_string( $field[23] );
						} else if ( $emailcol == 2 ) {
							$firstname = mysql_real_escape_string( $field[0] );
							$lastname  = mysql_real_escape_string( $field[1] );
							$company   = "";
							$email     = strtolower( mysql_real_escape_string( $field[2] ) );
							$opt1 = $opt2 = $opt3 = $opt4 = $opt5 = $opt6 = $opt7 = $opt8 = $opt9 = $opt10 = "";
							$opt11 = $opt12 = $opt13 = $opt14 = $opt15 = $opt16 = $opt17 = $opt18 = $opt19 = $opt20 = "";
						} else if ( $emailcol == 1 ) {
							$firstname = mysql_real_escape_string( $field[0] );
							$lastname  = $company = "";
							$email     = strtolower( mysql_real_escape_string( $field[1] ) );				
							$opt1 = $opt2 = $opt3 = $opt4 = $opt5 = $opt6 = $opt7 = $opt8 = $opt9 = $opt10 = "";
							$opt11 = $opt12 = $opt13 = $opt14 = $opt15 = $opt16 = $opt17 = $opt18 = $opt19 = $opt20 = "";
						} else if ( $emailcol == 0 ) {
							$firstname = $lastname = $company = "";
							$email     = strtolower( mysql_real_escape_string( $field[0] ) );
							$opt1 = $opt2 = $opt3 = $opt4 = $opt5 = $opt6 = $opt7 = $opt8 = $opt9 = $opt10 = "";
							$opt11 = $opt12 = $opt13 = $opt14 = $opt15 = $opt16 = $opt17 = $opt18 = $opt19 = $opt20 = "";
						}
						
						if ( $action == "********" ) {
							// Alternative switch for testing
						} else {
							$singlelist = explode( ";", $list );	
							foreach ( $singlelist as $mylist ) {
								$mylist = mysql_real_escape_string( $mylist );

								switch ($action) {
								case "overwrite":
									if ( $query_insert_values != "" ) { $query_insert_values .= ",\n"; }
									$query_insert_values .= "( '$mylist', '$firstname', '$lastname', '$company', '$email', '$opt1', '$opt2', '$opt3', '$opt4', '$opt5', '$opt6', '$opt7', '$opt8', '$opt9', '$opt10', '$opt11', '$opt12', '$opt13', '$opt14', '$opt15', '$opt16', '$opt17', '$opt18', '$opt19', '$opt20' )";
									break;
								case "append":
									if ( $allowdups || !in_array( strtolower( $mylist . $email ), $DupCheckTable ) ) {
										if ( $query_insert_values != "" ) { $query_insert_values .= ",\n"; }
										$query_insert_values .= "( '$mylist', '$firstname', '$lastname', '$company', '$email', '$opt1', '$opt2', '$opt3', '$opt4', '$opt5', '$opt6', '$opt7', '$opt8', '$opt9', '$opt10', '$opt11', '$opt12', '$opt13', '$opt14', '$opt15', '$opt16', '$opt17', '$opt18', '$opt19', '$opt20' )";
									//} else if ( in_array( strtolower( $mylist . $email ), $DupCheckTable ) ) {
									//	$query = "UPDATE `$tbname` SET `fld_sub` = '1', `fld_firstname` = '$firstname', `fld_lastname` = '$lastname', `fld_company` = '$company'
									//			  WHERE `fld_list` = '$mylist' AND `fld_email` = '$email' AND `fld_sub` = '0'";
									} else {
										$dup++;
									}
									break;
								case "delete":
									if ( $query_delete_values != "" ) { $query_delete_values .= "\nOR "; }
									$query_delete_values .= "( `fld_list` = '$mylist' AND `fld_email` = '$email' )";
									break;
								case "unsubscribe":
									if ( $query_unsub_values != "" ) { $query_unsub_values .= "\nOR "; }
									$query_unsub_values .= "( `fld_list` = '$mylist' AND `fld_email` = '$email' AND `fld_sub` = '1' )";
									break;
								case "update":
									$query = "UPDATE `$tbname` SET `fld_firstname` = '$firstname', `fld_lastname` = '$lastname', `fld_company` = '$company',
											  `fld_opt1` = '$opt1', `fld_opt2` = '$opt2', `fld_opt3` = '$opt3', `fld_opt4` = '$opt4', `fld_opt5` = '$opt5',
											  `fld_opt6` = '$opt6', `fld_opt7` = '$opt7', `fld_opt8` = '$opt8', `fld_opt9` = '$opt9', `fld_opt10` = '$opt10',
											  `fld_opt11` = '$opt11', `fld_opt12` = '$opt12', `fld_opt13` = '$opt13', `fld_opt14` = '$opt14', `fld_opt15` = '$opt15',
											  `fld_opt16` = '$opt16', `fld_opt17` = '$opt17', `fld_opt18` = '$opt18', `fld_opt19` = '$opt19', `fld_opt20` = '$opt20'
											 WHERE `fld_list` = '$mylist' AND `fld_email` = '$email'";		 
									if ( $query != "" ) {
										if ( $res = @mysql_db_query( $dbname, $query ) ) {
											$result = true;
											$added++;
										} else {
											//SendMessage( $admin_err_addr, "[MLM] Query error", $query, $headers, "" );
											if ( !mysql_ping( $mysql_link ) ) { ConnectToMySqlServer(); }									
											CreateListTable();
											if ( $res = @mysql_db_query( $dbname, $query ) ) {
												$result = true;
												$added++;
											}	
										//} else {
										//	$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
										//	SendMessage( $admin_err_addr, "[MLM] Error updating record from ImportList()", $mysql_err . "\r" . $query, $headers, "" );
										//	$temp = $list;
										//	$list = $mylist;
										//	SaveMySQLRecord();
										//	$list = $temp;			
										}
									}	 
									break;							
								case "invite":
									if ( $allowdups || !in_array( strtolower( $mylist . $email ), $DupCheckTable ) ) {
										$reqref = GetUniqueReference();
										if ( SaveInvitationRequest( $reqref, $mylist, $field ) ) {
											SendInvitationMessage( $reqref, $mylist, $firstname, $lastname, $email );
											$added++; // In this case -> sended
										}
									} else {
										$dup++;
									}
									break;
								}
							}
						}
					}
				}
				
				switch ($action) {
				case "overwrite":
					if ( $query_insert_values != "" ) { $query = $query_insert_fields . $query_insert_values . ";";	} else { $query = ""; }	
					//SendMessage( $admin_err_addr, "[MLM] Query (Overwrite)", $query, $headers, "" );
					break;
				case "append":
					if ( $query_insert_values != "" ) { $query = $query_insert_fields . $query_insert_values . ";";	} else { $query = ""; }		
					//SendMessage( $admin_err_addr, "[MLM] Query (Append)", $query, $headers, "" );
					break;
				case "delete":
					if ( $query_delete_values != "" ) { $query = $query_delete_records . "\n" . $query_delete_values; } else { $query = ""; }	
					//SendMessage( $admin_err_addr, "[MLM] Query (Delete)", $query, $headers, "" );
					break;
				case "unsubscribe":
					if ( $query_unsub_values != "" ) { $query = $query_unsub_records . "\n" . $query_unsub_values; } else { $query = ""; }	
					//SendMessage( $admin_err_addr, "[MLM] Query (Unsubscribe)", $query, $headers, "" );
					break;
				case "update":
					// Do nothing
					break;
				case "invite":
					// Do nothing
					break;
				}
				
				if ( $query != "" && ( $action == "overwrite" || $action == "append" || $action == "delete"  || $action == "unsubscribe" ) ) {
					if ( $res = @mysql_db_query( $dbname, $query ) ) {
						$result = true;
					} else {
						//SendMessage( $admin_err_addr, "[MLM] Query error", $query, $headers, "" );
						if ( !mysql_ping( $mysql_link ) ) { ConnectToMySqlServer(); }									
						CreateListTable();
						if ( $res = @mysql_db_query( $dbname, $query ) ) {
							$result = true;
						}	
					//} else {
					//	$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					//	SendMessage( $admin_err_addr, "[MLM] Error inserting/updating record from ImportList()", $mysql_err . "\r" . $query, $headers, "" );
					//	$temp = $list;
					//	$list = $mylist;
					//	SaveMySQLRecord();
					//	$list = $temp;			
					}
					
					$count_after = GetListSizeDB( $list );
					$count_diff  = $count_after - $count_before;
					if ( $count_diff < 0 ) { $deleted = abs( $count_diff ); }
					if ( $count_diff > 0 ) { $added = abs( $count_diff ); }
				}

				CloseConnectionToMySqlServer();
				
			} else {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				//SendMessage( $admin_err_addr, "[MLM] Error selecting database from ImportList()", $mysql_err, $headers, "" );
				SaveMySQLRecord();
			}
		} else {	
			//SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error from ImportList()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
			//SaveMySQLRecord();
		}
	
	} else {
	
		if ( $action == "overwrite" ) { $deletedrows = RemoveList( $list ); }
		while ( list ( $line_num, $line ) = each ( $data ) ) { // while there are elements in the array
					
			$line  = str_replace( "\n", "", $line );
			$field = explode( "\t", $line );
		
			if ( isEmailValid( strtolower( $field[3] ) ) ) {
				$record  = $field[0] . "\t" . $field[1] . "\t" . $field[2] . "\t" . strtolower( $field[3] ) . "\t";
				$record .= $field[4] . "\t" . $field[5] . "\t" . $field[6] . "\t" . $field[7] . "\t" . $field[8] . "\t";
				$record .= $field[9] . "\t" . $field[10] . "\t" . $field[11] . "\t" . $field[12] . "\t" . $field[13] . "\t";
				$record .= $field[14] . "\t" . $field[15] . "\t" . $field[16] . "\t" . $field[17] . "\t" . $field[18] . "\t";
				$record .= $field[19] . "\t" . $field[20] . "\t" . $field[21] . "\t" . $field[22] . "\t" . $field[23] . "\t";
				$record .= $list . "\n";
				
				if ( $action == "delete" ) { $deletedrows = RemoveEmailFromList( $list, $field[3] ); }

				if ( $action == "delete" ) {
					$deleted = $deleted + $deletedrows;
				} else {
					$singlelist = explode( ";", $list );	
					foreach ( $singlelist as $mylist ) {
						if ( $allowdups || !email_exists( $mylist, $field[3] ) ) {
							if ( $action == "invite" ) {
								$reqref = GetUniqueReference();
								if ( SaveInvitationRequest( $reqref, $mylist, $field ) ) {
									SendInvitationMessage( $reqref, $mylist, $firstname, $lastname, $email );
									$added++; // In this case -> sended
								}
							} else if ( $action == "update" ) {
								$counter = UpdateRecordFromListFile( $mylist, strtolower( $field[3] ), $record );
								If ( $counter <> -1 ) { $added++; } else { $bad++; }
							} else {
								AddRecordToListFile( $mylist, $field[3], $record );
								$added++;
							}
						} else {
							$dup++;
						}
					}
				}
			} else {
				if ( trim( $field[3] ) <> "" ) {
					$bad++;
					if ( $thebadones <> "" ) { $thebadones .= "<BR>"; }
					$thebadones .= $field[3];
				}
			}
		}
	}
	
	//$result = array();
	//if ( $action == "delete" ) { $result[0] = $deleted; } else { $result[0] = $added; }
	//$result[1] = $dup;
	//$result[2] = $bad;
	//$result[3] = $thebadones;
	
	if ( $action == "delete" ) { 
		$result = "$deleted\t$dup\t$bad\t$thebadones";
	} else {
		$result = "$added\t$dup\t$bad\t$thebadones";
	}
	
	return $result;
}

// Return an array containing the data from selected list in mySQL server
function CreateDuplicateCheckerArray( $dbname, $tbname, $lists ) {
	global $mysql_err, $mysql_link;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	$data = array();
		
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			if ( !TableExists( $tbname ) ) { CreateListTable(); }
			if ( !TableExists( $tbname ) ) {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return False; // Error creating table
			} else {
				$singlelist = explode( ";", $lists );	
				foreach ( $singlelist as $mylist ) {
					if ( $mylist <> "" ) {
						$mylist = mysql_real_escape_string( $mylist );
						if ( strlen( $thelists ) == 0 ) {
							$thelists = "`fld_list` = '$mylist'";
						} else {
							$thelists .= " OR `fld_list` = '$mylist'";
						}
					}
				}
				
				$query = "SELECT CONCAT( `fld_list`, `fld_email` ) FROM `$tbname` WHERE ( $thelists )";// ORDER BY UCASE(`fld_list`), UCASE(`fld_email`)"; //AND `fld_sub` = '1' 

				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count > 0 ) {
						for ( $j = 0; $j < $count; $j++ ) {
			 				$row = @mysql_fetch_array( $res );
			 				$data[] = strtolower( mysql_real_escape_string( $row[0] ) );
			 			}
					}
					//SendMessage( $admin_err_addr, "[MLM] CreateDuplicateCheckerArray() result", $query . "\n\n" . implode("\n", $data) . "\n\n" . $count, $headers, "" );
					return $data;
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					//SendMessage( $admin_err_addr, "[MLM] Querry Error in CreateDuplicateCheckerArray()", @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
					return -1; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			//SendMessage( $admin_err_addr, "[MLM] Error selecting DB table in CreateDuplicateCheckerArray()", @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
			return -1; // Error selecting the database
		}
	} else {
		$mysql_err = "mySQL server connection error";
		//SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error in CreateDuplicateCheckerArray()", @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
		return -1; // Error connecting to the mySQL server
	}
}

function ImportLists() {
	global $path_to_imports;
	
	if ( $handle = @opendir( $path_to_imports ) ) {
		while ( false !== ( $file = readdir( $handle ) ) ) {
			if ( $file != ".." && $file != "." && $file != ".htaccess" && $file != "index.html" ) {
				
				$filepath = $path_to_imports . "/" . $file;
				list( $added, $dup, $bad, $thebadones ) = ImportList( $filepath );
				
				$total_added = + $added;
				$total_dup   = + $dup;
				$total_bad   = + $bad;
				$total_thebadones .= $field[3];
				
				@unlink( $filepath ); // <- Doesn't work because of permissions

			}
		}
		closedir( $handle );
	} else {
		$result = -1; // ERROR: Handle not valid
	}

	//$result = array();
	//$result[0] = $total_added;
	//$result[1] = $total_dup;
	//$result[2] = $total_bad;
	//$result[3] = $total_thebadones;
	$result = "$total_added\t$total_dup\t$total_bad\t$total_thebadones";
	return $result;
}

function SendInvitationMessage( $reference, $list, $firstname, $lastname, $email ) {
	global $admin_address, $path_to_script, $cmd;
	global $admin_name_full, $admin_webAddress, $script_name, $script_version;
	global $msg, $sub, $emailencoding;
	
	$url = $path_to_script . "?cmd=confirm&key=" . $reference;
	
	$listfordisplay = formatlistnames( $list );
	
	$subject = $sub;
	$message = $msg;
	$message = str_replace( "[LIST]", $listfordisplay, $message );
	$message = str_replace( "[FIRSTNAME]", $firstname, $message );
	$message = str_replace( "[LASTNAME]", $lastname, $message );
	$message = str_replace( "[EMAIL]", $email, $message );
	$message = str_replace( "[CONFIRM_URL]", $url, $message );
	$message = str_replace( "[SIGNATURE]", "$admin_name_full\n$admin_webAddress\n$script_name $script_version", $message );
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	
	SendMessage( $email, $subject, $message, $headers, $emailencoding );
		
}

// Save Invitation request - WARNING - Similar to SaveRequest() below!
function SaveInvitationRequest( $reference, $list, $field ) {
	global $use_mysql, $path_to_requests, $writebom;
	
	if ( $use_mysql == 1 ) {
	
		// ***** MYSQL STUFF HERE *****
		$result = SaveInvitationRequestToDB( $reference, $list, $field );
		// ***** MYSQL STUFF HERE *****
		
	} else {
	
		CreateDirectory( $path_to_requests );
		
		$result   = false;	
		$filename = "$path_to_requests" . "/" . $reference . ".txt";
		$handle   = @fopen( $filename, "a+" );
		
		If( $handle ) {
			if ( $writebom ) { $contents = $utf8_bom; } else { $contents = ""; }
			$contents .= "<cmd>subscribe</cmd>\n";
			$contents .= "<list>$list</list>\n";
			$contents .= "<firstname>$field[0]</firstname>\n";
			$contents .= "<lastname>$field[1]</lastname>\n";
			$contents .= "<company>$field[2]</company>\n";
			$contents .= "<email>$field[3]</email>\n";
			$contents .= "<opt1>$field[4]</opt1>\n";
			$contents .= "<opt2>$field[5]</opt2>\n";
			$contents .= "<opt3>$field[6]</opt3>\n";
			$contents .= "<opt4>$field[7]</opt4>\n";
			$contents .= "<opt5>$field[8]</opt5>\n";
			$contents .= "<opt6>$field[9]</opt6>\n";
			$contents .= "<opt7>$field[10]</opt7>\n";
			$contents .= "<opt8>$field[11]</opt8>\n";
			$contents .= "<opt9>$field[12]</opt9>\n";
			$contents .= "<opt10>$field[13]</opt10>\n";
			$contents .= "<opt11>$field[14]</opt11>\n";
			$contents .= "<opt12>$field[15]</opt12>\n";
			$contents .= "<opt13>$field[16]</opt13>\n";
			$contents .= "<opt14>$field[17]</opt14>\n";
			$contents .= "<opt15>$field[18]</opt15>\n";
			$contents .= "<opt16>$field[19]</opt16>\n";
			$contents .= "<opt17>$field[20]</opt17>\n";
			$contents .= "<opt18>$field[21]</opt18>\n";
			$contents .= "<opt19>$field[22]</opt19>\n";
			$contents .= "<opt20>$field[23]</opt20>\n";		
			if ( @fwrite( $handle, $contents ) === false ) {
				$mlm_err = "Impossible to save request likely because the $path_to_requests folder has wrong permissions, should be 0777";
				$result = false;
			} else {
				$mlm_err = "";
				$result = true;
			}
			@fclose( $handle );
		} else {
			// ERROR: Handle not valid
			$mlm_err = "Impossible to save request likely because the $path_to_requests folder has wrong permissions, should be 0777";
			$result = false;
		}
	}
	return $result;
}

//******************************************************************************************************************************<REQUEST_HANDLING>

// Save request - WARNING - Similar to SaveInvitationRequest() above!
function SaveRequest( $reference ) {
	global $mlm_err, $use_mysql, $path_to_requests, $cmd, $list, $writebom;
	global $firstname, $lastname, $company, $email;
	global $opt1, $opt2, $opt3, $opt4, $opt5, $opt6, $opt7, $opt8, $opt9, $opt10;
	global $opt11, $opt12, $opt13, $opt14, $opt15, $opt16, $opt17, $opt18, $opt19, $opt20;
	
	if ( $use_mysql == 1 ) {
	
		// ***** MYSQL STUFF HERE *****
		$result = SaveRequestToDB( $reference );
		// ***** MYSQL STUFF HERE *****
		
	} else {
	
		CreateDirectory( $path_to_requests );
		
		$result   = false;	
		$filename = "$path_to_requests" . "/" . $reference . ".txt";
		$handle   = @fopen( $filename, "a+" );
		
		If( $handle ) {
			if ( $writebom ) { $contents = $utf8_bom; } else { $contents = ""; }
			$contents .= "<cmd>$cmd</cmd>\n";
			$contents .= "<list>$list</list>\n";
			$contents .= "<firstname>$firstname</firstname>\n";
			$contents .= "<lastname>$lastname</lastname>\n";
			$contents .= "<company>$company</company>\n";
			$contents .= "<email>$email</email>\n";
			$contents .= "<opt1>$opt1</opt1>\n";
			$contents .= "<opt2>$opt2</opt2>\n";
			$contents .= "<opt3>$opt3</opt3>\n";
			$contents .= "<opt4>$opt4</opt4>\n";
			$contents .= "<opt5>$opt5</opt5>\n";
			$contents .= "<opt6>$opt6</opt6>\n";
			$contents .= "<opt7>$opt7</opt7>\n";
			$contents .= "<opt8>$opt8</opt8>\n";
			$contents .= "<opt9>$opt9</opt9>\n";
			$contents .= "<opt10>$opt10</opt10>\n";
			$contents .= "<opt11>$opt11</opt11>\n";
			$contents .= "<opt12>$opt12</opt12>\n";
			$contents .= "<opt13>$opt13</opt13>\n";
			$contents .= "<opt14>$opt14</opt14>\n";
			$contents .= "<opt15>$opt15</opt15>\n";
			$contents .= "<opt16>$opt16</opt16>\n";
			$contents .= "<opt17>$opt17</opt17>\n";
			$contents .= "<opt18>$opt18</opt18>\n";
			$contents .= "<opt19>$opt19</opt19>\n";
			$contents .= "<opt20>$opt20</opt20>\n";		
			if ( @fwrite( $handle, $contents ) === false ) {
				$mlm_err = "Impossible to save request likely because the $path_to_requests folder has wrong permissions, should be 0777";
				$result = false;
			} else {
				$mlm_err = "";
				$result = true;
			}
			@fclose( $handle );
		} else {
			// ERROR: Handle not valid
			$mlm_err = "Impossible to save request likely because the $path_to_requests folder has wrong permissions, should be 0777";
			$result = false;
		}
	}
	return $result;
}

function SendRequestMessage( $reference ) {
	global $msg_subscribe, $admin_address, $path_to_script, $cmd, $list, $listfordisplay;
	global $admin_name_full, $admin_webAddress, $script_name, $script_version;
	global $firstname, $lastname, $company, $email, $emailencoding, $dec_quotes, $dec_charset;
	global $kTxt_emailsubject_coi, $lang;
	
	$url = $path_to_script . "?cmd=confirm&key=" . $reference . "&lang=" . $lang;
	
	$listfordisplay = formatlistnames( $list );
	
	$subject = @html_entity_decode( $kTxt_emailsubject_coi[$lang], $dec_quotes, $dec_charset );
	$message = $msg_subscribe;
	$message = str_replace( "[LIST]", $listfordisplay, $message );
	$message = str_replace( "[FIRSTNAME]", $firstname, $message );
	$message = str_replace( "[LASTNAME]", $lastname, $message );
	$message = str_replace( "[EMAIL]", $email, $message );
	$message = str_replace( "[CONFIRM_URL]", $url, $message );
	$message = str_replace( "[SIGNATURE]", "$admin_name_full\n$admin_webAddress\n$script_name $script_version", $message );
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	
	SendMessage( $email, $subject, $message, $headers, $emailencoding );
		
}

// Create a unique reference for requests
function GetUniqueReference() {
	global $use_mysql, $path_to_requests;
	
	$table = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	$text  = substr($table, rand(0, 25), 1) . substr($table, rand(0, 25), 1) . substr($table, rand(0, 25), 1);
	$text .= substr($table, rand(0, 25), 1) . substr($table, rand(0, 25), 1) . substr($table, rand(0, 25), 1);
	$reference = WordScramble( strtoupper( $text . date( 'YmdHis' ) ) );
	$counter = 0;
	
	if ( $use_mysql == 1 ) {
		while ( RequestExistsInDB( $reference . $counter ) ) {
			$counter++;
		}
		$result = $reference . $counter;
	} else {
		CreateDirectory( $path_to_requests );
		while ( file_exists( $path_to_requests . "/" . $reference . $counter . ".txt" ) ) {
			$counter++;
		}
		$result = $reference . $counter;
	}
	return $result;
}

// Check if the subscription request exists
function RequestIsValid( $reference ) {
	global $use_mysql, $path_to_requests;
	
	if ( $use_mysql == 1 ) {
	
		// ***** MYSQL STUFF HERE *****
		$result = RequestExistsInDB( $reference );
		// ***** MYSQL STUFF HERE *****
		
	} else {	
		If ( file_exists( $path_to_requests . "/" . $reference . ".txt") ) {
			$result = true;
		} else {
			$result = false;
		}	
	}	
	return $result;
}

//******************************************************************************************************************************<LIST_HANDLING>

// Create the List file
function CreateList( $lists ) {
	global $mlm_err, $use_mysql, $path_to_lists, $ext_list;
	global $ext_list_in, $ext_list_out, $ext_list_lock;
	
	if ( $use_mysql == 1 ) {
	
		// ***** MYSQL STUFF HERE *****
		$result = CreateListTable();
		// ***** MYSQL STUFF HERE *****
		
	} else {
		$singlelist = explode( ";", $lists );	
		foreach ( $singlelist as $mylist ) {
			$result = true;
		
			$filepath = $path_to_lists . "/" . $mylist . $ext_list;	
			if ( !file_exists( $filepath ) ) {
				$handle = @fopen( $filepath, "a+" );
				if ( $handle ) { 
					if ( $writebom ) { @fwrite( $handle, $utf8_bom ); }
					@fclose( $handle );
				} else {
					$mlm_err = "Error opening $filepath";
					$result = false;
				}
			}
			
			if ( $result ) {
			
				$filepath = $path_to_lists . "/" . $mylist . $ext_list_in;	
				if ( !file_exists( $filepath ) ) {
					$handle = fopen( $filepath, "a+" );
					if ( $handle ) { 
						if ( $writebom ) { @fwrite( $handle, $utf8_bom ); }
						@fclose( $handle );
					}
				}
				
				$filepath = $path_to_lists . "/" . $mylist . $ext_list_out;	
				if ( !file_exists( $filepath ) ) {
					$handle = fopen( $filepath, "a+" );
					if ( $handle ) { 
						if ( $writebom ) { @fwrite( $handle, $utf8_bom ); }
						@fclose( $handle );
					}
				}
				
				$filepath = $path_to_lists . "/" . $mylist . $ext_list_lock;	
				if ( !file_exists( $filepath ) ) {
					$handle = fopen( $filepath, "a+" );
					@fclose( $handle );
				}
			}
					
		}			
	}
	return $result;
}

// Check if the list(s) already exists
function list_exists( $lists ) {
	global $use_mysql, $path_to_lists, $ext_list;
	
	$result = true;
	
	if ( $use_mysql == 1 ) {
	
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			if ( ListExistsInDB( $lists ) ) { $result = true; } else { $result = false; }
		} else {
		 	// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = false;
		}
		// ***** MYSQL STUFF HERE *****
		
	} else {	
		$singlelist = explode( ";", $lists );	
		foreach ( $singlelist as $mylist ) {
			$filename = "$path_to_lists" . "/" . $mylist . $ext_list;
			if ( file_exists( $filename ) ) {
				// Do nothing
			} else {
				$result = false;
			}	
		}
	}
	return $result;
}

// Check if an email address already exists
function email_exists($listname, $emailaddress) {
	global $use_mysql, $path_to_lists, $ext_list;
	global $allowdups;
	
	if ( $allowdups == 1 ) { // Allow duplicates
	
		$exists = False;
		
	} else {
	
		$exists = False;
				
		if ( $use_mysql == 1 ) {
		
			// ***** MYSQL STUFF HERE *****
			if ( ConnectToMySqlServer() ) {
				if ( EmailAlreadyInDB( $listname, $emailaddress, "1" ) ) { $exists = True; } // If in DB AND Subscribed else we should return False
			} else {
				// Error connecting to mySQL database
				$mysql_err = "mySQL server connection error";
			}
			// ***** MYSQL STUFF HERE *****
			
		} else {
			$filepath = $path_to_lists . "/" . $listname . $ext_list;
			CreateDirectory( $path_to_lists );
			CreateList( $listname );
			$fcontents = LoadFileContentsAsArray( $filepath );
			if ( $emailaddress <> "" && count($fcontents) > 0 ) {	
				while ( list ($line_num, $line) = each ($fcontents) ) { // while there are elements in the array			
					$line  = str_replace("\n", "", $line);	
					$field = explode( "\t", $line );			
					if (strcmp($emailaddress, $field[3]) == 0) {
						$exists = True;
						break;
					}
				}
			}
		}
	}	
	return $exists;
}


// Add subscriber to list
function AddEmailToList( $reference ) {
	global $use_mysql, $mysql_link, $dbname, $tbname_req, $mysql_err;
	global $path_to_requests, $path_to_lists, $ext_list, $ext_list_in, $ext_list_lock;
	global $list, $firstname, $lastname, $company, $email, $listfordisplay;
	global $opt1, $opt2, $opt3, $opt4, $opt5, $opt6, $opt7, $opt8, $opt9, $opt10;
	global $opt11, $opt12, $opt13, $opt14, $opt15, $opt16, $opt17, $opt18, $opt19, $opt20;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	$result  = false;
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	
	if ( $use_mysql == 1 ) {
		if ( ConnectToMySqlServer() ) {		
			CreateDatabase( $dbname );		
			if ( $res = @mysql_select_db ( $dbname ) ) {
				if ( !TableExists( $tbname_req ) ) { CreateSubscribtionRequestTable(); }
				if ( !TableExists( $tbname_req ) ) {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					$result = False; // Error creating table
				} else {
				
					$query = "SELECT * FROM `$tbname_req` WHERE `fld_reference` = '$reference' AND `fld_sub` = '0'";					
					
					If ( $res = @mysql_db_query( $dbname, $query ) ) {
						$count = @mysql_num_rows( $res );
						if ( $count > 0 ) {
							$row = @mysql_fetch_array( $res );
							$cmd = $row[fld_command];
							$email = $row[fld_email];
							$list  = $row[fld_lists];
							$firstname = $row[fld_firstname];
							$lastname = $row[fld_lastname];
							$company = $row[fld_company];
							$opt1 = $row[fld_opt1];
							$opt2 = $row[fld_opt2];
							$opt3 = $row[fld_opt3];
							$opt4 = $row[fld_opt4];
							$opt5 = $row[fld_opt5];
							$opt6 = $row[fld_opt6];
							$opt7 = $row[fld_opt7];
							$opt8 = $row[fld_opt8];
							$opt9 = $row[fld_opt9];
							$opt10 = $row[fld_opt10];
							$opt11 = $row[fld_opt11];
							$opt12 = $row[fld_opt12];
							$opt13 = $row[fld_opt13];
							$opt14 = $row[fld_opt14];
							$opt15 = $row[fld_opt15];
							$opt16 = $row[fld_opt16];
							$opt17 = $row[fld_opt17];
							$opt18 = $row[fld_opt18];
							$opt19 = $row[fld_opt19];
							$opt20 = $row[fld_opt20];
							$result = True;
							$query = "UPDATE `$tbname_req` SET `fld_sub` = '1' WHERE `fld_reference` = '$reference'";
							If ( $res = @mysql_db_query( $dbname, $query ) ) {
								// Ok
							} else {
								$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
								SendMessage( $admin_err_addr, "[MLM] $tbname_req update error / Query error in AddEmailToList()", $mysql_err . "\r" . $query, $headers, "" );
								$result = False; // Querry Error
							}
						} else {
							$mysql_err = "No record found in mySQL table";
							$result = False;
						}	
					} else {
						$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
						SendMessage( $admin_err_addr, "[MLM] Query error in AddEmailToList()", $mysql_err . "\r" . $query, $headers, "" );
						$result = False; // Querry Error
					}
				}
			} else {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				SendMessage( $admin_err_addr, "[MLM] Error selecting database from AddEmailToList()", $mysql_err, $headers, "" );
				$result = False; // Error selecting the database
			}
		} else {
			// Error connecting to the mySQL server
			$mysql_err = "mySQL server connection error";
			SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error in AddEmailToList()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
			$result = False;
		}

	} else {
	
		$reffile = "$path_to_requests" . "/" . $reference . ".txt";
		
		CreateDirectory( $path_to_requests );
		$contents = LoadFileContentsAsText( $reffile );
		
		$xmlFieldNames = array("cmd", "list", "firstname", "lastname", "company", "email", "opt1", "opt2", "opt3", "opt4", "opt5", "opt6", "opt7", "opt8", "opt9", "opt10", "opt11", "opt12", "opt13", "opt14", "opt15", "opt16", "opt17", "opt18", "opt19", "opt20");
		$data = ParseXMLData( $contents, $xmlFieldNames );
		
		$cmd = $data['cmd'];
		$email = $data['email'];
		$list  = $data['list'];
		$firstname = $data['firstname'];
		$lastname = $data['lastname'];
		$company = $data['company'];
		$opt1 = $data['opt1'];
		$opt2 = $data['opt2'];
		$opt3 = $data['opt3'];
		$opt4 = $data['opt4'];
		$opt5 = $data['opt5'];
		$opt6 = $data['opt6'];
		$opt7 = $data['opt7'];
		$opt8 = $data['opt8'];
		$opt9 = $data['opt9'];
		$opt10 = $data['opt10'];
		$opt11 = $data['opt11'];
		$opt12 = $data['opt12'];
		$opt13 = $data['opt13'];
		$opt14 = $data['opt14'];
		$opt15 = $data['opt15'];
		$opt16 = $data['opt16'];
		$opt17 = $data['opt17'];
		$opt18 = $data['opt18'];
		$opt19 = $data['opt19'];
		$opt20 = $data['opt20'];
	
		$entry  = $data['firstname'] . "\t" . $data['lastname'] . "\t" . $data['company'] . "\t" . $data['email'] . "\t";
		$entry .= $data['opt1'] . "\t" . $data['opt2'] . "\t" . $data['opt3'] . "\t" . $data['opt4'] . "\t" . $data['opt5'] . "\t";
		$entry .= $data['opt6'] . "\t" . $data['opt7'] . "\t" . $data['opt8'] . "\t" . $data['opt9'] . "\t" . $data['opt10'] . "\t";
		$entry .= $data['opt11'] . "\t" . $data['opt12'] . "\t" . $data['opt13'] . "\t" . $data['opt14'] . "\t" . $data['opt15'] . "\t";
		$entry .= $data['opt16'] . "\t" . $data['opt17'] . "\t" . $data['opt18'] . "\t" . $data['opt19'] . "\t" . $data['opt20'] . "\t";
		$entry .= $data['list'] . "\n";
		
	}
	
	$listfordisplay = formatlistnames( $list );

	if ( $cmd == "subscribe" ) {
		
		if ( $use_mysql == 1 ) {
		
			// ***** MYSQL STUFF HERE *****
			if ( ConnectToMySqlServer() && $result == true ) {
				AddSubscriberToDB();
				CloseConnectionToMySqlServer();
			}
			// ***** MYSQL STUFF HERE *****
			
		} else {
			
			CreateDirectory( $path_to_lists );
			$singlelist = explode( ";", $data['list'] );	
			foreach ( $singlelist as $mylist ) {
				$result = AddRecordToListFile( $mylist, $email, $entry );
				if ( file_exists( $reffile ) ) { @unlink( $reffile ); }
			}
		}
				
	} else {
		// Other commands handling here
		// Other commands handling here
		// Other commands handling here
	}
	return $result;
}

// Update subscriber data from list
function UpdateEmailFromList( $list, $email, $newemail ) {
	global $use_mysql, $mysql_link;
	global $firstname, $lastname, $company;
	global $opt1, $opt2, $opt3, $opt4, $opt5, $opt6, $opt7, $opt8, $opt9, $opt10;
	global $opt11, $opt12, $opt13, $opt14, $opt15, $opt16, $opt17, $opt18, $opt19, $opt20;
	
	if ( trim( $newemail ) == "" ) { $newemail = $email; }
	
	$entry  = $firstname . "\t" . $lastname . "\t" . $company . "\t" . strtolower( $newemail) . "\t";
	$entry .= $opt1 . "\t" . $opt2 . "\t" . $opt3 . "\t" . $opt4 . "\t" . $opt5 . "\t";
	$entry .= $opt6 . "\t" . $opt7 . "\t" . $opt8 . "\t" . $opt9 . "\t" . $opt10 . "\t";
	$entry .= $opt11 . "\t" . $opt12 . "\t" . $opt13 . "\t" . $opt14 . "\t" . $opt15 . "\t";
	$entry .= $opt16 . "\t" . $opt17 . "\t" . $opt18 . "\t" . $opt19 . "\t" . $opt20 . "\t";
	$entry .= $list . "\n";
		
	if ( $use_mysql == 1 ) {
	
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = UpdateEmailFromDB( $list, $email, $entry );
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = False;
		}
		// ***** MYSQL STUFF HERE *****
		
	} else {
		$result = UpdateRecordFromListFile( $list, $email, $entry );
	}
	return $result;
}

function AddRecordToListFile( $list, $email, $entry ) {
	global $path_to_lists, $ext_list, $ext_list_in, $ext_list_lock;

	$filename = $path_to_lists . "/" . $list . $ext_list;
	$backup   = $path_to_lists . "/" . $list . $ext_list_in;
	$lockfile = $path_to_lists . "/" . $list . $ext_list_lock;
	
	CreateDirectory( $path_to_lists );
	CreateList( $list );
	
	if ( !email_exists( $list, $email ) ) {
		$handle = @fopen( $filename, "a+" );
		$locker = @fopen( $lockfile, "a+" );
		If ( $handle && $locker ) {
			If ( flock( $locker, LOCK_EX ) ) {
				if ( @fwrite( $handle, $entry ) === false ) { $result = false; } else { $result = true; };
				flock( $locker, LOCK_UN );
				if ( $result ) {				
					// <BACKUP>
					$handle = @fopen( $backup, "a+" );
					If( $handle ) {
						@fwrite( $handle, $entry );
						@fclose( $handle );
					}
					// </BACKUP>
				}
			} else {
				// ERROR: Can't Lock file
			}
			@fclose( $handle );
			@fclose( $locker );
		} else {
			// ERROR: Handle not valid
		}
	} else {
		// ERROR: Email already exists
	}	
	return $result;
}

function UpdateRecordFromListFile( $list, $email, $updatedentry ) {
	global $mlm_err, $path_to_lists, $ext_list, $ext_list_lock;

	CreateDirectory( $path_to_lists );

	$singlelist = explode( ";", $list );	
	foreach ( $singlelist as $mylist ) {
	
		$filepath = $path_to_lists . "/" . $mylist . $ext_list;
		$lockfile = $path_to_lists . "/" . $mylist . $ext_list_lock;
		
		CreateList( $mylist );
		
		$handle = @fopen( $filepath, "r+" );
		$locker = @fopen( $lockfile, "a+" );
		if ( $handle && $locker ) {
			If ( @flock( $locker, LOCK_EX ) ) {
				$fcontents = file( $filepath );
				ftruncate( $handle, 0 );
				if ( $writebom ) { @fwrite( $handle, $utf8_bom ); }
				while ( list ($line_num, $line) = each ($fcontents) ) { // while there are elements in the array
					$entry = $line;
					$line  = str_replace("\n", "", $line);	
					$field = explode( "\t", $line );			
					if ( strcmp( $email, $field[3] ) == 0 ) {
						fwrite( $handle, $updatedentry );
					} else {
						fwrite( $handle, $entry );
					}
					$counter++;
				}
				flock( $locker, LOCK_UN );
			} else {
				$counter = -1; // ERROR: Can't Lock file
				$mlm_err = "Error opening $lockfile";
			}
			@fclose( $handle );
			@fclose( $locker );
		} else {
			$counter = -1; // ERROR: Handle not valid
			$mlm_err = "Error opening $filepath";
		}
	}	
	return $counter;
}

function RemoveEmailFromList( $list, $email ) {
	global $mlm_err, $use_mysql, $path_to_lists, $ext_list, $ext_list_out, $ext_list_lock;
	
	$counter = 0;

	if ( $use_mysql == 1 ) {
			
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$counter = RemoveSubscriberFromDB( $email );
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
		}
		// ***** MYSQL STUFF HERE *****
	
	} else {
		CreateDirectory( $path_to_lists );
		$singlelist  = explode( ";", $list );
		$singleemail = explode( ";", $email );
		foreach ( $singlelist as $mylist ) {
		
			$filepath = $path_to_lists . "/" . $mylist . $ext_list;
			$lockfile = $path_to_lists . "/" . $mylist . $ext_list_lock;
			$backup   = $path_to_lists . "/" . $mylist . $ext_list_out;
			
			CreateList( $mylist );
			
			$handle = @fopen( $filepath, "r+" );
			$locker = @fopen( $lockfile, "a+" );
			$backuphandle = @fopen( $backup, "a+" );
			if ( $handle && $locker ) {
				If ( @flock( $locker, LOCK_EX ) ) {
					$fcontents = file( $filepath );
					ftruncate( $handle, 0 );
					if ( $writebom ) { @fwrite( $handle, $utf8_bom ); }
					while ( list ($line_num, $line) = each ($fcontents) ) { // while there are elements in the array
						$entry = $line;
						$line  = str_replace("\n", "", $line);	
						$field = explode( "\t", $line );
						
						foreach ( $singleemail as $myemail ) {
							if ( strcmp( $myemail, $field[3] ) == 0) {
								$counter++;
								If( $backuphandle ) { @fwrite( $backuphandle, $myemail ); }
							} else {
								fwrite( $handle, $entry );
							}
						}
						
					}
					flock( $locker, LOCK_UN );
				} else {
					$counter = -1; // ERROR: Can't Lock file
					$mlm_err = "Error opening $lockfile";
				}
				@fclose( $handle );
				@fclose( $locker );
				@fclose( $backuphandle );
			} else {
				$counter = -1; // ERROR: Handle not valid
				$mlm_err = "Error opening $filepath";
			}
		}
	}	
	return $counter;
}

// Send a confirmation message to the subscriber
function SendSubscriptionMessage() {
	global $msg_confirmation, $admin_address, $path_to_script, $cmd, $list, $listfordisplay;
	global $admin_name_full, $admin_webAddress, $script_name, $script_version, $emailencoding;
	global $firstname, $lastname, $company, $email, $admin_notifications, $dec_quotes, $dec_charset;
	global $kTxt_emailsubject_ysc, $kTxt_emailsubject_esl, $lang;
	
	$url = $path_to_script . "?cmd=unsubscribe&list=" . urlencode( $list ) . "&email=" . $email . "&lang=" . $lang;
	
	$listfordisplay = formatlistnames( $list );
	
	$subject = @html_entity_decode( $kTxt_emailsubject_ysc[$lang], $dec_quotes, $dec_charset );
	$message = $msg_confirmation;
	$message = str_replace( "[LIST]", $listfordisplay, $message );
	$message = str_replace( "[FIRSTNAME]", $firstname, $message );
	$message = str_replace( "[LASTNAME]", $lastname, $message );
	$message = str_replace( "[EMAIL]", $email, $message );
	$message = str_replace( "[UNSUBSCRIBE_URL]", $url, $message );
	$message = str_replace( "[SIGNATURE]", "$admin_name_full\n$admin_webAddress\n$script_name $script_version", $message );	
	$headers = "From: \"$admin_name_full\" <$admin_address>";	
	SendMessage( $email, $subject, $message, $headers, $emailencoding );
	
	if ( $admin_notifications == 1 ) {
		$subject = @html_entity_decode( str_replace( "[EMAIL]", $email, str_replace( "[LISTS]", $listfordisplay, $kTxt_emailsubject_esl[$lang] ) ), $dec_quotes, $dec_charset );
		$message = $subject . ".";
		$headers = "From: \"$admin_name_full\" <$admin_address>";	
		SendMessage( $admin_address, $subject, $message, $headers, $emailencoding );
	}
	
}

// Send subscription cancellation message to former subscriber
function SendUnsubscriptionMessage() {
	global $msg_unsubscribe, $admin_address, $path_to_script, $cmd, $list, $listfordisplay;
	global $admin_name_full, $admin_webAddress, $script_name, $script_version, $emailencoding;
	global $firstname, $lastname, $company, $email, $admin_notifications, $dec_quotes, $dec_charset;
	global $kTxt_emailsubject_yuc, $kTxt_emailsubject_eul, $lang, $local;
	
	$url = $path_to_script . "?cmd=subscribe&list=" . urlencode( $list ) . "&email=" . $email . "&lang=" . $lang;
	
	$listfordisplay = formatlistnames( $list );
	
	$subject = @html_entity_decode( $kTxt_emailsubject_yuc[$lang], $dec_quotes, $dec_charset );
	$message = $msg_unsubscribe;
	$message = str_replace( "[LIST]", $listfordisplay, $message );
	$message = str_replace( "[FIRSTNAME]", $firstname, $message );
	$message = str_replace( "[LASTNAME]", $lastname, $message );
	$message = str_replace( "[EMAIL]", $email, $message );
	$message = str_replace( "[SUBSCRIBE_URL]", $url, $message );
	$message = str_replace( "[SIGNATURE]", "$admin_name_full\n$admin_webAddress\n$script_name $script_version", $message );
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	SendMessage( $email, $subject, $message, $headers, $emailencoding );
	
	if ( $admin_notifications == 1 ) {
		$subject = @html_entity_decode( str_replace( "[EMAIL]", $email, str_replace( "[LISTS]", $listfordisplay, $kTxt_emailsubject_eul[$lang] ) ), $dec_quotes, $dec_charset );
		$message = $subject . ".";
		$headers = "From: \"$admin_name_full\" <$admin_address>";
		SendMessage( $admin_address, $subject, $message, $headers, $emailencoding );
	}
	
}

// Show one or several concatened lists list1;list2;list3...
function GetList( $lists, $start, $rows ) {
	global $use_mysql, $path_to_lists, $ext_list;
	
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = GetListFromDB( $lists, $start, $rows );
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = -1;
		}
		// ***** MYSQL STUFF HERE *****
		
	} else {
		$singlelist = explode( ";", $lists );	
		foreach ( $singlelist as $mylist ) {
			$filename = "$path_to_lists" . "/" . $mylist . $ext_list;
			if ( file_exists( $filename ) ) {
				//if ( $result != "" ) { $result .= "\n"; }
				$result .= LoadFileContentsAsText( $filename );
			} else {
				// Do nothing yet
			}	
		}
		if ( $start <> 0 && $rows <> 0 ) {
			$data = explode( "\n", $result );
			usort( $data, "strcasecmp" );
			$result = "";
			$first = intval( $start );
			$last  = $first + intval( $rows );
			for ( $j = $first; $j < $last; $j++ ) {
				if ( $result != "" ) { $result .= "\n"; }
				$result .= $data[$j];
			}
		}
	}
	return $result;
}

// Show the size of one or several concatened lists list1;list2;list3...
function GetListSize( $lists ) {
	global $use_mysql, $path_to_lists, $ext_list;
	
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = GetListSizeDB( $lists );
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = -1;
		}
		// ***** MYSQL STUFF HERE *****
		
	} else {
		$singlelist = explode( ";", $lists );	
		foreach ( $singlelist as $mylist ) {
			$filename = "$path_to_lists" . "/" . $mylist . $ext_list;
			if ( file_exists( $filename ) ) {
				$result = $result + count( LoadFileContentsAsArray( $filename ) );
			} else {
				// Do nothing yet
			}	
		}
	}
	return $result;
}

// Remove one or several concatened lists list1;list2;list3...
function RemoveList( $lists ) {
	global $use_mysql, $path_to_lists, $ext_list;
	global $ext_list_in, $ext_list_out, $ext_list_lock;
	
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = RemoveListFromDB();
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = False;
		}
		// ***** MYSQL STUFF HERE *****
		
	} else {
		$singlelist = explode( ";", $lists );	
		foreach ( $singlelist as $mylist ) {
			$filename = "$path_to_lists" . "/" . $mylist . $ext_list;
			if ( @file_exists( $filename ) ) {
				if ( unlink( $filename ) ) {
					$result++;
					$filename = "$path_to_lists" . "/" . $mylist . $ext_list_in;
					if ( @file_exists( $filename ) ) { unlink( $filename ); }
					$filename = "$path_to_lists" . "/" . $mylist . $ext_list_out;
					if ( @file_exists( $filename ) ) { unlink( $filename ); }
					$filename = "$path_to_lists" . "/" . $mylist . $ext_list_lock;
					if ( @file_exists( $filename ) ) { unlink( $filename ); }
				}
			}	
		}
	}
	return $result;
}

// Show a list of all lists including recipient count and last change date
// If $email argument is not null we only shows the lists the address is subscribed to
function ShowLists() {
	global $mlm_err, $use_mysql, $path_to_lists, $ext_list, $email, $pwd;
	// If you add a global here check if it is defined in subscribe_auto_single.php and subscribe_auto_multiple.php
	
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = ShowListNamesFromDB();
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
		}
		// ***** MYSQL STUFF HERE *****
	
	} else {
		if ( $handle = @opendir( $path_to_lists ) ) {
			while ( false !== ( $file = readdir( $handle ) ) ) {
				if ( $file != ".." && $file != "." && $file != ".htaccess" && $file != "index.html" && substr( $file, -strlen( $ext_list ) ) == $ext_list && $file != $ext_list ) {
					
					$filename = $path_to_lists . "/" . $file;
					$listname = str_replace( $ext_list, "", $file );
					
					if ( $pwd == "" ) {			
						If ( ( $email <> "" && email_exists( $listname, $email ) ) || $email == "" ) {
							If ( $result != "" ) { $result .= ";"; }
							$result .= $listname;
						}
					} else {
						If ( ( $email <> "" && email_exists( $listname, $email ) ) || $email == "" ) {
							If ( $result != "" ) { $result .= "\n"; }
							$result .= str_replace( $ext_list, "", $file ) . "\t" . count( LoadFileContentsAsArray( $filename ) ) . "\t" . date( "Y-m-d H:i:s", filemtime( $filename ) );
						}
					}
				}
			}
			closedir( $handle );
		} else {
			$mlm_err = "Error opening $path_to_lists";
			$result = -1; // ERROR: Handle not valid
		}
	}
	return $result;
}

// Rename a list
function RenameList( $list, $name ) {
	global $mlm_err, $use_mysql, $path_to_lists, $ext_list, $email, $pwd;
	global $ext_list_in, $ext_list_out, $ext_list_lock;
	
	$result = false;
	
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = RenameListFromDB( $list, $name );
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
		}
		// ***** MYSQL STUFF HERE *****
	
	} else {
		$oldname = "$path_to_lists" . "/" . $list . $ext_list;
		$newname = "$path_to_lists" . "/" . $name . $ext_list;
		if ( @file_exists( $oldname ) && @file_exists( $newname ) == False ) {
			if ( @rename( $oldname, $newname ) ) {
				$result = true;
				$oldname = "$path_to_lists" . "/" . $list . $ext_list_in;
				$newname = "$path_to_lists" . "/" . $name . $ext_list_in;
				if ( @file_exists( $oldname ) && @file_exists( $newname ) == False ) { @rename( $oldname, $newname ); }
				$oldname = "$path_to_lists" . "/" . $list . $ext_list_out;
				$newname = "$path_to_lists" . "/" . $name . $ext_list_out;
				if ( @file_exists( $oldname ) && @file_exists( $newname ) == False ) { @rename( $oldname, $newname ); }
				$oldname = "$path_to_lists" . "/" . $list . $ext_list_lock;
				$newname = "$path_to_lists" . "/" . $name . $ext_list_lock;
				if ( @file_exists( $oldname ) && @file_exists( $newname ) == False ) { @rename( $oldname, $newname ); }
			} else {
				$mlm_err = "Error renaming $oldname to $newname.";
			}
		} else {
			$mlm_err = "Error renaming $oldname to $newname. Either the file doesn't exist or a file with new name already exists.";
		}
	}
	return $result;
}

// Find a recipient
function FindRecipient() {
	global $mlm_err, $use_mysql, $path_to_lists, $ext_list;
	global $firstname, $lastname, $company, $email;
	
	$result = "";
	
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = FindRecipientFromDB();
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
		}
		// ***** MYSQL STUFF HERE *****
	
	} else {
		if ( $handle = @opendir( $path_to_lists ) ) {
			while ( false !== ( $file = readdir( $handle ) ) ) {
				if ( $file != ".." && $file != "." && $file != ".htaccess" && $file != "index.html" && substr( $file, -strlen( $ext_list ) ) == $ext_list && $file != $ext_list ) {
					
					$filepath = $path_to_lists . "/" . $file;
					$listname = str_replace( $ext_list, "", $file );
					
					$fcontents = LoadFileContentsAsArray( $filepath );
					if ( count($fcontents) > 0 ) {	
						while ( list ($line_num, $line) = each ($fcontents) ) { // while there are elements in the array			
							$line  = str_replace("\n", "", $line);	
							$field = explode( "\t", $line );
						
							if ( ( trim( $firstname ) == "" || ( trim( $firstname ) <> "" && stripos( $field[0], $firstname ) !== false ) )
								&& ( trim( $lastname ) == "" || ( trim( $lastname ) <> "" && stripos( $field[1], $lastname ) !== false ) )
								&& ( trim( $company ) == "" || ( trim( $company ) <> "" && stripos( $field[2], $company ) !== false ) )
								&& ( trim( $email ) == "" || ( trim( $email ) <> "" && stripos( $field[3], $email ) !== false ) )
								&& ( trim( $firstname ) <> "" || trim( $lastname ) <> "" || trim( $company ) <> "" || trim( $email ) <> "" ) ) {

								If ( $result != "" ) { $result .= "\n"; }
								$result .= $field[0] . "\t" . $field[1] . "\t" . $field[2] . "\t" . $field[3] . "\t" . $listname;
							}
						}
					}
					
				}
			}
			closedir( $handle );
		} else {
			$mlm_err = "Error opening $path_to_lists";
			$result = -1; // ERROR: Handle not valid
		}
	}
	return $result;
}

//******************************************************************************************************************************<FILE_HANDLING>

// Create the $path directory if it doesn't already exist
function CreateDirectory( $path ) {
	global $mlm_err;
	
	$result = True;
	
	if ( !@file_exists( $path ) ) { @mkdir( $path, 0777 ); }
	if ( !@file_exists( $path ) ) { @mkdir( $path, 0775 ); } // In case previous call fails
	if ( !@file_exists( $path ) ) { @mkdir( $path, 0755 ); } // In case previous call fails
	
	//clearstatcache();
	//$perm = substr( decoct( fileperms( $path ) ), 1 );
	//if ( $perm <> "0777" ) { @chmod( $path, 0777 ); }
	
	if ( file_exists( $path ) ) {
		$filename = $path . "/index.html";
		if ( !@file_exists( $filename ) ) {
			$handle = @fopen( $filename, "a+" );
			If( $handle ) {
				$contents .= "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n";
				$contents .= "<html><head>\n";
				$contents .= "<title>403 Forbidden</title>\n";
				$contents .= "</head><body>\n";
				$contents .= "<h1>Forbidden</h1>\n";
				$contents .= "<p>You don't have permission to access $path\n";
				$contents .= "on this server.</p>\n";
				$contents .= "</body></html>\n";
				if ( @fwrite( $handle, $contents ) === False ) { 
					$mlm_err = "Imposible to create file in directory \"$path\" (wrong permissions)";
					$result = False;
				} else {
					$mlm_err = "";
					$result = True;
				}
				@fclose( $handle );
			} else {
				// ERROR: Handle not valid
				clearstatcache();
				$perm = substr( decoct( fileperms( $path ) ), 1 );
				$mlm_err = "Directory \"$path\" has wrong permissions, $perm instead of 0777";
				$result = False;
			}
		}
	}
	return $result;
}

// Load the contents of a file as text
function LoadFileContentsAsText( $path ) {
	$handle = @fopen( $path, "r" );
	if ( $handle && filesize( $path ) > 0 ) {
		$contents = fread( $handle, filesize( $path ) );
		@fclose( $handle );
	}
	return $contents;
}

// Load the contents of a file as an Array
function LoadFileContentsAsArray( $path ) {
	$handle = @fopen( $path, "r" );
	if ( $handle ) {
		$contents = file($path, FILE_TEXT | FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
		@fclose( $handle );
	}
	return $contents;
}

// Delete files older than xx days
function DeleteFilesOlderThan($path, $days) {
	if ( is_dir("$path") ) { 
		$handle = opendir($path); 
		while (false!==($file = readdir($handle))) { 
			if ($file != "." && $file != ".." && $file != ".htaccess" && $file != "index.html" ) {  
				$Diff = (time() - filectime("$path/$file"))/60/60/24;
				if ($Diff > $days) unlink("$path/$file");
			} 
		}
		@closedir($handle); 
	}
}

// Delete all files from a folder
function DeleteAllFilesFromDir($path) {
	$counter = 0;
	if ($handle = opendir($path)) {
		while (false !== ($file = readdir($handle))) {
			if ( $file != ".." && $file != "." ) {
				if (unlink("$path/$file")) {
					$counter++;
				}
			}
		}
	@closedir($handle);
	}
	return $counter;
}

// Delete a folder
function DeleteDirectory($dirname) { 
	if (is_dir($dirname)) 
		$dir_handle = opendir($dirname); 
	if (!$dir_handle) 
		return false; 
		while($file = readdir($dir_handle)) { 
			if ($file != "." && $file != "..") { 
				if (!is_dir($dirname."/".$file)) 
				unlink($dirname."/".$file); 
				else 
				delete_directory($dirname.'/'.$file); 
			} 
		} 
	@closedir($dir_handle); 
	rmdir($dirname); 
	return true; 
} 

// Count the files in a folder
function CountFilesInDir( $path, $ext ) {
	$filecount = 0;
	if ( $handle = @opendir( $path ) ) {
		while ( false !== ( $file = readdir( $handle ) ) ) {
			if ( $file != ".." && $file != "." ) {
				If ( $ext <> "" ) {
					if ( substr( $file, -strlen( $ext ) , strlen( $ext ) ) == $ext ) {
						$filecount++;
					}
				} else {
					$filecount++;
				}
			}
		}
		@closedir( $handle );
	}
	return $filecount;
}

function EmptyFile( $filepath ) {
	$handle = @fopen( $filepath, "w+" );
	@fclose( $handle );
}

//******************************************************************************************************************************<TEXT_FUNCTIONS>

function wordScramble($x) {
	// split up the words and puctuation
	$ar=preg_split('/\b/',$x);

	// delete empty elements
	foreach($ar as $y=>$z)
		if(empty($z))
			unset($ar[$y]);
        
	$output=array();
	foreach($ar as $word){
		$elem=count($output)-1;
		if(strlen($word)>3){
			$word_start=substr($word,0,1);  // first letter
			$word_end=substr($word,-1);     // last letter
			$word_rest=substr($word,1,-1);  //rest of the word
			$word_rest_ar=array();
			for($i=0;$i<strlen($word_rest);$i++){
				// for each letter for the rest of the word
				$word_rest_ar[]=substr($word_rest,$i,1);
			}
			shuffle($word_rest_ar);
			$word=$word_start.join('',$word_rest_ar).$word_end;
		}
		$output[]=$word;
	}
	$find=array(" ' ",'( ',' )','{ ',' }','[ ',' ]',' .',' ?',' !',' , ');
	$replace=array("'",'(',')','{','}','[',']','.','?','!',', ');
	return preg_replace('/(\r\n|\r|\n){2}/',"\n",str_replace($find,$replace,join(' ',$output)));
}

function formatlistnames( $list ) {
	global $kTxt_and, $lang, $dec_quotes, $dec_charset;

	if ( count( explode( ";", $list ) ) == 1 ) {
		return $list;
	} else {
		$count = 1;
		$singlelist = explode( ";", $list );	
		foreach ( $singlelist as $mylist ) {
			if ( count( $singlelist ) == $count ) {
				$result .= " " . @html_entity_decode( $kTxt_and[$lang], $dec_quotes, $dec_charset ) . " ";
			} else if ( $result != "" ) {
				$result .= ", ";
			}
			$result .= $mylist;
			$count++;
		}
		return $result;
	}
}

function ReplaceLineEndings( $text ) {

	$result = $text;
	$result = str_replace( "\r\n", "\n", $result );
	$result = str_replace( "\r", "\n", $result );
	return $result;
}

// Simple email validation function
function isEmailValid( $email ) {

	if ( !eregi( "^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$", $email ) ) {
		return false;
	} else {
		return true;
	}
}

// Advanced email validation function (from http://www.linuxjournal.com/article/9585?page=0,2)
function isEmailValidAdv( $email ) {
   $isValid = true;
   $atIndex = strrpos($email, "@");
   if (is_bool($atIndex) && !$atIndex)
   {
      $isValid = false;
   }
   else
   {
      $domain = substr($email, $atIndex+1);
      $local = substr($email, 0, $atIndex);
      $localLen = strlen($local);
      $domainLen = strlen($domain);
      if ($localLen < 1 || $localLen > 64)
      {
         // local part length exceeded
         $isValid = false;
      }
      else if ($domainLen < 1 || $domainLen > 255)
      {
         // domain part length exceeded
         $isValid = false;
      }
      else if ($local[0] == '.' || $local[$localLen-1] == '.')
      {
         // local part starts or ends with '.'
         $isValid = false;
      }
      else if (preg_match('/\\.\\./', $local))
      {
         // local part has two consecutive dots
         $isValid = false;
      }
      else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain))
      {
         // character not valid in domain part
         $isValid = false;
      }
      else if (preg_match('/\\.\\./', $domain))
      {
         // domain part has two consecutive dots
         $isValid = false;
      }
      else if (!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/',
                 str_replace("\\\\","",$local)))
      {
         // character not valid in local part unless 
         // local part is quoted
         if (!preg_match('/^"(\\\\"|[^"])+"$/',
             str_replace("\\\\","",$local)))
         {
            $isValid = false;
         }
      }
      if ($isValid && !(checkdnsrr($domain,"MX") || checkdnsrr($domain,"A")))
      {
         // domain not found in DNS
         $isValid = false;
      }
   }
   return $isValid;
}

function EncodeForFileName( $text ) {
	global $use_mysql;
	
	$result = $text;
	if ( $use_mysql == 1 ) {
		// Do nothing
	} else {
		str_replace( " ", "_", $result );
		str_replace( "%20", "_", $result );
		//str_replace( "+", "_", $result );
	}
	return $result;
}

// In case we have to make the email address safe to be used as a file name
function email_makesafe($emailaddress) {
	$repl = array(
    '.' => '%46',
    '_' => '%95'
    );
	$safeEmail = strtr($email, $repl);
	return safeEmail;
}

//******************************************************************************************************************************<Mail_Queue>

// Send message and check result
function SendMessage($recipient, $subject, $message, $headers, $encoding) {
	global $admin_err_addr, $admin_address, $script_name, $script_version, $smtp_auth;
	if ( stristr( $recipient, "@" ) !== FALSE ) {
	
		$message = str_replace( "\r", "\r\n", $message ); // Replace all '\r' with '\r\n' in $message

		$key = strtoupper( md5( uniqid( microtime() ) ) );
		$key = substr( $key, 1, 8 ) . "-" . substr( $key, 9, 4 ) . "-" . substr( $key, 13, 4 ) . "-" . substr( $key, 17, 4 ) . "-" . substr( $key, 20, 12 );
		$host = getthehostname( $_SERVER['HTTP_HOST'] );
		$messageid = "<" . $key . "@" . $host . ">";
		
		$temp = $headers;		

		$headers  = "Return-Path: <$admin_err_addr>\r\n";
		$headers .= "Message-ID: $messageid\r\n";
		$headers .= "Mime-Version: 1.0\r\n";
		$headers .= $temp . "\r\n";
		$headers .= "Date: " . date( 'r' ) . "\r\n";
		$headers .= "X-Mailer: PHP/" . phpversion() . "\r\n"; //$script_name/$script_version\r\n";

		if ( $encoding <> "" ) {
			$headers .= "Content-Type: text/plain; charset=$encoding; Format=flowed\r\n";
			$headers .= "Content-Transfer-Encoding: 8bit";
		} else {
			$headers .= "Content-Type: text/plain; charset=us-ascii; Format=flowed\r\n";
			$headers .= "Content-Transfer-Encoding: 7bit";
		}
		
		if ( $encoding == 'utf-8' ) {
			//$subject = utf8_encode( $subject );
			//$message = utf8_encode( $message );
		}
		
		if ( $smtp_auth ) {
			$result = authmail( $recipient, $subject, $message, $admin_address );
		} else {
			$result = @mail( $recipient, $subject, $message, $headers, "-f$admin_address" ); // Godaddy needs the -f parameter
			if ( !$result ) { @mail( $recipient, $subject, $message, $headers ); }
		}
		
		if ( !$result ) { LogDeliveryError($recipient, $subject, $message, $headers); }
	}
}

// In case the server needs authentication we use the PEAR mail package
// From http://email.about.com/od/emailprogrammingtips/qt/PHP_Email_SMTP_Authentication.htm
function authmail( $to, $subject, $body, $from ) {
	global $smtp_host, $smtp_username, $smtp_password;
	
	require_once "Mail.php";
 
	$headers = array ( 'From' => $from,
		'To' => $to,
		'Subject' => $subject );
		
	$smtp = Mail::factory( 'smtp',
		array ( 'host' => $smtp_host,
			'auth' => true,
			'username' => $smtp_username,
			'password' => $smtp_password ) );
 
	$mail = $smtp->send( $to, $headers, $body );
 
	if (PEAR::isError( $mail ) ) {
		// Error - For more info use $mail->getMessage()
		$result = False;
	} else {
		// Message successfully sent!
		$result = true;
	}
  
	return $result;

}

// If message has not been sent successfully we store it to the mailqueue directory
function LogDeliveryError($recipient, $subject, $message, $headers) {
	global $path_to_mailqueue, $admin_err_addr;
	
	CreateDirectory( $path_to_mailqueue );
	$filename = $path_to_mailqueue . "/" . date('YmdHis') . ".txt";
	$counter = 1;
	while (@file_exists($filename)) {
		$filename = $path_to_mailqueue . "/" . date('YmdHis') . $counter . ".txt";
		$counter++;
	}
	$handle   = @fopen($filename, "a+");
	$contents = "<msg_recipient>$recipient</msg_recipient>\n";
	$contents .= "<msg_subject>$subject</msg_subject>\n";
	$contents .= "<msg_headers>$headers</msg_headers>\n";
	$contents .= "<msg_body>" . str_replace("\r", "\n", $message). "</msg_body>\n";
	@fputs($handle, $contents);
	@fclose($handle);
}

// Look at mailqueue directory and send all messages
function EmptyMailQueue() {
	global $path_to_mailqueue, $admin_address;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	CreateDirectory( $path_to_mailqueue );
	$path = $path_to_mailqueue;
	if ( CountFilesInDir("$path/", "*") > 0 ) {  // or "*.txt"
		if ($handle = opendir($path)) {
			while (false !== ($file = readdir($handle))) {
				if ( $file != ".." && $file != "." && $file != ".htaccess" && $file != "index.html" ) { 
					$filename = "$path/$file";
					$filehandle = fopen($filename, "r");
					if ($filehandle) {
						$contents = fread($filehandle, filesize($filename));
	   					@fclose($filehandle);
	   					$xmlFieldNames = array("msg_recipient", "msg_subject", "msg_headers", "msg_body");
						$data = ParseXMLData($contents, $xmlFieldNames);
						$result = @mail($data['msg_recipient'], $data['msg_subject'], $data['msg_body'], $data['msg_headers'], "-f$admin_address"); // Godaddy needs the -f parameter
						if ( !$result ) {
							if ( count( explode( "#", $filename ) ) > 4 ) {
								@unlink($filename);
								$headers = "From: \"$admin_name_full\" <$admin_address>";
								@mail( $admin_err_addr, "[MailQueue] Impossible to send the message after 5 attempts - Message removed from queue", $contents, $headers, "-f$admin_address" ); // Godaddy needs the -f parameter
							} else {
								@rename( $filename, $filename . "#" );
							}
						} else {
							@unlink($filename);
						}
					}			
				}
			}
		closedir($handle);
		}
	}
}

function getthehostname( $url ) {

	preg_match('@^(?:http://)?([^/]+)@i', $url, $matches);
	$host = $matches[1];

	// get last two segments of host name
	preg_match('/[^.]+\.[^.]+$/', $host, $matches);
	return $matches[0];

}

//******************************************************************************************************************************<mySQL Handling>

// Connect to the mySQL server
function ConnectToMySqlServer() {
	global $dbhost, $dbusername, $dbuserpass, $dbname, $mysql_link, $mysql_err, $mysql_charset;
	if ( !$mysql_link ) { $mysql_link = @mysql_connect ( $dbhost, $dbusername, $dbuserpass, $dbname ); }
	if ( !$mysql_link ) {
		$mysql_err = @mysql_errno( $mysql_link ) . ": " . @mysql_error( $mysql_link );
		return false;
	} else {
		$version = GetmySQLFullVersion();
		//if ( $version[0] >= 5 && $version[1] >= 2 && $version[2] >= 3 ) { @mysql_set_charset( "utf8", $mysql_link ); }
		if ( function_exists( "mysql_set_charset" ) ) { @mysql_set_charset( "utf8", $mysql_link ); }
		$mysql_charset = @mysql_client_encoding( $mysql_link ); // Success?
		return true;
	}
}

// Close the connection to the mySQL server
function CloseConnectionToMySqlServer() {
	//global $mysql_link;
	//if ( !$mysql_link ) {
	//	// Do nothing
	//} else {
	//	@mysql_close( $mysql_link );
	//}
}

// Get mySQL major version number (3, 4, 5...)
function GetmySQLMajorVersion() {
	If ( $res = @mysql_query( "select version() as ve" ) ) {
		$r = mysql_fetch_object( $res );
		$fv = $r->ve;
		$temp = explode( ".", $fv );
		$version = $temp[0];
	} else {
		$mysql_err = @mysql_errno( $mysql_link ) . ": " . @mysql_error( $mysql_link );
		$version = -1;
	}
	return $version;
}

// Get mySQL full version number
function GetmySQLFullVersion() {
	If ( $res = @mysql_query( "select version() as ve" ) ) {
		$r = mysql_fetch_object( $res );
		$fv = $r->ve;
		$version = explode( ".", $fv );
	} else {
		$mysql_err = @mysql_errno( $mysql_link ) . ": " . @mysql_error( $mysql_link );
		$version = array();
		$version[0] = '3';
		$version[1] = '0';
		$version[2] = '0';
	}
	return $version;
}

// Create a Database
function CreateDatabase() {
	global $mysql_link, $mysql_err, $dbname;
		
	if ( ConnectToMySqlServer() ) {
		$query = GetCreateDatabaseQuery( GetmySQLMajorVersion(), $dbname );
		if ( $res = @mysql_query( $query, $mysql_link ) ) {
			return true;  // Query handled successfully
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return false; // Query not handled - Error	
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return false;
	}
}

// Check if a given table exists in the database
function TableExists( $tablename ) {
	global $dbname, $mysql_link, $mysql_err;
	
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {	
			$query = "SELECT * FROM `$tablename`";	
			If ( $res = @mysql_db_query( $dbname, $query ) ) {
				return true;  // The table exists
			} else {
				return false; // The table doesn't exist
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return false; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return false;
	}
}

// Create the list table
function CreateListTable() {
	global $dbname, $tbname, $mysql_err, $mysql_link;

	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			//if ( !TableExists( $tbname ) ) {
				$query = GetCreateListTableQuery( GetmySQLMajorVersion(), $tbname );	
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					return true;  // Table created successfully
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return false; // Table not created - Error
				}
			//} else {
			//	return true; // The table already exists
			//}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return false; // Error selecting the database
		}
	} else {
		$mysql_err = "mySQL server connection error";
		return false; // Error connecting to the mySQL server
	}
}

function RemoveDBTable( $tablename) {
	global $dbname, $mysql_err, $mysql_link;

	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			//if ( !TableExists( $tablename ) ) {
				$query = "DROP TABLE IF EXISTS `$tablename`";	
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					return true;  // Table removed successfully
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return false; // Table not removed - Error
				}
			//} else {
			//	return true; // The table already exists
			//}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return false; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return false;
	}
}

// Add a subscriber to the mySQL table
function AddSubscriberToDB() {
	global $dbname, $tbname, $mysql_link, $mysql_err;
	global $list, $firstname, $lastname, $company, $email;
	global $opt1, $opt2, $opt3, $opt4, $opt5, $opt6, $opt7, $opt8, $opt9, $opt10;
	global $opt11, $opt12, $opt13, $opt14, $opt15, $opt16, $opt17, $opt18, $opt19, $opt20;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	
	if ( ConnectToMySqlServer() ) {
		If ( $res = @mysql_select_db ( $dbname ) ) {
			$firstname = mysql_real_escape_string( $firstname );
			$lastname  = mysql_real_escape_string( $lastname );
			$company   = mysql_real_escape_string( $company );
			$email     = mysql_real_escape_string( $email );
			$opt1      = mysql_real_escape_string( $opt1 );
			$opt2      = mysql_real_escape_string( $opt2 );
			$opt3      = mysql_real_escape_string( $opt3 );
			$opt4      = mysql_real_escape_string( $opt4 );
			$opt5      = mysql_real_escape_string( $opt5 );
			$opt6      = mysql_real_escape_string( $opt6 );
			$opt7      = mysql_real_escape_string( $opt7 );
			$opt8      = mysql_real_escape_string( $opt8 );
			$opt9      = mysql_real_escape_string( $opt9 );
			$opt10     = mysql_real_escape_string( $opt10 );
			$opt11     = mysql_real_escape_string( $opt11 );
			$opt12     = mysql_real_escape_string( $opt12 );
			$opt13     = mysql_real_escape_string( $opt13 );
			$opt14     = mysql_real_escape_string( $opt14 );
			$opt15     = mysql_real_escape_string( $opt15 );
			$opt16     = mysql_real_escape_string( $opt16 );
			$opt17     = mysql_real_escape_string( $opt17 );
			$opt18     = mysql_real_escape_string( $opt18 );
			$opt19     = mysql_real_escape_string( $opt19 );
			$opt20     = mysql_real_escape_string( $opt20 );

			$singlelist = explode( ";", $list );	
			foreach ( $singlelist as $mylist ) {
				$query = "";
				$mylist = mysql_real_escape_string( $mylist );
				if ( !EmailAlreadyInDB( $mylist, $email, "ALL" ) ) {		
					$query = "INSERT INTO `$tbname` ( `fld_list`, `fld_firstname`, `fld_lastname`, `fld_company`, `fld_email`,
								`fld_opt1`, `fld_opt2`, `fld_opt3`, `fld_opt4`, `fld_opt5`, `fld_opt6`, `fld_opt7`, `fld_opt8`, `fld_opt9`, `fld_opt10`,
								`fld_opt11`, `fld_opt12`, `fld_opt13`, `fld_opt14`, `fld_opt15`, `fld_opt16`, `fld_opt17`, `fld_opt18`, `fld_opt19`, `fld_opt20` )
								VALUES( '$mylist', '$firstname', '$lastname', '$company', '$email', '$opt1', '$opt2', '$opt3', '$opt4', '$opt5', '$opt6', '$opt7', '$opt8', '$opt9', '$opt10',
								'$opt11', '$opt12', '$opt13', '$opt14', '$opt15', '$opt16', '$opt17', '$opt18', '$opt19', '$opt20' )";
				} else if ( EmailAlreadyInDB( $mylist, $email, "0" ) )  {				
					$query = "UPDATE `$tbname` SET `fld_sub` = '1', `fld_firstname` = '$firstname', `fld_lastname` = '$lastname', `fld_company` = '$company', `fld_email` = '$email',
								 `fld_opt1` = '$opt1', `fld_opt2` = '$opt2', `fld_opt3` = '$opt3', `fld_opt4` = '$opt4', `fld_opt5` = '$opt5',
								 `fld_opt6` = '$opt6', `fld_opt7` = '$opt7', `fld_opt8` = '$opt8', `fld_opt9` = '$opt9', `fld_opt10` = '$opt10',
								 `fld_opt11` = '$opt11', `fld_opt12` = '$opt12', `fld_opt13` = '$opt13', `fld_opt14` = '$opt14', `fld_opt15` = '$opt15',
								 `fld_opt16` = '$opt16', `fld_opt17` = '$opt17', `fld_opt18` = '$opt18', `fld_opt19` = '$opt19', `fld_opt20` = '$opt20'
						   WHERE `fld_list` = '$mylist' AND `fld_email` = '$email'";			
				}			
				if ( $query <> "" ) {
					If ( $res = @mysql_db_query( $dbname, $query ) ) {
						// Ok
					} else {
						CreateListTable();
						If ( $res = @mysql_db_query( $dbname, $query ) ) {
							// Ok
						} else {
							$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
							SendMessage( $admin_err_addr, "[MLM] Error inserting/updating record from AddSubscriberToDB()", $mysql_err . "\r" . $query, $headers, "" );
							$temp = $list;
							$list = $mylist;
							SaveMySQLRecord();
							$list = $temp;
						}	
					}
				}	
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			SendMessage( $admin_err_addr, "[MLM] Error selecting database from AddSubscriberToDB()", $mysql_err, $headers, "" );
			SaveMySQLRecord();
		}
	} else {	
		SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error from AddSubscriberToDB()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
		SaveMySQLRecord();
	}
}

// Update a subscriber from the mySQL table
function UpdateEmailFromDB( $list, $email, $entry ) {
	global $dbname, $tbname, $mysql_link, $mysql_err;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	
	if ( ConnectToMySqlServer() ) {
		If ( $res = @mysql_select_db ( $dbname ) ) {

			$line  = str_replace( "\n", "", $entry );
			$field = explode( "\t", $line );
				
			//if ( isEmailValid( $field[3] ) ) {	
			$firstname = mysql_real_escape_string( $field[0] );
			$lastname  = mysql_real_escape_string( $field[1] );
			$company   = mysql_real_escape_string( $field[2] );
			$newemail  = strtolower( mysql_real_escape_string( $field[3] ) );
			$opt1      = mysql_real_escape_string( $field[4] );
			$opt2      = mysql_real_escape_string( $field[5] );
			$opt3      = mysql_real_escape_string( $field[6] );
			$opt4      = mysql_real_escape_string( $field[7] );
			$opt5      = mysql_real_escape_string( $field[8] );
			$opt6      = mysql_real_escape_string( $field[9] );
			$opt7      = mysql_real_escape_string( $field[10] );
			$opt8      = mysql_real_escape_string( $field[11] );
			$opt9      = mysql_real_escape_string( $field[12] );
			$opt10     = mysql_real_escape_string( $field[13] );
			$opt11     = mysql_real_escape_string( $field[14] );
			$opt12     = mysql_real_escape_string( $field[15] );
			$opt13     = mysql_real_escape_string( $field[16] );
			$opt14     = mysql_real_escape_string( $field[17] );
			$opt15     = mysql_real_escape_string( $field[18] );
			$opt16     = mysql_real_escape_string( $field[19] );
			$opt17     = mysql_real_escape_string( $field[20] );
			$opt18     = mysql_real_escape_string( $field[21] );
			$opt19     = mysql_real_escape_string( $field[22] );
			$opt20     = mysql_real_escape_string( $field[23] );

			$singlelist = explode( ";", $list );	
			foreach ( $singlelist as $mylist ) {
				$query = "";
				$mylist = mysql_real_escape_string( $mylist );
				
				if ( EmailAlreadyInDB( $mylist, $email, "ALL" ) )  {				
					$query = "UPDATE `$tbname` SET `fld_sub` = '1', `fld_firstname` = '$firstname', `fld_lastname` = '$lastname', `fld_company` = '$company', `fld_email` = '$newemail',
								 `fld_opt1` = '$opt1', `fld_opt2` = '$opt2', `fld_opt3` = '$opt3', `fld_opt4` = '$opt4', `fld_opt5` = '$opt5',
								 `fld_opt6` = '$opt6', `fld_opt7` = '$opt7', `fld_opt8` = '$opt8', `fld_opt9` = '$opt9', `fld_opt10` = '$opt10',
								 `fld_opt11` = '$opt11', `fld_opt12` = '$opt12', `fld_opt13` = '$opt13', `fld_opt14` = '$opt14', `fld_opt15` = '$opt15',
								 `fld_opt16` = '$opt16', `fld_opt17` = '$opt17', `fld_opt18` = '$opt18', `fld_opt19` = '$opt19', `fld_opt20` = '$opt20'
						   WHERE `fld_list` = '$mylist' AND `fld_email` = '$email'";		
				} else {		
					$query = "INSERT INTO `$tbname` ( `fld_list`, `fld_firstname`, `fld_lastname`, `fld_company`, `fld_email`,
								`fld_opt1`, `fld_opt2`, `fld_opt3`, `fld_opt4`, `fld_opt5`, `fld_opt6`, `fld_opt7`, `fld_opt8`, `fld_opt9`, `fld_opt10`,
								`fld_opt11`, `fld_opt12`, `fld_opt13`, `fld_opt14`, `fld_opt15`, `fld_opt16`, `fld_opt17`, `fld_opt18`, `fld_opt19`, `fld_opt20` )
								VALUES( '$mylist', '$firstname', '$lastname', '$company', '$email', '$opt1', '$opt2', '$opt3', '$opt4', '$opt5', '$opt6', '$opt7', '$opt8', '$opt9', '$opt10',
								'$opt11', '$opt12', '$opt13', '$opt14', '$opt15', '$opt16', '$opt17', '$opt18', '$opt19', '$opt20' )";
				}
				if ( $query <> "" ) {
					If ( $res = @mysql_db_query( $dbname, $query ) ) {
						$result = 1; // Ok
					} else {
						CreateListTable();
						If ( $res = @mysql_db_query( $dbname, $query ) ) {
							$result = 1; // Ok
						} else {
							$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
							SendMessage( $admin_err_addr, "[MLM] Error inserting/updating record from UpdateEmailFromDB()", $mysql_err . "\r" . $query, $headers, "" );
							//$temp = $list;
							//$list = $mylist;
							//SaveMySQLRecord();
							//$list = $temp;
							$result = -1;
						}	
					}
				}	
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			SendMessage( $admin_err_addr, "[MLM] Error selecting database from UpdateEmailFromDB()", $mysql_err, $headers, "" );
			//SaveMySQLRecord();
			$result = -1;
		}
	} else {
		$mysql_err = "mySQL server connection error";
		SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error from UpdateEmailFromDB()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
		//SaveMySQLRecord();
		$result = -1;
	}
	return $result;
}

// Remove a subscriber from the mySQL table
function RemoveSubscriberFromDB( $email ) {
	global $dbname, $tbname, $mysql_link, $mysql_err;
	global $list;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	
	if ( ConnectToMySqlServer() ) {
		If ( $res = @mysql_select_db ( $dbname ) ) {	
			$singlelist  = explode( ";", $list );
			$singleemail = explode( ";", $email );
			
			$thelists = "";
			foreach ( $singlelist as $mylist ) {
				if ( $mylist <> "" ) {
					$mylist = mysql_real_escape_string( $mylist );
					if ( strlen( $thelists ) == 0 ) {
						$thelists = "`fld_list` = '$mylist'";
					} else {
						$thelists .= " OR `fld_list` = '$mylist'";
					}
				}
			}
			
			$theemails = "";
			foreach ( $singleemail as $myemail ) {
				if ( $myemail <> "" ) {
					$myemail = mysql_real_escape_string( $myemail );
					if ( strlen( $theemails ) == 0 ) {
						$theemails = "`fld_email` = '$myemail'";
					} else {
						$theemails .= " OR `fld_email` = '$myemail'";
					}
				}
			}
			
			if ( $list == "" ) {
				$query = "DELETE LOW_PRIORITY FROM `$tbname` WHERE $theemails";
			} else {
				$query = "DELETE LOW_PRIORITY FROM `$tbname` WHERE ( $thelists ) AND ( $theemails )";
			}
			
			If ( $res = @mysql_db_query( $dbname, $query ) ) {
				$rows = @mysql_affected_rows( $mysql_link ); // Ok
			} else {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				SendMessage( $admin_err_addr, "[MLM] Error deleting record from RemoveSubscriberFromDB()", $mysql_err . "\r" . $query, $headers, "" );
				$temp = $list;
				$list = $mylist;
				SaveMySQLRecord();
				$list = $temp;
			}

			return $rows;
			
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			SendMessage( $admin_err_addr, "[MLM] Error selecting database from RemoveSubscriberFromDB()", $mysql_err, $headers, "" );
			SaveMySQLRecord();
		}
	} else {	
		SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error from RemoveSubscriberFromDB()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
		SaveMySQLRecord();
	}
	return 0;
}

// Remove one or several lists from the DB table (with all its emails)
function RemoveListFromDB() {
	global $dbname, $tbname, $mysql_link, $mysql_err;
	global $list;
	
	if ( ConnectToMySqlServer() ) {
		If ( $res = @mysql_select_db ( $dbname ) ) {
			$singlelist = explode( ";", $list );	
			foreach ( $singlelist as $mylist ) {
				if ( $mylist <> "" ) {
					$mylist = mysql_real_escape_string( $mylist );
					$count++;
					if ( strlen( $thelists ) == 0 ) {
						$thelists = "`fld_list` = '$mylist'";
					} else {
						$thelists .= " OR `fld_list` = '$mylist'";
					}
				}
			}
			$query = "DELETE LOW_PRIORITY FROM `$tbname` WHERE $thelists";
			If ( $res = @mysql_db_query( $dbname, $query ) ) {
				$rows = @mysql_affected_rows( $mysql_link ); // Ok
				return $count;
			} else {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return -1;
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return -1;
		}
	} else {
		$mysql_err = "mySQL server connection error";
		return -1;
	}
}

// Show one or several concatened lists list1;list2;list3...
function GetListFromDB( $lists, $start, $rows ) {
	global $dbname, $tbname, $mysql_err, $mysql_link;
	global $list;
		
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			if ( !TableExists( $tbname ) ) { CreateListTable(); }
			if ( !TableExists( $tbname ) ) {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return False; // Error creating table
			} else {
				$singlelist = explode( ";", $list );	
				foreach ( $singlelist as $mylist ) {
					if ( $mylist <> "" ) {
						$mylist = mysql_real_escape_string( $mylist );
						if ( strlen( $thelists ) == 0 ) {
							$thelists = "`fld_list` = '$mylist'";
						} else {
							$thelists .= " OR `fld_list` = '$mylist'";
						}
					}
				}
				
				if ( $start <> 0 && $rows <> 0 ) {
					$start--;
					$query = "SELECT * FROM `$tbname` WHERE $thelists AND `fld_sub` = '1' ORDER BY UCASE(`fld_firstname`), UCASE(`fld_lastname`) LIMIT $start, $rows";
				} else {
					$query = "SELECT * FROM `$tbname` WHERE $thelists AND `fld_sub` = '1' ORDER BY `fld_email`";
				}
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count > 0 ) {
						for ( $j = 0; $j < $count; $j++ ) {
			 				$row = @mysql_fetch_array( $res );			
			 				$result  .= $row[fld_firstname] . "\t";
							$result  .= $row[fld_lastname] . "\t";
							$result  .= $row[fld_company] . "\t";
							$result  .= $row[fld_email] . "\t";
							$result  .= $row[fld_opt1] . "\t";
							$result  .= $row[fld_opt2] . "\t";
							$result  .= $row[fld_opt3] . "\t";
							$result  .= $row[fld_opt4] . "\t";
							$result  .= $row[fld_opt5] . "\t";
							$result  .= $row[fld_opt6] . "\t";
							$result  .= $row[fld_opt7] . "\t";
							$result  .= $row[fld_opt8] . "\t";
							$result  .= $row[fld_opt9] . "\t";
							$result  .= $row[fld_opt10] . "\t";
							$result  .= $row[fld_opt11] . "\t";
							$result  .= $row[fld_opt12] . "\t";
							$result  .= $row[fld_opt13] . "\t";
							$result  .= $row[fld_opt14] . "\t";
							$result  .= $row[fld_opt15] . "\t";
							$result  .= $row[fld_opt16] . "\t";
							$result  .= $row[fld_opt17] . "\t";
							$result  .= $row[fld_opt18] . "\t";
							$result  .= $row[fld_opt19] . "\t";
							$result  .= $row[fld_opt20] . "\t";
							$result  .= $row[fld_list] . "\n";
			 			}
			 			return $result;
					} else {
						return "";
					}	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return false; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return false; // Error selecting the database
		}
	} else {
		$mysql_err = "mySQL server connection error";
		return false; // Error connecting to the mySQL server
	}
}

// Show the size of one or several concatened lists list1;list2;list3...
function GetListSizeDB( $lists ) {
	global $dbname, $tbname, $mysql_err, $mysql_link;
	
	if ( ConnectToMySqlServer() ) {
	
		CreateDatabase( $dbname );
		
		if ( $res = @mysql_select_db ( $dbname ) ) {
			if ( !TableExists( $tbname ) ) { CreateListTable(); }
			if ( !TableExists( $tbname ) ) {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return -1; // Error creating table
			} else {
				$singlelist = explode( ";", $lists );	
				foreach ( $singlelist as $mylist ) {
					if ( $mylist <> "" ) {
						$mylist = mysql_real_escape_string( $mylist );
						if ( strlen( $thelists ) == 0 ) {
							$thelists = "`fld_list` = '$mylist'";
						} else {
							$thelists .= " OR `fld_list` = '$mylist'";
						}
					}
				}
				
				$query = "SELECT * FROM `$tbname` WHERE $thelists AND `fld_sub` = '1' ORDER BY `fld_email`";

				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
					return $count;
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return -1; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return -1; // Error selecting the database
		}
	} else {
		$mysql_err = "mySQL server connection error";
		return -1; // Error connecting to the mySQL server
	}
}

// Rename a list
function RenameListFromDB( $list, $name ) {
	global $dbname, $tbname, $mysql_link, $mysql_err;
	
	if ( ConnectToMySqlServer() ) {
		If ( $res = @mysql_select_db ( $dbname ) ) {	
			$query = "UPDATE `$tbname` SET `fld_list` = '" . mysql_real_escape_string( $name ) . "' WHERE `fld_list` = '" . mysql_real_escape_string( $list ) . "'";
			If ( $res = @mysql_db_query( $dbname, $query ) ) {
				$rows = @mysql_affected_rows( $mysql_link ); // Ok
				return True; //$count;
			} else {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return False; //-1;
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return False; //-1;
		}
	} else {
		$mysql_err = "mySQL server connection error";
		return False; //-1;
	}
}

// Check if an email already exists in the table for the given list
function EmailAlreadyInDB( $list, $email, $subscribed ) {
	global $dbname, $tbname, $mysql_err, $mysql_link;
		
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			if ( !TableExists( $tbname ) ) { CreateListTable(); }
			if ( !TableExists( $tbname ) ) {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return False; // Error creating table
			} else {
				$query = "SELECT * FROM `$tbname` WHERE `fld_list` = '" . mysql_real_escape_string( $list ) . "' AND `fld_email` = '" . mysql_real_escape_string( $email ) . "'";
				If ( $subscribed == "0" ) { $query .= " AND `fld_sub` = '0'"; } // Search unsubscribed only
				If ( $subscribed == "1" ) { $query .= " AND `fld_sub` = '1'"; } // Search subscribed only
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count > 0 ) {
			 			return true;
					} else {
						return false;
					}	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return false; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return false; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return false;
	}
}

// Check if a list already exists in the table
function ListExistsInDB( $list ) {
	global $dbname, $tbname, $mysql_err, $mysql_link;
	
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			if ( !TableExists( $tbname ) ) { CreateListTable(); }
			if ( !TableExists( $tbname ) ) {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return False; // Error creating table
			} else {
				$singlelist = explode( ";", $list );
				$thelists = "";
				foreach ( $singlelist as $mylist ) {
					if ( $mylist <> "" ) {
						$mylist = mysql_real_escape_string( $mylist );
						if ( strlen( $thelists ) == 0 ) {
							$thelists = "`fld_list` = '$mylist'";
						} else {
							$thelists .= " OR `fld_list` = '$mylist'";
						}
					}
				}
				$query = "SELECT DISTINCT fld_list FROM `$tbname` WHERE $thelists";	
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count == count( $singlelist ) ) {
			 			return true;
					} else {
						return false;
					}	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return false; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return false; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return false;
	}
}

// Show a list of all lists including recipient count and last change date
function ShowListNamesFromDB() {
	global $dbname, $tbname, $mysql_err, $mysql_link;
	global $email, $pwd;
		
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			if ( !TableExists( $tbname ) ) { CreateListTable(); }
			if ( !TableExists( $tbname ) ) {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return -1; // Error creating table
			} else {
				if ( $email <> "" ) {
					$query = "SELECT DISTINCT fld_list FROM `$tbname` WHERE `fld_email` = '" . mysql_real_escape_string( $email ) . "'";
				} else {
					$query = "SELECT DISTINCT fld_list FROM `$tbname`";
				}	
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count > 0 ) {
			 			for ( $j = 0; $j < $count; $j++ ) {
			 				$row = @mysql_fetch_array( $res );
							
							// ----------------------- This code may be slow - Replace with: $tablelastupdate = "YYYY-MM-DD HH:MM:SS";
			 				if ( $resdate = @mysql_db_query( $dbname, "SELECT UPDATE_TIME FROM INFORMATION_SCHEMA.TABLES WHERE table_name='$tbname'" ) ) {
		 						if ( @mysql_num_rows( $resdate ) > 0 ) {
			 						$rowdate = @mysql_fetch_array( $resdate );
			 						$tablelastupdate = $rowdate[0];
			 					}
			 				}
			 				// -----------------------
			 					
			 				if ( $rescount = @mysql_db_query( $dbname, "SELECT * FROM `$tbname` WHERE `fld_list` = '" . mysql_real_escape_string( $row[fld_list] ) . "'" ) ) {
			 					$totalsubscribers = @mysql_num_rows( $rescount );
			 				}
			 				
			 				if ( $pwd == "" ) {			
								If ( ( $email != "" && EmailAlreadyInDB( $row[fld_list], $email, "1" ) ) || $email == "" ) {
									If ( $result != "" ) { $result .= ";"; }
			 						$result .= $row[fld_list];
								}
							} else {
								If ( ( $email != "" && EmailAlreadyInDB( $row[fld_list], $email, "1" ) ) || $email == "" ) {
									If ( $result != "" ) { $result .= "\n"; }
									$result .= $row[fld_list] . "\t" . $totalsubscribers . "\t" . $tablelastupdate;
								}
							}
			 				
			 			}
			 			return $result;
					} else {
						return "";
					}	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return -1; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return -1; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return -1;
	}
}

// Find a recipient
function FindRecipientFromDB() {
	global $dbname, $tbname, $mysql_err, $mysql_link;
	global $firstname, $lastname, $company, $email;
	
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			if ( !TableExists( $tbname ) ) { CreateListTable(); }
			if ( !TableExists( $tbname ) ) {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return -1; // Error creating table
			} else {
			
				$firstname = mysql_real_escape_string( $firstname );
				$lastname  = mysql_real_escape_string( $lastname );
				$company   = mysql_real_escape_string( $company );
				$email     = mysql_real_escape_string( $email );
			
				$query = "SELECT * FROM `$tbname` WHERE ";
				
				If ( trim( $firstname ) <> "" ) {
					if ( $and ) { $query .= " AND "; }
					$query .= "UCASE(`fld_firstname`) LIKE UCASE('%$firstname%')";
					$and = true;
				}
					
				If ( trim( $lastname ) <> "" ) {
					if ( $and ) { $query .= " AND "; }
					$query .= "UCASE(`fld_lastname`) LIKE UCASE('%$lastname%')";
					$and = true;
				}
				
				If ( trim( $company ) <> "" ) {
					if ( $and ) { $query .= " AND "; }
					$query .= "UCASE(`fld_company`) LIKE UCASE('%$company%')";
					$and = true;
				}
				
				If ( trim( $email ) <> "" ) {
					if ( $and ) { $query .= " AND "; }
					$query .= "UCASE(`fld_email`) LIKE UCASE('%$email%')";
					$and = true;
				}
				
				$query .= " ORDER BY UCASE(`fld_firstname`)";			
				
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count > 0 ) {
						for ( $j = 0; $j < $count; $j++ ) {
			 				$row = @mysql_fetch_array( $res );			
			 				$result  .= $row[fld_firstname] . "\t";
							$result  .= $row[fld_lastname] . "\t";
							$result  .= $row[fld_company] . "\t";
							$result  .= $row[fld_email] . "\t";
							$result  .= $row[fld_list] . "\n";
			 			}
					} else {
						$result = "";
					}	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					$result = -1; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			$result = -1; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		$result = -1;
	}
	return $result;
}

// If record has not been successfully added to mySQL database
function SaveMySQLRecord() {
	global $cmd, $list, $firstname, $lastname, $company, $email;
	global $opt1, $opt2, $opt3, $opt4, $opt5, $opt6, $opt7, $opt8, $opt9, $opt10;
	global $opt11, $opt12, $opt13, $opt14, $opt15, $opt16, $opt17, $opt18, $opt19, $opt20;
	global $admin_err_addr, $path_to_sqlqueue;
	
	CreateDirectory( $path_to_sqlqueue );
	$filename = $path_to_sqlqueue . "/" . GetUniqueReference() . ".txt";
	$handle   = @fopen( $filename, "a+" );
	if ( $handle ) {
		$contents = "<cmd>$cmd</cmd>\n";
		$contents .= "<list>$list</list>\n";
		$contents .= "<firstname>$firstname</firstname>\n";
		$contents .= "<lastname>$lastname</lastname>\n";
		$contents .= "<company>$company</company>\n";
		$contents .= "<email>$email</email>\n";
		$contents .= "<opt1>$opt1</opt1>\n";
		$contents .= "<opt2>$opt2</opt2>\n";
		$contents .= "<opt3>$opt3</opt3>\n";
		$contents .= "<opt4>$opt4</opt4>\n";
		$contents .= "<opt5>$opt5</opt5>\n";
		$contents .= "<opt6>$opt6</opt6>\n";
		$contents .= "<opt7>$opt7</opt7>\n";
		$contents .= "<opt8>$opt8</opt8>\n";
		$contents .= "<opt9>$opt9</opt9>\n";
		$contents .= "<opt10>$opt10</opt10>\n";
		$contents .= "<opt11>$opt11</opt11>\n";
		$contents .= "<opt12>$opt12</opt12>\n";
		$contents .= "<opt13>$opt13</opt13>\n";
		$contents .= "<opt14>$opt14</opt14>\n";
		$contents .= "<opt15>$opt15</opt15>\n";
		$contents .= "<opt16>$opt16</opt16>\n";
		$contents .= "<opt17>$opt17</opt17>\n";
		$contents .= "<opt18>$opt18</opt18>\n";
		$contents .= "<opt19>$opt19</opt19>\n";
		$contents .= "<opt20>$opt20</opt20>\n";	
		@fwrite( $handle, $contents );
		@fclose( $handle );
	}
}

// Look at sqlqueue directory and insert all records
function EmptyMySQLQueue() {
	global $dbhost, $dbusername, $dbuserpass, $dbname, $tbname;
	global $admin_name_full, $admin_address, $admin_err_addr, $path_to_sqlqueue;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	CreateDirectory( $path_to_sqlqueue );
	
	if ( CountFilesInDir( $path_to_sqlqueue . "/", ".txt") > 0 ) {
		if ( $handle = opendir( $path_to_sqlqueue ) ) {
			if ( ConnectToMySqlServer() ) {
				CreateDatabase( $dbname );
				if ( $res = @mysql_select_db ( $dbname ) ) {	
					while (false !== ($file = readdir($handle))) {
						if ( $file != ".." && $file != "." && $file != ".htaccess" && $file != "index.html" ) {
							$filename = $path_to_sqlqueue . "/" . $file;
							$filehandle = @fopen($filename, "r");
							if ($filehandle) {
			       				$contents = fread($filehandle, filesize($filename));
			   					@fclose($filehandle);
			   					$xmlFieldNames = array("cmd", "list", "firstname", "lastname", "company", "email", "opt1", "opt2", "opt3", "opt4", "opt5", "opt6", "opt7", "opt8", "opt9", "opt10", "opt11", "opt12", "opt13", "opt14", "opt15", "opt16", "opt17", "opt18", "opt19", "opt20");
								$data = ParseXMLData($contents, $xmlFieldNames);						
								$cmd       = $data['cmd'];
								$list      = $data['list'];
								$firstname = $data['firstname'];
								$lastname  = $data['lastname'];
								$company   = $data['company'];
								$email     = $data['email'];
								$opt1      = $data['opt1'];
								$opt2      = $data['opt2'];
								$opt3      = $data['opt3'];
								$opt4      = $data['opt4'];
								$opt5      = $data['opt5'];
								$opt6      = $data['opt6'];
								$opt7      = $data['opt7'];
								$opt8      = $data['opt8'];
								$opt9      = $data['opt9'];
								$opt10     = $data['opt10'];
								$opt11     = $data['opt11'];
								$opt12     = $data['opt12'];
								$opt13     = $data['opt13'];
								$opt14     = $data['opt14'];
								$opt15     = $data['opt15'];
								$opt16     = $data['opt16'];
								$opt17     = $data['opt17'];
								$opt18     = $data['opt18'];
								$opt19     = $data['opt19'];
								$opt20     = $data['opt20'];

								if ( $payer_email <> "" ) {
									$singlelist = explode( ";", $list );	
									foreach ( $singlelist as $mylist ) {
										$query = "";
										if ( $cmd == "subscribe" ) {
											if ( !EmailAlreadyInDB( $mylist, $email, "ALL" ) ) {	
												$query = "INSERT INTO `$tbname` ( `fld_list`, `fld_firstname`, `fld_lastname`, `fld_company`, `fld_email`,
															`fld_opt1`, `fld_opt2`, `fld_opt3`, `fld_opt4`, `fld_opt5`, `fld_opt6`, `fld_opt7`, `fld_opt8`, `fld_opt9`, `fld_opt10`,
															`fld_opt11`, `fld_opt12`, `fld_opt13`, `fld_opt14`, `fld_opt15`, `fld_opt16`, `fld_opt17`, `fld_opt18`, `fld_opt19`, `fld_opt20` )
															VALUES( '$mylist', '$firstname', '$lastname', '$company', '$email', '$opt1', '$opt2', '$opt3', '$opt4', '$opt5', '$opt6', '$opt7', '$opt8', '$opt9', '$opt10',
															'$opt11', '$opt12', '$opt13', '$opt14', '$opt15', '$opt16', '$opt17', '$opt18', '$opt19', '$opt20' )";
											} else if ( EmailAlreadyInDB( $mylist, $email, "0" ) ) {
												$query = "UPDATE `$tbname` SET `fld_sub` = '1', `fld_firstname` = '$firstname', `fld_lastname` = '$lastname', `fld_company` = '$company' 
												          WHERE `fld_list` = '$mylist' AND `fld_email` = '$email' AND `fld_sub` = '0'";
											}
										} else if ( $cmd == "unsubscribe" ) {
											$query = "DELETE LOW_PRIORITY FROM `$tbname` WHERE `fld_list` = '$mylist' AND `fld_email` = '$email'";
										}
										if ( $query <> "" ) {
											If ( $res = @mysql_db_query( $dbname, $query ) ) {
												if ( file_exists( $filename ) ) { @unlink( $filename ); } // Ok
											} else {
												if ( $cmd == "subscribe" ) {
													SendMessage( $admin_err_addr, "[MLM SQL Queue] Error inserting/updating record from Queue script", @mysql_errno($link_id) . ": " . @mysql_error($link_id) . "\r" . $query, $headers, "" );
												} else if ( $cmd == "unsubscribe" ) {
													SendMessage( $admin_err_addr, "[MLM SQL Queue] Error deleting record from Queue script", @mysql_errno($link_id) . ": " . @mysql_error($link_id) . "\r" . $query, $headers, "" );
												}
											}
				 						}			 						
			 						}
		 						} else {
		 							if ( file_exists( $filename ) ) { @unlink( $filename ); }
		 						}
							}			
						} else {
							//SendMessage( $admin_err_addr, "[MLM SQL Queue] Can't open Queue file", "File access problem!\rCan't open Queue directory.", $headers, "" );
						}
					}
				} else {
		 			//SendMessage( $admin_err_addr, "[MLM SQL Queue] Error selecting database '$dbname' from Queue script", @mysql_errno($link_id) . ": " . @mysql_error($link_id), $headers, "" );
		 		}
				CloseConnectionToMySqlServer();
			} else {
				$mysql_err = "mySQL server connection error";
				//SendMessage( $admin_err_addr, "[MLM SQL Queue] mySQL Connect Error from Queue script", "Service unavailable!\r" . @mysql_errno($link_id) . ": " . @mysql_error($link_id), $headers, "" );
			}
			closedir($handle);
		} else {
			SendMessage( $admin_err_addr, "[MLM SQL Queue] Can't open Queue directory", "Directory access problem!\rCan't open Queue directory '$path_to_sqlqueue'.", $headers, "" );
		}
	}
}

//******************************************************************************************************************************<XML_FUNCTIONS>

function ParseXMLData ($xmlRaw, $xmlFieldNames) {
	// $xmlRaw="<order>Order data</order><label>Label data</label><control>123</control>";
	// $xmlFieldNames=array("order", "label", "control");
	foreach ($xmlFieldNames as $xmlField) {
   		if(strpos($xmlRaw,$xmlField)!==false){
       		$parsedXML[$xmlField]=substr($xmlRaw, strpos($xmlRaw,"<$xmlField>")+strlen("<$xmlField>"), strpos($xmlRaw,"</$xmlField>")-strlen("<$xmlField>")-strpos($xmlRaw,"<$xmlField>"));
		}
	}
	return($parsedXML);
}

//******************************************************************************************************************************<CLICK-THROUGH TRACKING>

// Recipient has clicked a link
function TrackClick() {
	global $use_mysql, $path_to_traffic, $path_by_delivery, $path_by_recipient, $ext_click, $ext_click_lock, $ext_click_test;
	global $firstname, $lastname, $company, $email, $subject, $delivery, $list, $total, $alt, $url, $test;
	
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = trackclicktoDB();
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = false;
		}
		// ***** MYSQL STUFF HERE *****
		
	} else {
	
		$email    = trim( $email );
		$delivery = trim( $delivery );
		
		if ( $delivery <> "" ) { 
	
			$user_info = GetUserSystemInfo();
		
			$date    = gmdate( 'Y-m-d H:i:s' );
			$ip      = getip();
			$os      = $user_info[0];
			$browser = $user_info[1];
		
			$entry = "$date\t$delivery\t$subject\t$alt\t$url\t$firstname\t$lastname\t$company\t$email\t$list\t$total\t$ip\t$os\t$browser\n";
		
			CreateDirectory( $path_to_traffic );
			CreateDirectory( $path_to_traffic . "/" . $path_by_delivery );
			CreateDirectory( $path_to_traffic . "/" . $path_by_recipient );
		
			if ( $test == "yes" ) {
				$deliveryfile  = $path_to_traffic . "/" . $path_by_delivery . "/" . $delivery . $ext_click_test;
				$recipientfile = $path_to_traffic . "/" . $path_by_recipient . "/" . $email . $ext_click_test;
			} else {
				$deliveryfile  = $path_to_traffic . "/" . $path_by_delivery . "/" . $delivery . $ext_click;
				$recipientfile = $path_to_traffic . "/" . $path_by_recipient . "/" . $email . $ext_click;
			}
		
			$lockfile = $path_to_traffic . "/" . $path_by_delivery . "/" . $delivery . $ext_click_lock;
		
			$handle1 = @fopen( $deliveryfile, "a+" );
			$locker  = @fopen( $lockfile, "a+" );
					
			If ( $handle1 && $locker ) {
				If ( flock( $locker, LOCK_EX ) ) {
					if ( @fwrite( $handle1, $entry ) === false ) { $result = false; } else { $result = true; };
					if ( $email <> "" ) { 
						$handle2 = @fopen( $recipientfile, "a+" );
						if ( $handle2 ) {
							@fwrite( $handle2, $entry );
							@fclose( $handle2 );
						}
					}
					flock( $locker, LOCK_UN );
				} else {
					// ERROR: Can't Lock file
				}
				@fclose( $handle1 );
				@fclose( $locker );
			} else {
				// ERROR: Handle not valid
			}
		}
	}
	return $result;
}

// Add click info to the mySQL DB
function TrackClicktoDB() {
	global $dbname, $tbname_clk, $mysql_link, $mysql_err;
	global $firstname, $lastname, $company, $email, $subject, $delivery, $list, $total, $alt, $url, $test;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	$email    = trim( $email );
	$delivery = trim( $delivery );
	
	if ( $delivery <> "" ) { 
	
		if ( $test == "yes" ) {
			$table = $tbname_clk . "_test";
		} else {
			$table = $tbname_clk;
		}
		
		$headers = "From: \"$admin_name_full\" <$admin_address>";
		
		$user_info = GetUserSystemInfo();
		
		$date    = gmdate( 'Y-m-d H:i:s' );
		$ip      = getip();
		$os      = $user_info[0];
		$browser = $user_info[1];
		
		if ( ConnectToMySqlServer() ) {
			If ( $res = @mysql_select_db ( $dbname ) ) {
				$subject   = mysql_real_escape_string( $subject );
				$alt       = mysql_real_escape_string( $alt );
				$url       = mysql_real_escape_string( $url );
				$firstname = mysql_real_escape_string( $firstname );
				$lastname  = mysql_real_escape_string( $lastname );
				$company   = mysql_real_escape_string( $company );
				$email     = mysql_real_escape_string( $email );
				$list      = mysql_real_escape_string( $list );
				$ip        = mysql_real_escape_string( $ip );				
				$os        = mysql_real_escape_string( $os );
				$browser   = mysql_real_escape_string( $browser );
	
				$query = "INSERT INTO `$table` ( `fld_date`, `fld_delivery`, `fld_subject`, `fld_alt`, `fld_url`, `fld_firstname`, `fld_lastname`, `fld_company`, `fld_email`, `fld_list`, `fld_total`, `fld_ip`, `fld_os`, `fld_browser` )
							VALUES( '$date', '$delivery', '$subject', '$alt', '$url', '$firstname', '$lastname', '$company', '$email', '$list', '$total', '$ip', '$os', '$browser' )";
							
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					// Ok
				} else {
					CreateClickTable();
					If ( $res = @mysql_db_query( $dbname, $query ) ) {
						// Ok
					} else {
						$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
						SendMessage( $admin_err_addr, "[MLM] Error inserting record from TrackClicktoDB()", $mysql_err . "\r" . $query, $headers, "" );
					}	
				}
			} else {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				SendMessage( $admin_err_addr, "[MLM] Error selecting database '$dbname' from TrackClicktoDB()", $mysql_err, $headers, "" );
			}
		} else {
			$mysql_err = "mySQL server connection error";
			SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error from TrackClicktoDB()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
		}
	}
}

// Create the mySQL table
function CreateClickTable() {
	global $dbname, $tbname_clk, $mysql_err, $mysql_link, $test;
	
	if ( $test == "yes" ) {
		$table = $tbname_clk . "_test";
	} else {
		$table = $tbname_clk;
	}

	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			//if ( !TableExists( $table ) ) {
				$query = GetCreateClickTableQuery( GetmySQLMajorVersion(), $table );	
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					return true;  // Table created successfully
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return false; // Table not created - Error
				}
			//} else {
			//	return true; // The table already exists
			//}
		} else {
			return false; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return false;
	}
}

// Show one or several concatened deliveries clicks delivery1;delivery2;delivery3...
function GetClicks( $deliveries ) {
	global $use_mysql, $path_to_traffic, $path_by_delivery, $path_by_recipient, $ext_click, $ext_click_test, $test;
	global $delivery, $email;
		
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = GetClicksFromDB( $deliveries );
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
		}
		// ***** MYSQL STUFF HERE *****
		
	} else {
	
		$email    = trim( $email );
		$delivery = trim( $delivery );
	
		CreateDirectory( $path_to_traffic );
		CreateDirectory( $path_to_traffic . "/" . $path_by_delivery );
		CreateDirectory( $path_to_traffic . "/" . $path_by_recipient );
		
		if ( $email <> "" ) {
		
			if ( $test == "yes" ) {
				$filename = $path_to_traffic . "/" . $path_by_recipient . "/" . $email . $ext_click_test;
			} else {
				$filename = $path_to_traffic . "/" . $path_by_recipient . "/" . $email . $ext_click;
			}
			
			if ( file_exists( $filename ) ) {
				//if ( $result != "" ) { $result .= "\n"; }
				$result .= LoadFileContentsAsText( $filename );
			} else {
				// Do nothing yet
			}
		
		
		} else {
		
			$delivery = explode( ";", $deliveries );	
			foreach ( $delivery as $mydelivery ) {
			
				if ( $test == "yes" ) {
					$filename = $path_to_traffic . "/" . $path_by_delivery . "/" . $mydelivery . $ext_click_test;
				} else {
					$filename = $path_to_traffic . "/" . $path_by_delivery . "/" . $mydelivery . $ext_click;
				}
				
				if ( file_exists( $filename ) ) {
					//if ( $result != "" ) { $result .= "\n"; }
					$result .= LoadFileContentsAsText( $filename );
				} else {
					// Do nothing yet
				}	
			}
			
		}
	}
	return $result;
}

// Show one or several concatened deliveries clicks delivery1;delivery2;delivery3...
function GetClicksFromDB( $deliveries ) {
	global $dbname, $tbname_clk, $mysql_err, $email, $test;
	
	if ( $test == "yes" ) {
		$table = $tbname_clk . "_test";
	} else {
		$table = $tbname_clk;
	}
	
	if ( !TableExists( $table ) ) {
		CreateClickTable();
	}
	
	$email      = trim( $email );
	$deliveries = trim( $deliveries );
		
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {			
			if ( !TableExists( $table ) ) {
				CreateClickTable();
				return "";
			} else {
			
				if ( $email <> "" ) {
			
					$query = "SELECT * FROM `$table` WHERE `fld_email` = '$email' ORDER BY `fld_date`";
				
				} else {
				
					$delivery = explode( ";", $deliveries );
					
					foreach ( $delivery as $mydelivery ) {
						$mydelivery = trim( $mydelivery );
						if ( $mydelivery <> "" ) {
							$mydelivery = mysql_real_escape_string( $mydelivery );
							if ( strlen( $thedeliveries ) == 0 ) {
								$thedeliveries = "`fld_delivery` = '$mydelivery'";
							} else {
								$thedeliveries .= " OR `fld_delivery` = '$mydelivery'";
							}
						}
					}
					
					$query = "SELECT * FROM `$table` WHERE $thedeliveries ORDER BY `fld_date`";
				
				}

				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count > 0 ) {
						for ( $j = 0; $j < $count; $j++ ) {
			 				$row = @mysql_fetch_array( $res );
					
							$result  .= $row[fld_date] . "\t";
							$result  .= $row[fld_delivery] . "\t";
							$result  .= $row[fld_subject] . "\t";
							$result  .= $row[fld_alt] . "\t";
							$result  .= $row[fld_url] . "\t";
			 				$result  .= $row[fld_firstname] . "\t";
							$result  .= $row[fld_lastname] . "\t";
							$result  .= $row[fld_company] . "\t";
							$result  .= $row[fld_email] . "\t";
							$result  .= $row[fld_list] . "\t";
							$result  .= $row[fld_total] . "\t";
							$result  .= $row[fld_ip] . "\t";				
							$result  .= $row[fld_os] . "\t";
							$result  .= $row[fld_browser] . "\n";
							
			 			}
			 			return $result;
					} else {
						return "";
					}	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return false; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return false; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return false;
	}
}

// Show a list of all the delivery numbers
function ShowDeliveries( $start, $rows ) {
	global $mlm_err, $use_mysql, $path_to_traffic, $path_by_delivery, $path_by_recipient;
	global $pwd, $ext_click, $ext_click_test, $email, $test;
		
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = ShowDeliveriesFromDB( $start, $rows );
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = -1;
		}
		// ***** MYSQL STUFF HERE *****
	
	} else {
		
		CreateDirectory( $path_to_traffic );
		CreateDirectory( $path_to_traffic . "/" . $path_by_delivery );
		CreateDirectory( $path_to_traffic . "/" . $path_by_recipient );
		
		if ( $test == "yes" ) {
			$extention = $ext_click_test;
		} else {
			$extention = $ext_click;
		}
	
		if ( $handle = @opendir( $path_to_traffic . "/" . $path_by_delivery ) ) {
			while ( false !== ( $file = readdir( $handle ) ) ) {
				if ( $file != ".." && $file != "." && $file != ".htaccess" && $file != "index.html" && substr( $file, -strlen( $extention ) ) == $extention && $file != $extention ) {
					
					$filename = $path_to_traffic . "/" . $path_by_delivery . "/" . $file;
					
					$contents = LoadFileContentsAsArray( $filename );
					list( $delivery_date, $delivery_id, $delivery_subject, $log_alt, $log_url, $log_firstname, $log_lastname, $log_company, $log_email, $delivery_listname, $delivery_recipients, $log_ip, $log_os, $log_browser ) = explode( "\t", $contents['0'] );
					
					if ( $pwd == "" ) {			
						If ( ( $email != "" && email_exists( $delivery_listname, $email ) ) || $email == "" ) {
							If ( $result != "" ) { $result .= ";"; }
							$result .= $delivery_id;
						}
					} else {
						If ( ( $email != "" && email_exists( $delivery_listname, $email ) ) || $email == "" ) {
							If ( $result != "" ) { $result .= "\n"; }
							$result .= $delivery_subject . "\t" . $delivery_id . "\t" . $delivery_date . "\t" . $delivery_listname . "\t" . $delivery_recipients;
						}
					}
					
				}
			}
			closedir( $handle );
	
			if ( $start <> 0 && $rows <> 0 ) {
			
				$data = explode( "\n", $result );
				usort( $data, "SortByDelivery2" );
				$result = "";
				$first = intval( $start );
				$last  = $first + intval( $rows );
				for ( $j = $first; $j < $last; $j++ ) {
					if ( $result != "" ) { $result .= "\n"; }
					$result .= $data[$j];
				}
			}		
			
		} else {
			$mlm_err = "Error opening $path_to_traffic/$path_by_delivery";
			$result = -1; // ERROR: Handle not valid
		}
	}
	return $result;
}

// This is a modified version of lm_admin.php SortByDelivery
function SortByDelivery2( $a, $b )
{
    if ( intval( extract_unit( $a, "\t", "\t" ) ) > intval( extract_unit( $b, "\t", "\t" ) ) ) {
    	return -1;
    } else if ( intval( extract_unit( $a, "\t", "\t" ) )  < intval( extract_unit( $b, "\t", "\t" ) ) ) {
    	return 1;
    } else {
    	return 0;
    }
}

// Extract the text between 2 markers, $start and $end - Used in SortByDelivery2 to extract the data between first and second tab
function extract_unit($string, $start, $end) {
	$pos = stripos($string, $start);
	$str = substr($string, $pos);
	$str_two = substr($str, strlen($start));
	$second_pos = stripos($str_two, $end);
	$str_three = substr($str_two, 0, $second_pos);
	$unit = trim($str_three); // remove whitespaces
	return $unit;
}

// Show a list of all the delivery numbers
function ShowDeliveriesFromDB( $start, $rows ) {
	global $dbname, $tbname_clk, $mysql_err, $email, $pwd, $test;
	
	if ( $test == "yes" ) {
		$table = $tbname_clk . "_test";
	} else {
		$table = $tbname_clk;
	}
	
	if ( !TableExists( $table ) ) {
		CreateClickTable();
	}
		
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {			
			if ( !TableExists( $table ) ) {
				CreateClickTable();
				return "";
			} else {
				if ( $email <> "" ) {
					$email = mysql_real_escape_string( $email );
					$query = "SELECT * FROM `$table` WHERE `fld_email` = '$email' GROUP BY fld_delivery ORDER BY fld_delivery DESC";  // ORDER BY fld_delivery DESC
				} else {
					$query = "SELECT * FROM `$table` GROUP BY fld_delivery ORDER BY fld_delivery DESC"; // ORDER BY fld_delivery DESC
				}				
				if ( $start <> 0 && $rows <> 0 ) {
					$start--;
					$query .= "  LIMIT $start, $rows";
				}
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count > 0 ) {
			 			for ( $j = 0; $j < $count; $j++ ) {
			 				$row = @mysql_fetch_array( $res );
							
							// ----------------------- This code may be slow - Replace with: $tablelastupdate = "YYYY-MM-DD HH:MM:SS";
			 				//if ( $resdate = @mysql_db_query( $dbname, "SELECT UPDATE_TIME FROM INFORMATION_SCHEMA.TABLES WHERE table_name='$table'" ) ) {
		 					//	if ( @mysql_num_rows( $resdate ) > 0 ) {
			 				//		$rowdate = @mysql_fetch_array( $resdate );
			 				//		$tablelastupdate = $rowdate[0];
			 				//	}
			 				//}
			 				// -----------------------
			 					
			 				//if ( $rescount = @mysql_db_query( $dbname, "SELECT * FROM `$table` WHERE `fld_list` = '$row[fld_list]'" ) ) {
			 				//	$totalsubscribers = @mysql_num_rows( $rescount );
			 				//}
			 				
			 				if ( $pwd == "" ) {			
								If ( ( $email != "" && EmailAlreadyInDB( $row[fld_list], $email, "1" ) ) || $email == "" ) {
									If ( $result != "" ) { $result .= ";"; }
			 						$result .= $row[fld_delivery];
								}
							} else {
								If ( ( $email != "" && EmailAlreadyInDB( $row[fld_list], $email, "1" ) ) || $email == "" ) {
									If ( $result != "" ) { $result .= "\n"; }
									$result .= $row[fld_subject] . "\t" . $row[fld_delivery] . "\t" . $row[fld_date] . "\t" . $row[fld_list] . "\t" . $row[fld_total];
								}
							}
			 				
			 			}
			 			return $result;
					} else {
						return "";
					}	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return -1; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return -1; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return -1; 
	}
}

// Check if a given delivery exists
function delivery_exists( $delivery ) {
	global $mlm_err, $use_mysql, $path_to_traffic, $path_by_delivery, $path_by_recipient;
	global $ext_click, $ext_click_test, $ext_click_lock;
		
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			if ( DeliveryExistsInDB( $delivery ) ) { $result = true; } else { $result = false; }
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = False;
		}
		// ***** MYSQL STUFF HERE *****
	
	} else {
		
		$result = True;
		
		CreateDirectory( $path_to_traffic );
		CreateDirectory( $path_to_traffic . "/" . $path_by_delivery );
		CreateDirectory( $path_to_traffic . "/" . $path_by_recipient );
		
 		$singledelivery = explode( ";", $delivery );	
 		foreach ( $singledelivery as $mydelivery ) {
 			if ( $mydelivery <> "" ) {			
 				$filename  = $path_to_traffic . "/" . $path_by_delivery . "/" . $mydelivery . $ext_click;
 				$filename2 = $path_to_traffic . "/" . $path_by_delivery . "/" . $mydelivery . $ext_click_test;
 				if ( @file_exists( $filename ) || @file_exists( $filename2 ) ) { 
 					// Do nothing
 				} else {
 					$result = false;
 				}
 			}
 		}

	}
	return $result;
}

// Check if a given delivery exists in the database
function DeliveryExistsInDB( $delivery ) {
	global $dbname, $tbname_clk, $mysql_err;
	
	if ( ConnectToMySqlServer() ) {
		If ( $res = @mysql_select_db ( $dbname ) ) {
			$singledelivery = explode( ";", $delivery );	
			foreach ( $singledelivery as $mydelivery ) {
				if ( $mydelivery <> "" ) {
					$count++;
					$mydelivery = mysql_real_escape_string( $mydelivery );
					if ( strlen( $thedeliveries ) == 0 ) {
						$thedeliveries = "`fld_delivery` = '$mydelivery'";
					} else {
						$thedeliveries .= " OR `fld_delivery` = '$mydelivery'";
					}
				}
			}
			
			$query = "SELECT DISTINCT fld_delivery FROM `$tbname_clk" . "_test" . "` WHERE $thedeliveries";
			If ( $res = @mysql_db_query( $dbname, $query ) ) {
				$count = @mysql_num_rows( $res );
				if ( $count == count( $singledelivery ) ) {
			 		return true;
				} else {
					//return false;
				}
			} else {
				//$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				//return -1;
			}
			
			$query = "SELECT DISTINCT fld_delivery FROM `$tbname_clk` WHERE $thedeliveries";
			If ( $res = @mysql_db_query( $dbname, $query ) ) {
				$count = @mysql_num_rows( $res );
				if ( $count == count( $singledelivery ) ) {
			 		return true;
				} else {
					return false;
				}
			} else {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return False;
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return False;
		}
	} else {
		$mysql_err = "mySQL server connection error";
		return False;
	}
	return False;
}

// Remove a delivery
function RemoveDelivery( $delivery ) {
	global $mlm_err, $use_mysql, $path_to_traffic, $path_by_delivery, $path_by_recipient;
	global $ext_click, $ext_click_test, $ext_click_lock;
		
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = RemoveDeliveryFromDB( $delivery );
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = -1;
		}
		// ***** MYSQL STUFF HERE *****
	
	} else {
		
		CreateDirectory( $path_to_traffic );
		CreateDirectory( $path_to_traffic . "/" . $path_by_delivery );
		CreateDirectory( $path_to_traffic . "/" . $path_by_recipient );
		
 		$singledelivery = explode( ";", $delivery );	
 		foreach ( $singledelivery as $mydelivery ) {
 			if ( $mydelivery <> "" ) {			
 				$filename = $path_to_traffic . "/" . $path_by_delivery . "/" . $mydelivery . $ext_click;
 				if ( @file_exists( $filename ) ) { 
 					if ( !@unlink( $filename ) ) {
 						$mlm_err = "Error opening $path_to_traffic/$path_by_delivery";
 						//$result = False;
 					} else {
 						$result++;
 					}
 				}
				
 				$filename = $path_to_traffic . "/" . $path_by_delivery . "/" . $mydelivery . $ext_click_lock;
 				if ( @file_exists( $filename ) ) { @unlink( $filename ); }
 		
 				$filename = $path_to_traffic . "/" . $path_by_delivery . "/" . $mydelivery . $ext_click_test;
 				if ( @file_exists( $filename ) ) { @unlink( $filename ); }
 								
 			}
 		}

	}
	return $result;
}

// Remove a delivery from the mySQL database
function RemoveDeliveryFromDB( $delivery ) {
	global $dbname, $tbname_clk, $mysql_err;
	
	if ( ConnectToMySqlServer() ) {
		If ( $res = @mysql_select_db ( $dbname ) ) {
			$singledelivery = explode( ";", $delivery );	
			foreach ( $singledelivery as $mydelivery ) {
				if ( $mydelivery <> "" ) {
					$count++;
					$mydelivery = mysql_real_escape_string( $mydelivery );
					if ( strlen( $thedeliveries ) == 0 ) {
						$thedeliveries = "`fld_delivery` = '$mydelivery'";
					} else {
						$thedeliveries .= " OR `fld_delivery` = '$mydelivery'";
					}
				}
			}
			
			$query = "DELETE LOW_PRIORITY FROM `$tbname_clk" . "_test" . "` WHERE $thedeliveries";
			If ( $res = @mysql_db_query( $dbname, $query ) ) {
				$rows = @mysql_affected_rows( $mysql_link ); // Ok
				//return $count;
			} else {
				//$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				//return -1;
			}
			
			$query = "DELETE LOW_PRIORITY FROM `$tbname_clk` WHERE $thedeliveries";
			If ( $res = @mysql_db_query( $dbname, $query ) ) {
				$rows = @mysql_affected_rows( $mysql_link ); // Ok
				return $rows;
			} else {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return -1;
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return -1;
		}
	} else {
		$mysql_err = "mySQL server connection error";
		return -1;
	}
}

// Return the number of deliveries
function GetDeliveryListSize() {
	global $mlm_err, $use_mysql, $path_to_traffic, $path_by_delivery, $path_by_recipient;
	global $pwd, $ext_click, $ext_click_test, $email, $test;
		
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = GetDeliveryListSizeFromDB();
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = -1;
		}
		// ***** MYSQL STUFF HERE *****
	
	} else {
		
		CreateDirectory( $path_to_traffic );
		CreateDirectory( $path_to_traffic . "/" . $path_by_delivery );
		CreateDirectory( $path_to_traffic . "/" . $path_by_recipient );
		
		if ( $test == "yes" ) {
			$extention = $ext_click_test;
		} else {
			$extention = $ext_click;
		}
	
		if ( $handle = @opendir( $path_to_traffic . "/" . $path_by_delivery ) ) {
			while ( false !== ( $file = readdir( $handle ) ) ) {
				if ( $file != ".." && $file != "." && $file != ".htaccess" && $file != "index.html" && substr( $file, -strlen( $extention ) ) == $extention && $file != $extention ) {
					
					$filename = $path_to_traffic . "/" . $path_by_delivery . "/" . $file;			
					$result++;

				}
			}
			closedir( $handle );
			
		} else {
			$mlm_err = "Error opening $path_to_traffic/$path_by_delivery";
			$result = -1; // ERROR: Handle not valid
		}
	}
	return $result;
}

// Return the number of deliveries fomr the database
function GetDeliveryListSizeFromDB( $start, $rows ) {
	global $dbname, $tbname_clk, $mysql_err, $email, $pwd, $test;
	
	if ( $test == "yes" ) {
		$table = $tbname_clk . "_test";
	} else {
		$table = $tbname_clk;
	}
	
	if ( !TableExists( $table ) ) {
		CreateClickTable();
	}
		
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {			
			if ( !TableExists( $table ) ) {
				CreateClickTable();
				return "";
			} else {
				if ( $email <> "" ) {
					$email = mysql_real_escape_string( $email );
					$query = "SELECT * FROM `$table` WHERE `fld_email` = '$email' GROUP BY fld_delivery";  // ORDER BY fld_delivery DESC
				} else {
					$query = "SELECT * FROM `$table` GROUP BY fld_delivery"; // ORDER BY fld_delivery DESC
				}				
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
					return $count;
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return -1; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return -1; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return -1; 
	}
}

//******************************************************************************************************************************<MISC FUNCTIONS>

// Get client IP number
function getip() {
	if (getenv("HTTP_CLIENT_IP") && strcasecmp(getenv("HTTP_CLIENT_IP"), "unknown")) {
		$ip = getenv("HTTP_CLIENT_IP");
	} else if (getenv("HTTP_X_FORWARDED_FOR") && strcasecmp(getenv("HTTP_X_FORWARDED_FOR"), "unknown")) {
		$ip = getenv("HTTP_X_FORWARDED_FOR");
	} else if (getenv("REMOTE_ADDR") && strcasecmp(getenv("REMOTE_ADDR"), "unknown")) {
		$ip = getenv("REMOTE_ADDR");
	} else if (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], "unknown")) {
		$ip = $_SERVER['REMOTE_ADDR'];
	} else {
		$ip = "unknown";
	}
	return($ip);
}

// Get client Info
function GetUserSystemInfo() {
	$curos=strtolower($_SERVER['HTTP_USER_AGENT']);
	$uip=$_SERVER['REMOTE_ADDR'];
	$uht=gethostbyaddr($_SERVER['REMOTE_ADDR']);

	if (strstr($curos,"mac")) {
		$uos="MacOS";
	} else if (strstr($curos,"linux")) {
		$uos="Linux";
	} else if (strstr($curos,"win")) {
		$uos="Windows";
	} else if (strstr($curos,"bsd")) {
		$uos="BSD";
	} else if (strstr($curos,"qnx")) {
		$uos="QNX";
	} else if (strstr($curos,"sun")) {
		$uos="SunOS";
	} else if (strstr($curos,"solaris")) {
		$uos="Solaris";
	} else if (strstr($curos,"irix")) {
		$uos="IRIX";
	} else if (strstr($curos,"aix")) {
		$uos="AIX";
	} else if (strstr($curos,"unix")) {
		$uos="Unix";
	} else if (strstr($curos,"amiga")) {
		$uos="Amiga";
	} else if (strstr($curos,"os/2")) {
		$uos="OS/2";
	} else if (strstr($curos,"beos")) {
		$uos="BeOS";
	} else {
		$uos="Unknown";
	}
        
	if (strstr($curos,"gecko")) {
		if (strstr($curos,"iphone")) {
			$bos="iPhone";
		} else if (strstr($curos,"ipad")) {
			$bos="iPad";
		} else if (strstr($curos,"safari")) {
			$bos="Safari";
		} else if (strstr($curos,"camino")) {
			$bos="Camino";
		} else if (strstr($curos,"firefox")) {
			$bos="Firefox";
		} else if (strstr($curos,"netscape")) {
			$bos="Netscape";
		} else {
			$bos="Mozilla";
		}
	} else if (strstr($curos,"opera")) {
		$bos="Opera";
	} else if (strstr($curos,"msie")) {
		$bos="Internet Explorer";
	} else if (strstr($curos,"voyager")) {
		$bos="Voyager";        
	} else if (strstr($curos,"lynx")) {
		$bos="Lynx";
	} else {
		$bos="Unknown Browser";
	}
 	  
   return array ($uos,$bos,$uip,$uht);
}

// Check if a host name is included in the list of allowed hosts
function ishostallowed($host) {
	global $allowedhosts;
	if ( trim( $allowedhosts ) == "" || strtolower( $allowedhosts ) == "all" || $allowedhosts == "*" ) {
		return True;
	} else {
		$hostlist = explode( ",", strtolower( $allowedhosts ) );
		if ( in_array( strtolower( $host ), $hostlist ) ) {
			return True;
		} else {
			return False;
		}
	}
}

// Extract the host out of a URL address. http://www.mysite.com/misc/index.php -> www.mysite.com
function getHost($Address) { 
   $parseUrl = parse_url(trim($Address)); 
   return trim($parseUrl[host] ? $parseUrl[host] : array_shift(explode('/', $parseUrl[path], 2))); 
} 

//******************************************************************************************************************************<LOCAL UNSUBSCRIBE HANDLING>
function AddEmailToLocalUnsubscribeList( $list, $firstname, $lastname, $company, $email, $test ) {
	global $mlm_err, $use_mysql, $path_to_offlists, $ext_list, $ext_list_out, $ext_list_lock;
	
	if ( $list == "" ) { $list = "All"; }
	$counter = 0;

	if ( $use_mysql == 1 ) {
			
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$counter = AddEmailToLocalUnsubscribeListDB( $list, $firstname, $lastname, $company, $email, $test  );
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to the mySQL server
			$mysql_err = "mySQL server connection error";
			$counter = -1;
		}
		// ***** MYSQL STUFF HERE *****
	
	} else {
		CreateDirectory( $path_to_offlists );
		$singlelist = explode( ";", $list );	
		foreach ( $singlelist as $mylist ) {
		
			$filepath = $path_to_offlists . "/" . $mylist . $ext_list;
			$lockfile = $path_to_offlists . "/" . $mylist . $ext_list_lock;
			$backup   = $path_to_offlists . "/" . $mylist . $ext_list_out;
			
			$action = "0"; // 0 = Unsubscribe
			if ( $test == "yes" ) { $istest = "1"; } else { $istest = "0"; }
			$entry = "$firstname\t$lastname\t$company\t$email\t$istest\t$action\n";

			if ( !email_alreadyinUnsubscribeList( $list, $email ) ) {
				$handle = @fopen( $filepath, "a+" );
				$locker = @fopen( $lockfile, "a+" );
				If ( $handle && $locker ) {
					If ( flock( $locker, LOCK_EX ) ) {
						if ( @fwrite( $handle, $entry ) === false ) {
							$counter = -1;
							$mlm_err = "Error writing data to $filepath";
						} else {
							$counter++;
							// <BACKUP>
							$handle = @fopen( $backup, "a+" );
							If( $handle ) {
								@fwrite( $handle, $entry );
								@fclose( $handle );
							}
							// </BACKUP>
						}
						flock( $locker, LOCK_UN );
					} else {
						$counter = -1;
						$mlm_err = "Error opening $lockfile";
					}
					@fclose( $handle );
					@fclose( $locker );
				} else {
					$counter = -1;
					$mlm_err = "Error opening $filepath";
				}
			} else {
				$counter = 1; // We return 1 so the customer will not receive any error
			}
		}
	}	
	return $counter;	
}

// Check if an email address already exists in the given unsubscribe list
function email_alreadyinUnsubscribeList( $list, $email ) {
	global $use_mysql, $path_to_offlists, $ext_list;
	
	$exists = False;
			
	$filepath = $path_to_offlists . "/" . $list . $ext_list;
	$fcontents = LoadFileContentsAsArray( $filepath );
	if ( $email <> "" && count($fcontents) > 0 ) {	
		while ( list ($line_num, $line) = each ($fcontents) ) { // while there are elements in the array			
			$line  = str_replace("\n", "", $line);	
			$field = explode( "\t", $line );			
			if ( strcmp( $email, $field[3]) == 0 ) {
				$exists = True;
				break;
			}
		}
	}
	return $exists;
}

function AddEmailToLocalUnsubscribeListDB( $list, $firstname, $lastname, $company, $email, $test ) {
	global $dbname, $tbname_off, $mysql_link, $mysql_err;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	
	if ( ConnectToMySqlServer() ) {
		If ( $res = @mysql_select_db ( $dbname ) ) {
		
			$firstname = mysql_real_escape_string( $firstname );
			$lastname  = mysql_real_escape_string( $lastname );
			$company   = mysql_real_escape_string( $company );
			$email     = mysql_real_escape_string( $email );
			
			$action = "0"; // 0 = Unsubscribe
			if ( $test == "yes" ) { $istest = "1"; } else { $istest = "0"; }
			
			$singlelist = explode( ";", $list );	
			foreach ( $singlelist as $mylist ) {				
				if ( !EmailAlreadyInUnsubscribedDB( $mylist, $email ) ) {	
					$mylist = mysql_real_escape_string( $mylist );
					$query = "INSERT INTO `$tbname_off` ( `fld_list`, `fld_firstname`, `fld_lastname`, `fld_company`, `fld_email`, `fld_test`, `fld_action` )
								VALUES( '$mylist', '$firstname', '$lastname', '$company', '$email', '$istest', '$action' )";
					If ( $res = @mysql_db_query( $dbname, $query ) ) {
						$counter++; // Ok
					} else {
						CreateLocalUnsubscribeListTable();
						If ( $res = @mysql_db_query( $dbname, $query ) ) {
							$counter++; // Ok
						} else {
							$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
							SendMessage( $admin_err_addr, "[MLM] Error inserting record from AddEmailToLocalUnsubscribeListDB()", $mysql_err . "\r" . $query, $headers, "" );
							$counter = -1;
						}	
					}
				} else {	
					$mylist = mysql_real_escape_string( $mylist );
					$query = "UPDATE `$tbname_off` SET `fld_processed` = '0', `fld_test` = '$istest', `fld_action` = '$action' WHERE `fld_list` = '$mylist' AND `fld_email` = '$email'";
					If ( $res = @mysql_db_query( $dbname, $query ) ) {
						$rows = @mysql_affected_rows( $mysql_link ); // Ok
					} else {
						$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
						//return false; // Querry Error
					}
					$counter = 1;
				}
			}
	
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			SendMessage( $admin_err_addr, "[MLM] Error selecting database from AddEmailToLocalUnsubscribeListDB()", $mysql_err, $headers, "" );
			$counter = -1;
		}
	} else {
		$mysql_err = "mySQL server connection error";
		$mysql_err = "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
		SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error from AddEmailToLocalUnsubscribeListDB()", $mysql_err, $headers, "" );
		$counter = -1;
	}
	Return $counter;
}

// This function create the table that will be used to store local unsubscribe requests
function CreateLocalUnsubscribeListTable() {
	global $dbname, $tbname_off, $mysql_err, $mysql_link;

	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			$query = GetCreateLocalTableQuery( GetmySQLMajorVersion(), $tbname_off );	
			If ( $res = @mysql_db_query( $dbname, $query ) ) {
				return true;  // Table created successfully
			} else {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return false; // Table not created - Error
			}
		} else {
			return false; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return false;
	}
}

// Show one or several concatened lists list1;list2;list3...
function GetLocalUnsubscribeList( $lists ) {
	global $mlm_err, $use_mysql, $path_to_offlists, $ext_list, $ext_list_lock;
	
	if ( $use_mysql == 1 ) {
				
		// ***** MYSQL STUFF HERE *****
		if ( ConnectToMySqlServer() ) {
			$result = GetLocalUnsubscribeListDB( $lists );
			CloseConnectionToMySqlServer();
		} else {
			// Error connecting to mySQL database
			$mysql_err = "mySQL server connection error";
			$result = False;
		}
		// ***** MYSQL STUFF HERE *****
		
	} else {
		$singlelist = explode( ";", $lists );	
		foreach ( $singlelist as $mylist ) {
			$filename = $path_to_offlists . "/" . $mylist . $ext_list;
			$lockfile = $path_to_offlists . "/" . $mylist . $ext_list_lock;
			$locker = @fopen( $lockfile, "a+" );
			
			If ( $locker && file_exists( $filename ) ) {
				If ( flock( $locker, LOCK_EX ) ) {
					//$result .= LoadFileContentsAsText( $filename );
					$fcontents = LoadFileContentsAsArray( $filename );
					if ( count($fcontents) > 0 ) {
						while ( list ($line_num, $line) = each ($fcontents) ) { // while there are elements in the array			
							$line = str_replace("\n", "", $line);	
							$field  = explode( "\t", $line );			
							if ( $field[5] == 0 ) {
								//if ($result <> "" ) { $result .= "\n"; }
								$result .= $line . "\n";
							}
						}
					}
					EmptyFile( $filename );
					flock( $locker, LOCK_UN );
				} else {
					$mlm_err = "Error opening $lockfile";
					$result = False;
				}
				@fclose( $locker );
			} else {
				$mlm_err = "Error opening $filename";
				$result = False;
			}	
		}
	}
	return $result;
}

// Show one or several concatened lists list1;list2;list3...
function GetLocalUnsubscribeListDB( $lists ) {
	global $dbname, $tbname_off, $mysql_err;
		
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {			
			if ( !TableExists( $tbname_off ) ) {

			} else {
				$singlelist = explode( ";", $lists );	
				foreach ( $singlelist as $mylist ) {
					if ( $mylist <> "" ) {
						$mylist = mysql_real_escape_string( $mylist );
						if ( strlen( $thelists ) == 0 ) {
							$thelists = "`fld_list` = '$mylist'";
						} else {
							$thelists .= " OR `fld_list` = '$mylist'";
						}
					}
				}
				
				$query = "SELECT * FROM `$tbname_off` WHERE $thelists AND `fld_processed` = '0' AND `fld_action` = '0' ORDER BY `fld_email`";
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count > 0 ) {
						for ( $j = 0; $j < $count; $j++ ) {
			 				$row = @mysql_fetch_array( $res );
			 				$result  .= $row[fld_firstname] . "\t";
							$result  .= $row[fld_lastname] . "\t";
							$result  .= $row[fld_company] . "\t";
							$result  .= $row[fld_email] . "\t";
							$result  .= $row[fld_test] . "\t";
							$result  .= $row[fld_action] . "\n";
							//$result  .= $row[fld_list] . "\n";
			 			}
						//$query = "DELETE LOW_PRIORITY FROM `$tbname_off` WHERE $thelists";
						$query = "UPDATE `$tbname_off` SET `fld_processed` = '1' WHERE $thelists";
						If ( $res = @mysql_db_query( $dbname, $query ) ) {
							$rows = @mysql_affected_rows( $mysql_link ); // Ok
						} else {
							$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
							//return false; // Querry Error
						}
			 			return $result;
					} else {
						return "";
					}	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return false; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return false; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return false;
	}
}

// Check if an email already exists in the Unsubscribe table for the given list
function EmailAlreadyInUnsubscribedDB( $list, $email ) {
	global $dbname, $tbname_off, $mysql_err;
		
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {			
			if ( !TableExists( $tbname_off ) ) {

			} else {
				$query = "SELECT * FROM `$tbname_off` WHERE `fld_list` = '" . mysql_real_escape_string( $list ) . "' AND `fld_email` = '" . mysql_real_escape_string( $email ) . "'";	
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count > 0 ) {
			 			return true;
					} else {
						return false;
					}	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					return false; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			return false; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error";
		return false;
	}
}

//******************************************************************************************************************************<SUBSCRIPTION REQUESTS HANDLING>

// Save request - WARNING - Similar to SaveInvitationRequestToDB() below!
function SaveRequestToDB( $reference ) {
	global $dbname, $tbname_req, $mysql_link, $mysql_err, $cmd;
	global $list, $firstname, $lastname, $company, $email;
	global $opt1, $opt2, $opt3, $opt4, $opt5, $opt6, $opt7, $opt8, $opt9, $opt10;
	global $opt11, $opt12, $opt13, $opt14, $opt15, $opt16, $opt17, $opt18, $opt19, $opt20;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	$date    = gmdate( 'Y-m-d H:i:s' );
	
	if ( ConnectToMySqlServer() ) {
		If ( $res = @mysql_select_db ( $dbname ) ) {
			$reference = mysql_real_escape_string( $reference );
			$firstname = mysql_real_escape_string( $firstname );
			$lastname  = mysql_real_escape_string( $lastname );
			$company   = mysql_real_escape_string( $company );
			$email     = mysql_real_escape_string( $email );
			$opt1      = mysql_real_escape_string( $opt1 );
			$opt2      = mysql_real_escape_string( $opt2 );
			$opt3      = mysql_real_escape_string( $opt3 );
			$opt4      = mysql_real_escape_string( $opt4 );
			$opt5      = mysql_real_escape_string( $opt5 );
			$opt6      = mysql_real_escape_string( $opt6 );
			$opt7      = mysql_real_escape_string( $opt7 );
			$opt8      = mysql_real_escape_string( $opt8 );
			$opt9      = mysql_real_escape_string( $opt9 );
			$opt10     = mysql_real_escape_string( $opt10 );
			$opt11     = mysql_real_escape_string( $opt11 );
			$opt12     = mysql_real_escape_string( $opt12 );
			$opt13     = mysql_real_escape_string( $opt13 );
			$opt14     = mysql_real_escape_string( $opt14 );
			$opt15     = mysql_real_escape_string( $opt15 );
			$opt16     = mysql_real_escape_string( $opt16 );
			$opt17     = mysql_real_escape_string( $opt17 );
			$opt18     = mysql_real_escape_string( $opt18 );
			$opt19     = mysql_real_escape_string( $opt19 );
			$opt20     = mysql_real_escape_string( $opt20 );

			$query = "";
			$mylist = mysql_real_escape_string( $list );
	
			$query = "INSERT INTO `$tbname_req` ( `fld_reference`, `fld_date`, `fld_command`, `fld_lists`, `fld_firstname`, `fld_lastname`, `fld_company`, `fld_email`,
						`fld_opt1`, `fld_opt2`, `fld_opt3`, `fld_opt4`, `fld_opt5`, `fld_opt6`, `fld_opt7`, `fld_opt8`, `fld_opt9`, `fld_opt10`,
						`fld_opt11`, `fld_opt12`, `fld_opt13`, `fld_opt14`, `fld_opt15`, `fld_opt16`, `fld_opt17`, `fld_opt18`, `fld_opt19`, `fld_opt20` )
						VALUES( '$reference', '$date', '$cmd', '$mylist', '$firstname', '$lastname', '$company', '$email', '$opt1', '$opt2', '$opt3', '$opt4', '$opt5', '$opt6', '$opt7', '$opt8', '$opt9', '$opt10',
						'$opt11', '$opt12', '$opt13', '$opt14', '$opt15', '$opt16', '$opt17', '$opt18', '$opt19', '$opt20' )";
		
			if ( $query <> "" ) {
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					return true;
				} else {
					CreateSubscribtionRequestTable();
					If ( $res = @mysql_db_query( $dbname, $query ) ) {
						return true;
					} else {
						$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
						SendMessage( $admin_err_addr, "[MLM] Error inserting record in SaveRequestToDB()", $mysql_err . "\r" . $query, $headers, "" );
						return false;
					}	
				}
			}
				
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			SendMessage( $admin_err_addr, "[MLM] Error selecting database in SaveRequestToDB()", $mysql_err, $headers, "" );
			return false;
		}
	} else {	
		SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error in SaveRequestToDB()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
		return false;
	}
}

// Save Invitation request - WARNING - Similar to SaveRequestToDB() above!
function SaveInvitationRequestToDB( $reference, $list, $field ) {
	global $dbname, $tbname_req, $mysql_link, $mysql_err;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	$date    = gmdate( 'Y-m-d H:i:s' );
	
	if ( ConnectToMySqlServer() ) {
		If ( $res = @mysql_select_db ( $dbname ) ) {
			$cmd       = "subscribe";
			$reference = mysql_real_escape_string( $reference );
			$firstname = mysql_real_escape_string( $field[0] );
			$lastname  = mysql_real_escape_string( $field[1] );
			$company   = mysql_real_escape_string( $field[2] );
			$email     = mysql_real_escape_string( $field[3] );
			$opt1      = mysql_real_escape_string( $field[4]);
			$opt2      = mysql_real_escape_string( $field[5] );
			$opt3      = mysql_real_escape_string( $field[6] );
			$opt4      = mysql_real_escape_string( $field[7] );
			$opt5      = mysql_real_escape_string( $field[8] );
			$opt6      = mysql_real_escape_string( $field[9] );
			$opt7      = mysql_real_escape_string( $field[10] );
			$opt8      = mysql_real_escape_string( $field[11] );
			$opt9      = mysql_real_escape_string( $field[12] );
			$opt10     = mysql_real_escape_string( $field[13] );
			$opt11     = mysql_real_escape_string( $field[14] );
			$opt12     = mysql_real_escape_string( $field[15] );
			$opt13     = mysql_real_escape_string( $field[16] );
			$opt14     = mysql_real_escape_string( $field[17] );
			$opt15     = mysql_real_escape_string( $field[18] );
			$opt16     = mysql_real_escape_string( $field[19] );
			$opt17     = mysql_real_escape_string( $field[20] );
			$opt18     = mysql_real_escape_string( $field[21] );
			$opt19     = mysql_real_escape_string( $field[22] );
			$opt20     = mysql_real_escape_string( $field[23] );

			$query = "";
			$mylist = mysql_real_escape_string( $list );
	
			$query = "INSERT INTO `$tbname_req` ( `fld_reference`, `fld_date`, `fld_command`, `fld_lists`, `fld_firstname`, `fld_lastname`, `fld_company`, `fld_email`,
						`fld_opt1`, `fld_opt2`, `fld_opt3`, `fld_opt4`, `fld_opt5`, `fld_opt6`, `fld_opt7`, `fld_opt8`, `fld_opt9`, `fld_opt10`,
						`fld_opt11`, `fld_opt12`, `fld_opt13`, `fld_opt14`, `fld_opt15`, `fld_opt16`, `fld_opt17`, `fld_opt18`, `fld_opt19`, `fld_opt20` )
						VALUES( '$reference', '$date', '$cmd', '$mylist', '$firstname', '$lastname', '$company', '$email', '$opt1', '$opt2', '$opt3', '$opt4', '$opt5', '$opt6', '$opt7', '$opt8', '$opt9', '$opt10',
						'$opt11', '$opt12', '$opt13', '$opt14', '$opt15', '$opt16', '$opt17', '$opt18', '$opt19', '$opt20' )";
		
			if ( $query <> "" ) {
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					return true;
				} else {
					CreateSubscribtionRequestTable();
					If ( $res = @mysql_db_query( $dbname, $query ) ) {
						return true;
					} else {
						$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
						SendMessage( $admin_err_addr, "[MLM] Error inserting record in SaveInvitationRequestToDB()", $mysql_err . "\r" . $query, $headers, "" );
						return false;
					}	
				}
			}
				
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			SendMessage( $admin_err_addr, "[MLM] Error selecting database in SaveInvitationRequestToDB()", $mysql_err, $headers, "" );
			return false;
		}
	} else {	
		SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error in SaveInvitationRequestToDB()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
		return false;
	}
}

// Check if the subscription request exists
function RequestExistsInDB( $reference ) {
	global $dbname, $tbname_req, $mysql_err, $mysql_link;
	global $admin_name_full, $admin_address, $admin_err_addr;
	global $request_life_span;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			if ( !TableExists( $tbname_req ) ) { CreateSubscribtionRequestTable(); }
			if ( !TableExists( $tbname_req ) ) {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return False; // Error creating table
			} else {
			
				$expdate = date( 'Y-m-d', strtotime( "-$request_life_span days" ) );
				$query = "SELECT * FROM `$tbname_req` WHERE `fld_reference` = '$reference' AND `fld_sub` = '0' AND `fld_date` >= '$expdate'";					
				
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			if ( $count > 0 ) {
						Return True;
					} else {
						Return False;
					}	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					SendMessage( $admin_err_addr, "[MLM] Query error in RequestExistsInDB()", $mysql_err . "\r" . $query, $headers, "" );
					Return False; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			SendMessage( $admin_err_addr, "[MLM] Error selecting database in RequestExistsInDB()", $mysql_err, $headers, "" );
			Return False; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error in RequestExistsInDB()";
		SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error in RequestExistsInDB()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
		Return False;
	}

}

// Remove the Expired Requests From the DB
function RemoveExpiredRequestsFromDB() {
	global $dbname, $tbname_req, $mysql_err, $mysql_link;
	global $admin_name_full, $admin_address, $admin_err_addr;
	global $request_life_span;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";
	
	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			if ( !TableExists( $tbname_req ) ) { CreateSubscribtionRequestTable(); }
			if ( !TableExists( $tbname_req ) ) {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				return False; // Error creating table
			} else {
			
				$expdate = date( 'Y-m-d', strtotime( "-$request_life_span days" ) );
			
				$query = "DELETE LOW_PRIORITY FROM `$tbname_req` WHERE `fld_date` < '$expdate'"; // AND `fld_sub` = '0'					
				
				If ( $res = @mysql_db_query( $dbname, $query ) ) {
					$count = @mysql_num_rows( $res );
		 			Return True;	
				} else {
					$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
					SendMessage( $admin_err_addr, "[MLM] Query error in RemoveExpiredRequestsFromDB()", $mysql_err . "\r" . $query, $headers, "" );
					Return False; // Querry Error
				}
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			SendMessage( $admin_err_addr, "[MLM] Error selecting database in RemoveExpiredRequestsFromDB()", $mysql_err, $headers, "" );
			Return False; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		// $mysql_err = "mySQL server connection error in RemoveExpiredRequestsFromDB()";
		// SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error in RemoveExpiredRequestsFromDB()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
		// Return False;
		Return True; // No problem, more luck next time!
	}

}

// This function create the table that will be used to store the subscription requests
function CreateSubscribtionRequestTable() {
	global $dbname, $tbname_req, $mysql_err, $mysql_link;
	global $admin_name_full, $admin_address, $admin_err_addr;
	
	$headers = "From: \"$admin_name_full\" <$admin_address>";

	if ( ConnectToMySqlServer() ) {
		CreateDatabase( $dbname );
		if ( $res = @mysql_select_db ( $dbname ) ) {
			$query = GetCreateRequestTableQuery( GetmySQLMajorVersion(), $tbname_req );	
			If ( $res = @mysql_db_query( $dbname, $query ) ) {
				return true;  // Table created successfully
			} else {
				$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
				SendMessage( $admin_err_addr, "[MLM] Error creating the $tbname_req table in CreateSubscribtionRequestTable()", $mysql_err, $headers, "" );
				return false; // Table not created - Error
			}
		} else {
			$mysql_err = @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link);
			SendMessage( $admin_err_addr, "[MLM] Error selecting database in CreateSubscribtionRequestTable()", $mysql_err, $headers, "" );
			return false; // Error selecting the database
		}
	} else {
		// Error connecting to the mySQL server
		$mysql_err = "mySQL server connection error in CreateSubscribtionRequestTable()";
		SendMessage( $admin_err_addr, "[MLM] mySQL Connect Error in CreateSubscribtionRequestTable()", "Service unavailable!\r" . @mysql_errno($mysql_link) . ": " . @mysql_error($mysql_link), $headers, "" );
		return false;
	}
}

?>