<?php

/* TRANSLATION NOTES - PLEASE READ
	Never use the character "
	Always escape the character ' this way \' like in << We\'re sorry >>
	Never translate the text between brackets like [EMAIL], [LISTS]...
	The text between brackets is a tag, it will be replaced by data in the script.
		[EMAIL] will be replaced by an email address
		[LIST] will be replaced by a list name
		[LISTS] will be replaced by a lists of list names, list1, list2, list3...
		[CMD] will be replaced by a command name
		[NUM], [LIFESPAN], [DUP] and [BAD will be replaced with a number, 1, 2, 3...
		[FILE] will be replaced with a file name
		[KEY] will be replaced by a reference
	A string sometimes will handle singular and plural.
	This file looks big but it only contains 92 strings.
*/

// Missing parameters errors

$mlm_debug = False;

if ( $mlm_debug ) {
	error_reporting(E_ALL); 
	ini_set('display_errors','on');
} else {
	error_reporting(E_ALL ^ E_NOTICE); 
	ini_set('display_errors','off');
}

$enc_quotes  = ENT_COMPAT;
$enc_charset = "UTF-8";

$kErr_missingparam_cmd = array(
	'en' => htmlentities( 'Error - You forgot to provide the command parameter', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Vous n\'avez pas spécifié la commande à exécuter', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Sie haben vergessen, den Parameter für den Befehl anzugeben', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No ha especificado el comando a ejecutar', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - non hai fornito un parametro di comando', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Je bent vergeten de opdracht parameter te geven', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - zapomněli jste zadat jeden z příkazových parametrů.', $enc_quotes, $enc_charset )
 );

$kErr_missingparam_key = array(
	'en' => htmlentities( 'Error - The key argument is missing', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - La clé est manquante', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die Angabe des Schlüssels fehlt', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No ha especificado la referencia asociada a este comando', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Manca l\'argomento chiave', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Het belangrijkste argument ontbreekt', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - chybí klíčový argument.', $enc_quotes, $enc_charset )
 );

$kErr_missingparam_lst = array(
	'en' => htmlentities( 'Error - You forgot to provide the list name parameter', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Vous n\'avez pas spécifié le nom de la liste', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Sie haben vergessen, den Parameter für den Listennamen anzugeben', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No ha especificado el nombre de la lista', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non hai indicato il parametro nome dell\'elenco', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Je bent de lijstnaam parameter vergeten', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - zapomněl jste zadat jméno seznamu.', $enc_quotes, $enc_charset )
 );

$kErr_missingparam_adr = array(
	'en' => htmlentities( 'Error - You forgot to provide the email address parameter', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Vous n\'avez pas spécifié l\'adresse e-mail', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Sie haben vergessen, den Parameter für die E-Mail-Adresse anzugeben', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No ha especificado la dirección de correo electrónico', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non hai indicato l\'indirizzo di posta elettronica', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Je bent de emailadres parameter vergeten', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - zapomněl jste zadat email.', $enc_quotes, $enc_charset )
 );

$kErr_missingparam_pwd = array(
	'en' => htmlentities( 'Error - You forgot to provide the password parameter', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Vous n\'avez pas spécifié le mot de passe', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Sie haben vergessen, den Parameter für das Kennwort anzugeben', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No ha especificado la clave de acceso', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non ha indicato la password', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Je bent de wachtwoord parameter vergeten', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - zapomněl jste zadat heslo.', $enc_quotes, $enc_charset )
 );

$kErr_missingparam_act = array(
	'en' => htmlentities( 'Error - You forgot to provide the action parameter', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Vous n\'avez pas spécifié l\'action à exécuter', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Sie haben vergessen, den Parameter für die Aktion anzugeben', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No ha especificado el tipo de acción a ejecutar', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non ha indicato il parametro di azione', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Je bent de actie parameter vergeten', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - zapomněl jste zadat akci.', $enc_quotes, $enc_charset )
);

$kErr_missingparam_dat = array(
	'en' => htmlentities( 'Error - You forgot to provide the data parameter', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Vous n\'avez pas spécifié les données à traiter', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Sie haben vergessen, den Parameter für die Daten anzugeben', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No ha especificado que datos deben ser procesados', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non hai indicato il parametro dato', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Je bent de data parameter vergeten', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - zapomněl jste zadat data.', $enc_quotes, $enc_charset )
);

$kErr_missingparam_del = array(
	'en' => htmlentities( 'Error - You forgot to provide the delivery number parameter', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Vous n\'avez pas spécifié le numéro de livraison', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Sie haben vergessen, den Parameter für die Sende-Nr. anzugeben', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No ha especificado el número de entrega', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non ha specificato il numero di consegna', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Je bent de verzendaantal parameter vergeten', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - zapomněl jste zadat parametr doručení.', $enc_quotes, $enc_charset )
);

$kErr_missingparam_cmn = array(
	'en' => htmlentities( 'Error - Command [CMD] not supported', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - La commande [CMD] n\'est pas valide', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Befehl [CMD] nicht unterstützt', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - El comando [CMD] no está soportado', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Il comando [CMD] non è supportato', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Opdracht [CMD] word niet ondersteund', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - příkaz [CMD] není podporovaný.', $enc_quotes, $enc_charset )
);

$kErr_missingparam_nna = array(
	'en' => htmlentities( 'Error - You forgot to provide the new list name parameter', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Vous n\'avez pas spécifié le nouveau nom de la liste', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Sie haben vergessen, den Parameter für den neuen Listennamen anzugeben', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No ha especificado el nuevo nombre de la lista', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non hai indicato il nuovo nome della lista', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Je bent vergeten de nieuwe lijstnaam parameter in te vullen', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - zapomněl jste zadat jméno nového seznamu.', $enc_quotes, $enc_charset )
);

// Command processor errors

$kErr_cmdprocessor_dup = array(
	'en' => htmlentities( 'Error - The email address [EMAIL] is already subscribed to list [LIST].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - L\'adresse e-mail [EMAIL] est déjà abonnée à la liste [LIST].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die E-Mail-Adresse [EMAIL] ist bereits in der Liste [LIST] eingetragen.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - La dirección de correo [EMAIL] ya está suscrita a la lista [LIST].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - L\indirizzo email [EMAIL] è già abbonato alla lista [LIST].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Het emailadres [EMAIL] is al ingeschreven op lijst [LIST].', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - email [EMAIL] již obsahuje seznam [LIST].', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_pwd = array(
	'en' => htmlentities( 'Error - Your password is wrong.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Votre mot de passe est incorrect.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Ihr Kennwort ist falsch.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - La contraseña es errónea.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - La password è sbagliata.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Je wachtwoord is niet correct.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - zadané heslo je chybné.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_ser = array(
	'en' => htmlentities( 'Error - Server problem when trying to subscribe [EMAIL] to the list(s) [LISTS].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - L\'abonnement de l\'adresse e-mail [EMAIL] à/aux liste(s) [LISTS] a échoué en raison d\'une erreur du serveur.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Serverproblem beim Versuch, die E-Mail-Adresse [EMAIL] in die Liste(n) [LISTS] einzutragen.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Ha ocurrido un problema en el servidor al intentar dar de alta [EMAIL] en la(s) lista(s) [LISTS].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Si è verificato un problema col server durante il tentativo di abbonamento della email [EMAIL] all\'elenco [LISTS] o più di un elenco.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Er is een serverprobleem opgetreden bij de poging [EMAIL] in te schrijven op de lijst(en) [LISTS].', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - při přidávání emailu [EMAIL] do seznamu [LIST] došlo k chybě serveru.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_unf = array(
	'en' => htmlentities( 'Error - The email address [EMAIL] was not found in any of the lists.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - L\'adresse e-mail [EMAIL] n\'a été trouvée dans aucune des listes.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die E-Mail-Adresse [EMAIL] wurde in keiner der Listen gefunden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No se ha encontrado la dirección [EMAIL] en ninguna de las listas.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - L\'indirizzo email [EMAIL] non è stato trovato in nessuna delle liste disponibili.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - het emailadres [EMAIL] is in geen enkele lijst gevonden.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - Email [EMAIL] nebyl nalezen v žádném seznamu.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_usp = array(
	'en' => htmlentities( 'Error - Server problem when trying to unsubscribe [EMAIL] from all lists.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Le désabonnement de l\'adresse e-mail [EMAIL] de toutes les listes a échoué en raison d\'une erreur du serveur.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Serverproblem beim Versuch, [EMAIL] von allen Listen abzumelden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Ha ocurrido un problema al intentar dar de baja [EMAIL] de todas las listas.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Si sono verificati problemi durante il tentativo di cancellazione dell\'abbonamento [EMAIL] da tutte le liste.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Er is een serverprobleem opgetreden bij de poging [EMAIL] uit te schrijven van alle lijsten.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - při odstraňování emailu [EMAIL] ze všech seznamů nastal problém na serveru.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_ulf = array(
	'en' => htmlentities( 'Error - The list [LIST] was not found on this server.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - La liste [LIST] est introuvable sur ce serveur.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die Liste [LIST] wurde auf diesem Server nicht gefunden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No se ha encontrado la lista [LIST] en este servidor.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - La lista [LIST] non è stata trovata su questo server.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - De lijst [LIST] is niet op deze server gevonden.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - seznam [LIST] nebyl na tomto serveru nalezen.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_unk = array(
	'en' => htmlentities( 'Error - The email address [EMAIL] was not found in list [LIST].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - L\'adresse e-mail [EMAIL] n\'a pas été trouvée dans la liste [LIST].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die E-Mail-Adresse [EMAIL] wurde in der Liste [LIST] nicht gefunden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No se ha encontrado la dirección [EMAIL] en la lista [LIST].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - L\'indirizzo email [EMAIL] non è stato trovato nella lista [LIST].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - het emailadres [EMAIL] is niet in de lijst [LIST] aangetroffen.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - email [EMAIL] nebyl nalezen v seznamu [LIST].', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_usk = array(
	'en' => htmlentities( 'Error - Server problem when trying to unsubscribe [EMAIL] from the list [LIST].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Le désabonnement de l\'adresse e-mail [EMAIL] de la liste [LIST] a échoué en raison d\'une erreur du serveur.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Serverproblem beim Versuch, [EMAIL] von der Liste [LIST] abzumelden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Ha ocurrido un problema en el servidor al intentar dar de baja [EMAIL] de la lista [LIST].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Si è verificato un problema col server nel tentativo di cancellazione di [EMAIL] dalla lista [LIST].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Er is een serverprobleem opgetreden bij de poging [EMAIL] van de lijst [LIST] te verwijderen.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - při odstraňování emailu [EMAIL] ze seznamu [LIST] nastal problém na serveru.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_uus = array(
	'en' => htmlentities( 'Error - The email address [EMAIL] was not found in the list(s) [LISTS].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - L\'adresse e-mail [EMAIL] n\'a pas été trouvée dans la/les liste(s) [LISTS].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die E-Mail-Adresse [EMAIL] wurde in der/den Liste(n) [LISTS] nicht gefunden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No se ha encontrado la dirección [EMAIL] en la(s) lista(s) [LISTS].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - L\'indirizzo email [EMAIL] non è stato trovato nella/e lista/ [LISTS].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Het emailadres [EMAIL] is niet in de lijst(en) [LISTS] aangetroffen.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - email [EMAIL] nebyl nalezen v seznamu nebo seznamech [LISTS].', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_ust = array(
	'en' => htmlentities( 'Error - Server problem when trying to unsubscribe [EMAIL] from the list(s) [LISTS].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Le désabonnement de l\'adresse e-mail [EMAIL] de/des liste(s) [LISTS] a échoué en raison d\'une erreur du serveur.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Serverproblem beim Versuch, [EMAIL] von der/den Liste(n) [LISTS] abzumelden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Ha ocurrido un problema en el servidor al intentar dar de baja [EMAIL] de las lista(s) [LISTS].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Si sono verificati problemi col server nel tentativo di cqancellazione di [EMAIL] dalla/e lista/e [LISTS].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Er is een serverprobleem opgetreden bij de poging [EMAIL] te verwijderen van de lijst(en) [LISTS].', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - při odstraňování emailu [EMAIL] ze seznamů [LISTS] došlo k problému na serveru.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_gsp = array(
	'en' => htmlentities( 'Error - Server problem when reading list.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Problème sur le serveur lors de la lecture de la liste.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Serverproblem beim Lesen der Liste.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Ha ocurrido un problema en el servidor al leer la lista.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Il server ha riscontrato un errore durante la lettura della lista.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Er is een serverprobleem opgetreden bij het lezen van de lijst.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - při čtení seznamu došlo na serveru k chybě.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_glu = array(
	'en' => htmlentities( 'Error - At least one of the lists doesn\'t exist.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Au moins une des listes n\'existe pas.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Mindestens eine der Listen ist nicht vorhanden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Al menos una de las listas no existe.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Una o più liste indicate non esistono.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Minimaal één van de lijsten bestaat niet.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - minimálně jeden seznam neexistuje.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_rlu = array(
	'en' => htmlentities( 'Error - Impossible to remove the specified list(s).', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Impossible de supprimer la/les liste(s) spécifiée(s).', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die angegebenen Listen können nicht entfernt werden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Imposible borrar la(s) lista(s) especificada(s).', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non è stato possibile rimuovere una o più liste specificate.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Onmogelijk de opgegeven lijst(en) te verwijderen.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - nelze odstranit jeden nebo více seznamů.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_icd = array(
	'en' => htmlentities( 'Error - Impossible to create the database or the table.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Impossible de créer la base de données ou la table spécifiée.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die Datenbank oder die Tabelle kann nicht erstellt werden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Imposible crear la base de datos o la tabla especificada.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non è stato possibile creare il database oppure la tabella.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Omogelijk de database of tabel aan te maken.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - nelze vytvořit databázi nebo tabulku.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_icl = array(
	'en' => htmlentities( 'Error - Impossible to create the specified list.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Impossible de créer la liste spécifiée.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die angegebene Liste kann nicht erstellt werden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Imposible crear la lista especificada.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non è stato possibile creare la lista specificata.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Onmogelijk de opgegeven lijst aan te maken.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - nelze vytvořit specifikovaný seznam.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_lae = array(
	'en' => htmlentities( 'Error - At least one of the lists already exists.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Au moins une des listes existe déjà.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Mindestens eine der Listen ist bereits vorhanden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Al menos una de las listas ya existe.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Una o più liste esistono già.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Minstens één van de lijsten bestaat al.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - minimálně jeden seznam již existuje.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_aes = array(
	'en' => htmlentities( 'Error - The list [LIST] already exists on this server.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - La liste [LIST] existe déjà sur ce serveur.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die Liste  [LIST] ist auf diesem Server bereits vorhanden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - La lista [LIST] ya existe en este servidor.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - La lista [LIST] esiste già su questo server.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - De lijst [LIST] bestaat al op deze server.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - seznam [LIST] již na tomto serveru existuje.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_prd = array(
	'en' => htmlentities( 'Error - Server problem when reading list directory.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Problème de serveur lors de la lecture du répertoire contenant les listes.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Serverproblem beim Lesen des Listenverzeichnisses.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Ha ocurrido un problema en el servidor al leer el directorio de listas.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Il server ha riscontrato problemi durante la lettura della directory della lista.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Er is een serverprobleem opgetreden bij het lezen van het lijst overzicht.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - při výpisu složky došlo k chybě na serveru.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_mna = array(
	'en' => htmlentities( 'Error - mySQL is not activated.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - mySQL n\'est pas activé.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - mySQL ist nicht aktiviert.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - mySQL no está activado.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - mySQL non è attivo.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - mySQL is niet geactiveerd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - mySQL není aktivovaná.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_ium = array(
	'en' => htmlentities( 'Error - Impossible to uninstall MLM.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Impossible de désinstaller MLM.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - MLM kann nicht deinstalliert werden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Imposible desinstalar MLM.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non è stato possibile disinstallare MLM.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Onmogelijk om MLM te de-installeren.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - nelze odinstalovat MLM.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_ley = array(
	'en' => htmlentities( 'Error - The list is empty.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - La liste est vide.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die Liste ist leer.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - La lista está vacía.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - La lista è vuota.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - De lijst is leeg.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - seznam je prázdný.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_ltb = array(
	'en' => htmlentities( 'Error - The list is too big (>200000000).', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - La liste est trop grande (> 200000000).', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die Liste ist zu groß (> 200000000).', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - El tamaño de la lista excede el limite establecido (>200000000).', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - La lista è troppo grossa (>200000000).', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - De lijst is te groot (>200000000).', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - seznam je moc velký (>200000000).', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_gie = array(
	'en' => htmlentities( 'Error - An error occurred when trying to get information about the server.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Impossible d\'obtenir des informations sur le serveur.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Fehler aufgetreten beim Versuch, Informationen über den Server zu erhalten.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Ha ocurrido un problema en el servidor al intentar obtener información.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Si è verificato un errore nel tentativo di ottenere informazioni relative al server.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Er is een fout opgetreden bij de poging informatie over de server te verzamelen.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - při získávání informací o tomto serveru došlo k chybě.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_cte = array(
	'en' => htmlentities( 'Error - Server problem while reading the Click-Through data.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Problème de serveur lors de la lecture des données statistiques.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Serverproblem beim Versuch, die Daten über die Klickraten zu lesen.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Ha ocurrido un problema en el servidor al intentar obtener datos de seguimiento estadístico.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Il server ha riscontrato un errore durante la lettura dei dati Click-Through.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Er is een probleem opgetreden bij het lezen van de DoorKlik gegevens.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - při čtení dat Click-Through došlo k problému se serverem.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_rct = array(
	'en' => htmlentities( 'Error - Server problem while reading the Click-Through tracking directory.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Problème de serveur lors de la lecture du répertoire contenant les données statistiques.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Serverproblem beim Versuch, das Verzeichnis zur Verfolgung der Klickraten zu lesen.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Ha ocurrido un problema en el servidor al leer el directorio de seguimiento estadístico.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Il server ha riscontrato un errore durante la lettura della directory di tracciatura del Click-Through.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Er is een serverprobleem opgetreden tijdens het lezen van de DoorKlik traceer directory.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - při čtení složky Click-Through došlo k problému na serveru.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_ren = array(
	'en' => htmlentities( 'Error - Impossible to rename the list [LIST].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Impossible de renommer la liste [LIST].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die Liste  [LIST] kann nicht umbenannt werden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Imposible cambiar el nombre de la lista [LIST].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non è stato possibile rinominare la lista [LIST].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Het is niet mogelijk de naam van lijst [LIST] te wijzigen.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - nelze přejmenovat seznam [LIST].', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_rdu = array(
	'en' => htmlentities( 'Error - Impossible to remove the specified delivery/es.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Impossible de supprimer la/les livraison(s) spécifiée(s).', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die angegebenen Versand können nicht entfernt werden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Imposible borrar la(s) entrega(s) especificada(s).', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Non è stato possibile rimuovere una o più spedizioni specificate.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Onmogelijk de opgegeven aflevering(en) te verwijderen.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - nelze odstranit jeden nebo více doručení.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_gdu = array(
	'en' => htmlentities( 'Error - At least one of the deliveries doesn\'t exist.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - Au moins une des livraisons n\'existe pas.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Mindestens eine der Versand ist nicht vorhanden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - Al menos una de las entregas no existe.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - Una o più spedizioni indicate non esistono.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - Minimaal één van de afleveringen bestaat niet.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - Minimálně jeden doručení neexistuje.', $enc_quotes, $enc_charset )
);

$kErr_cmdprocessor_udf = array(
	'en' => htmlentities( 'Error - The delivery [DELIVERY] was not found on this server.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur - La livraison [DELIVERY] est introuvable sur ce serveur.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler - Die Versand [DELIVERY] wurde auf diesem Server nicht gefunden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error - No se ha encontrado la entrega [DELIVERY] en este servidor.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore - La spedizione [DELIVERY] non è stata trovata su questo server.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout - De aflevering [DELIVERY] is niet op deze server gevonden.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba - Doručení [DELIVERY] nebyl na tomto serveru nalezen.', $enc_quotes, $enc_charset )
);

// Command processor messages

$kRes_cmdprocessor_err = array(
	'en' => htmlentities( 'Error', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Erreur', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Fout', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tde = array(
	'en' => htmlentities( 'Duplicate Email', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Adresse e-mail en double', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Doppelte E-Mail-Adresse', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Dirección de correo duplicada', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Indirizzo di email duplicato', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Dupliceer Email', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Duplikovaný email.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tsc = array(
	'en' => htmlentities( 'Subscription confirmation', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Confirmation de l\'abonnement', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Bestätigung des Abonnements', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Confirmación de la subscripción', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Conferma di Abbonamento', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Inschrijfbevestiging', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Potvrzení přihlášení', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tuc = array(
	'en' => htmlentities( 'Subscription cancellation', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Résiliation de l\'abonnement', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Beendigung des Abonnements', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Anulación de la subscripción', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Cancellazione dell\'abbonamento', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Abonnement beëindiging', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Zrušení přihlášení', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tss = array(
	'en' => htmlentities( 'You have been subscribed successfully', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Vous avez été correctement souscrit(e)', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Sie wurden erfolgreich als Abonnent eingetragen', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Ha sido dado de alta correctamente', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Ti sei abbonato con successo', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je inschrijving is geslaagd', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Byl(a) jste úspěšně přihlášen(a)', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tse = array(
	'en' => htmlentities( 'Subscription error', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'L\'abonnement a échoué', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Fehler bei der Eintragung des Abonnements', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Error de subscripción', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Errore di Abbonamento', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Inschrijf fout', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chyba přihlášení', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tln = array(
	'en' => htmlentities( 'List not found', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Liste introuvable', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Liste nicht gefunden', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lista no encontrada', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Lista non trovata', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Lijst niet gevonden', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Seznam nenalezen', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_ten = array(
	'en' => htmlentities( 'Email address not found', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Adresse e-mail introuvable', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'E-Mail-Adresse nicht gefunden', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Dirección de email no encontrada', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Indirizzo email non trovato', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Emailadres niet gevonden', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Emailová adresa nenalezena', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tsf = array(
	'en' => htmlentities( 'Subscription failure', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'L\'abonnement a échoué', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Eintragung  des Abonnements fehlgeschlagen', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Subscripción fallida', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Abbonamento non riuscito', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Inschrijving mislukt', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Přihlášení selhalo', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tuf = array(
	'en' => htmlentities( 'Subscription cancellation failure', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'La résiliation de l\'abonnement a échoué', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Beendigung des Abonnements fehlgeschlagen', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Baja fallida', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Cancellazione dell\'abbonamento non riuscita', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Abonnement beëindiging mislukt', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Zrušení přihlášení selhalo', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tsr = array(
	'en' => htmlentities( 'Subscription request', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Demande d\'abonnement', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Abonnement anfordern', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Solicitud de subscripción', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Richiesta di abbonamento', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Inschrijfverzoek', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Požadavek na přihlášení', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_trr = array(
	'en' => htmlentities( 'Your request has been received successfully', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Votre demande a été reçue correctement', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Ihre Anforderung wurde erfolgreich empfangen', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Su solicitud ha sido recibida correctamente', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La tua richiesta è stata ricevuta correttamente', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je verzoek is in goede orde ontvangen', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Váš požadavek byl úspěšně přijat', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tus = array(
	'en' => htmlentities( 'Your subscription has been cancelled', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Votre abonnement a été résilié', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Ihr Abonnement wurde beendet', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Su subscripción ha sido cancelada', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Il tuo abbonamento è stato cancellato', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je abonnement is beëindigd', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Vaše přihlášení bylo zrušeno', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_tke = array(
	'en' => htmlentities( 'Key is not valid or has expired', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'La clé est incorrecte ou a expirée', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Der Schlüssel ist ungültig oder abgelaufen', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La referencia no es válida o ha caducado', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La chiave non è valida oppure è scaduta', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Sleutel is niet geldig of verlopen', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Klíč není platný nebo vypršel', $enc_quotes, $enc_charset )
 );

$kRes_cmdprocessor_tkm = array(
	'en' => htmlentities( 'The key argument is missing', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'La clé est manquante', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Die Angabe des Schlüssels fehlt', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'No ha proporcionado el parametro de referencia', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'argomento della chiave è mancante', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het belangrijkste argument ontbreekt', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Chybí argument klíče', $enc_quotes, $enc_charset )
 );

$kRes_cmdprocessor_tlu = array(
	'en' => htmlentities( 'List Upload', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Transfert de listes', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Liste hochladen', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Subida de listas', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Upload della Lista', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Lijst Upload', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Nahrání seznamu', $enc_quotes, $enc_charset )
 );

$kRes_cmdprocessor_tls = array(
	'en' => htmlentities( 'List(s) [LISTS] uploaded successfully', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'La/les liste(s) [LISTS] ont été correctement transférée(s)', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Liste(n) [LISTS] wurde(n) erfolgreich hochgeladen', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La(s) lista(s) [LISTS] han sido subidas correctamente', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'upload della/e lista/e [LISTS] è avvenuto correttamente', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Lijst(en) [LISTS] is met succes ge-upload', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Seznam(y) [LISTS] úspěšně nahrán(y)', $enc_quotes, $enc_charset )
 );

$kRes_cmdprocessor_tli = array(
	'en' => htmlentities( 'List Import', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Importation de listes', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Listenimport', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Importación de listas', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Importazione Lista', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Lijst Import', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Import seznamu', $enc_quotes, $enc_charset )
 );

$kRes_cmdprocessor_tis = array(
	'en' => htmlentities( 'List(s) imported successfully', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'La ou les liste(s) ont correctement été importée(s)', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Liste(n) erfolgreich importiert', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La(s) lista(s) han sido importada(s) correctamente', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'importazione della/e lista/e è avvenuta con successo', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Lijst(en) met succes geïmporteerd', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Seznam(y) úspěšně importován(y)', $enc_quotes, $enc_charset )
 );

$kRes_cmdprocessor_mde = array(
	'en' => htmlentities( 'We\'re sorry, but the email address [EMAIL] is already subscribed to the list [LIST]. There is no need to subscribe again. If you think this is an error please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Nous sommes désolés mais l\'adresse e-mail [EMAIL] est déjà inscrite à la liste [LIST]. Nul besoin de vous inscrire de nouveau. Si vous pensez que cela est une erreur veuillez nous contacter à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Es tut uns leid, aber die E-Mail-Adresse [EMAIL] ist bereits in der Liste [LIST] eingetragen. Sie müssen sich nicht noch einmal eintragen. Wenn Sie meinen, dass es sich um einen Fehler handelt, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lo sentimos pero la dirección [EMAIL] ya fue dada de alta en la lista [LIST]. No hace falta darla de alta de nuevo. Si piensa que se trata de un error por favor contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'indirizzo email [EMAIL] è già abbonato alla lista [LIST]. Non è necessario riabbonare tale indirizzo. Se credi che ciò sia un errore, contattaci all\'indirizzo', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het spijt ons, maar het emailadres [EMAIL] is al ingeschreven op de lijst [LIST]. Het is niet nodig nogmaals in te schrijven. Als je denkt dat dit een fout is, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Je nám líto, ale email [EMAIL] je již přihlášený v seznamu [LIST]. Není nutné se přihlašovat znovu. Pokud si myslíte, že se jedná o chybu, prosím kontaktujte nás na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_mea = array(
	'en' => htmlentities( 'The email address [EMAIL] has been added to the list(s) [LISTS] successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'L\'adresse e-mail [EMAIL] a été ajoutée à/aux liste(s) [LISTS].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Die E-Mail-Adresse [EMAIL] wurde der/den Liste(n) [LISTS] erfolgreich hinzugefügt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La dirección [EMAIL] ha sido añadida a la(s) lista(s) [LISTS].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'indirizzo email [EMAIL] è stato aggiunto alla lista od alle liste [LISTS] correttamente.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het emailadres [EMAIL] is met succes aan de lijst(en) [LISTS] toegevoegd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Email [EMAIL] byl úspěšně přidán do seznamu(ů) [LISTS].', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_mas = array(
	'en' => htmlentities( 'You have asked to be subscribed to the list(s) [LISTS] with the email address [EMAIL].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Vous avez sollicité votre abonnement à/aux liste(s) [LISTS] avec l\'adresse e-mail [EMAIL].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Sie möchten sich mit der E-Mail-Adresse [EMAIL] in die Liste(n) [LISTS] eintragen.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Ha solicitado ser dado de alta a la(s) lista(s) [LISTS] con la dirección [EMAIL].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Hai richiesto di abbonarti alla lista od alle liste [LISTS] con l\'indirizzo di email [EMAIL].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je hebt verzocht te worden ingeschreven op de lijst(en) [LISTS] met het emailadres [EMAIL].', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Přihlásil jste se k odebírání novinek v seznamu [LISTS] na email [EMAIL].', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_msa = array(
	'en' => htmlentities( 'You have been added to our mailing list(s) [LISTS] successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Vous avez été inscrit à/aux liste(s) [LISTS].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Sie wurden unserer/unseren Mailing-Liste(n) [LISTS] erfolgreich hinzugefügt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Ha sido añadido a la(s) lista(s) [LISTS].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Ti sei abbonato alla/e nostra/e mailist list [LISTS] correttamente.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je bent met succes aan onze mailinglijst(en) [LISTS] toegevoegd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Byl(a) jste úspěšně přidán(a) do seznamu(ů) [LISTS]', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_svr = array(
	'en' => htmlentities( 'We\'re sorry, but your subscription to the list(s) [LISTS] has failed due to a server error. Please wait a while and try again. If the problem persists please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Nous sommes désolés mais votre abonnement à/aux liste(s) [LISTS] a échoué en raison d\'une erreur du serveur. Veuillez attendre un moment avant d\'essayez de nouveau. Si le problème persiste, contactez-nous à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Es tut uns leid, aber die Eintragung in die Liste(n) [LISTS] ist aufgrund eines Serverfehlers fehlgeschlagen. Bitte warten Sie eine Weile und versuchen Sie es noch einmal. Wenn das Problem bestehen bleibt, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lo sentimos pero su subscripción a la(s) lista(s) [LISTS] ha fallado debido a un error del servidor. Por favor espere e intentelo más tarde. Si el problema persiste contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Il tentativo di abbonamento alla/e lista/e [LISTS] non è riuscito a causa di un errore del server. Attendi un pò e poi riprova. Qualora il problema dovesse persistere, contattaci a', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het spijt ons, maar het inschrijven op de lijst(en) [LISTS] is mislukt vanwege een probleem met de server. Wacht een tijdje en probeer het opnieuw. Als het probleem aanhoudt, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Je nám líto, ale přihlášení do seznamu(ů) [LISTS] selhalo kvůli chybě na serveru. Prosím počkejte, a poté akci opakujte. Pokud chyba přetrvává, prosím kontaktujte nás na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_ses = array(
	'en' => htmlentities( 'This service requires a confirmation in order to prevent others from subscribing you to the list without your consent. You have been sent an email with a special link. When you receive the email, please click on the link, or copy and paste it into your browser to enable your subscription.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Ce service nécessite une confirmation en vue d\'empêcher d\'autres personnes de vous abonner à une liste sans votre consentement. Nous vous avons envoyé un e-mail avec un lien spécial. Lorsque vous recevez cet e-mail, veuillez cliquer sur ce lien ou copiez et collez le dans votre navigateur afin d\'activer votre abonnement.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Dieser Service erfordert eine Bestätigung, um zu verhindern, dass andere Personen Sie ohne Ihr Einverständnis in die Liste eintragen. Wir haben eine E-Mail mit einem speziellen Link an Sie gesendet. Wenn Sie die E-Mail erhalten haben, klicken Sie bitte auf den Link oder kopieren Sie ihn in die Adresszeile Ihres Browsers, um das Abonnement freizuschalten.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Este servicio necesita una confirmación para evitar que otros puedan darle de alta sin su consentimiento. Le hemos enviado un correo electrónico con un enlace especial. Cuando reciba este correo y para finalizar su subscripción, solo necesita hacer click en el, o copiar y pegarlo a su navegador.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Per abbonarti a questo servizio è richiesta una conferma per prevenire che altri sottoscrivano il tuo indirizzo alla lista senza il tuo consenso. Ti è stata inviata una email contenente un link apposito. Quando riceverai l\'email, fai clic sul link oppure copialo ed incollalo nel tuo browser al fine di attivare il tuo abbonamento.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Deze dienst vereist een bevestiging om er voor te zorgen dat anderen je kunnen inschrijven op de lijst zonder je toestemming. We hebben je een email toegezonden met een speciale link. Als je de email hebt ontvangen, klik dan op de link of kopieer deze naar je webbrowser om je inschrijving te bevestigen.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Tato služba vyžaduje potvrzení Vašeho záměru z důvodu možného zneužití jinou osobou bez Vašeho vědomí. Byl Vám zaslán email se speciálním odkazem. Jakmile jej obdržíte, klikněte prosím na tento odkaz nebo jej zkopírujte do Vašeho prohlížeče pro potvrzení žádosti o přihlášení.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_ues = array(
	'en' => htmlentities( 'We\'re sorry, but the email address [EMAIL] has not been found in any of the lists. Check the address and try again. If you think this is an error please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Nous sommes désolés, mais l\'adresse e-mail [EMAIL] n\'a été trouvée dans aucune des listes. Vérifiez l\'adresse et essayez à nouveau. Si vous pensez que cela est une erreur veuillez nous contacter à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Es tut uns leid, aber die E-Mail-Adresse [EMAIL] wurde in keiner der Listen gefunden. Prüfen Sie die Adresse und versuchen Sie es noch einmal. Wenn Sie meinen, dass es sich um einen Fehler handelt, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lo sentimos pero no se ha encontrado la dirección de correo [EMAIL] en ninguna de las listas. Verifique la dirección y pruebe de nuevo. Si piensa que se trata de un error por favor contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'indirizzo email [EMAIL] non è stato trovato in alcuna delle liste. Verifica l\'indirizzo e riprova. Se credi che questo invece sia un errore, contattaci a', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het spijt ons, maar het emailadres [EMAIL] is geen enkele van de lijsten aangetroffen. Controleer het adres en probeer het nogmaals. Als je denkt dat het een fout is, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Je nám líto, ale email [EMAIL] nebyl nalezen v žádném z našich seznamů. Zkontrolujte prosím adresu a zkuste to znovu. Pokud si myslíte, že se jedná o chybu, kontaktujte nás prosím na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uss = array(
	'en' => htmlentities( 'We\'re sorry, but the cancellation of your subscription to all lists has failed due to a server error. Please wait a while and try again. If the problem persists please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Nous sommes désolés, mais la résiliation de votre abonnement à toutes les listes a échoué en raison d\'une erreur du serveur. Veuillez attendre un moment avant d\'essayez de nouveau. Si le problème persiste, contactez-nous à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Es tut uns leid, aber die Beendigung Ihrer gesamten Abonnements ist aufgrund eines Serverfehlers fehlgeschlagen. Bitte warten Sie eine Weile und versuchen Sie es noch einmal. Wenn das Problem bestehen bleibt, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lo sentimos pero su solicitud de baja desde todas las listas ha fallado debido a un error del servidor. Por favor espere e intentelo más tarde. Si el problema persiste contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La cancellazione dalla/e lista/e non ha avuto successo a causa di un errore del server. Attendi un pò e riprova più tardi. Qualora il problema dovesse persistere, contattaci a', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het spijt ons, maar de beëindiging van je abonnement op alle lijsten is mislukt vanwege een serverprobleem. Wacht een tijdje en probeer het opnieuw. Als het probleem aanhoudt, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Je nám líto, ale zrušení vašeho přihlášení do všech seznamů selhalo z důvodu chyby na serveru. Prosím počkejte a opakujte akci později. Pokud problém přetrvává, prosím kontaktujte nás na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uar = array(
	'en' => htmlentities( 'The email address [EMAIL] has been removed from all lists successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'L\'adresse e-mail [EMAIL] a été supprimée de toutes les listes.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Die E-Mail-Adresse [EMAIL] wurde erfolgreich aus allen Listen entfernt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La dirección de correo [EMAIL] ha sido dada de baja de todas las listas.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La cancellazione dell\'indirizzo email [EMAIL] è andata a buon fine.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het emailadres [EMAIL] is met succes van alle lijsten verwijderd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Email [EMAIL] byl úspšně odstraněn ze všech seznamů.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uya = array(
	'en' => htmlentities( 'You have asked to cancel your subscription from all lists.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Vous avez sollicité la résiliation de votre abonnement de toutes les listes.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Sie möchten Ihre Eintragung in allen Listen beenden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Ha solicitado la baja de su subscrición desde todas las listas.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Hai richiesto di de-abbonarti da tutte le liste.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je hebt om beëindiging van je abonnement op alle lijsten gevraagd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Požádal(a) jste o zrušení Vašeho přihlášení ze všech seznamů.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uso = array(
	'en' => htmlentities( 'The email address [EMAIL] has been successfully deleted.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'L\'adresse e-mail [EMAIL] a bien été supprimée.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Die E-Mail-Adresse [EMAIL] wurde erfolgreich gelöscht.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La dirección de correo [EMAIL] ha sido dada de baja.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La cancellazione dell\'indirizzo email [EMAIL] è andata a buon fine.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het emailadres [EMAIL] is met succes verwijderd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Email [EMAIL] byl úspěšně vymazán.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uer = array(
	'en' => htmlentities( 'The email address [EMAIL] has been removed from [LIST] successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'L\'adresse e-mail [EMAIL] a été retirée de la liste [LIST].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Die E-Mail-Adresse [EMAIL] wurde erfolgreich aus der Liste [LIST] entfernt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La dirección de correo [EMAIL] ha sido dada de baja de la lista [LIST].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La rimozione dell\'indirizzo email [EMAIL] dalla lista [LIST] è andata a buon fine.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het emailadres [EMAIL] is met succes van de lijst [LIST] verwijderd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Email [EMAIL] byl úspěšně odstraněn ze seznamu [LIST].', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uen = array(
	'en' => htmlentities( 'We\'re sorry, but the email address [EMAIL] has not been found in the list [LIST]. Check the address and try again. If you think this is an error please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Nous sommes désolés, mais l\'adresse e-mail [EMAIL] n\'a pas été trouvée dans la liste [LIST]. Vérifiez l\'adresse et essayez à nouveau. Si vous pensez que cela est une erreur veuillez nous contacter à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Es tut uns leid, aber die E-Mail-Adresse [EMAIL] wurde nicht in der Liste [LIST] gefunden. Prüfen Sie die Adresse und versuchen Sie es noch einmal. Wenn Sie meinen, dass es sich um einen Fehler handelt, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lo sentimos pero no se ha encontrado la dirección de correo [EMAIL] en la lista [LIST]. Verifique la dirección y pruebe de nuevo. Si piensa que se trata de un error por favor contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'indirizzo email [EMAIL] non è stato trovato nella lista [LIST]. Verifica l\'indirizzo e riprova. Qualora tu ritenga che questo invece sia un errore, contattaci a', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het spijt ons, maar het emailadres [EMAIL] is niet aangetroffen op de lijst [LIST]. Controleer het adres en probeer het opnieuw. Als je denkt dat het een fout is, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Je nám líto, ale email [EMAIL] nebyl nalazen v seznamu [LIST]. Zkontrolujte adresu a opakujte akci později. Pokud si myslíte, že se jedná o chybu, kontaktujte nás prosím na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_unf = array(
	'en' => htmlentities( 'We\'re sorry, but the email address [EMAIL] has not been found in the list(s) [LISTS]. Check the address and try again. If you think this is an error please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Nous sommes désolés, mais l\'adresse e-mail [EMAIL] n\'a pas été trouvée dans le(s) liste(s) [LISTS]. Vérifiez l\'adresse et essayez à nouveau. Si vous pensez que cela est une erreur veuillez nous contacter à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Es tut uns leid, aber die E-Mail-Adresse [EMAIL] wurde nicht in der/den Liste(n) [LISTS] gefunden. Prüfen Sie die Adresse und versuchen Sie es noch einmal. Wenn Sie meinen, dass es sich um einen Fehler handelt, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lo sentimos pero no se ha encontrado la dirección de correo [EMAIL] en la(s) lista(s) [LISTS]. Verifique la dirección y pruebe de nuevo. Si piensa que se trata de un error por favor contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'indirizzo email [EMAIL] non è stato trovato nella lista/e [LISTS]. Verifica l\'indirizzo e riprova. Qualora tu ritenga che questo invece sia un errore, contattaci a', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het spijt ons, maar het emailadres [EMAIL] is niet aangetroffen op de lijst(en) [LISTS]. Controleer het adres en probeer het opnieuw. Als je denkt dat het een fout is, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Je nám líto, ale email [EMAIL] nebyl nalezen v seznamu nebo seznamech [LISTS]. Zkontrolujte adresu a akci opakujte. Pokud si myslíte, že se jedná o chybu, prosím kontaktujte nás na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uec = array(
	'en' => htmlentities( 'We\'re sorry, but the cancellation of your subscription to list [LIST] has failed due to a server error. Please wait a while and try again. If the problem persists please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Nous sommes désolés, mais la résiliation de votre abonnement à la liste [LIST] a échoué en raison d\'une erreur du serveur. Veuillez attendre un moment avant d\'essayez de nouveau. Si le problème persiste, contactez-nous à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Es tut uns leid, aber die Beendigung Ihres Abonnements der Liste [LIST] ist aufgrund eines Serverfehlers fehlgeschlagen. Bitte warten Sie eine Weile und versuchen Sie es noch einmal. Wenn das Problem bestehen bleibt, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lo sentimos pero su solicitud de baja desde la lista [LIST] ha fallado debido a un error del servidor. Por favor espere e intentelo más tarde. Si el problema persiste contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Non è stato possibile cancellare il tuo abbonamento alla lista [LIST] a causa di un errore del server. Attendi un pò e poi riprova. Qualora il problema dovesse persistere, contattaci all\'indirizzo', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het spijt ons, maar de beëindiging van je abonnement op de lijst [LIST] is mislukt vanwege een serverprobleem. Wacht een tijdje en probeer het opnieuw. Als het probleem aanhoudt, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Je nám líto, ale zrušení Vašeho přihlášení v seznamu [LIST] selhalo z důvodu chyby na serveru. Počkejte prosím a akci později opakujte. Pokud problém přetrvává, prosím kontaktujte nás na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_ucf = array(
	'en' => htmlentities( 'We\'re sorry, but the cancellation of your subscription to the list(s) [LISTS] has failed due to a server error. Please wait a while and try again. If the problem persists please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Nous sommes désolés, mais la résiliation de votre abonnement à/aux liste(s) [LISTS] a échoué en raison d\'une erreur du serveur. Veuillez attendre un moment avant d\'essayez de nouveau. Si le problème persiste, contactez-nous à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Es tut uns leid, aber die Beendigung Ihrer Abonnements der Liste(n) [LISTS] ist aufgrund eines Serverfehlers fehlgeschlagen. Bitte warten Sie eine Weile und versuchen Sie es noch einmal. Wenn das Problem bestehen bleibt, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lo sentimos pero su solicitud de baja desde la(s) lista(s) [LISTS] ha fallado debido a un error del servidor. Por favor espere e intentelo más tarde. Si el problema persiste contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Non è stato possibile cancellare il tuo abbonamento alle liste [LISTS] a causa di un errore del server. Attendi un pò e poi riprova. Qualora il problema dovesse persistere, contattaci all\'indirizzo', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het spijt ons, maar de beëindiging van je abonnement op de lijst(en) [LISTS] is mislukt vanwege een serverprobleem. Wacht een tijdje en probeer het opnieuw. Als het probleem aanhoudt, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Je nám líto, ale zrušení Vašeho přihlášení v seznamech [LISTS] selhalo z důvodu chyby na serveru. Počkejte prosím a akci později opakujte. Pokud problém přetrvává, prosím kontaktujte nás na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_ucr = array(
	'en' => htmlentities( 'You have asked to cancel your subscription to the list [LIST].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Vous avez sollicité la résiliation de votre abonnement à la liste [LIST].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Sie möchten Ihre Eintragung in der Liste [LIST] beenden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Ha solicitado ser dado de baja de la lista [LIST].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Hai richiesto la cancellazione del tuo abbonamento dalla lista [LIST].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je hebt om beëindiging van je abonnement op de lijst [LIST] gevraagd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Požádal(a) jste o zrušení přihlášení v seznamu [LIST]', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uac = array(
	'en' => htmlentities( 'You have asked to cancel your subscription to the list(s) [LISTS].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Vous avez sollicité la résiliation de votre abonnement à/aux liste(s) [LISTS].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Sie möchten Ihre Eintragung in der/den Liste(n) [LISTS] beenden.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Ha solicitado ser dado de baja de la(s) lista(s) [LISTS].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Hai richiesto la cancellazione del tuo abbonamento dalle liste [LISTS].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je hebt om beëindiging van je abonnement op de lijst(en) [LISTS] gevraagd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Požádal(a) jste o zrušení přihlášení v seznamech [LISTS]', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_usr = array(
	'en' => htmlentities( 'The email address [EMAIL] has been successfully deleted.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'L\'adresse e-mail [EMAIL] a correctement été retirée.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Die E-Mail-Adresse [EMAIL] wurde erfolgreich gelöscht.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La dirección de correo [EMAIL] ha sido dada de baja correctamente.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'indirizzo email [EMAIL] è stato cancellato.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het emailadres [EMAIL] is met succes verwijderd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Email [EMAIL] byl úspěšně vymazán.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_urs = array(
	'en' => htmlentities( 'The email address [EMAIL] has been removed from the list(s) [LISTS] successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'L\'adresse e-mail [EMAIL] a correctement été retirée de(s) liste(s) [LISTS].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Die E-Mail-Adresse [EMAIL] wurde erfolgreich aus der/den Liste(n) [LISTS] entfernt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La dirección de correo [EMAIL] ha sido dada de baja de la(s) lista(s) [LISTS].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'indirizzo email è stato rimosso dall\'elenco o dagli elenchi [LISTS].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het emailadres [EMAIL] is met succes van de lijst(en) [LISTS] verwijderd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Email [EMAIL] byl úspěšně vymazán ze seznamu(ů) [LISTS].', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uns = array(
	'en' => htmlentities( 'We\'re sorry, but the list [LIST] can not be found on this server. Check the list name and try again. If the problem persists please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Nous sommes désolés, mais la liste [LIST] est introuvable sur ce serveur. Vérifiez le nom de la liste et essayez à nouveau. Si le problème persiste, contactez-nous à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Es tut uns leid, aber die Liste [LIST] wurde auf diesem Server nicht gefunden. Prüfen Sie den Listennamen und versuchen Sie es noch einmal. Wenn das Problem bestehen bleibt, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lo sentimos pero no se ha encontrado la lista [LIST] en este servidor. Verifique el nombre de la lista y pruebe de nuevo. Si el problema persiste contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La lista [LIST] non è stata trovata su questo server. Verifica il nome della lista e riprova. Qualora il problema dovesse persistere, contattaci a', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het spijt ons, maar de lijst [LIST] is niet op deze server aangetroffen. Controleer de lijstnaam en probeer opnieuw. Als het probleem aanhoudt, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Je nám líto, ale seznam [LIST] nemůže být nalezen na tomto serveru. Ověřte prosím jméno seznamu a akci opakujte. Pokud problém přetrvává, kontaktujte nás prosím na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_cke = array(
	'en' => htmlentities( '[KEY] is not a valid key. Either it has been used already or it has expired. Keys have a lifetime of [LIFESPAN] day(s). If you have waited more than [LIFESPAN] day(s) to confirm your subscription you will have to start the subscription process again. If you think this is an error please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( '[KEY] n\'est pas une clé valide. Soit elle a déjà été utilisée ou elle est arrivée à expiration. Les clés ont une durée de vie de [LIFESPAN] jour(s). Si vous avez attendu plus de [LIFESPAN] jour(s) pour confirmer votre abonnement, vous devrez lancer le processus d\'abonnement de nouveau. Si vous pensez que cela est une erreur veuillez nous contacter à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( '[KEY] ist kein gültiger Schlüssel. Entweder wurde er bereits verwendet oder er ist abgelaufen. Schlüssel haben eine Lebensdauer von [LIFESPAN] Tag(en). Wenn Sie länger als [LIFESPAN] Tag(en) gewartet haben, um Ihr Abonnement zu bestätigen, müssen Sie mit dem Anmeldeverfahren wieder von vorne beginnen. Wenn Sie meinen, dass es sich um einen Fehler handelt, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( '[KEY] no es una referencia válida. Puede que ya haya sido utilizada o que haya expirado. Las referencias tienen una validez de [LIFESPAN] día(s). Si ha esperado más de [LIFESPAN] día(s) para confirmar su alta tendrá que volver a iniciar el proceso de nuevo. Si piensa que se trata de un error por favor contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La chiave [KEY] non è valida. È stata già utilizzata oppure è scaduta. Le chiavi hanno un arco di vita di [LIFESPAN] giorni. Se hai atteso più di [LIFESPAN] giorni per confermare il tuo abbonamento, dovrai necessariamente rifare il processo di abbonamento. Se credi invece che vi sia un errore, contattaci a', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( '[KEY] is geen geldige waarde. Deze is al eerder gebruikt of is verlopen. Waarden hebben een levensduur van [LIFESPAN] dagen. Als je meer dan [LIFESPAN] dag(en) hebt gewacht met het bevestigen van je inschrijving, moet je je opnieuw inschrijven. Als je denkt dat dit een fout is, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( '[KEY] není platným klíčem. Buď je již používán, nebo jeho platnost vypršela. Klíče mají životnost [LIFESPAN] dnů. Pokud jste čekal(a) na potvrzení o přihlášení déle než [LIFESPAN] dnů, musíte se přihlásit znovu. Pokud si myslíte, že se jedná o chybu, kontaktujte nás prosím na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_ckm = array(
	'en' => htmlentities( 'We\'re sorry, but your subscription to the list(s) [LISTS] has failed because the Key argument is missing. Please start the subscription process again. If you need help please contact us at', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Nous sommes désolés, mais votre abonnement à/aux liste(s) [LISTS] a échoué car la clé est manquante. Veuillez lancer le processus d\'abonnement de nouveau. Si vous avez besoin d\'aide vous pouvez nous contacter à l\'adresse', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Es tut uns leid, aber Ihre Eintragung in die Liste(n) [LISTS] ist fehlgeschlagen, weil die Schlüsselangabe fehlt. Bitte beginnen Sie mit dem Anmeldeverfahren wieder von vorne. Wenn Sie Hilfe brauchen, kontaktieren Sie uns bitte unter', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Lo sentimos pero su alta a la(s) lista(s) [LISTS] ha fallado porque no se ha encontrado la referencia. Vuelva a intentarlo de nuevo. Si necesita ayuda contactenos a la dirección', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Il tuo abbonamento alla/e lista/ [LISTS] non è andato a buon fine in quant l\'argomento Chiave è mancante. Riavvia da capo la procedura di abbonamento. Se necessiti di aiuto, contattaci a', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het spijt ons, maar je inschrijving op de lijst(en) [LISTS] is mislukt omdat de belangrijkste waarde ontbreekt. Voer het inschrijfproces opnieuw uit. Als je hulp nodig hebt, neem dan contact met ons op via', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Je nám líto, ale přihlášení do seznamu(ů) [LISTS] selhalo z důvodu chybějícího argumentu klíče. Prosím přihlašte se znovu. Pokud potřebujete pomoc, kontaktujte nás prosím na adrese', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_rls = array(
	'en' => htmlentities( '[NUM] list(s) removed successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( '[NUM] liste(s) ont été supprimée(s).', $enc_quotes, $enc_charset ),
	'de' => htmlentities( '[NUM] Liste(n) erfolgreich entfernt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( '[NUM] lista(s) han sido eliminadas.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Liste rimosse: [NUM].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( '[NUM] lijst(en) met succes verwijderd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( '[NUM] seznam(ů) úspěšně odstraněno.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_dts = array(
	'en' => htmlentities( 'Database and table created successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'La base de données et la table ont correctement été créées.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Datenbank und Tabelle erfolgreich erstellt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La base de datos y la tabla han sido creados correctamente.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La creazione del database e della tabella è andata a buon fine.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Database en tabel met succes aangemaakt.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Databáze a tabulka byly úspěšně vytvořeny.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_lcs = array(
	'en' => htmlentities( 'List created successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'La liste a correctement été créée.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Liste erfolgreich erstellt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'La lista ha sido creada correctamente.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La lista è stata creata correttamente.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Lijst aanmaken geslaagd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Seznam by úspěšně vytvořen.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_mlr = array(
	'en' => htmlentities( 'MLM has been uninstalled. All files have been removed but the script files.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'MLM a été désinstallé. Tous les fichiers ont été supprimés sauf les fichiers du script.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'MLM wurde deinstalliert. Alle Dateien bis auf die Skriptdateien wurden erfolgreich entfernt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'MLM ha sido desinstalado. Todos los archivos han sido eliminados excepto los archivos del script.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'MLM è stato disinstallato. Tutti i documenti ad esso relativi sono stati rimossi, tranne lo script.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'MLM installatie is verwijderd. Alle bestanden zijn verwijderd behalve de script bestanden.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'MLM byl odinstalován. Všechny soubory byly kromě skriptů odinstalovány.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uls = array(
	'en' => htmlentities( 'The file [FILE] has been uploaded to the list(s) [LISTS] successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Le fichier [FILE] a correctement été transféré à/aux liste(s) [LISTS].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Die Datei [FILE] wurde erfolgreich in die Liste(n) [LISTS] geladen.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'El archivo [FILE] ha sido subido a la(s) lista(s) [LISTS] correctamente.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\upload dell\'archivio [FILE] sulla lista [LISTS] è stato effettuato correttamente.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Het bestand [FILE] is met succes naar de lijst(en) [LISTS] ge-upload.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Soubor [FILE] byl úspěšně nahrán do seznamu(ů) [LISTS].', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_ulr = array(
	'en' => htmlentities( '[NUM] email address(es) were added to [LISTS]. We found [DUP] duplicate(s) and [BAD] bad address(es).', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( '[NUM] adresse e-mail a/ont été ajoutée(s) à [LISTS]. Nous avons trouvé [DUP] doublon(s) et [BAD] mauvaise(s) adresse(s).', $enc_quotes, $enc_charset ),
	'de' => htmlentities( '[NUM] E-Mail-Adresse(n) wurde(n) [LISTS] hinzugefügt. Wir fanden [DUP] Duplikat(e) und [BAD] ungültige Adresse(n).', $enc_quotes, $enc_charset ),
	'es' => htmlentities( '[NUM] direccion(es) de correo ha(n) sido añadida(s) a [LISTS]. Hemos encontrado [DUP] duplicado(s) y [BAD] direccion(es) invalida(s).', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'A [LISTS] sono state aggiunti [NUM] indirizzi di email. Sono stati trovati [DUP] duplicato/i e [BAD] indirizzo/i sbagliati.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( '[NUM] emailadres(sen) zijn aan [LISTS] toegevoegd. We hebben [DUP] dubbel(e) en [BAD] ongeldig(e) adres(sen) aangetroffen.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( '[NUM] emailů bylo přidáno do [LISTS]. Nalezli jsme [DUP] doplikátů a [BAD] chybných adres.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_ude = array(
	'en' => htmlentities( '[NUM] email address(es) has been removed from [LISTS].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( '[NUM] adresse e-mail a/ont été retirée(s) de [LISTS].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( '[NUM] E-Mail-Adresse(n) wurde(n) von [LISTS] entfernt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( '[NUM] direcciones de correo ha(n) sido eliminada(s) de [LISTS].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( '[NUM] indirizzi email sono stati cancellati da [LISTS].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( '[NUM] emailadres(sen) zijn verwijderd van lijst(en) [LISTS].', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( '[NUM] emailů bylo odstraněno z [LISTS]', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_uco = array(
	'en' => htmlentities( '[NUM] confirmation email message(s) have been sent from [LISTS].', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( '[NUM] e-mail de confirmation ont été envoyés à partir de [LISTS].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( '[NUM] E-Mail-Bestätigungsnachricht(en) wurde(n) von [LISTS] gesendet.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( '[NUM] mensaje(s) de confirmación ha(n) sido enviado(s) de [LISTS].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( '[NUM] messaggi email di conferma sono stati inviati da [LISTS].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( '[NUM] bevestigingsemails zijn verzonden van lijst(en) [LISTS].', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( '[NUM] potvrzujících emailů bylo zasláno z [LISTS].', $enc_quotes, $enc_charset )
);


$kRes_cmdprocessor_ils = array(
	'en' => htmlentities( 'The file(s) available in the import directory have been imported to the list(s) [LISTS] successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Le(s) fichier(s) disponible(s) dans le répertoire d\'importation ont correctement été importés à/aux liste(s) [LISTS].', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Die im Importverzeichnis verfügbare(n) Datei(en) wurde(n) erfolgreich in die Liste(n) [LISTS] importiert.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'El/los archivo(s) disponible(s) en el directorio de importación han sido importados en la(s) lista(s) [LISTS].', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Il documento/i disponibile/i nella cartella di importazione sono stati importati nella/e lista/e [LISTS].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Bestand(en) beschikbaar in de import directory zijn met succes geïmporteerd naar de lijst(en) [LISTS].', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Soubor(y) dostupný(é) ve složce pro import byl(y) úspěšně importován(y) do seznamu(ů) [LISTS].', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_res = array(
	'en' => htmlentities( 'The list has been renamed sucessfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'La liste a été renommée correctement.', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Die Liste wurde erfolgreich umbenannt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'El nombre de la lista ha sido cambiado correctamente.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La lista è stata rinominata con successo.', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'De lijstnaam is succesvol gewijzigd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Seznam byl úspěšně odstraněn.', $enc_quotes, $enc_charset )
);

$kRes_cmdprocessor_rds = array(
	'en' => htmlentities( '[NUM] delivery/es removed successfully.', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( '[NUM] livraison(s) ont été supprimée(s).', $enc_quotes, $enc_charset ),
	'de' => htmlentities( '[NUM] Versand erfolgreich entfernt.', $enc_quotes, $enc_charset ),
	'es' => htmlentities( '[NUM] entrega(s) han sido eliminadas.', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Spedizioni rimosse: [NUM].', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( '[NUM] aflevering(en) met succes verwijderd.', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( '[NUM] doručení úspěšně odstraněno.', $enc_quotes, $enc_charset )
);

// Messages subject

$kTxt_emailsubject_coi = array(
	'en' => htmlentities( 'Your subscription request', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Votre demande d\'inscription', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Ihre Abonnement-Anforderung', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Su solicitud de subscripción', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La tua richiesta di abbonamento', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je verzoek tot inschrijving', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Pozadavek na prihlaseni', $enc_quotes, $enc_charset )
);

$kTxt_emailsubject_ysc = array(
	'en' => htmlentities( 'Your subscription confirmation', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Confirmation de votre inscription', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Eintragungsbestätigung', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Confirmación de su subscripción', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Conferma di abbonamento', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je bevestiging van inschrijving', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Potvrzeni prihlaseni', $enc_quotes, $enc_charset )
);


$kTxt_emailsubject_yuc = array(
	'en' => htmlentities( 'Your unsubscribe request confirmation', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Confirmation de la suppression de votre inscription', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Abmeldebestätigung', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Confirmación de baja', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'La tua richiesta di cancellazione di abbonamento', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Je bevestiging van verzoek tot uitschrijving', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Potvrzeni pozadavku na odhlaseni', $enc_quotes, $enc_charset )
);


$kTxt_emailsubject_eul = array(
	'en' => htmlentities( '[EMAIL] has unsubscribed from [LISTS]', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( '[EMAIL] a été supprimé de [LISTS]', $enc_quotes, $enc_charset ),
	'de' => htmlentities( '[EMAIL] wurde von [LISTS] abgemeldet', $enc_quotes, $enc_charset ),
	'es' => htmlentities( '[EMAIL] se ha dado de baja de la(s) lista(s) [LISTS]', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'indirizzo email [EMAIL] è stato disabbonato dalla lista [LISTS]', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( '[EMAIL] is uitgeschreven van [LISTS]', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( '[EMAIL] byl odhlášen ze seznamu(ů) [LISTS]', $enc_quotes, $enc_charset )
);

$kTxt_emailsubject_esl = array(
	'en' => htmlentities( '[EMAIL] has subscribed to [LISTS]', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( '[EMAIL] a été inscrit à [LISTS]', $enc_quotes, $enc_charset ),
	'de' => htmlentities( '[EMAIL] wurde in [LISTS] eingetragen', $enc_quotes, $enc_charset ),
	'es' => htmlentities( '[EMAIL] se ha dado de alta a la(s) lista(s) [LISTS]', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'L\'indirizzo email [EMAIL] è stato abbonato a [LISTS]', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( '[EMAIL] heeft ingeschreven op [LISTS]', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( '[EMAIL] byl přihlášen do [LISTS]', $enc_quotes, $enc_charset )
);

// Click-Through Tracker

$kTxt_clicktracker_und = array(
	'en' => htmlentities( 'Undefined', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'Non défini', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'Undefiniert', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'Sin definir', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'Non Definito', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'Onbepaald', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'Nedefinovaný', $enc_quotes, $enc_charset )
);

// Misc strings

$kTxt_and = array(
	'en' => htmlentities( 'and', $enc_quotes, $enc_charset ),
	'fr' => htmlentities( 'et', $enc_quotes, $enc_charset ),
	'de' => htmlentities( 'und', $enc_quotes, $enc_charset ),
	'es' => htmlentities( 'y', $enc_quotes, $enc_charset ),
	'it' => htmlentities( 'e', $enc_quotes, $enc_charset ),
	'nl' => htmlentities( 'en', $enc_quotes, $enc_charset ),
	'cz' => htmlentities( 'a', $enc_quotes, $enc_charset )
);

?>