
(function ($) {

Drupal.AjaxLoad = Drupal.AjaxLoad || { externalStyles: [], externalScripts: [], loadPending: [] };

/**
 * Load JavaScript and CSS files and data.
 */
Drupal.AjaxLoad.loadFiles = function (target, response) {
  // Initialize the list of currently loaded external stylesheets.
  if (!Drupal.AjaxLoad.externalStyles.length) {
    if (Drupal.settings.AjaxLoad && Drupal.settings.AjaxLoad['css']) {
      $.each(Drupal.settings.AjaxLoad['css'], function(i, path) {
        Drupal.AjaxLoad.externalStyles.push(path);
      });
    }
    else {
      $('link[type="text/css"]').each(function() {
        Drupal.AjaxLoad.externalStyles.push($(this).attr('href'));
      });
    }
  }

  // Initialize the list of currently loaded external scripts.
  if (!Drupal.AjaxLoad.externalScripts.length) {
    if (Drupal.settings.AjaxLoad && Drupal.settings.AjaxLoad['scripts']) {
      $.each(Drupal.settings.AjaxLoad['scripts'], function(i, path) {
        Drupal.AjaxLoad.externalScripts.push(path);
      });
    }
    else {
      $('script[src]').each(function() {
        Drupal.AjaxLoad.externalScripts.push($(this).attr('src'));
      });
    }
  }

  // Handle scripts. Do this first so that behaviors can access them easily.
  if (response.scripts) {
    // Each Ajax operation needs its own counter.
    var index = Drupal.AjaxLoad.loadPending.length;
    Drupal.AjaxLoad.loadPending[index] = 0;
    if (!response.__customSettings && response.scripts.setting) {
      $.extend(true, Drupal.settings, response.scripts.setting);
    }
    // Inline scripts will be handled separately.
    var types = ['core', 'module', 'theme'];
    $.each(types, function (i, type) {
      if (response.scripts[type]) {
        $.each(response.scripts[type], function (src, data) {
          // Load scripts.
          src = Drupal.settings.basePath + src;
          // Test if the script already exists.
          var found = false;
          for (var j = 0; j < Drupal.AjaxLoad.externalScripts.length; j++) {
            if (Drupal.AjaxLoad.externalScripts[j].indexOf(src) == 0) {
              found = true;
              break;
            }
          }
          if (!found) {
            Drupal.AjaxLoad.loadPending[index]++;
            $.getScript(src, function () {
              Drupal.AjaxLoad.externalScripts.push(src);
              Drupal.AjaxLoad.loadComplete(index, target, response);
            });
          }
        });
      }
    });
    // Ensure Drupal behaviors are attached to new content, even when no
    // new external scripts have been loaded.
    if (Drupal.AjaxLoad.loadPending[index] == 0) {
      Drupal.attachBehaviors(target);
      // Ensure inline scripts are parsed after all external scripts have loaded.
      Drupal.AjaxLoad.loadInline(response);
    }
  }

  // Handle stylesheets.
  if (response.css) {
    var types = ['module', 'theme'];
    $.each(response.css, function (media, files) {
      $.each(types, function (i, type) {
        if (files[type]) {
          $.each(files[type], function (src, data) {
            // Load stylesheets.
            src = Drupal.settings.basePath + src;
            // Test if the stylesheet already exists.
            var found = false;
            for (var j = 0; j < Drupal.AjaxLoad.externalStyles.length; j++) {
              if (Drupal.AjaxLoad.externalStyles[j].indexOf(src) == 0) {
                found = true;
                break;
              }
            }
            if (!found) {
              Drupal.AjaxLoad.externalStyles.push(src);
              $('<link type="text/css" rel="stylesheet" media="' + media + '" href="' + src + '" />').appendTo('head');
            }
          });
        }
      });
    });
  }
};

/**
 * Parse inline scripts after all external scripts have loaded.
 */
Drupal.AjaxLoad.loadInline = function(response) {
  // Handle inline scripts.
  if (response.scripts.inline) {
    $.each(response.scripts.inline, function (i, script) {
      // document.write calls would mess things up.
      if (script.code.indexOf('document.write') == -1) {
        eval(script.code);
      }
    });
  }
};

/**
 * When all scripts have loaded, attach behaviors.
 */
Drupal.AjaxLoad.loadComplete = function(index, target, response) {
  Drupal.AjaxLoad.loadPending[index]--;
  if (Drupal.AjaxLoad.loadPending[index] == 0) {
    Drupal.attachBehaviors(target);
    // Ensure inline scripts are parsed after all external scripts have loaded.
    Drupal.AjaxLoad.loadInline(response);
  }
};

})(jQuery);
