<?php
//=============================================================================
//= MENU CALLBACKS
//=============================================================================

/**
 * Successful payment callback.
 */
function uc_comgate_payment_success() {
  $_GET = array_merge($_GET, $_POST);

  //_uc_comgate_check_response_access();
  
  if (uc_comgate_setting('debug')) {
    watchdog('uc_comgate', 'Access to payment success page. $_REQUEST = %request', array(
      '%request' => print_r($_REQUEST, true)
    ) , WATCHDOG_NOTICE);
  }

  try {
    $lock_name = 'uc_comgate_' . $_GET['transId'];

    if (!lock_acquire($lock_name, 5)) {
      lock_wait($lock_name);
      lock_acquire($lock_name, 5);
    }

    //_uc_comgate_complete();

    lock_release($lock_name);

    // This lets us know it's a legitimate access of the complete page.
    $_SESSION['do_complete'] = true;
    drupal_goto('cart/checkout/complete');
  }
  catch(ComgatePaymentException $e) {
    drupal_set_message(t('Error during processing the payment: %error', array(
      '%error' => $e->getMessage()
    )) , 'error');
    drupal_goto('cart/checkout/review');
  }
}

/**
 * Failed payment callback.
 */
function uc_comgate_payment_failed() {
  /*if (empty($_GET['secret']) || ($_GET['secret'] <> uc_comgate_setting('secret'))) {
    drupal_access_denied();
    exit;
  }*/
  if (uc_comgate_setting('debug')) {
    watchdog('uc_comgate', 'Access to payment failed page. $_REQUEST = %request', array(
      '%request' => print_r($_REQUEST, true)
    ) , WATCHDOG_NOTICE);
  }
  unset($_SESSION['cart_order']);
  drupal_set_message(t('Your ComGate payment was canceled. Please feel free to continue shopping or contact us for assistance.'));
  drupal_goto('cart');
}

/**
 * Notify callback.
 */
function uc_comgate_soap_notify() {
  $_GET = array_merge($_GET, $_POST);

  _uc_comgate_check_response_access();

  if (uc_comgate_setting('debug')) {
    watchdog('uc_comgate', 'Access to payment notify page. $_REQUEST: <pre>@request</pre>', array(
      '@request' => print_r($_REQUEST, true)
    ) , WATCHDOG_NOTICE);
  }

  try {
    $lock_name = 'uc_comgate_' . $_GET['transId'];

    if (!lock_acquire($lock_name, 5)) {
      lock_wait($lock_name);
      lock_acquire($lock_name, 5);
    }

    _uc_comgate_complete();

    lock_release($lock_name);
  }
  catch(ComgatePaymentException $e) {
    _uc_comgate_server_error();
  }

  header('Content-Type: application/x-www-form-urlencoded');
  die('code=0&message=OK');
}

/**
 * Admin form of the ComGate methods.
 */
function uc_comgate_payment_methods_list() {
  uc_comgate_watchlog(print_r(dbtlog() , 1));

  $form = $options = array();

  $form['uc_comgate_back_top'] = array(
    '#prefix' => '<p>',
    '#value' => l(t('Back to ComGate settings') , 'admin/store/settings/payment/method/comgate_wps/') ,
    '#suffix' => '</p>'
  );

  $header = array(
    t('Logo') ,
    t('Payment method') ,
    t('Code') ,
    //t('Offline')
    
  );
  $payment_method_list = uc_comgate_channel_list_all();

  if (module_exists('elements')) {
    foreach ($payment_method_list as & $payment_method) {
      $row = array();
      $row[] = '<img src="' . $payment_method->logo . '">';
      $row[] = $payment_method->paymentMethod;
      $row[] = $payment_method->code;
      //$row[]                          = ($payment_method->offline == 1) ? t('yes') : t('no');
      $options[$payment_method->code] = $row;
    }

    $form['uc_comgate_enabled_channels'] = array(
      '#type' => 'tableselect',
      '#header' => $header,
      '#options' => $options,
      '#empty' => t('There are not payment channels available. Server connection error?') ,
      '#default_value' => uc_comgate_setting('channels')
    );
  }
  else {
    foreach ($payment_method_list as & $payment_method) {
      $row = sprintf('<img src="%s"> <b>%s</b> - %s <code>(%s)</code>', $payment_method->logo, $payment_method->paymentMethod, $payment_method->description, $payment_method->code /*, ($payment_method->offline == 1) ? t('yes') : t('no')*/);
      $options[$payment_method->code] = $row;
    }

    if ($options) {
      $form['uc_comgate_enabled_channels'] = array(
        '#type' => 'checkboxes',
        '#options' => $options,
        '#default_value' => uc_comgate_setting('channels')
      );
    }
    else {
      $form['uc_comgate_enabled_channels_empty'] = array(
        '#type' => 'markup',
        '#prefix' => '<p>',
        '#suffix' => '</p>',
        '#value' => t('There are not payment channels available. Server connection error?')
      );
    }
  }

  $form['uc_comgate_back_bottom'] = array(
    '#prefix' => '<p>',
    '#value' => l(t('Back to ComGate settings') , 'admin/store/settings/payment/method/comgate_wps/') ,
    '#suffix' => '</p>'
  );

  return system_settings_form($form);
}

//=============================================================================
//= HELPERS
//=============================================================================

/**
 * Returns 200 OK HTTP header.
 */
function _uc_comgate_server_success() {
  uc_comgate_watchlog(print_r(dbtlog() , 1));
  if (uc_comgate_setting('debug')) {
    watchdog('uc_comgate', 'Server SUCCESS.');
  }
  header('HTTP/1.1 200 OK');
  exit(0);
}

/**
 * Returns 500 Server error HTTP header.
 */
function _uc_comgate_server_error() {
  uc_comgate_watchlog(print_r(dbtlog() , 1));
  if (uc_comgate_setting('debug')) {
    watchdog('uc_comgate', 'Server ERROR.');
  }
  header('HTTP/1.1 500 Internal Server Error');
  exit(0);
}

/**
 * Splits variable symbol which came back from ComGate to order_id and cart_id.
 *
 * @param string $variable_symbol
 * @return array of order_id [0] and cart_id [1]
 */
function _uc_comgate_parse_variable_symbol($variable_symbol) {
  uc_comgate_watchlog(print_r(dbtlog() , 1));
  // Parse Order ID and Cart ID
  @list($order_id, $cart_id) = explode('-', $variable_symbol);
  // Sanitize order ID and cart ID
  $order_id = intval($order_id);
  $cart_id = $cart_id ? check_plain($cart_id) : 0;
  return array(
    $order_id,
    $cart_id
  );
}

/**
 * Checks if paymentSessionId, orderNumber, encryptedSignature, targetGoId are
 * available in $_GET.
 */
function _uc_comgate_check_response_access() {
  uc_comgate_watchlog(print_r(dbtlog() , 1));
  if (/*empty($_GET['payerId']) || */ empty($_GET['merchant']) || empty($_GET['transId']) || empty($_GET['status']) || empty($_GET['secret']) || empty($_GET['refId']) || ($_GET['merchant'] != uc_comgate_setting('comid')) /* || ($_GET['secret'] <> uc_comgate_setting('secret'))*/) {
    drupal_access_denied();
    exit(1);
  }
}

/**
 * Process the notification returned from the ComGate module to finish the payment
 * process.
 *
 * @throws ComgatePaymentException
 */
function _uc_comgate_complete() {
  uc_comgate_watchlog(print_r(dbtlog() , 1));
  // Assing the values from the ComGate request
  $returned_variable_symbol = $_GET['refId'];
  $returned_payment_session_id = $_GET['transId'];
  $returned_secret = $_GET['secret'];

  // Parse Order ID and Cart ID
  list($order_id, $cart_id) = _uc_comgate_parse_variable_symbol($returned_variable_symbol);

  if (!empty($cart_id)) {
    // Needed later by uc_complete_sale to empty the correct cart
    $_SESSION['uc_cart_id'] = $cart_id;
  }

   if (isset($_GET['payerId']) && ($cart_id != $_GET['payerId'])) {
    watchdog('uc_comgate', 'ComGate response attempted for invalid payer @payer_id.', array(
      '@payer_id' => $cart_id
    ) , WATCHDOG_ERROR, l(t('view') , 'admin/store/orders/' . $order_id));
    
    throw new ComgatePaymentException('ComGate transaction failed verification');
  }

  watchdog('uc_comgate', 'Receiving PN at URL for order @order_id. <pre>@debug</pre>', array(
    '@order_id' => $order_id,
    '@debug' => uc_comgate_setting('debug') ? print_r($_GET, true) : ''
  ) , WATCHDOG_NOTICE, l(t('view') , 'admin/store/orders/' . $order_id));

  $payment = uc_comgate_record_find_by_order_id($order_id);
  if (!$payment) {
    watchdog('uc_comgate', 'ComGate response attempted for non-existent payment @order_id.', array(
      '@order_id' => $order_id
    ) , WATCHDOG_ERROR, l(t('view') , 'admin/store/orders/' . $order_id));
    
    throw new ComgatePaymentException('ComGate transaction failed verification');
  }

  $payment['session_id'] = $returned_payment_session_id;

  if (uc_comgate_setting('debug')) {
    watchdog('uc_comgate', 'Payment session record. <pre>@debug</pre>', array(
      '@debug' => print_r($payment, true)
    ) , WATCHDOG_NOTICE, l(t('view') , 'admin/store/orders/' . $order_id));
  }

  // TODO: load using PaymentSessionId?
  $order = uc_order_load($order_id);
  if ($order == false) {
    watchdog('uc_comgate', 'ComGate response attempted for non-existent order @order_id.', array(
      '@order_id' => $order_id
    ) , WATCHDOG_ERROR, l(t('view') , 'admin/store/orders/' . $order_id));
    throw new ComgatePaymentException('ComGate transaction failed verification');
  }

  $eshop_comid = uc_comgate_setting('comid');
  $eshop_secret = uc_comgate_setting('secret');

  $payment_currency = $order->currency;

  watchdog('uc_comgate', 'ComGate: transaction @id for @order_id verified.', array(
    '@id' => $returned_payment_session_id,
    '@order_id' => $order_id
  ) , WATCHDOG_NOTICE, l(t('view') , 'admin/store/orders/' . $order_id));

  // Check if the order is payed
  if (empty($_GET['status'])) {
    throw new ComgatePaymentException('Empty or invalid ComGate payment result.');
  }
  if (uc_comgate_setting('debug')) {
    watchdog('uc_comgate', 'ComGate: transaction @id for @order_id. Saved session: <pre>@session</pre> result: <pre>@result</pre>', array(
      '@id' => $returned_payment_session_id,
      '@order_id' => $order_id,
      '@session' => print_r($payment, true) ,
      '@result' => print_r($result, true)
    ) , WATCHDOG_NOTICE, l(t('view') , 'admin/store/orders/' . $order_id));
  }

  $original_state = $payment['session_state'];

  switch ($_GET['status']) {
    case 'PENDING':
      if ($payment['session_state'] != 'PENDING') {
        $payment['session_state'] = $_GET['status'];
        uc_order_update_status($order_id, 'comgate_pending');
        uc_order_comment_save($order_id, 0, t('Payment is pending at ComGate.') , 'admin');
      }
    break;

    case 'PAID':
      if (empty($payment['session_state']) || in_array($payment['session_state'], array('PENDING', 'AUTHORIZED'))) {
        $payment['session_state'] = $_GET['status'];
        $amount = $payment['total_price'] / 100.00;
        $comment = t('ComGate payment session ID: @sess_id', array(
          '@sess_id' => $returned_payment_session_id
        ));
        uc_payment_enter($order_id, UC_COMGATE_STANDARD_PAYMENT_METHOD, $amount, $order->uid, $payment, $comment);
        uc_cart_complete_sale($order);
		//zmena z payment_received na pending - cize potvrdena
        uc_order_update_status($order_id, 'pending');
        uc_order_comment_save($order_id, 0, t('Payment of @amount @currency submitted through ComGate.', array(
          '@amount' => uc_currency_format($amount, false) ,
          '@currency' => $payment_currency
        )) , 'admin');
      }
    break;

    case 'FAILED':
      if ($payment['session_state'] !== 'FAILED') {
        $payment['session_state'] = $_GET['status'];
        //uc_order_update_status($order_id, 'comgate_pending');
        uc_order_comment_save($order_id, 0, t("The customer's attempted payment from a ComGate account failed.") , 'admin');
      }
    break;

    case 'CANCELLED':
      if ($payment['session_state'] !== 'CANCELLED') {
        $payment['session_state'] = $_GET['status'];
        //uc_order_update_status($order_id, 'comgate_pending');
        uc_order_comment_save($order_id, 0, t('ComGate has canceled the reversal and returned !amount !currency to your account.', array(
          '!amount' => uc_currency_format($payment['total_price'], false) ,
          '!currency' => $payment_currency
        )) , 'admin');
      }
    break;

    case 'AUTHORIZED': 
      $payment['session_state'] = $_GET['status'];
      break;

    default:
      watchdog('uc_comgate', 'ComGate: Unknown payment state.', array() , WATCHDOG_ERROR, l(t('view') , 'admin/store/orders/' . $order_id));
      throw new ComgatePaymentException('Unknown ComGate payment state.');
  }

  // Save payment status info if changed.
  if ($original_state != $payment['session_state']) {
    watchdog('uc_comgate', 'ComGate: transaction @id for @order_id state changed from %from to %to.', array(
      '@id' => $returned_payment_session_id,
      '@order_id' => $order_id,
      '%from' => $original_state ? $original_state : '--',
      '%to' => $payment['session_state']
    ) , WATCHDOG_NOTICE, l(t('view') , 'admin/store/orders/' . $order_id));

    uc_comgate_record_save($payment);
  }
}