<?php

ini_set('xdebug.max_nesting_level', 5000);

function uc_fulfillment_pdf_generate($html) {
  //define("DOMPDF_ENABLE_CSS_FLOAT", true);
  //define("DOMPDF_ENABLE_HTML5PARSER", true);

  require_once('dompdf/autoload.inc.php');
  $dompdf = new \Dompdf\Dompdf();
  $html = uc_fulfillment_pdf_prepare_html($html);

  $exec_time = ini_get('max_execution_time');
  set_time_limit(variable_get('uc_fulfillment_process_timeout', 100));
  ini_set('max_execution_time', variable_get('uc_fulfillment_process_timeout', 100));
  $abort = ignore_user_abort(FALSE);
 
  //$dompdf->set_paper(array(0, 0, 595,  variable_get('uc_fulfillment_page_height', 1263)), 'portrait');
  $dompdf->setPaper('A4', 'portrait');
  $dompdf->load_html($html, 'UTF-8');
  $dompdf->render();

  $output = $dompdf->output();
  
  set_time_limit($exec_time);
  ini_set('max_execution_time', $exec_time);
  ignore_user_abort($abort);
  
  return $output;
}

function uc_fulfillment_pdf_prepare_html($html) {
  $html = str_replace('font-family: verdana, arial, helvetica', 'font-family:  Dejavu Sans', $html);
  /*libxml_use_internal_errors(true);
  $doc = new DomDocument('1.0', 'UTF-8');
  $doc->loadHTML($html);
  $dom->formatOutput = TRUE;
  $html = $doc->saveXML();*/
  $html = mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8');
  $html = str_replace('&euro;', '<span style="font-family: Helvetica">€</span>', $html);
  //echo($html); die();
  return $html;
}

function uc_fulfillment_pdf_print($pdf, $filename = 'invoice.pdf') {
  ob_clean();
  header("Content-type:application/pdf");
  header("Content-Disposition:attachment;filename='" . $filename . "'");
  print($pdf);
  ob_flush();
  flush();
  die();
}