<?php

//=============================================================================
//= MENU CALLBACKS
//=============================================================================

function uc_fulfillment_configuration() {
  return drupal_get_form('uc_fulfillment_configuration_form');
}

function uc_fulfillment_configuration_form(&$form_state) {
  $form                             = array();
  $form['uc_fulfillment_client_id'] = array(
    '#title' => t('Fulfillment Client ID'),
    '#type' => 'textfield',
    '#required' => TRUE,
    '#default_value' => variable_get('uc_fulfillment_client_id', 'e8d6272ea64dbdc4334fe9ae114e9479')
  );
  
  $form['uc_fulfillment_client_secret'] = array(
    '#title' => t('Fulfillment Client Secret'),
    '#type' => 'textfield',
    '#required' => TRUE,
    '#default_value' => variable_get('uc_fulfillment_client_secret', '5x4QemfeMA90RS5f16b5f67dy16i0948is0pto0g')
  );
  
  $form['uc_fulfillment_order_prefix'] = array(
    '#title' => t('Fulfillment Order Prefix'),
    '#type' => 'textfield',
    '#required' => TRUE,
    '#default_value' => variable_get('uc_fulfillment_order_prefix', 0)
  );
  
  $form['uc_fulfillment_configuration_submit'] = array(
    '#value' => t('Save'),
    '#type' => 'submit'
  );
  
  $form['uc_fulfillment_configuration_cancel'] = array(
    '#type' => 'button',
    '#value' => t('Cancel'),
    '#attributes' => array(
      'onClick' => 'history.go(-1); return true;'
    )
  );
  
  return $form;
}

function uc_fulfillment_configuration_form_validate($form, &$form_state) {
  if ($form_state['clicked_button']['#value'] != t('Save')) {
    return;
  }
  
  if ((filter_var($form_state['values']['uc_fulfillment_order_prefix'], FILTER_VALIDATE_INT) === FALSE) || (int) $form_state['values']['uc_fulfillment_order_prefix'] < 0) {
    form_set_error('uc_fulfillment_order_prefix', t('Invalid order prefix.'));
  }
}

function uc_fulfillment_configuration_form_submit($form, &$form_state) {
  if ($form_state['clicked_button']['#value'] != t('Save')) {
    return;
  }
  
  variable_set('uc_fulfillment_client_id', $form_state['values']['uc_fulfillment_client_id']);
  variable_set('uc_fulfillment_client_secret', $form_state['values']['uc_fulfillment_client_secret']);
  variable_set('uc_fulfillment_order_prefix', (int) $form_state['values']['uc_fulfillment_order_prefix']);
  
  drupal_set_message(t('Configuration saved.'));
}

function uc_fulfillment_order_confirmed($order) {
  $client = uc_fulfillment_get_client();
  try {
    $ffOrder = $client->getOrder(uc_fulfillment_order_id($order->order_id));
    uc_fulfillment_watchlog('Confirm called: ' . print_r($ffOrder, 1) . "<br/><br/>" . print_r($order, 1));
    
    if (TRUE /*$ffOrder['status'] == 'confirmed'*/ ) {
      uc_fulfillment_watchlog('Order confirmed: ' . $order->order_id);
    }
  }
  catch (Exception $e) {
    if (in_array($e->_status, array(
      404
    ))) {
      uc_fulfillment_watchlog('Order ' . $order->order_id . ' not found.');
    } else {
      uc_fulfillment_watchlog('Error updating order status: ' . print_r($e, 1));
    }
  }
}

function uc_fulfillment_order_sent($order) {
  $client = uc_fulfillment_get_client();
  try {
    $ffOrder = $client->getOrder(uc_fulfillment_order_id($order->order_id));
    uc_fulfillment_watchlog('Sent called: ' . print_r($ffOrder, 1) . "<br/><br/>" . print_r($order, 1));
    
    $status_sent = variable_get('uc_fulfillment_status_sent', 'package_sent');
    
    if (TRUE /*$ffOrder['status'] == 'sent'*/ ) {
      uc_fulfillment_watchlog('Order sent: ' . $order->order_id);
      if (@$ffOrder['_embedded']['trackingNumber'] && !variable_get('uc_fulfillment_order_tracking:' . $order->order_id, FALSE)) {
        uc_fulfillment_watchlog('Setting tracking for order: ' . $order->order_id . ' to: ' . $ffOrder['_embedded']['trackingNumber'][0]);
        
        $invoiceDir  = $_SERVER['DOCUMENT_ROOT'] . base_path() . conf_path() . '/' . file_directory_path() . '/invoices';
        $orderHash   = md5($order->order_id . $_SERVER['DOCUMENT_ROOT']);
        $invoiceFile = $invoiceDir . '/invoice_' . $orderHash . '.pdf';
        @unlink($invoiceFile);
        
        variable_set('uc_fulfillment_order_tracking:' . $order->order_id, TRUE);
        uc_order_comment_save($order->order_id, 1 /*$GLOBALS['user']->uid*/ , $ffOrder['_embedded']['trackingNumber'][0], 'order', $order->order_status);
      }
      
      uc_order_update_status($order->order_id, $status_sent);
    }
  }
  catch (Exception $e) {
    if (in_array($e->_status, array(
      404
    ))) {
      uc_fulfillment_watchlog('Order ' . $order->order_id . ' not found.');
    } else {
      uc_fulfillment_watchlog('Error updating order status: ' . print_r($e, 1));
    }
  }
}

function uc_fulfillment_order_delivered($order) {
  $client = uc_fulfillment_get_client();
  try {
    $ffOrder = $client->getOrder(uc_fulfillment_order_id($order->order_id));
    uc_fulfillment_watchlog('Delivered called: ' . print_r($ffOrder, 1) . "<br/><br/>" . print_r($order, 1));
    
    $status_completed = variable_get('uc_fulfillment_status_completed', 'completed');
    
    if (TRUE /*$ffOrder['status'] == 'delivered'*/ ) {
      uc_fulfillment_watchlog('Order delivered: ' . $order->order_id);
      
      $invoiceDir  = $_SERVER['DOCUMENT_ROOT'] . base_path() . conf_path() . '/' . file_directory_path() . '/invoices';
      $orderHash   = md5($order->order_id . $_SERVER['DOCUMENT_ROOT']);
      $invoiceFile = $invoiceDir . '/invoice_' . $orderHash . '.pdf';
      @unlink($invoiceFile);
      
      /*if (@$ffOrder['_embedded']['trackingNumber'] && !variable_get('uc_fulfillment_order_tracking:' . $order->order_id, FALSE)) {
      variable_set('uc_fulfillment_order_tracking:' . $order->order_id, TRUE);
      uc_order_comment_save($order->order_id, $GLOBALS['user']->uid , $ffOrder['_embedded']['trackingNumber'][0], 'order', $order->order_status);
      }*/
      
      uc_order_update_status($order->order_id, $status_completed);
    }
  }
  catch (Exception $e) {
    if (in_array($e->_status, array(
      404
    ))) {
      uc_fulfillment_watchlog('Order ' . $order->order_id . ' not found.');
    } else {
      uc_fulfillment_watchlog('Error updating order status: ' . print_r($e, 1));
    }
  }
}

function uc_fulfillment_order_invoice_pdf($order, $print = TRUE) {
  module_load_include('inc', 'uc_order', 'uc_order.admin');
  $invoice_html = uc_order_invoice($order);
  
  require_once('pdf/pdf.inc.php');
  
  $pdf = uc_fulfillment_pdf_generate($invoice_html);
  
  if ($print) {
    uc_fulfillment_pdf_print($pdf);
  } else {
    return $pdf;
  }
}

//=============================================================================
//= HELPERS
//=============================================================================