<?php
// $Id$

/**
 * @file
 * This file contains the Conditional Actions hooks and functions necessary to
 * make the invoice generation actions work.
 * @date 23/09/2010
 * @author TahitiClic
 */

/******************************************************************************
 * Conditional Actions Hooks
 */

/**
 * Implementation of hook_ca_action().
 */
function uc_invoice_ca_action() {
  $order_arg = array(
    '#entity' => 'uc_order',
    '#title' => t('Order'),
  );

  $actions['uc_invoice_generate_invoice'] = array(
    '#title' => t('Generate an invoice for an order'),
    '#category' => t('Invoice'),
    '#callback' => 'uc_invoice_generate_invoice',
    '#arguments' => array(
      'order' => $order_arg,
    ),
  );

  return $actions;
}

/******************************************************************************
 * Action Callbacks and Forms
 */

/**
 * Generate the invoice
 *
 * @see uc_invoice_order(), uc_invoice_view_generate_invoice_form_submit()
 */
function uc_invoice_generate_invoice(&$order) {

  // we check if there's already an invoice for this order, if yes we do nothing
  // elsewise we generate the invoice
  $result = db_query("SELECT COUNT(*) FROM {uc_invoice} WHERE order_id = %d", $order->order_id);
  $count = db_result($result);
  if ($count == 0) {
  $result = db_query("SELECT invoice_nbr FROM {uc_invoice} WHERE invoice_id = (SELECT MAX(invoice_id) FROM {uc_invoice})");
  $invoice_nbr = db_result($result);
  $invoice_nbr_prefix = substr($invoice_nbr,0,4);
  $invoice_nbr_key = (int)(substr($invoice_nbr,4,strlen($invoice_nbr)-4));
  $current_year = date('Y');
  if ($invoice_nbr_prefix != $current_year) {
    $invoice_nbr = $current_year."00001";
    }
  else {
    $invoice_nbr_key += 1;
    $invoice_nbr = $current_year.str_pad($invoice_nbr_key, 5, "0", STR_PAD_LEFT);
    }
  $order_id = $order->order_id;
  $time = time();

  db_query("INSERT INTO {uc_invoice} (invoice_id, order_id, created, invoice_nbr) VALUES (NULL, %d, %d, %s)", $order_id, $time, $invoice_nbr);
  }
}