<?php

/*error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
*/

/***********************************  vysvetlivky  *************
* vytahuje produkty priamo z db
* preklady su v subore translations , upradnu sa z fuzzysearch modulu po stlaceni tlacitka
* 
*
*
*
/****************************************************************/

require_once 'search_functions.inc';
require_once 'helpers.inc';

//kontrola a sanita keyw

if (!app_ajax_security(array('keyw'), 'https://www.biome.sk')) exit();	
$keyword = search_cleanse($_POST['keyw']);


/***********************/
/* DRUPAL BOOTSTRAP  */
/************************/

chdir($_SERVER['DOCUMENT_ROOT']);
global $base_url;//toto a pod tym doplnene z https://api.drupal.org/api/drupal/includes%21bootstrap.inc/function/drupal_bootstrap/6.x
$base_url = 'https://'.$_SERVER['HTTP_HOST'];//
require_once './includes/bootstrap.inc';
require_once './includes/unicode.inc';

drupal_bootstrap( DRUPAL_BOOTSTRAP_DATABASE);
//drupal_bootstrap(DRUPAL_BOOTSTRAP_SESSION);

require_once './includes/common.inc';
require_once './includes/module.inc';


// Set the Drupal custom error hander.
//set_error_handler('drupal_error_handler');//vytiahnute z full_bootstrap - nezapisuju sa do error logu vsetky notice, ktorych je v uc_discounts pozehnane

/***********************/
/* DRUPAL BOOTSTRAP  END */
/************************/


//skopirovane z fuzzysearchu a upravene
$results = search_fuzzy($keyword, $limit = 7);
//watchdog('sear', '<pre>' . print_r( 'test', true) . '</pre>');


$html = '';
if ($results){
	$taxo = array();
	$nids = array();
	$terms_manufacturer = array();
	//var_dump($results);
	foreach ($results as $result){
		//var_dump($result);
		$language_prefix = ($result->language == 'en') ? '' : '/'. $result->language; 
		
		//price
		if ($result->discount_price > 0){
			$price = '<del>' . number_format($result->sell_price, 2, ',','') . '€</del><br>';
			$price .= '<strong class="_f-danger">' . number_format($result->discount_price, 2, ',','') . '€</strong>';
			
		} else {
			$price = '<strong>' . number_format($result->sell_price, 2, ',','') . '€</strong>';
		}				
		
		$html .= '<a class="item prod" href="/'. $result->dst .'">';
		if (isset($result->filename)) {
			$html .= '<img src="/files/imagecache/100/products/'. $result->filename . '">';
		}
		$html .= '<div class="main">';
		$html .= '<span>'. $result->title . '</span>';
		$html .= '<br><small>'. $result->field_toptitle_value . '</small>';		
		$html .= '</div>';
		$html .= '<div class="pricing"><span>'. $price . '</span></div>';
		$html .= '</a>';
		//$html .= '<div>'. $result->score . '</div>';
		//$html .= '<div>'. $result->percent . '</div>';
		
		
		if (!empty($result->znacka_path)){
			$terms_manufacturer[$result->znacka_nid] = '<a class="item categ" href="/'. $result->znacka_path .'">' . $result->znacka_title . '</a>';
		}
	}

//finalny html output
/*echo '<pre>';
print_r($GLOBALS['translations']); 
echo '</pre>';*/


	echo '<div class="products col d8 noLRpadding">'. $html . '</div>';
	echo '<div class="col d4">';	
	echo '<div class="mt-1"><strong>Značky</strong>:' . implode('',$terms_manufacturer) . '</div>';
	echo '</div>';
	

	
	
}

