<?php
define('PREG_CLASS_SEARCH_EXCLUDE',
'\x{0}-\x{2f}\x{3a}-\x{40}\x{5b}-\x{60}\x{7b}-\x{bf}\x{d7}\x{f7}\x{2b0}-'.
'\x{385}\x{387}\x{3f6}\x{482}-\x{489}\x{559}-\x{55f}\x{589}-\x{5c7}\x{5f3}-'.
'\x{61f}\x{640}\x{64b}-\x{65e}\x{66a}-\x{66d}\x{670}\x{6d4}\x{6d6}-\x{6ed}'.
'\x{6fd}\x{6fe}\x{700}-\x{70f}\x{711}\x{730}-\x{74a}\x{7a6}-\x{7b0}\x{901}-'.
'\x{903}\x{93c}\x{93e}-\x{94d}\x{951}-\x{954}\x{962}-\x{965}\x{970}\x{981}-'.
'\x{983}\x{9bc}\x{9be}-\x{9cd}\x{9d7}\x{9e2}\x{9e3}\x{9f2}-\x{a03}\x{a3c}-'.
'\x{a4d}\x{a70}\x{a71}\x{a81}-\x{a83}\x{abc}\x{abe}-\x{acd}\x{ae2}\x{ae3}'.
'\x{af1}-\x{b03}\x{b3c}\x{b3e}-\x{b57}\x{b70}\x{b82}\x{bbe}-\x{bd7}\x{bf0}-'.
'\x{c03}\x{c3e}-\x{c56}\x{c82}\x{c83}\x{cbc}\x{cbe}-\x{cd6}\x{d02}\x{d03}'.
'\x{d3e}-\x{d57}\x{d82}\x{d83}\x{dca}-\x{df4}\x{e31}\x{e34}-\x{e3f}\x{e46}-'.
'\x{e4f}\x{e5a}\x{e5b}\x{eb1}\x{eb4}-\x{ebc}\x{ec6}-\x{ecd}\x{f01}-\x{f1f}'.
'\x{f2a}-\x{f3f}\x{f71}-\x{f87}\x{f90}-\x{fd1}\x{102c}-\x{1039}\x{104a}-'.
'\x{104f}\x{1056}-\x{1059}\x{10fb}\x{10fc}\x{135f}-\x{137c}\x{1390}-\x{1399}'.
'\x{166d}\x{166e}\x{1680}\x{169b}\x{169c}\x{16eb}-\x{16f0}\x{1712}-\x{1714}'.
'\x{1732}-\x{1736}\x{1752}\x{1753}\x{1772}\x{1773}\x{17b4}-\x{17db}\x{17dd}'.
'\x{17f0}-\x{180e}\x{1843}\x{18a9}\x{1920}-\x{1945}\x{19b0}-\x{19c0}\x{19c8}'.
'\x{19c9}\x{19de}-\x{19ff}\x{1a17}-\x{1a1f}\x{1d2c}-\x{1d61}\x{1d78}\x{1d9b}-'.
'\x{1dc3}\x{1fbd}\x{1fbf}-\x{1fc1}\x{1fcd}-\x{1fcf}\x{1fdd}-\x{1fdf}\x{1fed}-'.
'\x{1fef}\x{1ffd}-\x{2070}\x{2074}-\x{207e}\x{2080}-\x{2101}\x{2103}-\x{2106}'.
'\x{2108}\x{2109}\x{2114}\x{2116}-\x{2118}\x{211e}-\x{2123}\x{2125}\x{2127}'.
'\x{2129}\x{212e}\x{2132}\x{213a}\x{213b}\x{2140}-\x{2144}\x{214a}-\x{2b13}'.
'\x{2ce5}-\x{2cff}\x{2d6f}\x{2e00}-\x{3005}\x{3007}-\x{303b}\x{303d}-\x{303f}'.
'\x{3099}-\x{309e}\x{30a0}\x{30fb}-\x{30fe}\x{3190}-\x{319f}\x{31c0}-\x{31cf}'.
'\x{3200}-\x{33ff}\x{4dc0}-\x{4dff}\x{a015}\x{a490}-\x{a716}\x{a802}\x{a806}'.
'\x{a80b}\x{a823}-\x{a82b}\x{e000}-\x{f8ff}\x{fb1e}\x{fb29}\x{fd3e}\x{fd3f}'.
'\x{fdfc}-\x{fe6b}\x{feff}-\x{ff0f}\x{ff1a}-\x{ff20}\x{ff3b}-\x{ff40}\x{ff5b}-'.
'\x{ff65}\x{ff70}\x{ff9e}\x{ff9f}\x{ffe0}-\x{fffd}');

define('PREG_CLASS_CJK', '\x{3041}-\x{30ff}\x{31f0}-\x{31ff}\x{3400}-\x{4db5}'.
'\x{4e00}-\x{9fbb}\x{f900}-\x{fad9}');

function search_fuzzy($query, $limit = 10) {
	


  $nlength = 4; //rucne nastavena velkost ngramov
  $min_spelling = 30;
  
 
  $words = explode(' ', $query);
  // Build the WHERE clause for the ngrams.
  $clause = ''; // inak bolo undefined variable
  foreach ($words as $k => $word) {
	  
    // @todo Change type of query based on boolean operators
    //$length = drupal_strlen($word);
	$length = mb_strlen($word);
	if ($length == 0) {break;} //ak prazdne tak idem dalej
	
	//var_dump($word);
    if ($length > $nlength) {
      // Determine lengths which we want to search for
      if ($length > 3) {
        // 5 letter word matches down to 4 letter words
        $comp = 1 / (4 - $nlength + 1);
      }
      if ($length > 5) {
        // 6 and 7 letter words match down to 5 letter words
        $comp = 1 / (5 - $nlength + 1);
      }
      if ($length > 7) {
        // anything larger matches down 2 letters than its own length
        $comp = 1 / ($length - 2 - $nlength + 1);
      }
      $comp = number_format($comp + .001, 3) * 100;
      for ($i=0; $i < $length - 2; $i++) {
       // $clause .= " (ngram = '". drupal_substr($word, $i, $nlength) ."' AND completeness < ". $comp .") OR";
	    $clause .= " (ngram = '". mb_substr($word, $i, $nlength) ."' AND completeness < ". $comp .") OR";
      }
    } elseif ($length == $nlength) {
		$clause .= " ngram = '". $word ."' OR";
	} else {
	  $clause .= " ngram LIKE '". $word ."%' OR";
	//ak su mensie tak hladaj like  
    } 
	//doplnit dodatocnu komplexitu?
	if ($length == 3){
		//$clause = " ngram = '". $word ."' AND completeness < 10 OR";
	}
  }

  $clause = preg_replace("/ OR$/", '', $clause);
//var_dump($clause);

  // @todo: Fix the minimum completeness so that a single qgram match doesn't necessarily return a match
  $min_completeness = 0;

  // Get content types to exclude from results. They are still indexed.
  //$types = array_filter(variable_get('fuzzysearch_nodetypes', array('')));
 // $types = array('page' => 'page', 'story' => 'story');
 $types = array('product' => 'product');

  // Build the query args and placeholders.
  $args[] = $min_completeness;
  $args += $types;

  $placeholders = count($types) ? db_placeholders($types, 'text'): '\'\'';
	
	//var_dump($clause);
	
  // Main query
  $sql = "SELECT n.nid, n.title, f.filename, ua.dst, ua.language, tt.field_toptitle_value, ucp.sell_price, znacka.znacka_path, znacka.znacka_title, znacka.znacka_nid, ucp.sell_price, ucp.discount_price, MAX(n.moderate) AS moderate, MAX(n.uid) AS uid, MAX(n.type) AS type, MAX(n.status) AS status, SUM(subpercent) AS percent, SUM(subscore) AS score
          FROM (SELECT DISTINCT word_id, nn.nid, SUM(completeness) AS subpercent, SUM(score) AS subscore
            FROM {fuzzysearch_index} s
            LEFT JOIN {node} nn ON (nn.nid = s.nid)
			WHERE ($clause)
            GROUP BY word_id, nn.nid HAVING SUM(completeness) >= %d) AS q
          LEFT JOIN {node} n on n.nid = q.nid
		  LEFT JOIN {url_alias} ua on ua.src = CONCAT('node/', q.nid)
		  LEFT JOIN {content_type_product} pr on pr.nid = q.nid
		  LEFT JOIN {uc_products} ucp ON ucp.nid = q.nid		  
		  LEFT JOIN {content_field_toptitle} tt on tt.nid = q.nid
		  LEFT JOIN {content_field_p_pic_main} pp on pp.nid = q.nid
		  LEFT JOIN {files} f on f.fid = pp.field_p_pic_main_fid			
		  JOIN (
			SELECT cfz.nid, uaa.dst AS znacka_path, no.title AS znacka_title, cfz.field_znacka_nid as znacka_nid 
			FROM {content_field_znacka} cfz
			LEFT JOIN {node} no ON no.nid = cfz.field_znacka_nid
			LEFT JOIN {url_alias} uaa ON uaa.src = CONCAT('node/', cfz.field_znacka_nid)
				) znacka ON znacka.nid = q.nid
          WHERE n.status = 1 AND (pr.field_avail_date_value IS NULL OR pr.field_avail_date_value NOT LIKE 'x') AND n.type IN ($placeholders)
          GROUP BY n.nid ORDER BY percent DESC, score DESC";


  $sql = db_rewrite_sql($sql);
 
 
  //vzdy pouzivam block_theme (ked volam tuto funkciu) lebo je jednoduchsia a limit nastavujem v parametroch pri volani
  
	$pager_results = db_query($sql. ' LIMIT '. $limit, $args); //upravene nech berie limit z parametra

  // Load the matched nodes.
  $results = array();
  while ($row = db_fetch_object($pager_results)) {
    
      $results[] = $row;
    
  }
  return $results;
}

function search_cleanse($text) {
  $text = strip_tags($text);

  mb_internal_encoding('UTF-8'); // treba nastavit inak vypisovalo diamant s otaznikom pri accented
  $text = mb_strtolower($text);
  
  //toto by malo nechat iba pismena a cisla - aj accenty necha
  $text = preg_replace('/[^\w\s+$]/u', '', $text);
  return preg_replace('/['. PREG_CLASS_SEARCH_EXCLUDE . ']+/u', ' ', $text);
}

