<?php
include( '../lm_strings.php' );
include( '../lm_prefs.php' );
include( '../lm_settings.php' );
include( '../lm_queries.php' );
include( '../lm_functions.php' );

//--SETTINGS--------------------------------------------------------------------

$lm_path = "../lm.php"; // The path of the MLM script

//--DEBUGING--------------------------------------------------------------------

$mlm_debug = False;

if ( $mlm_debug ) {
	error_reporting(E_ALL); 
	ini_set('display_errors','on');
} else {
	error_reporting(E_ALL ^ E_NOTICE); 
	ini_set('display_errors','off');
}

//--PARAMATER CHECKING----------------------------------------------------------

if ( isset( $_REQUEST['cmd'] ) && !empty( $_REQUEST['cmd'] ) ) { $cmd = $_REQUEST['cmd']; }
if ( isset( $_REQUEST['email'] ) && !empty( $_REQUEST['email'] ) ) { $email = $_REQUEST['email']; }
if ( isset( $_REQUEST['firstname'] ) && !empty( $_REQUEST['firstname'] ) ) { $firstname = $_REQUEST['firstname']; }
if ( isset( $_REQUEST['lastname'] ) && !empty( $_REQUEST['lastname'] ) ) { $lastname = $_REQUEST['lastname']; }

if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) { $list = $_REQUEST['list']; }

//-- INTERNAL PARAMETERS -------------------------------------------------------

$script_file = $_SERVER["SCRIPT_NAME"];
$script_path = Explode( '/', $script_file );
$script_name = $script_path[ count( $script_path ) - 1 ];

//-- PARAMETER CHECKER & ERROR HANDING -----------------------------------------

if ( isset( $_REQUEST['submit'] ) ) {
	$errors = array();
	if ( $email == "" ) { $errors[] = "Enter your email address in the email address text box"; $wrong['email'] = TRUE; }
	if ( $email !== "" && ( stristr( $email, "." ) == FALSE || stristr( $email, "@" ) == FALSE ) ) { $errors[] = "The e-mail address you have entered is not valid"; $wrong['email'] = TRUE; }
	if ( $firstname == "" ) { $errors[] = "Enter your first name in the first name text box"; $wrong['firstname'] = TRUE; }
	if ( $lastname == "" ) { $errors[] = "Enter your last name in the last name text box"; $wrong['lastname'] = TRUE; }
	
	if ( $list == "" ) { $errors[] = "You have to select a list"; $wrong['list'] = TRUE; }
	
	if ( count( $errors ) == 0 ) {
		$url = $lm_path . "?cmd=$cmd&list=$list&email=$email&firstname=$firstname&lastname=$lastname";
		header("Location: $url");
	}
}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">

	<head>
		<meta http-equiv="content-type" content="text/html;charset=utf-8" />
		<meta name="generator" content="Adobe GoLive" />
		<title>Mailing List Subscription</title>
		<style type=text/css>
			A:link  { color: #396D84; font-weight: normal; text-decoration: underline }
			A {
				CURSOR: hand; TEXT-DECORATION: none
			}
			A:visited  { color: #396D84; font-weight: normal; text-decoration: underline }
			A:active  { color: #86B82D; text-decoration: underline }
			A:hover   { color: #86B82D; font-weight: normal; text-decoration: underline }
			
			input[type="text"], input[type="password"], textarea {font-weight: bold;}
			select:focus, textarea:focus, input:focus {background-color: #ffffee;}
		</style>
	</head>

	<body>
		<div align="center">
			<br />
			<br />
			<table width="500" border="0" cellspacing="2" cellpadding="0">
				<tr bgcolor="#0059a5" height="22">
					<td height="22">
						<div align="center">
							<font color="white" face="Verdana, Arial, Helvetica, sans-serif"><b>Mailing List Subscription</b></font></div>
					</td>
				</tr>
				<tr bgcolor="white" height="16">
					<td height="16"></td>
				</tr>
				<tr>
					<td>
						<div align="center">
							<form id="FormName" action="<?php echo $script_name; ?>" method="get" name="FormName">
								<table width="100%" border="0" cellspacing="2" cellpadding="0">
									<tr height="24">
										<td width="40%" height="24">
											<div align="right">
												<font size="-1" color="#0059a5" face="Verdana"><b>Your E-mail Address</b></font></div>
										</td>
										<td width="15" height="24"></td>
										<td height="24"><input type="text" name="email" size="30" <?php echo " value=\"$email\""; ?> /></td>
										<td height="24"><font size="-2" color="#ff9c9c" face="Geneva,Arial,Helvetica,sans-serif">Required</font></td>
									</tr>
									<tr height="24">
										<td width="40%" height="24">
											<div align="right">
												<font size="-1" color="#0059a5" face="Verdana"><b>Your First Name</b></font></div>
										</td>
										<td width="15" height="24"></td>
										<td height="24"><input type="text" name="firstname" size="30" <?php echo " value=\"$firstname\""; ?> /></td>
										<td height="24"><font size="-2" color="#ff9c9c" face="Geneva,Arial,Helvetica,sans-serif">Required</font></td>
									</tr>
									<tr height="24">
										<td width="40%" height="24">
											<div align="right">
												<font size="-1" color="#0059a5" face="Verdana"><b>Your Last Name</b></font></div>
										</td>
										<td width="15" height="24"></td>
										<td height="24"><input type="text" name="lastname" size="30" <?php echo " value=\"$lastname\""; ?> /></td>
										<td height="24"><font size="-2" color="#ff9c9c" face="Geneva,Arial,Helvetica,sans-serif">Required</font></td>
									</tr>
									<tr height="24">
										<td valign="top" width="40%" height="24">
											<div align="right">
												<font size="-1" color="#0059a5" face="Verdana"><b>Mailing Lists</b></font></div>
										</td>
										<td width="15" height="24"></td>
											<td height="24">
												<select name="list">
												<?php
												$pwd = $admin_password;
												$ext_list = ".txt";
												$lists = explode( "\n", ShowLists() );
												usort( $lists, "SortByName" );									
												foreach ( $lists as $mylist ) {
													list( $name, $count, $date ) = explode( "\t", $mylist );
													if ( trim( $name <> "" ) ) {
														echo "<option";
														if ( $name == $list ) { echo " selected=\"selected\""; }
														echo " value=\"" . $name . ".php\">" . $name . "</option>\n";
													}
												}
												function SortByName( $a, $b )
												{
    												return strcasecmp( $a['name'], $b['name'] );
												}
												?>
												</select>
											</td>
										<td height="24"><font size="-2" color="#ff9c9c" face="Geneva,Arial,Helvetica,sans-serif">Required</font></td>
									</tr>
									<tr height="24">
										<td width="40%" height="24"></td>
										<td width="15" height="24"></td>
										<td height="24"><input type="radio" name="cmd" value="subscribe" <?php if ( $cmd == "" || $cmd == "subscribe" ) { echo "checked=\"checked\""; } ?> /><font size="2" face="Arial"> Subscribe <input type="radio" name="cmd" value="unsubscribe" <?php if ( $cmd == "unsubscribe" ) { echo "checked=\"checked\""; } ?> /> Unsubscribe</font></td>
										<td height="24"></td>
									</tr>
									<tr height="20">
										<td colspan="3" valign="top" height="20"></td>
										<td valign="top" height="20"></td>
									</tr>
									<tr>
										<td width="40%">
											<div align="center"></div>
										</td>
										<td width="15"></td>
										<td>
											<div align="right">
												<font size="-1" face="Verdana"><b><input type="submit" name="submit" value="Submit" /> <input type="reset" value="Clear Form" /></b></font></div>
										</td>
										<td></td>
									</tr>
								</table>
							</form>
						</div>
					</td>
				</tr>
				<tr height="10">
					<td height="10">
						<div align="center">
							<?php

// --- ERROR CHECKING ---

if ( isset( $_REQUEST['submit'] ) ) {
	if ( count( $errors ) > 0) {
		echo "<br />";
		echo "<table width=\"500\" border=\"0\" cellspacing=\"2\" cellpadding=\"0\">";
		echo "<tr bgcolor=\"#ff0000\" height=\"22\">";
		echo "<td height=\"22\">";
		echo "<div align=\"center\">";
		echo "<font color=\"white\" face=\"Verdana, Arial, Helvetica, sans-serif\"><b>Sorry but we can't process your request</b></font></div>";
		echo "</td>";
		echo "</tr>";
		echo "</table>";
		echo "<font size=\"-1\" color=\"red\" face=\"Verdana, Arial, Helvetica, sans-serif\"\>";
		echo "<b/>Please fix the following issues</b/><br />";
		for($i=0; $i<count($errors); $i++){
			echo $errors[$i]."<br />";
		}
	} else if ( count( $successes ) > 0) {
		echo "<font color=\"blue\" face=\"Verdana, Arial, Helvetica, sans-serif\"\>";
		echo "<b/>Your request has been processed successfully:</b/><br />";
		for($i=0; $i<count($successes); $i++){
			echo $successes[$i]."<br />";
		}
	}
}

?></div>
					</td>
				</tr>
				<tr bgcolor="white">
					<td>
						<div align="center">
							<hr />
							<font size="-2" color="#636363" face="Verdana, Arial, Helvetica, sans-serif">Maxprog List Manager v1.0 - <a href="http://www.maxprog.com/">Max Programming, LLC</a> - Copyright (c) 2008 - 2009</font></div>
					</td>
				</tr>
			</table>
			<br />
			<br />
		</div>
	</body>

</html>