<?php
/****************************************************************************
 *                         Maxprog List Manager (MLM)
 *                            -------------------
 *   begin                : Friday, Feb 09, 2007
 *   copyright            : (C) 2008 - 2012 - Stan Busk, Max Programming, LLC
 *   support              : http://maxprog.com/forum/viewforum.php?f=16
 *   website              : http://www.maxprog.com/site/scripts/list_manager/
 *
 ****************************************************************************/
 
// Supported commands:
//
// lm.php?cmd=subscribe&list=list1[;list2;...&email=email_addr[&pwd=password]
// lm.php?cmd=unsubscribe[&list=list1[;list2;...]]&email=email_addr[&pwd=password]

// lm.php?cmd=lists[&email=email_addr][&pwd=password]
// lm.php?cmd=getlist&list=list1[;list2;...]&pwd=password[&output=file]
// lm.php?cmd=createlist&list=list&pwd=password
// lm.php?cmd=removelist&list=list1[;list2;...]&pwd=password
// lm.php?cmd=import&list=list1[;list2;...]&pwd=password&action=Append|overwrite|Update

// lm.php?cmd=getinfo&pwd=password
// lm.php?cmd=getver&pwd=password
// lm.php?cmd=init&pwd=password (mySQL only)
// lm.php?cmd=uninstall&pwd=password

//--SETTINGS--------------------------------------------------------------------

include( 'lm_strings.php' );
include( 'lm_prefs.php' );
include( 'lm_settings.php' );
include( 'lm_queries.php' );
include( 'lm_functions.php' );
include( 'lm_admin.php' );

if ( !ini_get('safe_mode') ) { @set_time_limit(1800); } // Set script maximum execution time

// @ini_set('memory_limit', '32M');
// @ini_set('max_execution_time', '1800');

if ( $mlm_debug ) {
	error_reporting(E_ALL); 
	ini_set('display_errors','on');
} else {
	error_reporting(E_ALL ^ E_NOTICE); 
	ini_set('display_errors','off');
}

//-- INTERNAL PARAMETERS -------------------------------------------------------

$script_name    = "Maxprog List Manager";
$script_version = "3.0.8";
$copyright      = "Copyright (c) 2008 - 2012";
$languages      = array( 'en', 'fr', 'de', 'es', 'it', 'nl', 'cz' );

$dec_quotes  = ENT_COMPAT;
$dec_charset = "UTF-8";

$allowdups   = 0;   // Allow duplicate email addresses
$rowsperpage = 100; // Recipients per page when displaying a list thru the web interface

//-- PARAMETER CHECKER ---------------------------------------------------------

// import_request_variables('GPC'); // In case register_globals = OFF in php.ini

if ( isset( $_REQUEST['lang'] ) && !empty( $_REQUEST['lang'] ) ) {
	$language = strtolower( $_REQUEST['lang'] );
	if ( in_array( $language, $languages ) ) {
		$lang = $language;
	} else {
		$lang = $defaults_language;
	}
} else {
	$lang = $defaults_language;
}

if ( !in_array( $lang, $languages ) ) { $lang = "en"; } // Language security check

//if ( $lang == "en" ) { $emailencoding = ""; } else { $emailencoding = "utf-8"; }
$emailencoding = "utf-8";

if ( isset( $_REQUEST['cmd'] ) && !empty( $_REQUEST['cmd'] ) ) {
	$cmd   = strtolower( $_REQUEST['cmd'] );
} else if ( isset( $_REQUEST['tk'] ) && !empty( $_REQUEST['tk'] ) ) {
	$cmd   = "tk";
	$data  = base64_decode( $_REQUEST['tk'] );
	list( $firstname, $lastname, $company, $email, $subject, $delivery, $list, $total, $action, $fwd, $test ) = explode( "\t", $data );
	$url   = $_REQUEST['url'];
} else if ( isset( $_REQUEST['un'] ) && !empty( $_REQUEST['un'] ) ) {
	$cmd   = "un";
	$data  = base64_decode( $_REQUEST['un'] );
	list( $firstname, $lastname, $company, $email, $subject, $delivery, $list, $listid, $total, $action, $fwd, $test ) = explode( "\t", $data );	
} else {
	// <ERROR>Error - You forgot to provide the command parameter: &cmd=command</ERROR>
	//exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_cmd[$lang] . ": &cmd=command</ERROR>", $dec_quotes, $dec_charset ) );
	$cmd = "admin";
	$action = "login";
}

if ( $cmd == "confirm" ) {
	If ( isset( $_REQUEST['key'] ) && !empty( $_REQUEST['key'] ) ) {
		$key = $_REQUEST['key'];
	} else {
		// <ERROR>Error - The key argument is missing.</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_key[$lang] . ": &key=reference</ERROR>", $dec_quotes, $dec_charset ) );
	}
} else if ( $cmd == "subscribe" || $cmd == "unsubscribe" || $cmd == "un" || $cmd == "update" ) {
	if ( $cmd == "subscribe" || $cmd == "unsubscribe" || $cmd == "update" ) {
		if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) {
			$list = $_REQUEST['list'];
		} else {
			if ( $cmd == "unsubscribe") {
				// Do nothing - No list = All lists
			} else {
				// <ERROR>Error - You forgot to provide the list name parameter: &list=listname</ERROR>
				exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_lst[$lang] . ": &list=listname</ERROR>", $dec_quotes, $dec_charset ) );
			}
		}
		if ( isset( $_REQUEST['email'] ) && !empty( $_REQUEST['email'] ) ) {
			$email = strtolower( $_REQUEST['email'] );
		} else {
			// <ERROR>Error - You forgot to provide the email address parameter: &email=emailaddress</ERROR>
			exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_adr[$lang] . ": &email=emailaddress</ERROR>", $dec_quotes, $dec_charset ) );
		}
		if ( $cmd == "update" ) {
			if ( isset( $_REQUEST['newemail'] ) && !empty( $_REQUEST['newemail'] ) ) {
				$newemail = strtolower( $_REQUEST['newemail'] );
			} else { 
				$newemail = $email;
			}
		}
		if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) { $pwd = $_REQUEST['pwd']; }
		if ( isset( $_REQUEST['firstname'] ) && !empty( $_REQUEST['firstname'] ) ) { $firstname = $_REQUEST['firstname']; }
		if ( isset( $_REQUEST['lastname'] ) && !empty( $_REQUEST['lastname'] ) ) { $lastname = $_REQUEST['lastname']; }
		if ( isset( $_REQUEST['company'] ) && !empty( $_REQUEST['company'] ) ) { $company = $_REQUEST['company']; }
		if ( isset( $_REQUEST['opt1'] ) && !empty( $_REQUEST['opt1'] ) ) { $opt1 = $_REQUEST['opt1']; }
		if ( isset( $_REQUEST['opt2'] ) && !empty( $_REQUEST['opt2'] ) ) { $opt2 = $_REQUEST['opt2']; }
		if ( isset( $_REQUEST['opt3'] ) && !empty( $_REQUEST['opt3'] ) ) { $opt3 = $_REQUEST['opt3']; }
		if ( isset( $_REQUEST['opt4'] ) && !empty( $_REQUEST['opt4'] ) ) { $opt4 = $_REQUEST['opt4']; }
		if ( isset( $_REQUEST['opt5'] ) && !empty( $_REQUEST['opt5'] ) ) { $opt5 = $_REQUEST['opt5']; }
		if ( isset( $_REQUEST['opt6'] ) && !empty( $_REQUEST['opt6'] ) ) { $opt6 = $_REQUEST['opt6']; }
		if ( isset( $_REQUEST['opt7'] ) && !empty( $_REQUEST['opt7'] ) ) { $opt7 = $_REQUEST['opt7']; }
		if ( isset( $_REQUEST['opt8'] ) && !empty( $_REQUEST['opt8'] ) ) { $opt8 = $_REQUEST['opt8']; }
		if ( isset( $_REQUEST['opt9'] ) && !empty( $_REQUEST['opt9'] ) ) { $opt9 = $_REQUEST['opt9']; }
		if ( isset( $_REQUEST['opt10'] ) && !empty( $_REQUEST['opt10'] ) ) { $opt10 = $_REQUEST['opt10']; }
		if ( isset( $_REQUEST['opt11'] ) && !empty( $_REQUEST['opt11'] ) ) { $opt11 = $_REQUEST['opt11']; }
		if ( isset( $_REQUEST['opt12'] ) && !empty( $_REQUEST['opt12'] ) ) { $opt12 = $_REQUEST['opt12']; }
		if ( isset( $_REQUEST['opt13'] ) && !empty( $_REQUEST['opt13'] ) ) { $opt13 = $_REQUEST['opt13']; }
		if ( isset( $_REQUEST['opt14'] ) && !empty( $_REQUEST['opt14'] ) ) { $opt14 = $_REQUEST['opt14']; }
		if ( isset( $_REQUEST['opt15'] ) && !empty( $_REQUEST['opt15'] ) ) { $opt15 = $_REQUEST['opt15']; }
		if ( isset( $_REQUEST['opt16'] ) && !empty( $_REQUEST['opt16'] ) ) { $opt16 = $_REQUEST['opt16']; }
		if ( isset( $_REQUEST['opt17'] ) && !empty( $_REQUEST['opt17'] ) ) { $opt17 = $_REQUEST['opt17']; }
		if ( isset( $_REQUEST['opt18'] ) && !empty( $_REQUEST['opt18'] ) ) { $opt18 = $_REQUEST['opt18']; }
		if ( isset( $_REQUEST['opt19'] ) && !empty( $_REQUEST['opt19'] ) ) { $opt19 = $_REQUEST['opt19']; }
		if ( isset( $_REQUEST['opt20'] ) && !empty( $_REQUEST['opt20'] ) ) { $opt20 = $_REQUEST['opt20']; }	
	} else if ( $cmd == "un" ) {
		if ( $action == "unsubscribe" ) {
			$fwd = 'no';
			$url = 'unsubscribe';
			$alt = 'Unsubscribe';
		}
	}
	if ( isset( $_REQUEST['return'] ) && !empty( $_REQUEST['return'] ) ) {
		$return = $_REQUEST['return'];
	} else {
		$return = "html";
	}
	if ( isset( $_REQUEST['local'] ) && !empty( $_REQUEST['local'] ) ) { $local = $_REQUEST['local']; } else { $local = "no"; }
} else if ( $cmd == "getlist" || $cmd == "createlist" || $cmd == "removelist" || $cmd == "renamelist" ) {
	if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) {
	//if ( isset( $_REQUEST['list'] ) ) {
		$list = $_REQUEST['list'];
	} else {
		// <ERROR>Error - You forgot to provide the list name parameter: &list=listname</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_lst[$lang] . ": &list=listname</ERROR>", $dec_quotes, $dec_charset ) );
	}
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) {
		$pwd = $_REQUEST['pwd'];
	} else {
		// <ERROR>Error - You forgot to provide the password parameter: &pwd=password</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_pwd[$lang] . ": &pwd=password</ERROR>", $dec_quotes, $dec_charset ) );
	}
	if ( isset( $_REQUEST['return'] ) && !empty( $_REQUEST['return'] ) ) {
		$return = $_REQUEST['return'];
	} else {
		$return = "html";
	}	
	if ( $cmd == "renamelist" ) {
		if ( isset( $_REQUEST['name'] ) && !empty( $_REQUEST['name'] ) ) {
			$name = $_REQUEST['name'];
		} else {
			// <ERROR>Error - You forgot to provide the new list name parameter: &name=newlistname</ERROR>
			exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_nna[$lang] . ": &name=newlistname</ERROR>", $dec_quotes, $dec_charset ) );
		}
	}
	if ( $cmd == "getlist" && isset( $_REQUEST['output'] ) && !empty( $_REQUEST['output'] ) ) { $output_type = strtolower( $_REQUEST['output'] ); }	
} else if ( $cmd == "removedelivery" ) {
	if ( isset( $_REQUEST['delivery'] ) && !empty( $_REQUEST['delivery'] ) ) {
		$delivery = $_REQUEST['delivery'];
	} else {
		// <ERROR>Error - You forgot to provide the delivery number parameter: &delivery=delivery</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_del[$lang] . ": &delivery=delivery</ERROR>", $dec_quotes, $dec_charset ) );	
	}
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) {
		$pwd = $_REQUEST['pwd'];
	} else {
		// <ERROR>Error - You forgot to provide the password parameter: &pwd=password</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_pwd[$lang] . ": &pwd=password</ERROR>", $dec_quotes, $dec_charset ) );
	}
	if ( isset( $_REQUEST['return'] ) && !empty( $_REQUEST['return'] ) ) {
		$return = $_REQUEST['return'];
	} else {
		$return = "html";
	}	
} else if ( $cmd == "getinfo" ) {
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd']) ) {
		$pwd = $_REQUEST['pwd'];
	} else {
		// <ERROR>Error - You forgot to provide the password parameter: &pwd=password</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_pwd[$lang] . ": &pwd=password</ERROR>", $dec_quotes, $dec_charset ) );
	}
} else if ( $cmd == "getversion" ) {
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd']) ) {
		$pwd = $_REQUEST['pwd'];
	} else {
		// <ERROR>Error - You forgot to provide the password parameter: &pwd=password</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_pwd[$lang] . ": &pwd=password</ERROR>", $dec_quotes, $dec_charset ) );
	}	
} else if ( $cmd == "lists" ) {
	if ( isset( $_REQUEST['email'] ) && !empty( $_REQUEST['email'] ) ) { $email = strtolower( $_REQUEST['email'] ); }
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) { $pwd = $_REQUEST['pwd']; }	
} else if ( $cmd == "init"  || $cmd == "uninstall" ) {
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) {
		$pwd = $_REQUEST['pwd'];
	} else {
		// <ERROR>Error - You forgot to provide the password parameter: &pwd=password</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_pwd[$lang] . ": &pwd=password</ERROR>", $dec_quotes, $dec_charset ) );
	}
} else if ( $cmd == "upload" ) {
	if ( isset( $_REQUEST['src'] ) && !empty( $_REQUEST['src'] ) ) { $src = $_REQUEST['src']; } // upload from cpanel?
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) {
		$pwd = $_REQUEST['pwd'];
	} else {
		// <ERROR>Error - You forgot to provide the password parameter: &pwd=password</ERROR>
		if ( $src == "cpanel" ) {
			$result = -1;
			$errorstr = $kErr_missingparam_pwd[$lang] . ": &pwd=password";
			cpanel_upload();
			exit();
		} else {
			exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_pwd[$lang] . ": &pwd=password</ERROR>", $dec_quotes, $dec_charset ) );
		}
	}
	if ( isset( $_REQUEST['action'] ) && !empty( $_REQUEST['action'] ) ) {
		$action = $_REQUEST['action'];
	} else {
		// <ERROR>Error - You forgot to provide the action parameter: &action=action</ERROR>
		if ( $src == "cpanel" ) {
			$result = -1;
			$errorstr = $kErr_missingparam_act[$lang] . ": &action=action";
			cpanel_upload();
			exit();
		} else {
			exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_act[$lang] . ": &action=action</ERROR>", $dec_quotes, $dec_charset ) );
		}
	}	
	if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) {
		$list = $_REQUEST['list'];
	} else {
		// <ERROR>Error - You forgot to provide the list name parameter: &list=listname</ERROR>
		if ( $src == "cpanel" ) {
			$result = -1;
			$errorstr = $kErr_missingparam_lst[$lang] . ": &list=listname";
			cpanel_upload();
			exit();
		} else {
			exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_lst[$lang] . ": &list=listname</ERROR>", $dec_quotes, $dec_charset ) );
		}
	}
	if ( isset( $_REQUEST['return'] ) && !empty( $_REQUEST['return'] ) ) {
		$return = $_REQUEST['return'];
	} else {
		$return = "html";
	}
	if ( isset( $_REQUEST['dups'] ) && !empty( $_REQUEST['dups'] ) ) {
		if ( $_REQUEST['dups'] == 'yes' || $_REQUEST['dups'] == '1' ) {
			$allowdups = True;
		} else {
			$allowdups = False;
		}
	} else {
		$allowdups = False;
	}
	if ( isset( $_REQUEST['msg'] ) && !empty( $_REQUEST['msg'] ) ) { $msg = $_REQUEST['msg']; }
	if ( isset( $_REQUEST['sub'] ) && !empty( $_REQUEST['sub'] ) ) { $sub = $_REQUEST['sub']; }
	if ( isset( $_FILES['upload'] ) && !empty( $_FILES['upload']['name'] ) && $_FILES['upload']['size'] > 0 ) {
		@$upload_Name      = $_FILES['upload']['name'];
		@$upload_Size      = $_FILES['upload']['size'];
		@$upload_Temp      = $_FILES['upload']['tmp_name'];
		@$upload_Mime_Type = $_FILES['upload']['type'];
	} else {
		// <ERROR>Error - You forgot to provide the data parameter: &upload=data</ERROR>
		if ( $src == "cpanel" ) {
			$result = -1;
			$errorstr = $kErr_missingparam_dat[$lang] . ": &upload=data";
			cpanel_upload();
			exit();
		} else {
			exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_dat[$lang] . ": &upload=data</ERROR>", $dec_quotes, $dec_charset ) );
		}
	}
} else if ( $cmd == "import" ) {
	if ( isset( $_REQUEST['src'] ) && !empty( $_REQUEST['src'] ) ) { $src = $_REQUEST['src']; } // upload from cpanel?
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) {
		$pwd = $_REQUEST['pwd'];
	} else {
		// <ERROR>Error - You forgot to provide the password parameter: &pwd=password</ERROR>
		if ( $src == "cpanel" ) {
			$result = -1;
			$errorstr = $kErr_missingparam_pwd[$lang] . ": &pwd=password";
			cpanel_upload();
			exit();
		} else {
			exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_pwd[$lang] . ": &pwd=password</ERROR>", $dec_quotes, $dec_charset ) );
		}
	}
	if ( isset( $_REQUEST['action'] ) && !empty( $_REQUEST['action'] ) ) {
		$action = $_REQUEST['action'];
	} else {
		// <ERROR>Error - You forgot to provide the action parameter: &action=action</ERROR>
		if ( $src == "cpanel" ) {
			$result = -1;
			$errorstr = $kErr_missingparam_act[$lang] . ": &action=action";
			cpanel_upload();
			exit();
		} else {
			exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_act[$lang] . ": &action=action</ERROR>", $dec_quotes, $dec_charset ) );
		}
	}	
	if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) {
		$list = $_REQUEST['list'];
	} else {
		// <ERROR>Error - You forgot to provide the list name parameter: &list=listname</ERROR>
		if ( $src == "cpanel" ) {
			$result = -1;
			$errorstr = $kErr_missingparam_lst[$lang] . ": &list=listname";
			cpanel_upload();
			exit();
		} else {
			exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_lst[$lang] . ": &list=listname</ERROR>", $dec_quotes, $dec_charset ) );
		}
	}
	if ( isset( $_REQUEST['return'] ) && !empty( $_REQUEST['return'] ) ) {
		$return = $_REQUEST['return'];
	} else {
		$return = "html";
	}
	if ( isset( $_REQUEST['dups'] ) && !empty( $_REQUEST['dups'] ) ) {
		if ( $_REQUEST['dups'] == 'yes' || $_REQUEST['dups'] == '1' ) {
			$allowdups = True;
		} else {
			$allowdups = False;
		}
	} else {
		$allowdups = False;
	}
	if ( isset( $_REQUEST['msg'] ) && !empty( $_REQUEST['msg'] ) ) { $msg = $_REQUEST['msg']; }
	if ( isset( $_REQUEST['sub'] ) && !empty( $_REQUEST['sub'] ) ) { $sub = $_REQUEST['sub']; }
} else if ( $cmd == "track" || $cmd == "tk" ) {
	if ( $cmd == "track" ) {
		if ( isset( $_REQUEST['delivery'] ) && !empty( $_REQUEST['delivery'] ) ) { $delivery = $_REQUEST['delivery']; }
		if ( isset( $_REQUEST['subject'] ) && !empty( $_REQUEST['subject'] ) ) { $subject = $_REQUEST['subject']; } else { $subject = $kTxt_clicktracker_und[$lang]; }
		if ( isset( $_REQUEST['firstname'] ) && !empty( $_REQUEST['firstname'] ) ) { $firstname = $_REQUEST['firstname']; } else { $firstname = ""; }
		if ( isset( $_REQUEST['lastname'] ) && !empty( $_REQUEST['lastname'] ) ) { $lastname = $_REQUEST['lastname']; } else { $lastname = ""; }
		if ( isset( $_REQUEST['company'] ) && !empty( $_REQUEST['company'] ) ) { $company = $_REQUEST['company']; } else { $company = ""; }
		if ( isset( $_REQUEST['email'] ) && !empty( $_REQUEST['email'] ) ) { $email = strtolower( $_REQUEST['email'] ); } else { $email = $kTxt_clicktracker_und[$lang]; }	
		if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) { $list = $_REQUEST['list']; } else { $list = $kTxt_clicktracker_und[$lang]; }
		if ( isset( $_REQUEST['total'] ) && !empty( $_REQUEST['total'] ) ) { $total = $_REQUEST['total']; }
		if ( isset( $_REQUEST['action'] ) && !empty( $_REQUEST['action'] ) ) { $action = $_REQUEST['action']; } else { $action = "click"; }
		if ( isset( $_REQUEST['test'] ) && !empty( $_REQUEST['test'] ) ) { $test = $_REQUEST['test']; } else { $test = "no"; }
	} else {
		if ( $subject == "" ) { $subject = $kTxt_clicktracker_und[$lang]; }
		if ( $email == "" ) { $email = $kTxt_clicktracker_und[$lang]; }
		if ( $list == "" ) { $list = $kTxt_clicktracker_und[$lang]; }
		if ( $action == "" ) { $action = "click"; }
	}
	if ( $action == "click" ) {
		if ( $cmd == "track" ) {
			if ( isset( $_REQUEST['fwd'] ) && !empty( $_REQUEST['fwd'] ) ) { $fwd = $_REQUEST['fwd']; } else { $fwd = 'yes'; }		
			if ( isset( $_REQUEST['url'] ) && !empty( $_REQUEST['url'] ) ) { $url = $_REQUEST['url']; } else { $url = $kTxt_clicktracker_und[$lang]; }
			if ( isset( $_REQUEST['alt'] ) && !empty( $_REQUEST['alt'] ) ) { $alt = $_REQUEST['alt']; }
		} else {
			if ( $fwd == "" ) { $fwd = 'yes'; }
			if ( $url == "" ) { $url = $kTxt_clicktracker_und[$lang]; }
		}
	} else if ( $action == "open" ) {
		$fwd = 'no';
		$url = 'open';
		$alt = 'Open';
	} else if ( $action == "bounce" ) {
		$fwd = 'no';
		$url = 'bounce';
		$alt = 'Bounce';
	}
} else if ( $cmd == "getclicks" ) {
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) {
		$pwd = $_REQUEST['pwd'];
	} else {
		// <ERROR>Error - You forgot to provide the password parameter: &pwd=password</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_pwd[$lang] . ": &pwd=password</ERROR>", $dec_quotes, $dec_charset ) );
	}
	if ( isset( $_REQUEST['email'] ) && !empty( $_REQUEST['email'] ) ) {
		$email = strtolower( $_REQUEST['email'] );
	} else {
		if ( isset( $_REQUEST['delivery'] ) && !empty( $_REQUEST['delivery'] ) ) {
			$delivery = $_REQUEST['delivery'];
		} else {
			// <ERROR>Error - You forgot to provide the delivery number parameter: &delivery=delivery</ERROR>
			exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_del[$lang] . ": &delivery=delivery</ERROR>", $dec_quotes, $dec_charset ) );	
		}
	}
	if ( isset( $_REQUEST['test'] ) && !empty( $_REQUEST['test'] ) ) { $test = $_REQUEST['test']; } else { $test = "no"; }
	if ( isset( $_REQUEST['output'] ) && !empty( $_REQUEST['output'] ) ) { $output_type = strtolower( $_REQUEST['output'] ); }
	if ( isset( $_REQUEST['start'] ) && !empty( $_REQUEST['start'] ) ) { $start = $_REQUEST['start']; }	else { $start = 0; }
	if ( isset( $_REQUEST['return'] ) && !empty( $_REQUEST['return'] ) ) { $return = $_REQUEST['return']; } else { $return = "xml"; }
} else if ( $cmd == "deliveries" ) {	
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) {
		$pwd = $_REQUEST['pwd'];
	} else {
		// <ERROR>Error - You forgot to provide the password parameter: &pwd=password</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_pwd[$lang] . ": &pwd=password</ERROR>", $dec_quotes, $dec_charset ) );
	}	
	if ( isset( $_REQUEST['email'] ) && !empty( $_REQUEST['email'] ) ) { $email = strtolower( $_REQUEST['email'] ); }
	if ( isset( $_REQUEST['test'] ) && !empty( $_REQUEST['test'] ) ) { $test = $_REQUEST['test']; } else { $test = "no"; }
} else if ( $cmd == "getofflist" || $cmd == "getlocactlist" ) {
	if ( isset( $_REQUEST['listid'] ) ) {
		$listid = $_REQUEST['listid'];
	} else {
		// <ERROR>Error - You forgot to provide the list name parameter: &listid=listID</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_lst[$lang] . ": &listid=listID</ERROR>", $dec_quotes, $dec_charset ) );
	}
	if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) {
		$pwd = $_REQUEST['pwd'];
	} else {
		// <ERROR>Error - You forgot to provide the password parameter: &pwd=password</ERROR>
		exit ( @html_entity_decode( "<ERROR>" . $kErr_missingparam_pwd[$lang] . ": &pwd=password</ERROR>", $dec_quotes, $dec_charset ) );
	}
	if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) { $list = base64_decode( $_REQUEST['list'] ); }
	if ( isset( $_REQUEST['return'] ) && !empty( $_REQUEST['return'] ) ) { $return = $_REQUEST['return']; } else { $return = "xml"; }	
	if ( isset( $_REQUEST['output'] ) && !empty( $_REQUEST['output'] ) ) { $output_type = strtolower( $_REQUEST['output'] ); }
} else if ( $cmd == "admin" ) {
	if ( isset( $_REQUEST['action'] ) && !empty( $_REQUEST['action'] ) ) { $action = $_REQUEST['action']; } else { $action = "login"; }
	if ( $action == "login" ) {
    	if ( isset( $_REQUEST['uid'] ) && !empty( $_REQUEST['uid'] ) ) { $uid = $_REQUEST['uid']; }
		if ( isset( $_REQUEST['pwd'] ) && !empty( $_REQUEST['pwd'] ) ) { $pwd = $_REQUEST['pwd']; }
	} else if ( $action == "showlist" ) {
		if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) { $list = $_REQUEST['list']; }
		if ( isset( $_REQUEST['page'] ) && !empty( $_REQUEST['page'] ) ) { $page = $_REQUEST['page']; } else { $page = 1; } // Page to diplay
		if ( isset( $_REQUEST['size'] ) && !empty( $_REQUEST['size'] ) ) { $size = $_REQUEST['size']; } else { $size = 0; }	// Number of recipients in the list
	} else if ( $action == "removelist" ) {
		if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) { $list = $_REQUEST['list']; }
		if ( isset( $_REQUEST['conf'] ) && !empty( $_REQUEST['conf'] ) ) { $confirmed = $_REQUEST['conf']; } // Confirmed?		
	} else if ( $action == "renamelist" ) {
		if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) { $list = $_REQUEST['list']; }
		if ( isset( $_REQUEST['newname'] ) && !empty( $_REQUEST['newname'] ) ) { $newname = $_REQUEST['newname']; }
		if ( isset( $_REQUEST['result'] ) && !empty( $_REQUEST['result'] ) ) { $result = strtolower( $_REQUEST['result'] ); } else { $result = ""; } // Ok, Cancel or ''?
	} else if ( $action == "newlist" ) {
		if ( isset( $_REQUEST['newname'] ) && !empty( $_REQUEST['newname'] ) ) { $newname = $_REQUEST['newname']; }
		if ( isset( $_REQUEST['result'] ) && !empty( $_REQUEST['result'] ) ) { $result = strtolower( $_REQUEST['result'] ); } else { $result = ""; } // Ok, Cancel or ''?
		$email = $admin_address;
		$firstname = $admin_name_short;
		$list = $newname;
	} else if ( $action == "removeaddr" ) {
		if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) { $list = $_REQUEST['list']; }
		if ( isset( $_REQUEST['email'] ) && !empty( $_REQUEST['email'] ) ) { $email = strtolower( $_REQUEST['email'] ); }
		if ( isset( $_REQUEST['conf'] ) && !empty( $_REQUEST['conf'] ) ) { $confirmed = $_REQUEST['conf']; } // Confirmed?
	} else if ( $action == "editaddr" || $action == "findaddr" ) {
		if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) { $list = $_REQUEST['list']; }
		if ( isset( $_REQUEST['firstname'] ) && !empty( $_REQUEST['firstname'] ) ) { $firstname = $_REQUEST['firstname']; } else { $firstname = ""; }
		if ( isset( $_REQUEST['lastname'] ) && !empty( $_REQUEST['lastname'] ) ) { $lastname = $_REQUEST['lastname']; } else { $lastname = ""; }
		if ( isset( $_REQUEST['company'] ) && !empty( $_REQUEST['company'] ) ) { $company = $_REQUEST['company']; } else { $company = ""; }
		if ( isset( $_REQUEST['email'] ) && !empty( $_REQUEST['email'] ) ) { $email = strtolower( $_REQUEST['email'] ); }
		if ( isset( $_REQUEST['newemail'] ) && !empty( $_REQUEST['newemail'] ) ) { $newemail = strtolower( $_REQUEST['newemail'] ); } else { $newemail = $email; }
		if ( isset( $_REQUEST['result'] ) && !empty( $_REQUEST['result'] ) ) { $result = strtolower( $_REQUEST['result'] ); } else { $result = ""; } // Ok, Cancel or ''?
		if ( isset( $_REQUEST['opt1'] ) && !empty( $_REQUEST['opt1'] ) ) { $opt1 = $_REQUEST['opt1']; }
		if ( isset( $_REQUEST['opt2'] ) && !empty( $_REQUEST['opt2'] ) ) { $opt2 = $_REQUEST['opt2']; }
		if ( isset( $_REQUEST['opt3'] ) && !empty( $_REQUEST['opt3'] ) ) { $opt3 = $_REQUEST['opt3']; }
		if ( isset( $_REQUEST['opt4'] ) && !empty( $_REQUEST['opt4'] ) ) { $opt4 = $_REQUEST['opt4']; }
		if ( isset( $_REQUEST['opt5'] ) && !empty( $_REQUEST['opt5'] ) ) { $opt5 = $_REQUEST['opt5']; }
		if ( isset( $_REQUEST['opt6'] ) && !empty( $_REQUEST['opt6'] ) ) { $opt6 = $_REQUEST['opt6']; }
		if ( isset( $_REQUEST['opt7'] ) && !empty( $_REQUEST['opt7'] ) ) { $opt7 = $_REQUEST['opt7']; }
		if ( isset( $_REQUEST['opt8'] ) && !empty( $_REQUEST['opt8'] ) ) { $opt8 = $_REQUEST['opt8']; }
		if ( isset( $_REQUEST['opt9'] ) && !empty( $_REQUEST['opt9'] ) ) { $opt9 = $_REQUEST['opt9']; }
		if ( isset( $_REQUEST['opt10'] ) && !empty( $_REQUEST['opt10'] ) ) { $opt10 = $_REQUEST['opt10']; }
		if ( isset( $_REQUEST['opt11'] ) && !empty( $_REQUEST['opt11'] ) ) { $opt11 = $_REQUEST['opt11']; }
		if ( isset( $_REQUEST['opt12'] ) && !empty( $_REQUEST['opt12'] ) ) { $opt12 = $_REQUEST['opt12']; }
		if ( isset( $_REQUEST['opt13'] ) && !empty( $_REQUEST['opt13'] ) ) { $opt13 = $_REQUEST['opt13']; }
		if ( isset( $_REQUEST['opt14'] ) && !empty( $_REQUEST['opt14'] ) ) { $opt14 = $_REQUEST['opt14']; }
		if ( isset( $_REQUEST['opt15'] ) && !empty( $_REQUEST['opt15'] ) ) { $opt15 = $_REQUEST['opt15']; }
		if ( isset( $_REQUEST['opt16'] ) && !empty( $_REQUEST['opt16'] ) ) { $opt16 = $_REQUEST['opt16']; }
		if ( isset( $_REQUEST['opt17'] ) && !empty( $_REQUEST['opt17'] ) ) { $opt17 = $_REQUEST['opt17']; }
		if ( isset( $_REQUEST['opt18'] ) && !empty( $_REQUEST['opt18'] ) ) { $opt18 = $_REQUEST['opt18']; }
		if ( isset( $_REQUEST['opt19'] ) && !empty( $_REQUEST['opt19'] ) ) { $opt19 = $_REQUEST['opt19']; }
		if ( isset( $_REQUEST['opt20'] ) && !empty( $_REQUEST['opt20'] ) ) { $opt20 = $_REQUEST['opt20']; }	
	} else if ( $action == "sendemail" ) {	
		if ( isset( $_REQUEST['firstname'] ) && !empty( $_REQUEST['firstname'] ) ) { $firstname = $_REQUEST['firstname']; } else { $firstname = ""; }
		if ( isset( $_REQUEST['lastname'] ) && !empty( $_REQUEST['lastname'] ) ) { $lastname = $_REQUEST['lastname']; } else { $lastname = ""; }
		if ( isset( $_REQUEST['company'] ) && !empty( $_REQUEST['company'] ) ) { $company = $_REQUEST['company']; } else { $company = ""; }
		if ( isset( $_REQUEST['email'] ) && !empty( $_REQUEST['email'] ) ) { $email = strtolower( $_REQUEST['email'] ); }
		if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) { $list = $_REQUEST['list']; }
		if ( isset( $_REQUEST['result'] ) && !empty( $_REQUEST['result'] ) ) { $result = strtolower( $_REQUEST['result'] ); } else { $result = ""; } // Ok, Cancel or ''?
		if ( isset( $_REQUEST['subject'] ) && !empty( $_REQUEST['subject'] ) ) { $subject = $_REQUEST['subject']; }
		if ( isset( $_REQUEST['message'] ) && !empty( $_REQUEST['message'] ) ) { $message = $_REQUEST['message']; }
	} else if ( $action == "showdeliveries" ) {
		if ( isset( $_REQUEST['page'] ) && !empty( $_REQUEST['page'] ) ) { $page = $_REQUEST['page']; } else { $page = 1; } // Page to diplay
	} else if ( $action == "showdelivery" ) {
		if ( isset( $_REQUEST['delivery'] ) && !empty( $_REQUEST['delivery'] ) ) { $delivery = $_REQUEST['delivery']; } else { $delivery = -1; }
	} else if ( $action == "removedelivery" ) {
		if ( isset( $_REQUEST['delivery'] ) && !empty( $_REQUEST['delivery'] ) ) { $delivery = $_REQUEST['delivery']; } else { $delivery = -1; }
		if ( isset( $_REQUEST['conf'] ) && !empty( $_REQUEST['conf'] ) ) { $confirmed = $_REQUEST['conf']; } // Confirmed?		
	} else if ( $action == "upload" ) {
		// Do nothing yet
	}
} else {
	// <ERROR>Error - Command '$cmd' not supported.</ERROR>
	exit ( @html_entity_decode( "<ERROR>" . str_replace( "[CMD]", "'" . $cmd . "'", $kErr_missingparam_cmn[$lang] ) . "</ERROR>", $dec_quotes, $dec_charset ) );
}

if ( !isset( $_REQUEST['pwd'] ) ) { $pwd = ""; }

//-- PRE-PROCESS ---------------------------------------------------------------

$path_to_script = "http://" . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];

if ( isset( $_REQUEST['list'] ) && !empty( $_REQUEST['list'] ) ) {
	$listfordisplay = formatlistnames( $list );
} else {
	$listfordisplay = "";
}

$ext_list       = ".txt";
$ext_list_in    = ".in";
$ext_list_out   = ".out";
$ext_list_lock  = ".lock";
$ext_click      = ".txt";
$ext_click_lock = ".lock";
$ext_click_test = ".test";

$writebom      = false;
$utf8_bom      = "\xEF\xBB\xBF";

$mysql_link    = false;
$mysql_err     = "";
$mysql_charset = "";

// Folder path definitions moved to the settings file

$page_header       = LoadFileContentsAstext( $path_to_templates . "/pageheader.html" );
$page_footer       = LoadFileContentsAstext( $path_to_templates . "/pagefooter.html" );
$msg_subscribe     = LoadFileContentsAsText( $path_to_templates . "/" . $lang . "/msg_subscribe.txt" );
$msg_confirmation  = LoadFileContentsAsText( $path_to_templates . "/" . $lang . "/msg_confirmation.txt" );
$msg_unsubscribe   = LoadFileContentsAsText( $path_to_templates . "/" . $lang . "/msg_unsubscribe.txt" );
$cpanel_header     = LoadFileContentsAstext( $path_to_templates . "/cpanelheader.html" );
$cpanel_footer     = LoadFileContentsAstext( $path_to_templates . "/cpanelfooter.html" );

// Create all the directories

if ( $use_mysql == 0 ) {
	CreateDirectory( $path_to_lists );
	CreateDirectory( $path_to_traffic );
	CreateDirectory( $path_by_delivery );
	CreateDirectory( $path_by_recipient );
}
		
CreateDirectory( $path_to_requests );
CreateDirectory( $path_to_mailqueue );
CreateDirectory( $path_to_sqlqueue );
CreateDirectory( $path_to_templates );
CreateDirectory( $path_to_uploads );
CreateDirectory( $path_to_imports );

$mlm_err = "Unhandled Error";

//-- COMMAND PROCESSOR ---------------------------------------------------------

if ($cmd == "subscribe") {
	
	If ( count( explode( ";", $list ) ) == 1 && email_exists( $list, $email ) ) {
		If ( $pwd == $admin_password ) {
			// <ERROR>Error - The email address '$email' is already subscribed to '$list'.</ERROR>
			echo @html_entity_decode( "<ERROR>" . str_replace( "[LIST]", "'" . $list . "'", str_replace( "[EMAIL]", "'" . $email . "'", $kErr_cmdprocessor_dup[$lang] ) ) . "</ERROR>", $dec_quotes, $dec_charset );
		} else if ( !empty( $pwd ) && $pwd != $admin_password ) {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );		
		} else {
			// We're sorry, but the email address [email] is already subscribed to the list [list]. There is no need to subscribe again. If you think this is an error please contact the administrator at ...
			$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tde[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_tde[$lang], $page_header ) );
			$page .= str_replace( "[LIST]", "'" . $list . "'", str_replace( "[EMAIL]", "'" . "<a href=\"mailto:$email\">$email</a>" . "'", $kRes_cmdprocessor_mde[$lang] ) ) . " <a href=\"mailto:$admin_address\">$admin_address</a>.";
			$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
			echo $page;
		}
	} else {
		$reqref = GetUniqueReference();
		If ( $pwd == $admin_password  || !$mlm_optin ) {
			if ( SaveRequest( $reqref ) ) {
				If ( AddEmailToList( $reqref ) ) {
					If ( $pwd == $admin_password ) {
						// Email address [email] has been added to the list(s) [lists] successfully.
						echo str_replace( "[LISTS]", $listfordisplay, str_replace( "[EMAIL]", "'" . $email . "'", $kRes_cmdprocessor_mea[$lang] ) );	
					} else {
						// You have asked to be subscribed to the list(s) [lists] with the email address [email].
						// You have been added to our mailing list [lists] successfully.
						SendSubscriptionMessage();
						$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tsc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_tss[$lang], $page_header ) );
						$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", str_replace( "[EMAIL]", "<a href=\"mailto:$email\">$email</a>", $kRes_cmdprocessor_mas[$lang] ) ) . "<br><br>";
						$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_msa[$lang] );
						$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
						echo $page;	
					}
				} else {
					if ( $pwd == $admin_password ) {
						if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
						// <ERROR>Error - Server problem when trying to subscribe [email] to the list(s) [lists].</ERROR>
						echo @html_entity_decode( "<ERROR>" . str_replace( "[LISTS]", "'" . $listfordisplay . "'", str_replace( "[EMAIL]", "'" . $email . "'", $kErr_cmdprocessor_ser[$lang] ) ) . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
					} else {
						if ( $use_mysql == 1 ) { $errorstr = "<br><br>[$mysql_err]"; } else { $errorstr = "<br><br>" . print_r( $mlm_err, true ); }
						// We're sorry, but your subscription to the list(s) [lists] has failed due to a server error. Please wait a while and try again. If the problem persists contact the administrator at...
						$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tse[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_tsf[$lang], $page_header ) );
						$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_svr[$lang] ) . " <a href=\"mailto:$admin_address\">$admin_address</a>.";
						$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
						echo $page;
					}				
				}
			} else {
				if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
				// <ERROR>Error - Server problem when trying to subscribe [email] to the list(s) [lists].</ERROR>
				echo @html_entity_decode( "<ERROR>" . str_replace( "[LISTS]", "'" . $listfordisplay . "'", str_replace( "[EMAIL]", "'" . $email . "'", $kErr_cmdprocessor_ser[$lang] ) ) . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
			}
		} else if ( !empty( $pwd ) && $pwd != $admin_password ) {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {	
			if ( SaveRequest( $reqref ) ) {
				// You have asked to be subscribed to the list(s) [lists] with the email address [email]";
				// This service requires a confirmation in order to prevent others from subscribing you to the list without your consent. You have been sent an email with a special link. When you receive the email, please click on the link, or copy and paste it into your browser to enable your subscription.
				SendRequestMessage( $reqref );
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tsr[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_trr[$lang], $page_header ) );
				$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", str_replace( "[EMAIL]", "<a href=\"mailto:$email\">$email</a>", $kRes_cmdprocessor_mas[$lang] ) ) . "<br><br>";
				$page .= $kRes_cmdprocessor_ses[$lang];
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
			} else {
				if ( $use_mysql == 1 ) { $errorstr = "<br><br>[$mysql_err]"; } else { $errorstr = "<br><br>" . print_r( $mlm_err, true ); }
				// We're sorry, but your subscription to the list(s) [lists] has failed due to a server error. Please wait a while and try again. If the problem persists contact the administrator at...
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tse[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_tsf[$lang], $page_header ) );
				$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_svr[$lang] ) . " <a href=\"mailto:$admin_address\">$admin_address</a>." . $errorstr;
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
			}
		}		
	}
		
} else if ( $cmd == "unsubscribe" || $cmd == "un" ) {

	if ( $list == "" ) {
		$temp = $pwd;
		$pwd  = "";
		if ( $local == "yes" ) { $num = AddEmailToLocalUnsubscribeList( $listid, $firstname, $lastname, $company, $email, $test ); } else { $num = RemoveEmailFromList( ShowLists(), $email ); }
		$pwd  = $temp;
		If ( $pwd == $admin_password ) {	
			if ( $num == 0 ) {
				// <ERROR>Error - The email address [email] was not found in any of the lists.</ERROR>
				echo @html_entity_decode( "<ERROR>" . str_replace( "[EMAIL]", "'" . $email . "'", $kErr_cmdprocessor_unf[$lang] ) . "</ERROR>", $dec_quotes, $dec_charset );
			} else if ( $num == -1 ) {
				if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
				// <ERROR>Error - Server problem when trying to unsubscribe [email] from all lists.</ERROR>
				echo @html_entity_decode( "<ERROR>" . str_replace( "[EMAIL]", "'" . $email . "'", $kErr_cmdprocessor_usp[$lang] ) . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
			} else {
				if ( $return == "text" ) {
					echo "ok\t$num\n";
				} else {
					// Email address [email] has been removed from all lists successfully.
					echo str_replace( "[EMAIL]", "'" . $email . "'", $kRes_cmdprocessor_uar[$lang] );
				}
				if ( $cmd == "un" ) { TrackClick(); }
			}
		} else if ( !empty( $pwd ) && $pwd != $admin_password ) {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {
			if ( $num == 0 ) {
				// We're sorry, but the email address [email] has not been found in any of the lists. Check the address and try again. If you think this is an error please contact the administrator at...
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tuc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_ten[$lang], $page_header ) );
				$page .= str_replace( "[EMAIL]", "<a href=\"mailto:$email\">$email</a>", $kRes_cmdprocessor_ues[$lang] ) . " <a href=\"mailto:$admin_address\">$admin_address</a>.";
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
			} else if ( $num == -1 ) {
				if ( $use_mysql == 1 ) { $errorstr = "<br><br>[$mysql_err]"; } else { $errorstr = "<br><br>" . print_r( $mlm_err, true ); }
				// We're sorry, but the cancellation of your subscription to all lists has failed due to a server error. Please wait a while and try again. If the problem persists contact the administrator at...
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tuc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_tuf[$lang], $page_header ) );
				$page .= $kRes_cmdprocessor_uss[$lang] . " <a href=\"mailto:$admin_address\">$admin_address</a>." . $errorstr;
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
			} else {
				// You have asked to cancel your subscription from all lists.
				// The email address [email] has been successfully deleted.
				SendUnsubscriptionMessage();
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tuc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_tus[$lang], $page_header ) );
				$page .= $kRes_cmdprocessor_uya[$lang] . "<br><br>";
				$page .= str_replace( "[EMAIL]", "<a href=\"mailto:$email\">$email</a>", $kRes_cmdprocessor_uso[$lang] );
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
				if ( $cmd == "un" ) { TrackClick(); }
			}
		}
	} else if ( count( explode( ";", $list ) ) == 1 && ( list_exists( $list ) || $local == "yes" ) ) {
		if ( $local == "yes" ) { $num = AddEmailToLocalUnsubscribeList( $listid, $firstname, $lastname, $company, $email, $test ); } else { $num = RemoveEmailFromList( $list, $email ); }
		If ( $pwd == $admin_password ) {		
			if ( $num == 0 ) {
				// <ERROR>Error - The email address [email] was not found in [list].</ERROR>
				echo @html_entity_decode( "<ERROR>" . str_replace( "[LIST]", "'" . $list . "'", str_replace( "[EMAIL]", "'" . $email . "'", $kErr_cmdprocessor_unk[$lang] ) ) . "</ERROR>", $dec_quotes, $dec_charset );
			} else if ( $num == -1 ) {
				if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
				// <ERROR>Error - Server problem when trying to unsubscribe [email] from [list].</ERROR>
				echo @html_entity_decode( "<ERROR>" . str_replace( "[LIST]", "'" . $list . "'", str_replace( "[EMAIL]", "'" . $email . "'", $kErr_cmdprocessor_usk[$lang] ) ) . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
			} else {
				if ( $return == "text" ) {
					echo "ok\t$num\n\n";
					echo $list . "\t" . GetListSizeDB( $list ) . "\n";
				} else {
					// Email address [email] has been removed from [list] successfully.
					echo str_replace( "[LIST]", "'" . $list . "'", str_replace( "[EMAIL]", "'" . $email . "'", $kRes_cmdprocessor_uer[$lang] ) );
				}
				if ( $cmd == "un" ) { TrackClick(); }
			}
		} else if ( !empty( $pwd ) && $pwd != $admin_password ) {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {
			if ( $num == 0 ) {
				// We're sorry, but the email address [email] has not been found in the list [list]. Check the address and try again. If you think this is an error please contact the administrator at...
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tuc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_ten[$lang], $page_header ) );
				$page .= str_replace( "[LIST]", "'" . $list . "'", str_replace( "[EMAIL]", "'" . "<a href=\"mailto:$email\">$email</a>" . "'", $kRes_cmdprocessor_uen[$lang] ) ) . " <a href=\"mailto:$admin_address\">$admin_address</a>.";
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
			} else if ( $num == -1 ) {
				if ( $use_mysql == 1 ) { $errorstr = "<br><br>[$mysql_err]"; } else { $errorstr = "<br><br>" . print_r( $mlm_err, true ); }
				// We're sorry, but the cancellation of your subscription to list [list] has failed due to a server error. Please wait a while and try again. If the problem persists contact the administrator at...
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tuc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_tuf[$lang], $page_header ) );
				$page .= str_replace( "[LIST]", "'" . $list . "'", $kRes_cmdprocessor_uec[$lang] ) . " <a href=\"mailto:$admin_address\">$admin_address</a>." . $errorstr;
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
			} else {
				// You have asked to cancel your subscription to the list [list].
				// The email address [email] has been successfully deleted.
				SendUnsubscriptionMessage();
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tuc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_tus[$lang], $page_header ) );
				$page .= str_replace( "[LIST]", "'" . $list . "'", $kRes_cmdprocessor_ucr[$lang] ) . "<br><br>";
				$page .= str_replace( "[EMAIL]", "'" . "<a href=\"mailto:$email\">$email</a>" . "'", $kRes_cmdprocessor_usr[$lang] );
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
				if ( $cmd == "un" ) { TrackClick(); }
			}
		}
	} else if ( count( explode( ";", $list ) ) > 1 ) {
		if ( $local == "yes" ) { $num = AddEmailToLocalUnsubscribeList( $listid, $firstname, $lastname, $company, $email, $test ); } else { $num = RemoveEmailFromList( $list, $email ); }	
		If ( $pwd == $admin_password ) {		
			if ( $num == 0 ) {
				// <ERROR>Error - The email address [email] was not found in the list(s) [lists].</ERROR>
				echo @html_entity_decode( "<ERROR>" . str_replace( "[LISTS]", "'" . $listfordisplay . "'", str_replace( "[EMAIL]", "'" . $email . "'", $kErr_cmdprocessor_uus[$lang] ) ) . "</ERROR>", $dec_quotes, $dec_charset );
			} else if ( $num == -1 ) {
				if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
				// <ERROR>Error - Server problem when trying to unsubscribe [email] from the list(s) [lists].</ERROR>
				echo @html_entity_decode( "<ERROR>" . str_replace( "[LISTS]", "'" . $listfordisplay . "'", str_replace( "[EMAIL]", "'" . $email . "'", $kErr_cmdprocessor_ust[$lang] ) ) . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
			} else {
				if ( $return == "text" ) {
					echo "ok\t$num\n\n";
					$singlelist = explode( ";", $list );	
					foreach ( $singlelist as $mylist ) {
						echo $mylist . "\t" . GetListSizeDB( $mylist ) . "\n";
					}
				} else {
					// Email address [email] has been removed from the list(s) [lists] successfully.
					echo str_replace( "[LISTS]", "'" . $listfordisplay . "'", str_replace( "[EMAIL]", "'" . $email . "'", $kRes_cmdprocessor_urs[$lang] ) );
				}
				if ( $cmd == "un" ) { TrackClick(); }
			}
		} else if ( !empty( $pwd ) && $pwd != $admin_password ) {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {
			if ( $num == 0 ) {
				// We're sorry, but the email address [email] has not been found in the list(s) [lists]. Check the address and try again. If you think this is an error please contact the administrator at...
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tuc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_ten[$lang], $page_header ) );
				$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", str_replace( "[EMAIL]", "'" . "<a href=\"mailto:$email\">$email</a>" . "'", $kRes_cmdprocessor_unf[$lang] ) ) . " <a href=\"mailto:$admin_address\">$admin_address</a>.";
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
			} else if ( $num == -1 ) {
				if ( $use_mysql == 1 ) { $errorstr = "<br><br>[$mysql_err]"; } else { $errorstr = "<br><br>" . print_r( $mlm_err, true ); }
				// We're sorry, but the cancellation of your subscription to the list(s) [lists] has failed due to a server error. Please wait a while and try again. If the problem persists contact the administrator at...
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tuc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_tuf[$lang], $page_header ) );
				$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_ucf[$lang] ) . " <a href=\"mailto:$admin_address\">$admin_address</a>." . $errorstr;
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
			} else {
				// You have asked to cancel your subscription to the list(s) [lists]
				// The email address [email] has been successfully deleted.
				SendUnsubscriptionMessage();
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tuc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_tus[$lang], $page_header ) );
				$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_uac[$lang] ) . "<br><br>";
				$page .= str_replace( "[EMAIL]", "'" . "<a href=\"mailto:$email\">$email</a>" . "'", $kRes_cmdprocessor_usr[$lang] );
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
				if ( $cmd == "un" ) { TrackClick(); }
			}
		}
	} else {
		If ( $pwd == $admin_password ) {
			// <ERROR>Error - The list '$list' was not found on this server.</ERROR>
			echo @html_entity_decode( "<ERROR>". str_replace( "[LIST]", "'" . $list . "'", $kErr_cmdprocessor_ulf[$lang] ) . "</ERROR>", $dec_quotes, $dec_charset );
		} else if ( !empty( $pwd ) && $pwd != $admin_password ) {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {
			// We're sorry, but the list [list] can not be found on this server. Check the list name and try again. If the problem persists contact the administrator at...
			$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tuc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_tln[$lang], $page_header ) );
			$page .= str_replace( "[LIST]", "'" . $list . "'", $kRes_cmdprocessor_uns[$lang] ) . " <a href=\"mailto:$admin_address\">$admin_address</a>.";
			$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
			echo $page;
		}
	}

} else if ($cmd == "update") {

	If ( list_exists( $list ) ) {
		If ( $pwd == $admin_password ) {
			$result = UpdateEmailFromList( $list, $email, $newemail );
			if ( $result == -1 ) {
				if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
				// <ERROR>Error - Server problem when reading list.</ERROR>
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_gsp[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
			} else {
				echo "OK!\n\n";
				$singlelist = explode( ";", $list );	
				foreach ( $singlelist as $mylist ) {
					echo $mylist . "\t" . GetListSizeDB( $mylist ) . "\n";
				}	
			}
		} else {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		}
	} else {
		if ( strpos( $list, ";" ) !==false ) {
			// <ERROR>Error - At least one of the lists doesn't exist.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_glu[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {
			// <ERROR>Error - The list '$list' was not found on this server.</ERROR>
			echo @html_entity_decode( "<ERROR>". str_replace( "[LIST]", "'" . $list . "'", $kErr_cmdprocessor_ulf[$lang] ) . "</ERROR>", $dec_quotes, $dec_charset );
		}
	}

} else if ($cmd == "confirm") {
	
	If ( isset( $key ) ) {
		If ( RequestIsValid( $key ) ) {
			if ( AddEmailToList( $key ) ) {
				// You have asked to be subscribed to the list(s) [lists] with the email address [email].
				// You have been added to our mailing list [lists] successfully.
				SendSubscriptionMessage();
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - ". $kRes_cmdprocessor_tsc[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_tss[$lang], $page_header ) );
				$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", str_replace( "[EMAIL]", "<a href=\"mailto:$email\">$email</a>", $kRes_cmdprocessor_mas[$lang] ) ) . "<br><br>";
				$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_msa[$lang] );
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
			} else {
				if ( $use_mysql == 1 ) { $errorstr = "<br><br>[$mysql_err]"; } else { $errorstr = "<br><br>" . print_r( $mlm_err, true ); }
				// We're sorry, but your subscription to the list(s) [lists] has failed due to a server error. Please wait a while and try again. If the problem persists contact the administrator at...
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tse[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_tsf[$lang], $page_header ) );
				$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_svr[$lang] ) . " <a href=\"mailto:$admin_address\">$admin_address</a>." . $errorstr;
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				echo $page;
			}
		} else {
			// [key] is not a valid key. Either it has been used already or it has expired. Keys have a lifetime of [lifespan]. If you have waited more than [lifespan] day(s) to confirm your subscription you will have to start the subscription process again. If you think this is an error please contact the administrator at...
			$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tse[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_tke[$lang], $page_header ) );
			$page .= str_replace( "[KEY]", $key, str_replace( "[LIFESPAN]", $request_life_span, $kRes_cmdprocessor_cke[$lang] ) ) . " <a href=\"mailto:$admin_address\">$admin_address</a>.";
			$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
			echo $page;
		}
	} else {
		// We're sorry, but your subscription to the list(s) [lists] has failed because the Key argument is missing. Please start the subscription process again. If you need help please contact the administrator at...
		$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tse[$lang], str_replace( "[HEADER_TITLE]", $kRes_cmdprocessor_err[$lang] . ": " . $kRes_cmdprocessor_tkm[$lang], $page_header ) );
		$page .= str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_ckm[$lang] ) . " <a href=\"mailto:$admin_address\">$admin_address</a>.";
		$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
		echo $page;
	}
 
} else if ($cmd == "getlist") {
	
	If ( list_exists( $list ) ) {
		If ( $pwd == $admin_password ) {
			$result = GetList( $list, 0, 0 );
			if ( $result == -1 ) {
				if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
				// <ERROR>Error - Server problem when reading list.</ERROR>
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_gsp[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
			} else {
				@header('Content-type: text/plain; charset="utf-8"');
				@header('Content-Length: ' . strlen( $result ) );
				if ( $output_type == "file" ) {
					if ( count( explode( ";", $list ) ) > 1 ) {
						@header('Content-Disposition: attachment; filename="Lists.txt"');
					} else {
						@header('Content-Disposition: attachment; filename="' . $list . '"');
					}
				}
				echo $result;
			}
		} else {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		}
	} else {
		if ( strpos( $list, ";" ) !==false ) {
			// <ERROR>Error - At least one of the lists doesn't exist.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_glu[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {
			// <ERROR>Error - The list '$list' was not found on this server.</ERROR>
			echo @html_entity_decode( "<ERROR>". str_replace( "[LIST]", "'" . $list . "'", $kErr_cmdprocessor_ulf[$lang] ) . "</ERROR>", $dec_quotes, $dec_charset );
		}
	}

} else if ($cmd == "removelist") {
	
	If ( list_exists( $list ) ) {
		If ( $pwd == $admin_password ) {
			$result = RemoveList( $list );
			if ( !$result ) {
				if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
				// <ERROR>Error - Impossible to remove the list(s).</ERROR>
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_rlu[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
			} else {
				if ( $return == "text" ) {
					echo "ok\t$result";
				} else {
					// [num] list(s) removed sucessfully."
					echo str_replace( "[NUM]", $result, $kRes_cmdprocessor_rls[$lang] );
				}
			}
		} else {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		}
	} else {
		if ( strpos( $list, ";" ) !==false ) {
			// <ERROR>Error - At least one of the lists doesn't exist.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_glu[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {
			// <ERROR>Error - The list '$list' was not found on this server.</ERROR>
			echo @html_entity_decode( "<ERROR>". str_replace( "[LIST]", "'" . $list . "'", $kErr_cmdprocessor_ulf[$lang] ) . "</ERROR>", $dec_quotes, $dec_charset );
		}
	}
	
} else if ($cmd == "createlist") {
	
	If ( !list_exists( $list ) ) {
		If ( $pwd == $admin_password ) {
			$result = CreateList( $list );		
			if ( $use_mysql == 1 ) {
				$result = $result && CreateClickTable();
				if ( $result ) {
					// Database and table created successfully.
					echo $kRes_cmdprocessor_dts[$lang];	
				} else {
					// <ERROR>Error - Impossible to create the database or the table.<br>[$mysql_err]</ERROR>
					echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_icd[$lang] . "<br>[$mysql_err]</ERROR>", $dec_quotes, $dec_charset );
				}
			} else {
				if ( !$result ) {
				    $errorstr = "<br>" . print_r( $mlm_err, true );
					// <ERROR>Error - Impossible to create the list.</ERROR>
					echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_icl[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
				} else {
					// List created successfully.
					echo $kRes_cmdprocessor_lcs[$lang];
				}
			}	
		} else {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		}
	} else {
		if ( strpos( $list, ";" ) !== false ) {
			// <ERROR>Error - At least one of the list already exists.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_lae[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {
			// <ERROR>Error - The list [list] already exists on this server.</ERROR>
			echo @html_entity_decode( "<ERROR>" . str_replace( "[LIST]", "'". $list . "'", $kErr_cmdprocessor_aes[$lang] ) . "</ERROR>", $dec_quotes, $dec_charset );
		}
	}
 
} else if ($cmd == "renamelist") { 
 
	if ( list_exists( $name ) ) {
		// <ERROR>Error - The list [list] already exists on this server.</ERROR>
		echo @html_entity_decode( "<ERROR>" . str_replace( "[LIST]", "'". $name . "'", $kErr_cmdprocessor_aes[$lang] ) . "</ERROR>", $dec_quotes, $dec_charset );
	} else if ( list_exists( $list ) ) {
		If ( $pwd == $admin_password ) {
			$result = RenameList( $list, $name );
			if ( !$result ) {
			    if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
				// <ERROR>Error - Impossible to rename the list [LIST].</ERROR>
				echo @html_entity_decode( "<ERROR>". str_replace( "[LIST]", "'" . $list . "'", $kErr_cmdprocessor_ren[$lang] ) . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
			} else {
				if ( $return == "text" ) {
					echo "ok\t$result";
				} else {
					// The list has been renamed sucessfully."
					echo $kRes_cmdprocessor_res[$lang];
				}
			}
		} else {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		}
	} else {
		if ( strpos( $list, ";" ) !== false ) {
			// <ERROR>Error - At least one of the lists doesn't exist.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_glu[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {
			// <ERROR>Error - The list '$list' was not found on this server.</ERROR>
			echo @html_entity_decode( "<ERROR>". str_replace( "[LIST]", "'" . $list . "'", $kErr_cmdprocessor_ulf[$lang] ) . "</ERROR>", $dec_quotes, $dec_charset );
		}
	}
 
} else if ($cmd == "lists") {
	
	$result = ShowLists();
	if ( $result == -1 ) {
		if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
		// Error - Server problem when reading list directory.
		echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_prd[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset);
	} else {
		If ( $pwd != "" ) {
			if ( $pwd == $admin_password ) {
				echo "<LISTS>" . $result . "</LISTS>";
			} else {
				// <ERROR>Error - Your password is wrong.</ERROR>
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
			}
		} else {
			echo $result;
		}
	}
	
} else if ($cmd == "init") {
	
	If (  $use_mysql == 1 ) {
		If ( $pwd == $admin_password ) {
			$result = CreateList( $list ) && CreateClickTable() && CreateSubscribtionRequestTable();
			if ( $result ) {
				// Database and table created successfully.
				echo $kRes_cmdprocessor_dts[$lang];
			} else {
				// <ERROR>Error - Impossible to create the database or the table.<br>[$mysql_err]</ERROR>
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_icd[$lang] . "<br>[$mysql_err]</ERROR>", $dec_quotes, $dec_charset );
			}
	
		} else {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		}
	} else {
		// <ERROR>Error - mySQL is not activated.</ERROR>
		echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_mna[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
	}
	
} else if ($cmd == "uninstall") {
	
	If ( $pwd == $admin_password ) {
		$result = RemoveAll();		
		if ( $result ) {
			// MLM has been uninstalled. All files have been removed but the script itself and the settings file.
			echo $kRes_cmdprocessor_mlr[$lang];
		} else {
			If (  $use_mysql == 1 ) {
				// <ERROR>Error - Impossible to uninstall MLM.<br>[$mysql_err]</ERROR>
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_ium[$lang] . "<br>[$mysql_err]</ERROR>", $dec_quotes, $dec_charset );
			} else {
				$errorstr = "<br>" . print_r( $mlm_err, true );
				// <ERROR>Error - Impossible to uninstall MLM.</ERROR>
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_ium[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
			}
		}

	} else {
		// <ERROR>Error - Your password is wrong.</ERROR>
		echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
	}
		
} else if ($cmd == "upload") {	

	If ( $pwd == $admin_password ) {
		if ( $upload_Size == 0) {
			// <ERROR>Error - The list is empty.</ERROR>
			if ( $src == "cpanel" ) {
					$result = -1;
					$errorstr = $kErr_cmdprocessor_ley[$lang];
					cpanel_upload();
			} else {
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_ley[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
			}
		} else if ( $upload_Size >200000000 ) {
			@unlink( $upload_Temp );
			// <ERROR>Error - The list is too big (>200000000).</ERROR>
			if ( $src == "cpanel" ) {
					$result = -1;
					$errorstr = $kErr_cmdprocessor_ltb[$lang];
					cpanel_upload();
			} else {
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_ltb[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
			}
		} else {
			// The file [file] has been uploaded to the list(s) [lists] successfully.
			// [num] email address(es) were added to [lists]. We found [dup] duplicate(s) and [bad] bad address(es).
			$result = UploadList();
			list( $added, $dup, $bad, $thebadones ) = explode( "\t", $result );
			if ( $return == "text" ) {
				if ( $src == "cpanel" ) {
					$result = 1;
					cpanel_upload();
				} else {
					echo "ok\t$added\t$dup\t$bad\n\n" . str_replace( "<BR>", ",", $thebadones );
				}				
			} else {
				if ( $action == "delete" ) {
					$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tlu[$lang], str_replace( "[HEADER_TITLE]", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_tls[$lang] ), $page_header ) );
					$page .= str_replace( "[FILE]", "'" . $_FILES['upload']['name'] . "'", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_uls[$lang] ) ) . "<br><br>";
					$page .= str_replace( "[NUM]", $added, str_replace( "[LISTS]", $listfordisplay, str_replace( "[DUP]", $dup, str_replace( "[BAD]", $bad, $kRes_cmdprocessor_ude[$lang] ) ) ) );
					if( $bad > 0 ) {
						$page .= ":<br><br><font size=\"-1\" color=\"#f16666\" face=\"Verdana, Arial, Helvetica, sans-serif\">$thebadones</font>";
					} else {
						$page .= ".";
					}	
					$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				} else if ( $action == "invite" ) {
					$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tlu[$lang], str_replace( "[HEADER_TITLE]", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_tls[$lang] ), $page_header ) );
					$page .= str_replace( "[FILE]", "'" . $_FILES['upload']['name'] . "'", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_uls[$lang] ) ) . "<br><br>";
					$page .= str_replace( "[NUM]", $added, str_replace( "[LISTS]", $listfordisplay, str_replace( "[DUP]", $dup, str_replace( "[BAD]", $bad, $kRes_cmdprocessor_uco[$lang] ) ) ) );
					if( $bad > 0 ) {
						$page .= ":<br><br><font size=\"-1\" color=\"#f16666\" face=\"Verdana, Arial, Helvetica, sans-serif\">$thebadones</font>";
					} else {
						$page .= ".";
					}	
					$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				} else {
					$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tlu[$lang], str_replace( "[HEADER_TITLE]", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_tls[$lang] ), $page_header ) );
					$page .= str_replace( "[FILE]", "'" . $_FILES['upload']['name'] . "'", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_uls[$lang] ) ) . "<br><br>";
					$page .= str_replace( "[NUM]", $added, str_replace( "[LISTS]", $listfordisplay, str_replace( "[DUP]", $dup, str_replace( "[BAD]", $bad, $kRes_cmdprocessor_ulr[$lang] ) ) ) );
					if( $bad > 0 ) {
						$page .= ":<br><br><font size=\"-1\" color=\"#f16666\" face=\"Verdana, Arial, Helvetica, sans-serif\">$thebadones</font>";
					} else {
						$page .= ".";
					}	
					$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
				}
				echo $page;
			}
		}
	} else {
		// <ERROR>Error - Your password is wrong.</ERROR>
		if ( $src == "cpanel" ) {
			$result = -1;
			$errorstr = $kErr_cmdprocessor_pwd[$lang];
			cpanel_upload();
		} else {
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		}
	}
	
} else if ($cmd == "import") {	

	If ( $pwd == $admin_password ) {
		// The file(s) available in the import directory have been imported to the list(s) [lists] successfully.
		// [num] email address(es) were added to [lists]. We found [dup] duplicate(s) and [bad] bad address(es).
		
		$result = ImportLists( $path );
		list( $added, $dup, $bad, $thebadones ) = explode( "\t", $result );	
		if ( $return == "text" ) {
			if ( $src == "cpanel" ) {
				$result = 1;
				cpanel_upload();
			} else {
				echo "ok\t$added\t$dup\t$bad\n\n" . str_replace( "<BR>", ",", $thebadones );
			}				
		} else {
			if ( $action == "delete" ) {
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tlu[$lang], str_replace( "[HEADER_TITLE]", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_tls[$lang] ), $page_header ) );
				$page .= str_replace( "[FILE]", "'" . $_FILES['upload']['name'] . "'", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_uls[$lang] ) ) . "<br><br>";
				$page .= str_replace( "[NUM]", $added, str_replace( "[LISTS]", $listfordisplay, str_replace( "[DUP]", $dup, str_replace( "[BAD]", $bad, $kRes_cmdprocessor_ude[$lang] ) ) ) );
				if( $bad > 0 ) {
					$page .= ":<br><br><font size=\"-1\" color=\"#f16666\" face=\"Verdana, Arial, Helvetica, sans-serif\">$thebadones</font>";
				} else {
					$page .= ".";
				}	
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
			} else if ( $action == "invite" ) {
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tlu[$lang], str_replace( "[HEADER_TITLE]", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_tls[$lang] ), $page_header ) );
				$page .= str_replace( "[FILE]", "'" . $_FILES['upload']['name'] . "'", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_uls[$lang] ) ) . "<br><br>";
				$page .= str_replace( "[NUM]", $added, str_replace( "[LISTS]", $listfordisplay, str_replace( "[DUP]", $dup, str_replace( "[BAD]", $bad, $kRes_cmdprocessor_uco[$lang] ) ) ) );
				if( $bad > 0 ) {
					$page .= ":<br><br><font size=\"-1\" color=\"#f16666\" face=\"Verdana, Arial, Helvetica, sans-serif\">$thebadones</font>";
				} else {
					$page .= ".";
				}	
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
			} else {
				$page  = str_replace( "[PAGE_TITLE]", "$admin_name_short $script_name - " . $kRes_cmdprocessor_tlu[$lang], str_replace( "[HEADER_TITLE]", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_tls[$lang] ), $page_header ) );
				$page .= str_replace( "[FILE]", "'" . $_FILES['upload']['name'] . "'", str_replace( "[LISTS]", "'" . $listfordisplay . "'", $kRes_cmdprocessor_uls[$lang] ) ) . "<br><br>";
				$page .= str_replace( "[NUM]", $added, str_replace( "[LISTS]", $listfordisplay, str_replace( "[DUP]", $dup, str_replace( "[BAD]", $bad, $kRes_cmdprocessor_ulr[$lang] ) ) ) );
				if( $bad > 0 ) {
					$page .= ":<br><br><font size=\"-1\" color=\"#f16666\" face=\"Verdana, Arial, Helvetica, sans-serif\">$thebadones</font>";
				} else {
					$page .= ".";
				}	
				$page .= str_replace( "[FOOTER_TITLE]", "$script_name $script_version - <a href=\"$admin_webAddress\">$admin_name_full</a> - $copyright", $page_footer );
			}
			echo $page;
		}
	} else {
		// <ERROR>Error - Your password is wrong.</ERROR>
		if ( $src == "cpanel" ) {
			$result = -1;
			$errorstr = $kErr_cmdprocessor_pwd[$lang];
			cpanel_upload();
		} else {
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		}
	}
	
} else if ($cmd == "getinfo") {
	
	$result = GetInfo();
	if ( $result == -1 ) {
	    if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
		// <ERROR>Error - Server problem when getting info.</ERROR>
		echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_gie[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
	} else {
		echo $result;
	}
	
} else if ($cmd == "getversion") {
	
	$result = GetVer();
	echo $result;

} else if ( $cmd == "track" || $cmd == "tk" ) {
	
	if ( trim( $allowedhosts ) == "" || strtolower( $allowedhosts ) == "all" || $allowedhosts == "*" || ishostallowed( getHost( $url ) ) ) {
		if ( $action == "click" ) {
			TrackClick();
			if ( $fwd == "yes" && $url <> "" ) { header( "Location: $url" ); }
		} else if ( $action == "open" ) {
			TrackClick();
		} else if ( $action == "bounce" ) {
			TrackClick();
		} else {
			// Handle other commands here
		}
	} else {
		// Error, the $url host is not allowed
	}
	
} else if ($cmd == "getclicks") {

	If ( $pwd == $admin_password ) {
		$result = GetClicks( $delivery );
		
		$stats_Start = "<STATS>\n";
		$stats_Stop  = "</STATS>";
		
		//$sample = $result;
		//for( $i = $start; $i < 500; $i++ ) { $result .= $sample; }
		
		if ( $return == "xml" ) {
			$resultsize = strlen( $stats_Start . $result . $stats_Stop );
		} else {
			$resultsize = strlen( $result );
		}
		
		if ( $result == -1 ) {
		    if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
			// <ERROR>Error - Server problem while reading the Click-Through data.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_cte[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
		} else {
			@header('Content-type: text/plain; charset="utf-8"');
			@header('Content-Length: ' . $resultsize );
			if ( $output_type == "file" ) {
				if ( count( explode( ";", $delivery ) ) > 1 ) {
					@header('Content-Disposition: attachment; filename="Clicks.txt"');
				} else {
					@header('Content-Disposition: attachment; filename="' . $delivery . '.txt"');
				}
			}
			if ( $return == "xml" ) { echo $stats_Start; }
			if ( $start <= 0 ) {
				echo $result;
			} else {
				$result_array = explode( "\n", $result );
				for( $i = $start; $i < count( $result_array ); $i++ ) {
					if ( trim( $result_array[$i] ) <> "" ) {
						echo $result_array[$i];
						if ( $i < count( $result_array ) - 1 ) { echo "\n"; }
					}
				}
			}
			if ( $return == "xml" ) { echo $stats_Stop; }
		}
	} else {
		// <ERROR>Error - Your password is wrong.</ERROR>
		echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
	}

} else if ($cmd == "deliveries") {

		$result = ShowDeliveries();
		if ( $result == -1 ) {
		    if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
			// Error - Server problem while reading the Click-Through tracking directory.
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_rct[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
		} else {
			if ( $pwd == $admin_password ) {
				echo "<DELIVERIES>" . $result . "</DELIVERIES>";
			} else {
				// <ERROR>Error - Your password is wrong.</ERROR>
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
			}
		}
		
} else if ($cmd == "removedelivery") {

	If ( delivery_exists( $delivery ) ) {
		If ( $pwd == $admin_password ) {
			$result = RemoveDelivery( $delivery );
			if ( $result == -1 ) {
				if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
				// <ERROR>Error - Impossible to remove the delivery(es).</ERROR>
				echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_rdu[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
			} else {
				if ( $return == "text" ) {
					echo "ok\t$result";
				} else {
					// [num] delivery(es) removed sucessfully."
					echo str_replace( "[NUM]", $result, $kRes_cmdprocessor_rds[$lang] );
				}
			}
		} else {
			// <ERROR>Error - Your password is wrong.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		}
	} else {
		if ( strpos( $delivery, ";" ) !== false ) {
			// <ERROR>Error - At least one of the deliveries doesn't exist.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_gdu[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
		} else {
			// <ERROR>Error - The delivery '$delivery' was not found on this server.</ERROR>
			echo @html_entity_decode( "<ERROR>". str_replace( "[DELIVERY]", "'" . $delivery . "'", $kErr_cmdprocessor_udf[$lang] ) . "</ERROR>", $dec_quotes, $dec_charset );
		}
	}
	
} else if ($cmd == "getofflist" || $cmd == "getlocactlist") {
	
	// Right now we treat 'getofflist' and 'getlocactlist' the same way
	// but 'getlocactlist' is suposed to return both subscribe and unsubscribe actions
	// 'getlocactlist' => 'Get Local Actions List'
	
	If ( $pwd == $admin_password ) {
		$result = GetLocalUnsubscribeList( $listid );
		
		$list_Start = "<LOCALUNSUB>\n";
		$list_Stop  = "</LOCALUNSUB>";
		
		if ( $return == "xml" ) {
			$resultsize = strlen( $list_Start . $result . $list_Stop );
		} else {
			$resultsize = strlen( $result );
		}
		
		if ( $result == -1 ) {
		    if ( $use_mysql == 1 ) { $errorstr = "<br>[$mysql_err]"; } else { $errorstr = "<br>" . print_r( $mlm_err, true ); }
			// <ERROR>Error - Server problem when reading list.</ERROR>
			echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_gsp[$lang] . "$errorstr</ERROR>", $dec_quotes, $dec_charset );
		} else {
			@header('Content-type: text/plain; charset="utf-8"');
			@header('Content-Length: ' . $resultsize );
			if ( $output_type == "file" ) {
				@header('Content-Disposition: attachment; filename="localunsub.txt"');
			}
			if ( $return == "xml" ) { echo $list_Start; }
			echo $result;
			if ( $return == "xml" ) { echo $list_Stop; }
		}
	} else {
		// <ERROR>Error - Your password is wrong.</ERROR>
		echo @html_entity_decode( "<ERROR>" . $kErr_cmdprocessor_pwd[$lang] . "</ERROR>", $dec_quotes, $dec_charset );
	}
	
} else if ( $cmd == "admin" ) {

	list( $uos, $bos, $uip, $uht ) = GetUserSystemInfo();
	If ( $bos == "iPhone" ) { $width = "320"; } else { $width = "760"; }
	define( "CPANEL_WIDTH", $width );
	define( "CPANEL_BROWSER", $bos );

	$logged = False;
	if ( isset( $_COOKIE['mlm_login'] ) ) {
		if ( md5( $admin_id . $admin_password ) == $_COOKIE['mlm_login'] ) {
			$logged = True;
			$uid = $admin_id;
			$pwd = $admin_password;	
		}
	}
	
	if ( $action == "login" || !$logged ) {
		if ( $uid <> "" && $pwd <> "" ) {
			if ( $uid == $admin_id && $pwd == $admin_password ) { // Login Successfull
				$logged = True;
				setcookie( "mlm_login", md5( $uid . $pwd ) );
				cpanel_Main();
			} else {
				$logged = False;
				setcookie( "mlm_login", "", time() - 3600 );
				unset( $_COOKIE['mlm_login'] );
				cpanel_Login( True );
			}
		} else {
			$logged = False;
			cpanel_Login( False);
		}
		
	} else if ( $action == "logout" ) {
		$logged = False;
		setcookie( "mlm_login", "", time() - 3600 );
		unset( $_COOKIE['mlm_login'] );
		cpanel_Login( False );
	
	} else if ( $action == "showlists" ) {
		cpanel_showlists();
		
	} else if ( $action == "showdeliveries" ) {
		cpanel_showdeliveries();
		
	} else if ( $action == "showdelivery" ) {
		cpanel_showdelivery( $delivery );
		
	} else if ( $action == "removedelivery" ) {
		cpanel_deletedelivery( $delivery, $confirmed );
		
	} else if ( $action == "showlist" ) {
		cpanel_showlist();
		
	} else if ( $action == "removelist" ) {
		cpanel_deletelist( $list, $confirmed );
		
	} else if ( $action == "renamelist" || $action == "newlist"  ) {
		cpanel_editlist();
		
	} else if ( $action == "removeaddr" ) {
		cpanel_deleterecipient( $list, $email, $confirmed );
		
	} else if ( $action == "editaddr" ) {
		cpanel_editrecipient();
		
	} else if ( $action == "findaddr" ) {
		cpanel_findrecipient();
		
	} else if ( $action == "sendemail" ) {
		cpanel_sendemail_single();
		
	} else if ( $action == "upload" ) {
		cpanel_upload();
	}
    	
}

//-- POST-PROCESS --------------------------------------------------------------

if ( $cmd != "uninstall" ) {
	EmptyMailQueue();
	if ( $use_mysql == 1 ) {
		EmptyMySQLQueue();
		RemoveExpiredRequestsFromDB();
	} else {
		DeleteFilesOlderThan( $path_to_requests, $request_life_span );
	}
}

//Uncomment to delete a specific directory - Use with care, can't be undone!
//DeleteAllFilesFromDir( $path_to_lists );
//DeleteAllFilesFromDir( $path_to_offlists );
//DeleteAllFilesFromDir( $path_to_traffic );
//DeleteAllFilesFromDir( $path_by_delivery );
//DeleteAllFilesFromDir( $path_by_recipient );
//DeleteAllFilesFromDir( $path_to_uploads );
//DeleteAllFilesFromDir( $path_to_imports );
//DeleteAllFilesFromDir( $path_to_requests );
//DeleteAllFilesFromDir( $path_to_sqlqueue );
//DeleteAllFilesFromDir( $path_to_mailqueue );
//DeleteAllFilesFromDir( $path_to_templates );

?>