<?php

/**
 * Overridden copy of uc_payment_get_totals() that removes the first line
 * if the separate order preview pane is in use.
 */
function uc_checkout_tweaks_uc_payment_get_totals() {
  $output = '';
  if (is_array($_POST)) {
    $order = unserialize($_POST['order']);
  }

  if ($order) {
    usort($order->line_items, 'uc_weight_sort');
	

	
    if (!variable_get('uc_pane_checkout_preview_enabled', TRUE)) {
      $output = t('Order total preview:')
              .' <span id="order-total-throbber"></span>';
    }
    $output .= '<table>';
    $grand_total = 0;

    $context = array(
      'type' => 'line_item',
      'subject' => array(
        'order' => $order,
      ),
    );

    foreach ($order->line_items as $line) {

	
		if (!empty($line['title'])){

        $context['revision'] = 'themed';
        $context['subject']['line_item'] = $line;

		if ($line['type'] != 'subtotal' && $line['type'] != 'uc_discounts') {
			
	//vyhodeny subtotal z ajaxovej tabulky v checkoute a zlavnena suma (ta je doplnena do tabulky)		
        $output .= '<tr><td align="left">'. $line['title'] .':</td>'
                  .'<td align="right">'. uc_price($line['amount'], $context) .'</td></tr>';
		}
		
		/*if ($line['type'] == 'uc_discounts') {
			
			$output .= '<tr><td align="right"><a class="slide-toggle">detail</a><div class="_hidden">eeeeeeeeeeeeeee</div><b>'. $line['title'] .':</b></td>'
                  .'<td align="right">'. uc_price($line['amount'], $context) .'</td></tr>';
		}*/
		
		
        if ($line['summed']) {
          $context['revision'] = 'altered';
        }
		
      }
    }

    $context['revision'] = 'themed';
    $context['type'] = 'amount';
    unset($context['subject']);
    $output .= '<tr><td align="left"><b>'. t('Order total:') .'</b></td>'
              .'<td align="right"><b>'. uc_price(uc_order_get_total($order), $context)
              .'</b></td></tr></table>';
  }

  print $output;
  exit();
}
