<?php

class FulfillmentApiException extends RuntimeException {
  function __construct($message, Exception $e = NULL) {
    parent::__construct($message);
    if ($e) {
		
      $this->_header = $e->_header;
      $this->_status = $e->_status;
	  $this->_err = $e->_err;
    }
  }
}

/**
 * @author Pexxi Solutions [pexxi.eu]
 */
class FulfillmentClient {
  
  private $app_id = NULL;
  private $secret = NULL;
  private $token = NULL;
  private $endPoint = NULL;
  
  function __construct($app_id, $secret, $token = NULL, $endPoint = 'https://api.fhb.sk/v3') {
	 // function __construct($app_id, $secret, $token = NULL, $endPoint = 'http://api-dev.fhb.sk/v3') {
		  // function __construct($app_id, $secret, $token = NULL, $endPoint = 'http://api-dev.fhb.sk/v1') {
    $this->app_id     = $app_id;
    $this->secret = $secret;
    $this->token     = $token;
    $this->endPoint  = $endPoint;
    
    if (!$this->token) {
      $tokenResponse = $this->login();
      //$this->token   = $tokenResponse['token']; 
	  $this->token   = $tokenResponse['output']['token']; //upravene 
    }
  }
  
  
  public function login() {
    $request = $this->prepareRequest('login', array(
      'app_id' => $this->app_id,
      'secret' => $this->secret
    ));
    
    try {
      $response = $this->executeRequest($request);
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e . $e->_err);
    }
    return $response;
  }
  
  
  public function getProducts($query = NULL) {
    $query   = rawurlencode($query);
    $request = $this->prepareRequest('products');
    
    try {
      $response = $this->executeRequest($request);
      $response = $response['_embedded']['products'];
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e);
    }
    return $response;
  }
  
  public function getProduct($id) {
    if (is_array($id)) {
      $id = $id['id'];
    }
    
    $id      = sprintf('%02s', $id);
    $request = $this->prepareRequest('product/?id=' . $id);
    try {
      $response = $this->executeRequest($request);
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e);
    }
    return $response;
  }
  
  public function insertProduct($product) {
    if ($product['id']) {
      $product['id'] = sprintf('%02s', $product['id']);
      
    }
    $request = $this->prepareRequest('products', $product);
    try {
      $response = $this->executeRequest($request);
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e);
    }
    return $response;
  }
  
  public function updateProduct($product) {
    $product['id'] = sprintf('%02s', $product['id']);
    $request       = $this->prepareRequest('products?id=' . $product['id'], $product, 'PATCH');
    try {
      $response = $this->executeRequest($request);
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e);
    }
    return $response;
  }
  
  public function getProductByCode($code) {
    $products = $this->getProducts();
    foreach ($products as $product) {
      if ($product['ean'] == $code) {
        return $product;
      }
    }
    
    return FALSE;
  }
  
  
  public function getSomething($what, $query = NULL) {
    $query   = rawurlencode($query);
    $request = $this->prepareRequest($what);
    
    try {
      $header   = array();
      $response = $this->executeRequest($request, TRUE, $header);
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e);
    }
    return $response;
  }
  
  
  public function getOrders($query = NULL) {
    $query   = rawurlencode($query);
    $request = $this->prepareRequest('orders');
    
    try {
      $response = $this->executeRequest($request);
      $response = $response['_embedded']['orders'];
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e);
    }
    return $response;
  }
  
  public function getOrder($id) {
    if (is_array($id)) {
      $id = $id['id'];
    }
    
    $request = $this->prepareRequest('order/?id=' . $id);
    try {
      $response = $this->executeRequest($request);
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e);
    }
    return $response;
  }
  
  public function insertOrder($order) {
    $request = $this->prepareRequest('order', $order);
    try {
      $response = $this->executeRequest($request);
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e);
    }
    return $response;
  }
  
  public function updateOrder($order) {
    $request = $this->prepareRequest('order/?id=' . $order['id'], $order, 'PUT');
    try {
      $response = $this->executeRequest($request);
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e);
    }
    return $response;
  }
  
  public function deleteOrder($order) {
    if (is_numeric($order)) {
      $order = array(
        'id' => $order
      );
    }
    
    $request = $this->prepareRequest('order/?id=' . $order['id'], NULL, 'DELETE');

    try {
      $response = $this->executeRequest($request);
    }
    catch (Exception $e) {
      $response = $e->getMessage();
      throw new FulfillmentApiException(__METHOD__ . ' | ' . $response . ' / ' . $e->_header . '[' . $e->_status . ']', $e);
    }
    return $response;
  }
  
  public function getOrderByCode($code) {
    $orders = $this->getOrders();
    foreach ($orders as $order) {
      if ($order['variableSymbol'] == $code) {
        return $order;
      }
    }
    
    return FALSE;
  }
  
  
  /**
   * @param string $content JSON encoded request content/data
   * @return array
   */
  private function prepareHeaders($content = '', $type = 'application/json') {
    $headers = array(
      'Content-Type: ' . $type
    );
    
    if ($this->token) {
      $headers[] = 'X-Authentication-Simple: ' . base64_encode($this->token);
    }
    
    
    return $headers;
  }
  
  /**
   * @param string $url
   * @param string|'' $content
   * @param string|'POST' $type
   * @return CURL resource
   */
  private function prepareRequest($url, $content = '', $method = NULL, $type = 'application/json') {
    $ch = curl_init($this->endPoint . '/' . $url);
    
    curl_setopt($ch, CURLOPT_HTTPHEADER, $this->prepareHeaders($content, $type));
    
    if ($content || isset($method)) {
      if ($content) {
        if (is_array($content)) {
          $content = json_encode($content); // http_build_query($content);
        }
        
        if (is_object($content)) {
          $content = /*http_build_query(json_decode(*/ json_encode($content) /*, TRUE))*/ ;
        }
        
        //if ($this->token) {var_dump($content); die();}
        curl_setopt($ch, CURLOPT_POSTFIELDS, $content);
      }
      
      if (isset($method)) {
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
      } else {
        curl_setopt($ch, CURLOPT_POST, 1);
      }
    } else {
      curl_setopt($ch, CURLOPT_POST, 0);
    }
    
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
    
    curl_setopt($ch, CURLOPT_VERBOSE, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, TRUE);
    
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, variable_get('uc_fulfillment_connect_timeout', 10));
    curl_setopt($ch, CURLOPT_TIMEOUT, variable_get('uc_fulfillment_connect_timeout', 10));
    
    return $ch;
  }
  
  /**
   * @param CURL resource
   * @return string
   */
  private function executeRequest($ch, $json = TRUE, &$header = NULL) {

    $response = curl_exec($ch);
    
    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $header      = substr($response, 0, $header_size);
    $output      = substr($response, $header_size);
    $code = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
   // error_log(print_r($code , TRUE));
	
    if ($output === FALSE) {		
      $exc          = new RuntimeException('Error executing CURL request: ' . $ch);
      $exc->_header = $header;
      $exc->_status = $code;
	  $exc->_err = curl_error($ch);
      throw $exc;
    }
    
    curl_close($ch);
    
    if ($json) {
		
      $json_output = json_decode($output, TRUE);
      if (!isset($json_output)) {
        $exc          = new RuntimeException('Error parsing JSON response: ' . htmlentities(strip_tags($output)));
        $exc->_header = $header;
        $exc->_status = $code;
        //var_dump($code);
        //var_dump($header); die();
        throw $exc;
      }
      
      if ($json_output['status'] == 'error') {
        $exc          = new RuntimeException('Error executing API request: ' . print_r($json_output, 1));
        $exc->_header = $header;
        $exc->_status = $code;
        //var_dump($code);
        //var_dump($header); die();
        throw $exc;
      }
      	//error_log(print_r($output , TRUE));
		//error_log(print_r($code , TRUE));
		
		//return $json_output;	
		$json_output_arr = array('output' => $json_output, 'code' => $code);//doplnene 
      return $json_output_arr;
	  
    }
    return $output;
  }
}