<?php
/**
 * Implementation of hook_views_data_alter().
 */
function uc_invoice_views_data_alter(&$data) {
  $invoice_schema = drupal_get_schema('uc_invoice');
  $data['uc_invoice']['table']['join']['uc_orders'] = array(
    'left_field' => 'order_id',
    'field' => 'order_id',
  );

  $data['uc_invoice']['table']['join']['uc_order_products'] = array(
    'left_field' => 'order_id',
    'field' => 'order_id',
  );

  $data['uc_invoice']['table']['group'] = t('Ubercart invoice number');
  $data['uc_invoice']['invoice_nbr'] = array(
    'title' => t('Invoice number'),
    'help' => $invoice_schema['fields']['invoice_nbr']['description'],
    'field' => array(
    'handler' => 'views_handler_field',
    'click sortable' => TRUE,
  ),
  'sort' => array(
    'handler' => 'views_handler_sort',
  ),
  'filter' => array(
    'handler' => 'views_handler_filter_numeric',
  ),
  );

  $data['uc_invoice']['created'] = array(
    'title' => t('Invoice date'),
    'help' => $invoice_schema['fields']['created']['description'],
    'field' => array(
    'handler' => 'views_handler_field_date',
    'click sortable' => TRUE,
  ),
  'sort' => array(
    'handler' => 'views_handler_sort_date',
  ),
  'filter' => array(
    'handler' => 'views_handler_filter_date',
  ),
  );
}