<?php

/**
 * @file
 * Ubercart Rule integration input forms
 */

/**
 * Settings form for order status update action.
 *
 * @param array $settings
 *
 * @ingroup forms
 */
function uc_rules_action_order_update_status_form($settings, &$form) {
  foreach (uc_order_status_list('general') as $status) {
    $options[$status['id']] = $status['title'];
  }
  foreach (uc_order_status_list('specific') as $status) {
    $options[$status['id']] = $status['title'];
  }
  $form['settings']['order_status'] = array(
    '#type' => 'select',
    '#title' => t('Order status'),
    '#options' => $options,
    '#default_value' => $settings['order_status'],
  );
}

/**
 * Settings form for add comment action.
 *
 * @param array $settings
 *
 * @ingroup forms
 */
function uc_rules_action_order_add_comment_form($settings, &$form) {
  $settings += array('comment_type' => 'admin', 'comment' => '');
  $form['settings']['comment_type'] = array(
    '#type' => 'radios',
    '#title' => t('Select order comment type'),
    '#options' => array(
      'admin' => t('Admin comment'),
      'order' => t('Customer comment.'),
      'notified' => t('Customer comment with notification'),
    ),
    '#default_value' => $settings['comment_type'],
    '#required' => TRUE,
  );
  $form['settings']['comment'] = array(
    '#type' => 'textarea',
    '#title' => t('Comment'),
    '#description' => t('Enter the comment message. Uses <a href="!url">order and global tokens</a>.', array('!url' => url('admin/store/help/tokens'))),
    '#default_value' => $settings['comment'],
    '#required' => TRUE,
  );
}

/**
 * Settings form for send e-mail invoice action.
 *
 * @param array $settings
 *
 * @ingroup forms
 */
function uc_rules_action_send_order_email_invoice_form($settings, &$form) {
//watchdog("rules", '<pre>' . print_r( $form, true) . '</pre>');
  $settings += array(
    'from' => uc_store_email_from(),
    'addresses' => '[uc_order:order-email-raw]',
    'subject' => '',
    'template' => '',
    'view' => 'checkout-mail',
  );
  $form['settings']['from'] = array(
    '#type' => 'textfield',
    '#title' => t('Sender'),
    '#default_value' => $settings['from'],
    '#description' => t('The "From" address.'),
    '#required' => TRUE,
  );
  $form['settings']['addresses'] = array(
    '#type' => 'textarea',
    '#title' => t('Recipients'),
    '#default_value' => $settings['addresses'],
    '#description' => t('Enter the email addresses to receive the notifications, one on each line. You may use order tokens for dynamic email addresses.'),
    '#required' => TRUE,
  );
  $form['settings']['subject'] = array(
    '#type' => 'textfield',
    '#title' => t('Subject'),
    '#default_value' => $settings['subject'],
    '#required' => TRUE,
  );
  $form['settings']['template'] = array(
    '#type' => 'select',
    '#title' => t('Invoice template'),
    '#description' => t('Select the invoice template to use for this email.'),
    '#options' => uc_order_template_options(),
    '#default_value' => $settings['template'],
  );
  $form['settings']['view'] = array(
    '#type' => 'radios',
    '#title' => t('Included information'),
    '#options' => array(
      'print' => t('Show the business header and shipping method.'),
      'admin-mail' => t('Show all of the above plus the help text, email text, and store footer.'),
      'checkout-mail' => t('Show all of the above plus the "thank you" message.'),
    ),
    '#default_value' => $settings['view'],
    '#required' => TRUE,
  );
}

/**
 * Settings form for load product action.
 *
 * @param array $settings
 *
 * @ingroup forms
 */
function uc_rules_action_load_product_form($settings, &$form) {
  $settings += array('uc_product_id' => 0, 'uc_product_id_text' => '');
  $form['settings']['uc_product_id'] = array(
    '#type' => 'select',
    '#title' => t('Product'),
    '#options' => uc_rules_options_product(),
    '#default_value' => $settings['uc_order_id'],
    '#description' => t('Select the product to load.'),
  );
  $form['settings']['uc_product_id_text'] = array(
    '#type' => 'textfield',
    '#title' => t('Product node ID'),
    '#default_value' => $settings['uc_order_id'],
    '#description' => t('Optional: Enter the product node ID. This will override the selection above.'),
  );
}

/**
 * Settings form for load order by id action.
 *
 * @param array $settings
 *
 * @ingroup forms
 */
function uc_rules_action_load_order_by_id_form($settings, &$form) {
  $form['settings']['uc_order_id'] = array(
    '#type' => 'textfield',
    '#title' => t('Order Id'),
    '#default_value' => $settings['uc_order_id'],
    '#description' => t('Enter the order ID to load.'),
    '#required' => TRUE,
  );
}

/**
 * Settings form for order has products action.
 *
 * @param array $settings
 *
 * @ingroup forms
 */
function uc_rules_condition_order_has_products_form($settings, $form) {
  $settings += array('products' => array(), 'required' => 0, 'forbidden' => 0);
  $form['settings']['products'] = array(
    '#type' => 'select',
    '#title' => t('Products'),
    '#options' => uc_rules_options_product(),
    '#description' => t('Use Ctrl button to select multiple products.'),
    '#default_value' => $settings['products'],
    '#multiple' => TRUE,
  );
  $form['settings']['required'] = array(
    '#type' => 'checkbox',
    '#title' => t('Require all selected products'),
    '#description' => t('If selected the order must contain all selected products. Otherwise, order must contain at least one of the selected products.'),
    '#default_value' => $settings['required'],
  );
  $form['settings']['forbidden'] = array(
    '#type' => 'checkbox',
    '#title' => t('Forbid other products'),
    '#description' => t('If selected the order must contain only the selected products. Otherwise, order may contain other products.'),
    '#default_value' => $settings['forbidden'],
  );
}

/**
 * Settings form for order has status action.
 *
 * @param array $settings
 *
 * @ingroup forms
 */
function uc_rules_condition_order_has_status_form($settings, &$form) {
  foreach (uc_order_status_list() as $status) {
    $status_list[$status['id']] = $status['title'];
  }

  $form['settings']['status'] = array(
    '#type' => 'select',
    '#title' => t('Status'),
    '#options' => $status_list,
    '#default_value' => $settings['status'],
    '#description' => t('Select the desired order status.'),
  );
}

if (module_exists('uc_attribute')) {

  /**
   * Settings form for order has any product with attribute option action.
   *
   * @param array $settings
   *
   * @ingroup forms
   */
  function uc_rules_condition_products_with_attribute_option_form($settings, &$form) {
    $settings += array('option' => 0);
    $form['settings']['option'] = array(
      '#type' => 'select',
      '#title' => t('Attribute options'),
      '#options' => uc_rules_options_attribute_ordered_product(),
      '#default_value' => $settings['option'],
    );
  }

  /**
   * Product attribute options callback.
   *
   * @see uc_rules_condition_products_with_attribute_option_form()
   */
  function uc_rules_options_attribute_ordered_product() {
    $options = array();
    $result = db_query("SELECT a.aid, a.name AS attr_name, a.ordering, o.oid, o.name AS opt_name, o.ordering FROM {uc_attributes} a JOIN {uc_attribute_options} o ON a.aid = o.aid ORDER BY a.ordering, o.ordering");
    while ($option = db_fetch_object($result)) {
      $options[$option->attr_name][$option->oid] = $option->opt_name;
    }

    return $options;
  }

}