<?php

/**
 * @file
 * This file is the default email template for when someone receives a gift certificate
 * You have access to the global, gift certificate, and user account token variables.
 * Additional variables:
 *  The gift cert object: $gift_certificate
 *  The recipient user object: $account
 *  The order object, if there is one: $order
 *  The order_product object, if there is one, which is useful if you have other attributes associated with the certificate: $order_product
 *  Is new user flag: $is_new_user
 *  New user password: $new_password
 */
?>
<p>Dobrá správa!</p>
<p>Práve ste obdržali darčekovú poukážku v hodnote <strong><?php echo $gift_cert_value; ?></strong> na nákup v našom obchode <?php echo $store_link; ?>.</p>

<blockquote><?php echo $gift_cert_message; ?></blockquote>
<?php if ($is_new_user): ?>
<p><strong>Vytvorili sme pre Vás účet:</strong></p>
<p>
  <strong>Meno:</strong> <?php echo $user; ?><br />
  <strong>Heslo:</strong> <?php echo $new_password; ?>
</p>
<?php endif; ?>
<p><strong>Pozorne si prečítajte:</strong> Akým spôsobom je možné použiť darčekovú poukážku?</p>
<ol>
  <li>Na našej stránke www.biome.sk si vyberiete tovar v hodnote poukážky.</li>
  <li>Tovar vložíte do košíka</li>
  <li>V pokladni sa prihlásite. (Ak už ste náš zákazník, použite Vaše prihlasovacie údaje. Ak ste u nás ešte nenakupovali, použijete prihlasovacie údaje z tohto mailu.) <strong>Upozornenie</strong>: Bez prihlásenia nebude možné uplatniť poukážku.</li>
  <li>Na stránke pokladne sa zobrazí správa o darčekovej poukážke ako aj možnosť platby darčekovou poukážkou.<br />
  </li>
</ol>
<p><strong>Ďalšie informácie:</strong></p>
<ul>
  <li>Ak pri nákupe nespotrebujete všetok kredit z poukážky, môžete ho minúť pri ďalšom nákupe.</li>
  <li>Celý kredit alebo nespotrebovaný zvyšok môžete tiež darovať pomocou kódu vytvoreného špeciálne ku každej poukážke. Kódy sa môžu sčítavať.</li>
  <li><strong>Kód k Vašej poukážke je:</strong> <?php echo $gift_cert_code; ?></li>
  <li>V prípade potreby je možné vložiť kódy v užívateľskom účte po prihlásení. </li>
</ul>

<p>Želáme príjemné nakupovanie :)</p>
