<?php
/**
 * @file views-view.tpl.php
 * Main view template
 *
 * Variables available:
 * - $classes_array: An array of classes determined in
 *   template_preprocess_views_view(). Default classes are:
 *     .view
 *     .view-[css_name]
 *     .view-id-[view_name]
 *     .view-display-id-[display_name]
 *     .view-dom-id-[dom_id]
 * - $classes: A string version of $classes_array for use in the class attribute
 * - $css_name: A css-safe version of the view name.
 * - $css_class: The user-specified classes names, if any
 * - $header: The view header
 * - $footer: The view footer
 * - $rows: The results of the view query, if any
 * - $empty: The empty text to display if the view is empty
 * - $pager: The pager next/prev links to display, if any
 * - $exposed: Exposed widget form/info to display
 * - $feed_icon: Feed icon to display, if any
 * - $more: A link to view more, if any
 * - $admin_links: A rendered list of administrative links
 * - $admin_links_raw: A list of administrative links suitable for theme('links')
 *
 * @ingroup views_templates
 */

?>


<span class="-close" id="modalbox-close">✖</span>
<p style="text-align:center"><strong>A je to v košíku!</strong></p>

<div class="<?php print $classes; ?>">
  <?php if ($admin_links): ?>
    <div class="views-admin-links views-hide">
      <?php print $admin_links; ?>
    </div>
  <?php endif; ?>
  <?php if ($header): ?>
    <div class="view-header">
      <?php print $header; ?>
    </div>
  <?php endif; ?>

  
<?php 
	  $nid = $view->result['0']->nid;
	  $nodetype = $view->result['0']->node_type;
	  ?>
  
 <?php if ($nodetype == 'product'): ?>
<div class="modalcart-prod-wrap row">
  <?php // produkt vlozeny do kosika ?>

  <div class="modalcart-img">
	<?php print $view->field['field_p_pic_main_fid_1']->original_value;?>
  </div>
  <div class="modalcart-desc">
	  
	
		<span class="d-block"><strong><?php print $view->field['title']->original_value;?></strong></span>
		 <?php print ('Cena: ' . $view->field['sell_price']->original_value);?>
		 <span class="akciacena"><?php print $view->field['field_akcia_cena_value']->original_value;?></span>  
  </div> 
</div>
<?php endif;?>

<?php if ($nodetype == 'product_kit'): ?>
<?php
$result = db_query("SELECT product_id FROM {uc_product_kits} WHERE nid = '$nid' ");

while ($row = $result->fetch_assoc()) {
	$produkty_nid .= $row['product_id']."+";
}
$nids = substr($produkty_nid, 0, -1);
?>


	<?php	print views_embed_view('addtocartpopup_prodkit', 'default',  $nid);?>
	<?php endif; ?>


<div class="popupcartlinks row">
	<div class="_noPadding _floatRight _alignCenter col m6"><a class="popuptocart button d-block" href=/cart>Prejsť do košíka ></a></div>
	<div class="_noPadding _floatLeft _alignCenter col m6"><a class="button d-block closemodal" href="#">< Pokračovať v nákupe</a></div>
	
</div>


  
  
<?php



//kontrola ci view je prazdne - zisti ci html obsahuje klasu views-row
$check = views_embed_view('addtocartpopup_odporucane', 'default',  $nid);
if(strpos($check, 'views-field-title') === false){ //view-content nemam na biome.sk tak ako na teste
	?><div class="modalcart-text _alignCenter"><strong>Často kupované spolu:</strong></div><?php
	
	if ($nodetype == 'product_kit') {
    print views_embed_view('upsell_cart_pairs_popup', 'default',  $nids);} 
	else {
		print views_embed_view('upsell_cart_pairs_popup', 'default',  $nid);
	};
	
	
} else {
	?><div class="modalcart-text _alignCenter"><strong>Odporúčame dokúpiť:</strong></div><?php
	print views_embed_view('addtocartpopup_odporucane', 'default',  $nid);
}

?>


</div> <?php /* class view */ ?>

