

// obtain cookieconsent plugin
var cc = initCookieConsent();

// run plugin with config object
cc.run({
	
    current_lang: 'sk',
    autoclear_cookies: true,                    // default: false
    cookie_name: 'cc_cookie',             // default: 'cc_cookie'
    cookie_expiration: 365,                     // default: 182
    page_scripts: true,                         // default: false
    force_consent: false,                        // default: false

    // auto_language: null,                     // default: null; could also be 'browser' or 'document'
    // autorun: true,                           // default: true
    // delay: 0,                                // default: 0
    // hide_from_bots: false,                   // default: false
     //remove_cookie_tables: true ,             // default: false
    // cookie_domain: location.hostname,        // default: current domain
    // cookie_path: '/',                        // default: root
    // cookie_same_site: 'Lax',
    // use_rfc_cookie: false,                   // default: false
    // revision: 0,                             // default: 0

    gui_options: {
        consent_modal: {
            layout: 'bar',                    // box,cloud,bar
            position: 'bottom center',          // bottom,middle,top + left,right,center
            transition: 'slide'                 // zoom,slide
        },
        settings_modal: {
            layout: 'box',                      // box,bar
            position: 'left',                   // right,left (available only if bar layout selected)
            transition: 'slide'                 // zoom,slide
        }
    },

    onFirstAction: function(){
       // console.log('onFirstAction fired');
	  
            typeof gtag === 'function' && gtag('consent', 'update', {
                'analytics_storage': cc.allowedCategory('analytics') ? 'granted' : 'denied',
				'ad_storage': cc.allowedCategory('ads') ? 'granted' : 'denied'
            });
			fbq('consent', cc.allowedCategory('ads') ? 'grant' : 'revoke');
			

    },

    onAccept: function (cookie) {
       
    },

    onChange: function (cookie, changed_preferences) {
        //console.log('onChange fired!');

    },

    languages: {
        'sk': {
            consent_modal: {                
                description: 'Na tejto stránke používame súbory cookies. <button type="button" data-cc="c-settings" class="cc-link" aria-haspopup="dialog">Nastavenie</button>',
                primary_btn: {
                    text: 'Súhlasím a pokračovať',
                    role: 'accept_all'      //'accept_selected' or 'accept_all'
                },
				secondary_btn: {
                    text: 'Odmietnuť',
                    role: 'accept_necessary'      //'settings' or 'accept_necessary'
                },

                
            },
            settings_modal: {
                title: 'Podrobné nastavenia cookies',
                save_settings_btn: 'Uložiť výber',
                accept_all_btn: 'Prijať všetko',
                reject_all_btn: 'Odmietnuť všetko',
                close_btn_label: 'Zatvoriť',
                cookie_table_headers: [
                    {col1: 'Meno'},
                    {col2: 'Doména'},
                    {col3: 'Popis'}
                ],
                blocks: [
                    {
                        title: 'Ako používame cookies?',
                        description: 'Cookies používame na zlepšenie služieb, aby pre vás bolo prehliadanie stránok jednoduchšie. Cookies tretích strán sú uložené len s vašim súhlasom a vždy máte možnosť svoje nastavenia zmeniť. Vypnutie niektorých cookies môže mať vplyv na funkčnosť stránky alebo jej doplnkovú funkcionalitu, ktorá nebude dostupná.'
                    }, {
                        title: 'Nevyhnutné cookies',
                        description: 'Tieto cookies sú nevyhnutné na správne fungovanie stránky a bez nich by mohla byť stránka nefunkčná. Nie je ich možné odmietnuť.',
                        toggle: {
                            value: 'necessary',
                            enabled: true,
                            readonly: true  //cookie categories with readonly=true are all treated as "necessary cookies"
                        }, 
						cookie_table: [
                            {
                                col1: 'has_js',
                                col2: 'biome.sk',
                                col3: 'Používané na určenie, či je javascript zapnutý',
                               
                            },							 						
                         
                        ],
                    }, {
                        title: 'Analytické a výkonnostné cookies',
                        description: 'Tieto cookies nám pomáhajú identifikovať návštevníkov a získať informácie o počte návštev, navštívených stránkach a podobných metrikách. Sú určené na získanie všeobecného prehľadu, vďaka ktorému vieme zlepšovať služby, aby vám na stránke nič neprekážalo a mohli ste sa sústrediť na svoj cieľ pri jej prehliadaní.',
                        toggle: {
                            value: 'analytics',
                            enabled: false,
                            readonly: false
                        },
                        cookie_table: [
                            {
                                col1: '^_ga',
                                col2: 'biome.sk',
                                col3: 'ID používané na identifikáciu používateľov.',
                                is_regex: true
                            }, 
							{
                                col1: '^_gid',
                                col2: 'biome.sk',
                                col3: 'používané na identifikáciu používateľov.',
                               
                            },                          
                         
                        ],
                    }, {
                        title: 'Reklamné cookies',
                        description: 'Tieto cookies používame na zaznamenávanie Vašich návštev na našich webových stránkach, iných stránkach a odkazov, na ktoré ste klikli. Informácie, ktoré tak získame, používame na prispôsobenie našich webových stránok Vašim záujmom. Tieto informácie môžeme taktiež zdieľať s tretími osobami, napr. prevádzkovateľmi sociálnych sietí.',
                        toggle: {
                            value: 'ads',
                            enabled: false,
                            readonly: false
                        },
                        cookie_table: [
                            {
                                col1: '^_fbp',
                                col2: 'biome.sk',
                                col3: 'ID používané na identifikáciu používateľov.',
                                is_regex: true,
                            }, 
                          
                         
                        ],
                    },{
                        title: 'Viac informácií',
                        description: 'Všetky ďalšie informácie o tom ako spracovávame a chránime osobné údaje sa dočítate na stránke <a href="/obchod/ochrana-sukromia" class="cc-link">ochrana osobných údajov</a>.',
                    }
					
                ]
            }
        }
    }
});