<?php

    
// Auto-rebuild the theme registry during theme development.
if (theme_get_setting('basic_rebuild_registry')) {
  drupal_rebuild_theme_registry();
}

// Add Zen Tabs styles
if (theme_get_setting('basic_zen_tabs')) {
  drupal_add_css( drupal_get_path('theme', 'basic') .'/css/tabs.css', 'theme', 'screen');
}
//local css ako posledne 

drupal_add_css( drupal_get_path('theme', 'basic') .'/css/local.css', 'theme', 'all');

/**
 *	This function creates the body classes that are relative to each page
 *
 *	@param $vars
 *	  A sequential array of variables to pass to the theme template.
 *	@param $hook
 *	  The name of the theme function being called ("page" in this case.)
 */

 //nezobrazi pager na taxonomy termoch nikde
function basic_pager($tags = array(), $limit = 10, $element = 0, $parameters = array(), $quantity = 9) {
if (arg(0)=="taxonomy" && arg(1)=="term" && is_numeric(arg(2))) {
	return "";
} else {
	return theme_pager($tags, $limit, $element, $parameters, $quantity);
}
} 

function basic_preprocess_page(&$vars, $hook) {
//var_dump($vars); 	

	
	//var_dump($vars['node']);
//zobrazi alternativny meta title ak je vyplneny - iba u produktov a clankov je
//if ($vars['node']->field_title_meta['0']['value']) {
	//$vars['head_title'] = $vars['node']->field_title_meta['0']['value'].' | biome.sk';
//}

$vars['logo'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 418.3 95" style="enable-background:new 0 0 418.3 95; height:38px" xml:space="preserve">
<style type="text/css">
	.st0{fill:#D22027;}
	.st1{fill:#FFFFFF;}
</style>
<rect id="XMLID_93_" x="-13.9" y="-29.2" class="st0" width="644.9" height="150.7"/>
<g id="XMLID_237_">
	<path id="XMLID_290_" class="st1" d="M41.1,78.5c-6.2,0-10.7-2.4-13.8-5.6v4.7H15.1V15.4h12.3v20.9c3.2-3.1,7.9-5.3,13.8-5.3
		c12.9,0,21.6,9.8,21.6,23.7S54,78.5,41.1,78.5z M37.7,41.7c-4.1,0-8,1.9-10.3,4.3v17.6c2.1,2.1,6,4.2,10.3,4.2
		c7.5,0,12.4-5.3,12.4-13.1C50.2,46.8,45.2,41.7,37.7,41.7z"/>
	<path id="XMLID_293_" class="st1" d="M80.3,12.7c4.2,0,7,1.6,7,6c0,4.5-2.8,6.1-7,6.1c-4.3,0-7.2-1.7-7.2-6.1
		C73.1,14.3,76,12.7,80.3,12.7z M74.1,31.8h12.3v45.8H74.1V31.8z"/>
	<path id="XMLID_296_" class="st1" d="M122.2,30.5c14.4,0,24.7,10.3,24.7,24.3c0,13.8-10.3,24-24.7,24c-14.2,0-24.5-10.3-24.5-24
		C97.7,40.9,108,30.5,122.2,30.5z M122.2,67.6c7.7,0,12.9-5.6,12.9-12.8c0-7.4-5.2-13.1-12.9-13.1c-7.5,0-12.7,5.7-12.7,13.1
		C109.5,62,114.7,67.6,122.2,67.6z"/>
	<path id="XMLID_299_" class="st1" d="M170.5,31.8v5.1c3.4-3.6,8.3-6,15-6c8.2,0,12.6,2.8,15.3,7.6c3.2-3.9,8.9-7.5,16.7-7.5
		c12.4,0,17.4,8.9,17.4,20.2v26.4h-12.3V53.2c0-6.7-2.7-11-9.2-11c-6,0-9.2,3.4-10.6,7v28.3h-12.3V53.1c0-6.7-2.6-10.9-9.2-10.9
		c-6.1,0-9.4,3.5-10.9,7.2v28.1h-12.3V31.8H170.5z"/>
	<path id="XMLID_301_" class="st1" d="M290,72.6c-4.7,3.9-11.5,6.2-19.3,6.2c-17.3,0-25-10.5-25-24c0-13.7,9.5-24.3,24.2-24.3
		c13.9,0,20.5,8.5,20.5,19.1c0,2.8-0.4,7.2-1,8.9h-31.1c1.1,6.4,5.3,10,12.7,10c5.8,0,11.1-2.4,14.3-4.7L290,72.6z M278.7,47.5
		c0-3.7-2.8-6.8-9-6.8c-6.6,0-10.1,3.9-11,8.4h19.9C278.7,48.7,278.7,48,278.7,47.5z"/>
	<path id="XMLID_304_" class="st1" d="M306.7,68.7c3.1,0,4.8,1.8,4.8,4.9c0,3.2-1.8,4.9-4.8,4.9c-3.1,0-4.7-1.7-4.7-4.9
		C302,70.5,303.6,68.7,306.7,68.7z"/>
	<path id="XMLID_306_" class="st1" d="M356.8,39.6c-3.7-1.8-9.4-3.5-14.6-3.5c-7.5,0-11.6,3-11.6,8.2c0,3.9,2.5,5.3,8.9,6.7l7.5,1.8
		c8.9,2.1,13.1,5.7,13.1,12c0,8-7.1,13.7-18.4,13.7c-7.7,0-13.7-2.2-17.1-3.9l1.3-5.3c3.5,1.8,8.9,4.1,15.5,4.1
		c7.8,0,12.6-3.4,12.6-8.2c0-3.9-3.2-5.9-9.2-7.2l-7.5-1.8c-8.7-2-12.8-4.9-12.8-11.6c0-8.2,6.4-13.7,18-13.7
		c5.7,0,12.4,1.8,15.8,3.4L356.8,39.6z"/>
	<path id="XMLID_308_" class="st1" d="M410.6,32.7L386,53.3l26.1,23.3v1h-7.4l-25-22.8v22.8h-6V15.4h6v36.5l24-20.2h6.8V32.7z"/>
</g>

</svg>';
$vars['steps_cart'] = '<div id="checkout-steps" class="row no-gutters text-center justify-content-center ">
			<div class="col-auto cart-step  px-2 cart-step-active">
				
				<a>
					
					<u><span>Košík</span></u>
				</a>
			</div>
			<div class="col-auto cart-step  px-2 ">
				
				<a>
					
					<span>Pokladňa</span>
				</a>
			</div>
			<div class="col-auto cart-step  px-2 ">
				
				<a>
					
					<span>Potvrdenie</span>
				</a>
			</div>
		</div>';
$vars['steps_checkout'] = '<div id="checkout-steps" class="row no-gutters text-center justify-content-center ">
			<div class="col-auto cart-step  px-2 ">
				
				<a href="/cart">
					
					<span>Košík</span>
				</a>
			</div>
			<div class="col-auto cart-step  px-2 cart-step-active">
				
				<a>
					
					<u><span>Pokladňa</span></u>
				</a>
			</div>
			<div class="col-auto cart-step  px-2 ">
				
				<a>
					
					<span>Potvrdenie</span>
				</a>
			</div>
		</div>	'; 
$vars['steps_review'] = '<div id="checkout-steps" class="row no-gutters text-center justify-content-center ">
			<div class="col-auto cart-step  px-2 ">
				
				<a href="/cart">
					
					<span>Košík</span>
				</a>
			</div>
			<div class="col-auto cart-step  px-2">
				
				<a href="/cart/checkout">
					
					<span>Pokladňa</span>
				</a>
			</div>
			<div class="col-auto cart-step  px-2 cart-step-active">
				
				<a>
					
					<u><span>Potvrdenie</span></u>
				</a>
			</div>
		</div>';
		
$vars['footer_icons']= '<div class="footer_msg row _maincolor mt-1 p-1">
		<div class="col d3 m6 _alignCenter">
			<div>
				<i class="fs-3 material-icons">verified_user</i>
			</div>
			<div class="mt-1">
				<strong>Už '.  ((date("Y"))-2009) .' rokov na trhu</strong>
			</div>
		</div>
		<div class="col d3 m6 _alignCenter">
			<div>
				<i class="fs-3 material-icons">local_phone</i>
			</div>
			<div class="mt-1">
				<strong>Spoľahlivá zákaznícka podpora</strong>
			</div>
		</div>
		<div class="col d3 m6 _alignCenter">
			<div>
				<i class="fs-3 material-icons">thumb_up</i>
			</div>
			<div class="mt-1">
				<strong>Kvalitné a časom overené produkty</strong>
			</div>
		</div>
		<div class="col d3 m6 _alignCenter">
			<div>
				<i class="fs-3 material-icons">local_shipping</i>
			</div>
			<div class="mt-1">
				<strong>Rýchle doručenie</strong>
			</div>
		</div>
	</div>
';				
if ((arg(0) == 'user' && !(arg(1))) || (arg(0) == 'user' && (arg(1) == 'login')) || ((arg(0) == 'user' ) && (arg(1) == 'register')) || ((arg(0) == 'user' ) && (arg(1) == 'password'))) {
	$vars['template_file'] = 'user_login';
}

// remove sticky table headers
  $js = drupal_add_js();
  unset($js['module']['misc/tableheader.js']);



//prida js css
 drupal_add_js('sites/all/themes/basic/js/smooth2.js');
  drupal_add_js('sites/all/themes/basic/js/js.cookie.js');
 // drupal_add_js('sites/all/themes/basic/js/visitedProducts.js');
  //drupal_add_js('sites/all/themes/basic/js/jquery.mmenu.min.js');
  //drupal_add_js('sites/all/themes/basic/js/menu-call.js');

  
  //drupal_add_css('sites/all/themes/basic/css/jquery.mmenu.css');

  //global $user;
  /*if (!in_array('baliky', $user->roles)) { 
  $external_js = '//static.addtoany.com/menu/page.js';
drupal_add_js('document.write(unescape("%3Cscript src=\''. $external_js .'\' type=\'text/javascript\'%3E%3C/script%3E"));', 'inline');
  };*/
drupal_add_js('sites/all/themes/basic/js/youtubeload.js');
 drupal_add_css('sites/all/themes/basic/css/youtubeload.css');
  drupal_add_css('sites/all/themes/basic/css/main-youtubeload.css');
  
  //crystalslider
  drupal_add_js('sites/all/themes/basic/js/crystalslider.min.js');
 drupal_add_css('sites/all/themes/basic/css/crystalslider.css');
 
 //lightgallery
  drupal_add_js('sites/all/themes/basic/js/lg/lightgallery.min.js');
  drupal_add_js('sites/all/themes/basic/js/lg/lg-thumbnail.min.js');
  drupal_add_js('sites/all/themes/basic/js/lg/lg-video.min.js');
  drupal_add_js('sites/all/themes/basic/js/lg/lg-autoplay.js');
  drupal_add_css('sites/all/themes/basic/css/lightgallery.min.css');
  
  drupal_add_js('sites/all/themes/basic/js/jquery.qbeforeafter.js');
 drupal_add_css('sites/all/themes/basic/css/qbeforeafter.css');

  if (arg(0) == 'cart' && arg(1) == 'checkout' && arg(2) == 'review') {
    drupal_add_js('sites/all/themes/basic/js/order_loader.js');}
 
 drupal_add_css('sites/all/themes/basic/css/ouibounce.css');
  drupal_add_js('sites/all/themes/basic/js/beauter.js');
  drupal_add_js('sites/all/themes/basic/js/nav-menu.js');
  drupal_add_js('sites/all/themes/basic/js/vsetkomozne.js');
  
  drupal_add_js('sites/all/themes/basic/js/search-fast.js'); 
 //drupal_add_js('sites/all/themes/basic/js/responsivelyLazy.js');
 drupal_add_js('sites/all/themes/basic/js/responsivelyLazy.min.js');
  drupal_add_css('sites/all/themes/basic/css/responsivelyLazy.min.css');
  drupal_add_js('sites/all/themes/basic/js/mark.min.js');
  
  drupal_add_css('sites/all/themes/basic/css/nav-menu.css');
  drupal_add_css('sites/all/themes/basic/css/beauter.css');
 // drupal_add_css('sites/all/themes/basic/css/local.css');
  
  //drupal_add_js('sites/all/themes/basic/js/uc_ajax_cart.js');
  
  //$variables['scripts'] = drupal_get_js();
  //$vars['styles'] = drupal_get_css();
  
  drupal_add_js('sites/all/themes/basic/js/google-search.js');
  
 // var_dump($vars);

//------------------------------------------------  

// pridane hodnotenia pre neprihlasenych - setne cookie podla parametra v url. Problem bol s otaznikom v url pri destination. Prihlaseni idu priamo v pohode na node/add a z parametra sa berie hodnota.
// user argument preto, lebo logintobogan na 403 stranku drbne prihlasovaciu form a drupal to berie ako prihlasovaciu stranku
  if (arg(0) == 'user') {
	  $exploded = explode("/", request_uri());
	  if ($exploded[1] == 'node' && $exploded[2] == 'add') {
 
	  preg_match('/.*?prodreview(.*)/', $exploded[3], $matches);
	 
//watchdog('matches', $matches[1]);

if (ctype_digit($matches[1])) {
//watchdog('rulezzz', 'digit');
$product_nid = $matches[1];
//watchdog('mssss', $product_nid);
$cookie_name = "prodreview";
$cookie_value = $product_nid;
setcookie($cookie_name, $cookie_value, time() + (86400), "/"); // 86400 = 1 day
}; 
	  };
}

//doplni odporucane produkty do praveho sidebaru
if 	(($vars['node']->type == 'product') && (arg(2) != 'edit')){	
$vars['layout'] = 'both';	
//$vars['right'] .= '<div id="prodsidebar-'. $vars['node']->nid .'" class="views-ajax-load"></div>';	
};
 
   global $user;
if ((in_array('baliky', $user->roles))  ){
  $vars['template_file'] = 'page-admin-order';
  }
 
		



 
 
//product reviews metatag pr/produktxy
if ((arg(0) == 'pr') && arg(1)){
	
global $base_url;

	 $vars['head'] .= '<link rel="canonical" href="'.$base_url.'/pr/'.arg(1).'" />';
	//var_dump($vars);
};
 
//AMP
if(arg(0)=='amp') {
$nyd = substr(drupal_get_normal_path(arg(1)), 5);
$noode = node_load($nyd);
	if ($noode->type == 'story') {
$vars['template_file'] = 'page-amp_story';
};
if ($noode->type == 'product') {
$vars['template_file'] = 'page-amp_product';
};
}
if (isset($vars['node']) && ($vars['node']->type == 'story' || $vars['node']->type == 'product') ) {
    $vars['print_extra_header'] = true;
	 $system_path = 'node/'.arg(1);
	 $current_path = drupal_get_path_alias($system_path);
 $vars['head'] =  $vars['head'] . '<link rel="amphtml" href="https://www.biome.sk/amp/' . $current_path . '">' . "\n";
};
///AMP

  
  
  //if ( isset($_GET['ajax']) && $_GET['ajax'] == 1 ) {
  //      $variables['template_file'] = 'page-ajax1';
  //}
  
 // amp metatag 

 if (arg(0) == 'node' && (arg(1) == '440')) {
 $variables['head'] =  $variables['head'] . '<link rel="amphtml" href="https://www.biome.sk/amp/vypadavanie-vlasov.html">' . "\n";
 };  
// AMP  
  
drupal_set_html_head('<link rel="apple-touch-icon" href="/apple-touch-icon.png"/>');  
  
  // Don't display empty help from node_help().
  if ($vars['help'] == "<div class=\"help\"><p></p>\n</div>") {
    $vars['help'] = '';
  }

  // Classes for body element. Allows advanced theming based on context
  // (home page, node of certain type, etc.)
  $body_classes = array($vars['body_classes']);
  if (user_access('administer blocks')) {
	  $body_classes[] = 'admin';
	}
	if (theme_get_setting('basic_wireframe')) {
    $body_classes[] = 'with-wireframes'; // Optionally add the wireframes style.
  }
  if (!empty($vars['primary_links']) or !empty($vars['secondary_links'])) {
    $body_classes[] = 'with-navigation';
  }
  if (!empty($vars['secondary_links'])) {
    $body_classes[] = 'with-secondary';
  }
 
  if (!$vars['is_front']) {
    // Add unique classes for each page and website section
    $path = drupal_get_path_alias($_GET['q']);
    list($section, ) = explode('/', $path, 2);
    $body_classes[] = basic_id_safe('page-'. $path);
    $body_classes[] = basic_id_safe('section-'. $section);

    if (arg(0) == 'node') {
      if (arg(1) == 'add') {
        if ($section == 'node') {
          array_pop($body_classes); // Remove 'section-node'
        }
        $body_classes[] = 'section-node-add'; // Add 'section-node-add'
      }
      elseif (is_numeric(arg(1)) && (arg(2) == 'edit' || arg(2) == 'delete')) {
        if ($section == 'node') {
          array_pop($body_classes); // Remove 'section-node'
        }
        $body_classes[] = 'section-node-'. arg(2); // Add 'section-node-edit' or 'section-node-delete'
      }
    }
  }
  /*// Check what the user's browser is and add it as a body class
    // DEACTIVATED - Only works if page cache is deactivated
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    if($user_agent) {
      if (strpos($user_agent, 'MSIE')) {
        $body_classes[] = 'browser-ie';
      } else if (strpos($user_agent, 'MSIE 6.0')) {
        $body_classes[] = 'browser-ie6';
      } else if (strpos($user_agent, 'MSIE 7.0')) {
        $body_classes[] = 'browser-ie7';
      } else if (strpos($user_agent, 'MSIE 8.0')) {
        $body_classes[] = 'browser-ie8'; 
      } else if (strpos($user_agent, 'Firefox/2')) {
        $body_classes[] = 'browser-firefox2';
      } else if (strpos($user_agent, 'Firefox/3')) {
        $body_classes[] = 'browser-firefox3';
      }else if (strpos($user_agent, 'Safari')) {
        $body_classes[] = 'browser-safari';
      } else if (strpos($user_agent, 'Opera')) {
        $body_classes[] = 'browser-opera';
      }
    }
  
  /** 
   * Add template suggestions based on content type
   * You can use a different page template depending on the
   * content type or the node ID
   * For example, if you wish to have a different page template
   * for the story content type, just create a page template called
   * page-type-story.tpl.php
   * For a specific node, use the node ID in the name of the page template
   * like this : page-node-22.tpl.php (if the node ID is 22)
   */
  
  if ($vars['node']->type != "") {
      $vars['template_files'][] = "page-type-" . $vars['node']->type;
    }
  if ($vars['node']->nid != "") {
      $vars['template_files'][] = "page-node" . $vars['node']->nid;
    }
	//doplni do vars ak na stranke term
	if (arg(0)=="taxonomy" && arg(1)=="term" && is_numeric(arg(2))) {
		 $vars['taxonomy_term'] = arg(2);
	 }
	
	
	//prida cislo nody na kazdy stranku
    $body_classes[] = 'node-' . $vars['node']->nid;  
	
	//prida user skupinu ako klasu
	if ($vars['user']) {
    foreach($vars['user']->roles as $key => $role){
      $role_class = 'role-' . str_replace(' ', '-', $role);
      $body_classes[] = $role_class;
    }
	$body_classes[] = 'userid-'. $vars['user']->uid; 
  }
//prida klasy s kategoriami do body pre produkt aj clanok (kategoria si pridava klasy cez modul dynamic-categories)	
//PRODUKT
if ($vars['node']->type == 'product') {
	
	if ($vars['node']->field_typ[0]) {
		preg_match ('/href="\/([^"]+)"/', $vars['node']->field_typ[0]['view'], $linka);
		$tags[] = $linka[1];
	}
	if ($vars['node']->field_ucinok[0]) {
		foreach ($vars['node']->field_ucinok as $uc){
			preg_match ('/href="\/([^"]+)"/', $uc['view'], $linka);
			$tags[] = $linka[1];
		}
	}
	if ($vars['node']->field_znacka[0]) {
		//toto sa imploduje nizsie ked sa pridavaju dalsie klasy
		preg_match ('/href="\/([^"]+)"/', $vars['node']->field_znacka[0]['view'], $linka);
		$tags[] = $linka[1];
	}
	if ($vars['node']->field_prekoho[0]) {
		foreach ($vars['node']->field_prekoho as $uc){
			preg_match ('/href="\/([^"]+)"/', $uc['view'], $linka);
			$tags[] = $linka[1];
		}
	}
}
if ($vars['node']->type == 'story') {
	
	if ($vars['node']->field_new_tags[0]) {
		foreach ($vars['node']->field_new_tags as $uc){
			preg_match ('/href="\/([^"]+)"/', $uc['view'], $linka);
			$tags[] = $linka[1];
		}
	}
	
}
  //doplnam pre script fb cez page template
  if ($tags) {
 $vars['category_tags'] = implode(' ', $tags); 
  }

  $vars['body_classes'] = implode(' ', $body_classes); // Concatenate with spaces


// Add a unique css id for the body tag by converting / or + or _ in the current page alias into a dash (-).

  $vars['body_id'] = 'pid-' . strtolower(clean_css_identifier(drupal_get_path_alias($_GET['q'])));
  
// preprocesujem views a davam do vars, potom ich printujem v template. Priamo zobrazit view v template nefunguje ajax - kvoli scriptom
// https://www.drupal.org/node/386388
if (($vars['is_front'] ) && (in_array('baliky', $user->roles))) {
  $vars['baliky'] = views_embed_view('baliky_admin_blocks','default');
  $vars['baliky2'] = views_embed_view('baliky_admin_blocks2','default');
  $vars['baliky3'] = views_embed_view('baliky_admin_blocks3','default');
  $vars['baliky4'] = views_embed_view('baliky_admin_blocks','block_1');
  $vars['baliky5'] = views_embed_view('baliky_admin_blocks','block_2');
}

if ((arg(0) =='cart' && !arg(1)) || (arg(0) =='cart' && arg(1) == 'checkout' && !arg(2))) {
	
//datalayer pre GA4
//aky event	
$event = 'view_cart';
if (arg(1) == 'checkout'){
	$event = 'begin_checkout';
}
$produkty_cart = uc_cart_get_contents();
//var_dump(node_load(1));

foreach ($produkty_cart as $product) {
$nid = $product->nid;
//vytahujem z db znacku a ucinok - node_load nema tieto fieldy uplne vyplnene
$query	= "SELECT n.title FROM {node} n
LEFT JOIN {content_field_znacka} z ON n.nid = z.field_znacka_nid
WHERE z.nid = '$nid' ";
$znacka = db_result(db_query($query));	

$query1	= "SELECT n.title FROM {node} n
LEFT JOIN {content_field_ucinok} z ON n.nid = z.field_ucinok_nid
WHERE z.nid = '$nid' ";
$ucinok = db_result(db_query($query1));
$cart_items .= "{";
$cart_items .= 'item_name:' . '\'' . $product->title . '\',' . "\n";
$cart_items .= 'item_id:' . '\'' . $product->model . '\',' . "\n";
$cart_items .= 'price:' . '\'' . round($product->price,2) . '\',' . "\n";
$cart_items .= 'item_brand:' . '\'' . $znacka . '\',' . "\n";
$cart_items .= 'item_category:' . '\'' . split_title($ucinok,1) . '\',' . "\n";
$cart_items .= 'quantity:' . '\'' . $product->qty . '\',' . "\n";
$cart_items .= "},";
}
$layerscript = ' <script>
				dataLayer.push({
				event: \''  . $event . '\',
					  ecommerce: {
					  items: [
						' . $cart_items . '
					  ]
					  }			
				});
				</script>';
				
$vars['cart_datalayer']	= $layerscript;

//$vars['cart_upsell_view'] = views_embed_view('upsell_cart_pairs2', 'default');
}

  $vars['scripts'] = drupal_get_js();
$vars['styles'] = drupal_get_css(); 
  
}  



/**
 * @function fusion_core_clean_css_identifier()
 *   backport of drupal_clean_css_identifier() from Drupal 7.x
 *
 * @param $identifier
 *   the identifier to clean
 * @param $filter
 *   an array of string replacements to use on the identifier 
 *
 * @return
 *   A string safe for use as a CSS class or ID
 **/
 
 function clean_css_identifier($identifier, $filter = array(' ' => '-', '_' => '-', '/' => '-', '[' => '-', ']' => '')) {
 
   // By default, we filter using Drupal's coding standards.
   $identifier = strtr($identifier, $filter);
 
   // Valid characters in a CSS identifier are:
   // - the hyphen (U+002D)
   // - a-z (U+0030 - U+0039)
   // - A-Z (U+0041 - U+005A)
   // - the underscore (U+005F)
   // - 0-9 (U+0061 - U+007A)
   // - ISO 10646 characters U+00A1 and higher
   // We strip out any character not in the above list.
   $identifier = preg_replace('/[^\x{002D}\x{0030}-\x{0039}\x{0041}-\x{005A}\x{005F}\x{0061}-\x{007A}\x{00A1}-\x{FFFF}]/u', '', $identifier);
 
   return $identifier;
 
 }

 
 
 
 
/**
 * This function creates the NODES classes, like 'node-unpublished' for nodes
 * that are not published, or 'node-mine' for node posted by the connected user...
 *
 * @param $vars
 *  A sequential array of variables to pass to the theme template.
 * @param $hook
 *  The name of the theme function being called ("node" in this case.)
 */

function basic_preprocess_node(&$vars, $hook) {

//////////////////////////////////	
	$node  = $vars['node'];
  if (!empty($node)) {
    $vars['template_files'][] = "node-" . $node->nid;
  }
////////////////////////////////	
	//var_dump($vars);
	if ($vars['node']->type == 'kategoria') {
	$vars['kategoria_zoznam_produktov'] = views_embed_view('kateg_list2', 'default', $nid);
	}
	
	if ($vars['is_front']) {
   $vars['template_file'] = 'node-front';
};
if (arg(0) == 'product-rev') {
   $vars['template_file'] = 'product-reviews';
};

//taxonomia nepouzivam zatial ale funguje
	 if (arg(0) == 'taxonomy') {
    $suggestions = array(
      'node-taxonomy'
    );
    $vars['template_files'] = array_merge($vars['template_files'], $suggestions);
  } 
	
  // Special classes for nodes
  $classes = array('node');
  if ($vars['sticky']) {
    $classes[] = 'sticky';
  }
  // support for Skinr Module
  if (module_exists('skinr')) {
    $classes[] = $vars['skinr'];
  }
  if (!$vars['status']) {
    $classes[] = 'node-unpublished';
    $vars['unpublished'] = TRUE;
  }
  else {
    $vars['unpublished'] = FALSE;
  }
  if ($vars['uid'] && $vars['uid'] == $GLOBALS['user']->uid) {
    $classes[] = 'node-mine'; // Node is authored by current user.
  }
  if ($vars['teaser']) {
    $classes[] = 'node-teaser'; // Node is displayed as teaser.
  }
  $classes[] = 'clearfix';
  
  // Class for node type: "node-type-page", "node-type-story", "node-type-my-custom-type", etc.
  $classes[] = basic_id_safe('node-type-' . $vars['type']);
  $vars['classes'] = implode(' ', $classes); // Concatenate with spaces
  
  ///sharing buttons
$nid = $vars['node']->nid;
$node_title = $vars['node']->title;
$nodepath = 'https://'. ($_SERVER["HTTP_HOST"]) .'/'. $vars['node']->path;


$vars['node']->sharing_fb = '<a class="resp-sharing-button__link" href="https://facebook.com/sharer/sharer.php?u=' .$nodepath. '" target="_blank" rel="noopener nofollow" aria-label="Facebook">
  <div class="resp-sharing-button resp-sharing-button--facebook resp-sharing-button--medium"><div aria-hidden="true" class="resp-sharing-button__icon resp-sharing-button__icon--solid">
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M18.77 7.46H14.5v-1.9c0-.9.6-1.1 1-1.1h3V.5h-4.33C10.24.5 9.5 3.44 9.5 5.32v2.15h-3v4h3v12h5v-12h3.85l.42-4z"/></svg></div>Zdieľať</div>
</a>';

$vars['node']->sharing_email = '<a class="resp-sharing-button__link" href="mailto:?subject=' .$node_title. '&amp;body=' .$nodepath. '" target="_self" rel="noopener nofollow" aria-label="">
  <div class="resp-sharing-button resp-sharing-button--email resp-sharing-button--small"><div aria-hidden="true" class="resp-sharing-button__icon resp-sharing-button__icon--solid">
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M22 4H2C.9 4 0 4.9 0 6v12c0 1.1.9 2 2 2h20c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zM7.25 14.43l-3.5 2c-.08.05-.17.07-.25.07-.17 0-.34-.1-.43-.25-.14-.24-.06-.55.18-.68l3.5-2c.24-.14.55-.06.68.18.14.24.06.55-.18.68zm4.75.07c-.1 0-.2-.03-.27-.08l-8.5-5.5c-.23-.15-.3-.46-.15-.7.15-.22.46-.3.7-.14L12 13.4l8.23-5.32c.23-.15.54-.08.7.15.14.23.07.54-.16.7l-8.5 5.5c-.08.04-.17.07-.27.07zm8.93 1.75c-.1.16-.26.25-.43.25-.08 0-.17-.02-.25-.07l-3.5-2c-.24-.13-.32-.44-.18-.68s.44-.32.68-.18l3.5 2c.24.13.32.44.18.68z"/></svg>
    </div>
  </div>
</a>';
$vars['node']->sharing_whatsapp = '<a class="resp-sharing-button__link" href="whatsapp://send?text=' .$node_title. '%20' .$orig_path. '" target="_blank" rel="noopener nofollow" aria-label="">
  <div class="resp-sharing-button resp-sharing-button--whatsapp resp-sharing-button--small"><div aria-hidden="true" class="resp-sharing-button__icon resp-sharing-button__icon--solid">
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M20.1 3.9C17.9 1.7 15 .5 12 .5 5.8.5.7 5.6.7 11.9c0 2 .5 3.9 1.5 5.6L.6 23.4l6-1.6c1.6.9 3.5 1.3 5.4 1.3 6.3 0 11.4-5.1 11.4-11.4-.1-2.8-1.2-5.7-3.3-7.8zM12 21.4c-1.7 0-3.3-.5-4.8-1.3l-.4-.2-3.5 1 1-3.4L4 17c-1-1.5-1.4-3.2-1.4-5.1 0-5.2 4.2-9.4 9.4-9.4 2.5 0 4.9 1 6.7 2.8 1.8 1.8 2.8 4.2 2.8 6.7-.1 5.2-4.3 9.4-9.5 9.4zm5.1-7.1c-.3-.1-1.7-.9-1.9-1-.3-.1-.5-.1-.7.1-.2.3-.8 1-.9 1.1-.2.2-.3.2-.6.1s-1.2-.5-2.3-1.4c-.9-.8-1.4-1.7-1.6-2-.2-.3 0-.5.1-.6s.3-.3.4-.5c.2-.1.3-.3.4-.5.1-.2 0-.4 0-.5C10 9 9.3 7.6 9 7c-.1-.4-.4-.3-.5-.3h-.6s-.4.1-.7.3c-.3.3-1 1-1 2.4s1 2.8 1.1 3c.1.2 2 3.1 4.9 4.3.7.3 1.2.5 1.6.6.7.2 1.3.2 1.8.1.6-.1 1.7-.7 1.9-1.3.2-.7.2-1.2.2-1.3-.1-.3-.3-.4-.6-.5z"/></svg>
    </div>
  </div>
</a>';
  
// pocet hodnoteni na produkte
if ($vars['node']->type == 'product') {

	$hodnotenie_all = $vars['node']->field_hodnotenie['0']['value'];
	preg_match('/(.*)-(.*)/', $hodnotenie_all, $matches);
	
$vars['node']->hodnotenie_count = $matches[2];	
}
  
  
}


function basic_preprocess_comment_wrapper(&$vars) {
  $classes = array();
  $classes[] = 'comment-wrapper';
  
  // Provide skinr support.
  if (module_exists('skinr')) {
    $classes[] = $vars['skinr'];
  }
  $vars['classes'] = implode(' ', $classes);
}
 

/**
 * This function create the EDIT LINKS for blocks and menus blocks.
 * When overing a block (except in IE6), some links appear to edit
 * or configure the block. You can then edit the block, and once you are
 * done, brought back to the first page.
 *
 * @param $vars
 *  A sequential array of variables to pass to the theme template.
 * @param $hook
 *  The name of the theme function being called ("block" in this case.)
 */ 

function basic_preprocess_block(&$vars, $hook) {
  $block = $vars['block'];

  // special block classes
  $classes = array('block');
  //$classes[] = basic_id_safe('block-' . $vars['block']->module);
  //$classes[] = basic_id_safe('block-' . $vars['block']->region);
 // $classes[] = basic_id_safe('block-id-' . $vars['block']->bid);
  //$classes[] = 'clearfix';
  
  
  $vars['block_classes1'] = implode(' ', $classes); // Concatenate with spaces

  if (theme_get_setting('basic_block_editing') && user_access('administer blocks')) {
    // Display 'edit block' for custom blocks.
    if ($block->module == 'block') {
      $edit_links[] = l('<span>' . t('edit block') . '</span>', 'admin/build/block/configure/' . $block->module . '/' . $block->delta,
        array(
          'attributes' => array(
            'title' => t('edit the content of this block'),
            'class' => 'block-edit',
          ),
          'query' => drupal_get_destination(),
          'html' => TRUE,
        )
      );
    }
    // Display 'configure' for other blocks.
    else {
      $edit_links[] = l('<span>' . t('configure') . '</span>', 'admin/build/block/configure/' . $block->module . '/' . $block->delta,
        array(
          'attributes' => array(
            'title' => t('configure this block'),
            'class' => 'block-config',
          ),
          'query' => drupal_get_destination(),
          'html' => TRUE,
        )
      );
    }
    // Display 'edit menu' for Menu blocks.
    if (($block->module == 'menu' || ($block->module == 'user' && $block->delta == 1)) && user_access('administer menu')) {
      $menu_name = ($block->module == 'user') ? 'navigation' : $block->delta;
      $edit_links[] = l('<span>' . t('edit menu') . '</span>', 'admin/build/menu-customize/' . $menu_name,
        array(
          'attributes' => array(
            'title' => t('edit the menu that defines this block'),
            'class' => 'block-edit-menu',
          ),
          'query' => drupal_get_destination(),
          'html' => TRUE,
        )
      );
    }
    // Display 'edit menu' for Menu block blocks.
    elseif ($block->module == 'menu_block' && user_access('administer menu')) {
      list($menu_name, ) = split(':', variable_get("menu_block_{$block->delta}_parent", 'navigation:0'));
      $edit_links[] = l('<span>' . t('edit menu') . '</span>', 'admin/build/menu-customize/' . $menu_name,
        array(
          'attributes' => array(
            'title' => t('edit the menu that defines this block'),
            'class' => 'block-edit-menu',
          ),
          'query' => drupal_get_destination(),
          'html' => TRUE,
        )
      );
    }
    $vars['edit_links_array'] = $edit_links;
    $vars['edit_links'] = '<div class="edit">' . implode(' ', $edit_links) . '</div>';
  }

}

/**
 * Override or insert PHPTemplate variables into the block templates.
 *
 * @param $vars
 *  An array of variables to pass to the theme template.
 * @param $hook
 *  The name of the template being rendered ("comment" in this case.)
 */

function basic_preprocess_comment(&$vars, $hook) {
  // Add an "unpublished" flag.
  $vars['unpublished'] = ($vars['comment']->status == COMMENT_NOT_PUBLISHED);

  // If comment subjects are disabled, don't display them.
  if (variable_get('comment_subject_field_' . $vars['node']->type, 1) == 0) {
    $vars['title'] = '';
  }

  // Special classes for comments.
  $classes = array('comment');
  if ($vars['comment']->new) {
    $classes[] = 'comment-new';
  }
  $classes[] = $vars['status'];
  $classes[] = $vars['zebra'];
  if ($vars['id'] == 1) {
    $classes[] = 'first';
  }
  if ($vars['id'] == $vars['node']->comment_count) {
    $classes[] = 'last';
  }
  if ($vars['comment']->uid == 0) {
    // Comment is by an anonymous user.
    $classes[] = 'comment-by-anon';
  }
  else {
    if ($vars['comment']->uid == $vars['node']->uid) {
      // Comment is by the node author.
      $classes[] = 'comment-by-author';
    }
    if ($vars['comment']->uid == $GLOBALS['user']->uid) {
      // Comment was posted by current user.
      $classes[] = 'comment-mine';
    }
  }
  $vars['classes'] = implode(' ', $classes);
}

/**
 * Customize the PRIMARY and SECONDARY LINKS, to allow the admin tabs to work on all browsers
 * An implementation of theme_menu_item_link()
 *
 * @param $link
 * 	array The menu item to render.
 * @return
 * 	string The rendered menu item.
 */ 	

function basic_menu_item_link($link) {
	//prida ikony namiesto textu vo footeri do social odakzov
	$yt = '<svg class="svg-icon" viewBox="0 0 20 20">
							<path fill="none" d="M9.426,7.625h0.271c0.596,0,1.079-0.48,1.079-1.073V4.808c0-0.593-0.483-1.073-1.079-1.073H9.426c-0.597,0-1.079,0.48-1.079,1.073v1.745C8.347,7.145,8.83,7.625,9.426,7.625 M9.156,4.741c0-0.222,0.182-0.402,0.404-0.402c0.225,0,0.405,0.18,0.405,0.402V6.62c0,0.222-0.181,0.402-0.405,0.402c-0.223,0-0.404-0.181-0.404-0.402V4.741z M12.126,7.625c0.539,0,1.013-0.47,1.013-0.47v0.403h0.81V3.735h-0.81v2.952c0,0-0.271,0.335-0.54,0.335c-0.271,0-0.271-0.202-0.271-0.202V3.735h-0.81v3.354C11.519,7.089,11.586,7.625,12.126,7.625 M6.254,7.559H7.2v-2.08l1.079-2.952H7.401L6.727,4.473L6.052,2.527H5.107l1.146,2.952V7.559z M11.586,12.003c-0.175,0-0.312,0.104-0.405,0.204v2.706c0.086,0.091,0.213,0.18,0.405,0.18c0.405,0,0.405-0.451,0.405-0.451v-2.188C11.991,12.453,11.924,12.003,11.586,12.003 M14.961,8.463c0,0-2.477-0.129-4.961-0.129c-2.475,0-4.96,0.129-4.96,0.129c-1.119,0-2.025,0.864-2.025,1.93c0,0-0.203,1.252-0.203,2.511c0,1.252,0.203,2.51,0.203,2.51c0,1.066,0.906,1.931,2.025,1.931c0,0,2.438,0.129,4.96,0.129c2.437,0,4.961-0.129,4.961-0.129c1.117,0,2.024-0.864,2.024-1.931c0,0,0.202-1.268,0.202-2.51c0-1.268-0.202-2.511-0.202-2.511C16.985,9.328,16.078,8.463,14.961,8.463 M7.065,10.651H6.052v5.085H5.107v-5.085H4.095V9.814h2.97V10.651z M9.628,15.736h-0.81v-0.386c0,0-0.472,0.45-1.012,0.45c-0.54,0-0.606-0.515-0.606-0.515v-3.991h0.809v3.733c0,0,0,0.193,0.271,0.193c0.27,0,0.54-0.322,0.54-0.322v-3.604h0.81V15.736z M12.801,14.771c0,0,0,1.03-0.742,1.03c-0.455,0-0.73-0.241-0.878-0.429v0.364h-0.876V9.814h0.876v1.92c0.135-0.142,0.464-0.439,0.878-0.439c0.54,0,0.742,0.45,0.742,1.03V14.771z M15.973,12.39v1.287h-1.688v0.965c0,0,0,0.451,0.405,0.451s0.405-0.451,0.405-0.451v-0.45h0.877v0.708c0,0-0.136,0.901-1.215,0.901c-1.08,0-1.282-0.901-1.282-0.901v-2.51c0,0,0-1.095,1.282-1.095S15.973,12.39,15.973,12.39 M14.69,12.003c-0.405,0-0.405,0.45-0.405,0.45v0.579h0.811v-0.579C15.096,12.453,15.096,12.003,14.69,12.003"></path>
						</svg>';	
$fb = '<svg class="svg-icon" viewBox="0 0 20 20">
							<path fill="none" d="M11.344,5.71c0-0.73,0.074-1.122,1.199-1.122h1.502V1.871h-2.404c-2.886,0-3.903,1.36-3.903,3.646v1.765h-1.8V10h1.8v8.128h3.601V10h2.403l0.32-2.718h-2.724L11.344,5.71z"></path>
						</svg>';
$ig = '<svg class="svg-icon" viewBox="0 0 20 20">
							<path fill="none" d="M14.52,2.469H5.482c-1.664,0-3.013,1.349-3.013,3.013v9.038c0,1.662,1.349,3.012,3.013,3.012h9.038c1.662,0,3.012-1.35,3.012-3.012V5.482C17.531,3.818,16.182,2.469,14.52,2.469 M13.012,4.729h2.26v2.259h-2.26V4.729z M10,6.988c1.664,0,3.012,1.349,3.012,3.012c0,1.664-1.348,3.013-3.012,3.013c-1.664,0-3.012-1.349-3.012-3.013C6.988,8.336,8.336,6.988,10,6.988 M16.025,14.52c0,0.831-0.676,1.506-1.506,1.506H5.482c-0.831,0-1.507-0.675-1.507-1.506V9.247h1.583C5.516,9.494,5.482,9.743,5.482,10c0,2.497,2.023,4.52,4.518,4.52c2.494,0,4.52-2.022,4.52-4.52c0-0.257-0.035-0.506-0.076-0.753h1.582V14.52z"></path>
						</svg>';						
if ($link['title'] == 'Facebook'){				
		$link['title'] = $fb;
		$link['localized_options']['html'] = TRUE;
	}
if ($link['title'] == 'Youtube'){				
		$link['title'] = $yt;
		$link['localized_options']['html'] = TRUE;
	}	
if ($link['title'] == 'Instagram'){				
		$link['title'] = $ig;
		$link['localized_options']['html'] = TRUE;
	}
  if (empty($link['localized_options'])) {
    $link['localized_options'] = array();
  }

  // If an item is a LOCAL TASK, render it as a tab
  if ($link['type'] & MENU_IS_LOCAL_TASK) {
    $link['title'] = '<span class="tab">' . check_plain($link['title']) . '</span>';
    $link['localized_options']['html'] = TRUE;
  }

  return l($link['title'], $link['href'], $link['localized_options']);
}


/**
 * Duplicate of theme_menu_local_tasks() but adds clear-block to tabs.
 */

function basic_menu_local_tasks() {
  $output = '';
  if ($primary = menu_primary_local_tasks()) {
    if(menu_secondary_local_tasks()) {
      $output .= '<ul class="tabs primary with-secondary clearfix">' . $primary . '</ul>';
    }
    else {
      $output .= '<ul class="tabs primary clearfix">' . $primary . '</ul>';
    }
  }
  if ($secondary = menu_secondary_local_tasks()) {
    $output .= '<ul class="tabs secondary clearfix">' . $secondary . '</ul>';
  }
  return $output;
}


/**
 *	Converts a string to a suitable html ID attribute.
 *	
 *	 http://www.w3.org/TR/html4/struct/global.html#h-7.5.2 specifies what makes a
 *	 valid ID attribute in HTML. This function:
 *	
 *	- Ensure an ID starts with an alpha character by optionally adding an 'n'.
 *	- Replaces any character except A-Z, numbers, and underscores with dashes.
 *	- Converts entire string to lowercase.
 *	
 *	@param $string
 *	 The string
 *	@return
 *	 The converted string
 */	

function basic_id_safe($string) {
  // Replace with dashes anything that isn't A-Z, numbers, dashes, or underscores.
  $string = strtolower(preg_replace('/[^a-zA-Z0-9_-]+/', '-', $string));
  // If the first character is not a-z, add 'n' in front.
  if (!ctype_lower($string{0})) { // Don't use ctype_alpha since its locale aware.
    $string = 'id'. $string;
  }
  return $string;
}

/**
 * Return a themed breadcrumb trail.
 *
 * @param $breadcrumb
 *  An array containing the breadcrumb links.
 * @return
 *  A string containing the breadcrumb output.
 */
function basic_breadcrumb($breadcrumb) {
  // Determine if we are to display the breadcrumb.
  $show_breadcrumb = theme_get_setting('basic_breadcrumb');
  if ($show_breadcrumb == 'yes' || $show_breadcrumb == 'admin' && arg(0) == 'admin') {

    // Optionally get rid of the homepage link.
    $show_breadcrumb_home = theme_get_setting('basic_breadcrumb_home');
    if (!$show_breadcrumb_home) {
      array_shift($breadcrumb);
    }

    // Return the breadcrumb with separators.
    if (!empty($breadcrumb)) {
      $breadcrumb_separator = theme_get_setting('basic_breadcrumb_separator');
      $trailing_separator = $title = '';
      if (theme_get_setting('basic_breadcrumb_title')) {
        if ($title = drupal_get_title()) {
          $trailing_separator = $breadcrumb_separator;
        }
      }
      elseif (theme_get_setting('basic_breadcrumb_trailing')) {
        $trailing_separator = $breadcrumb_separator;
      }
      return '<div class="breadcrumb">' . implode($breadcrumb_separator, $breadcrumb) . "$trailing_separator$title</div>";
    }
  }
  // Otherwise, return an empty string.
  return '';
}

//function basic_button($element) {
  // Make sure not to overwrite classes.
//  if (isset($element['#attributes']['class'])) {
//    $element['#attributes']['class'] = 'form-' . $element['#button_type'] . ' ' . $element['#attributes']['class'];
//  }
//  else {
//    $element['#attributes']['class'] = 'form-' . $element['#button_type'];
//  }
//
//  return '<span class="button"><span><input type="submit" ' . (empty($element['#name']) ? '' : 'name="' . $element['#name'] . 
//
//'" ') . 'id="' . $element['#id'] . '" value="' . check_plain($element['#value']) . '" ' . drupal_attributes($element['#attributes']) .' /></span></span>';
//}

/*prebrate z uc cart block*/
function basic_uc_cart_block_content_cachable() {
  return t('<span class="cartnojava">Pre nakupovanie nie je nutná registácia</span><p><a href="!url" style="color:#3C78A7">Otvoriť</a> nákupný košík.', array('!url' => url('cart')));
}

/**
 * Resize the body field - nefunguje
 **/
//function phptemplate_textarea($element) {
 // if ($element['#name'] =='panes[uc_discounts][uc-discounts-codes]' || 'panes[comments][comments]' ) {
  //  $element['#rows'] = 2;
   //  } 
  //return theme_textarea($element);
//}

/*fivestar google snippet*/
function basic_fivestar_summary($user_rating, $average_rating, $votes, $stars = 5, $feedback = TRUE) {
  $output = '';
  $div_class = '';
  if (isset($user_rating)) {
    $div_class = isset($votes) ? 'user-count' : 'user';
    $user_stars = round(($user_rating * $stars) / 100, 1);
    $output .= '<span class="user-rating">'. t('Your rating: <span>!stars</span>', array('!stars' => $user_rating ? $user_stars : t('None'))) .'</span>';
  }
  if (isset($user_rating) && isset($average_rating)) {
    $output .= ' ';
  }
  if (isset($average_rating)) {
    $div_class = isset($votes) ? 'average-count' : 'average';
    $average_stars = round(($average_rating * $stars) / 100, 1);
	//musim liadnut celu nudu kvoil nazvu, prijebane
	if ( arg(0) == 'node' && is_numeric(arg(1)) ) {
    $node = node_load(arg(1));
    $node_title = $node->title;
}
    $output .= '<div itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating"><span itemprop="name">' . $node_title . ' </span>'. t('Priemerné hodnotenie: <span itemprop="ratingValue"> !stars', array('!stars' => $average_stars)) .'</span>';
  }
  if (isset($user_rating) && isset($average_rating)) {
    $div_class = 'combo';
  }

  if (isset($votes) && !(isset($user_rating) || isset($average_rating))) {
    $output .= format_plural($votes, '<span itemprop="ratingCount"> @count</span> hodnotení', '<span itemprop="ratingCount"> @count</span> hodnotení') .'<meta itemprop="bestRating" content="5" />
    <meta itemprop="worstRating" content="1" />
    <div itemprop="itemReviewed" itemscope itemtype="http://schema.org/CreativeWork"></div></div>';
    $div_class = 'count';
  }
  elseif (isset($votes)) {
    $output .= format_plural($votes, '<span itemprop="ratingCount"> @count</span> hodnotení', '<span itemprop="ratingCount"> @count</span> hodnotení') .'<meta itemprop="bestRating" content="5" />
    <meta itemprop="worstRating" content="1" />
    <div itemprop="itemReviewed" itemscope itemtype="http://schema.org/CreativeWork"></div></div>';
  }

  if ($votes === 0) {
    $output = '<span class="empty">'. t('Bez hodnotenia') .'</span>';
  }

  $output = '<div class="fivestar-summary fivestar-summary-'. $div_class . ($feedback ? ' fivestar-feedback-enabled' : '') .'">'. $output .'</div>';
  return $output;
}

function basic_uc_cart_view_form($form) {

  drupal_add_css(drupal_get_path('module', 'uc_cart') .'/uc_cart.css');
  
$pocet_produktov = count(uc_cart_get_contents());
//var_dump($form['items']['1']['desc']['#value'] .=);
//vyhodim total z tabulky a doplnim ho pod nu
foreach (element_children($form['items']) as $i) {
	//subtotal_row - znacka doplnena v uc_cart module aby som ju mohol najst a vybrat
	  if ($form['items'][$i]['total']['#typ'] == 'subtotal_row') {	 
	  $total_value = $form['items'][$i]['total']['#value'];
	//  var_dump($form['items'][$i]['total']);
	 unset($form['items'][$i]['total']);	 
	 
 }
}
//$form['checkout']['#value'] = 'Do pokladne'; - nefunguje preklik do checkoutu ak zmenim tu
$form['checkout']['#attributes']['class'] = '_width100 btn-loader pozriet btn-color-1';
$form['checkout']['#button_type'] = 'button';
$form['continue_shopping']['#attributes']['class'] = '_width100';




//doplneny wraper na discount code
 
  
  if (!$_SESSION['uc_discounts_codes']) {
	   //$input_btn = '<input class="form-submit _posAbs" id="uc-discounts-button" name="op" type="button" value="Aktivovať" />';
	    $input_btn = '<button class="form-submit _posAbs" id="uc-discounts-button" name="op" type="button" value="Aktivovať">Overiť</button>';
	   
		 $discount_form = '<div class="textfield_wrapper form-item" id="uc-discounts-codes-wrapper">
	<label class="field_label textfield_label" for="uc-discounts-codes"><small>Vložte zľavový kód</small></label> <div class="input-wrap _posRel"><input class="form-text _width100" id="uc-discounts-codes" maxlength="128" name="code" size="30" type="text" value="" placeholder="Tu vložte kód"/>'.$input_btn.'</div></div>';
	  $discount_html = '<div id="discount-code-wrap" class="_alignLeft _noPadding col d4 m8 mm6"><a class="slide-toggle v1">Mám kupón</a><div class="x-panel _noPadding" style="display:none;">'.$discount_form.'</div></div><div class="_clear"></div>';
	 
  }

  

  
 //total row nech sa v carte nezobrazuje ak session obsahuje discount - nebude to preblikavat kvoli js
 if (!($_SESSION['uc_discounts_exists'])) {
	$total_row = '<div class="total_row _alignRight"><div>'. $total_value .'</div></div>';
 }

  $output = '<div id="cart-form-productz" class="'.$pocet_produktov.'">'
          . drupal_render($form['items']) .'</div>';


$output .= $discount_html;		  
 $output .= $total_row;
 
 
 
 
 
  foreach (element_children($form['items']) as $i) {
	  
    foreach (array('title', 'options', 'remove', 'image', 'qty') as $column) {
      $form['items'][$i][$column]['#printed'] = TRUE;
    }
    $form['items'][$i]['#printed'] = TRUE;
	
  }
  

  // Add the continue shopping element and cart submit buttons.
  if (($type = variable_get('uc_continue_shopping_type', 'link')) != 'none') {
    // Render the continue shopping element into a variable.
    $cs_element = drupal_render($form['continue_shopping']);
 
    // Add the element with the appropriate markup based on the display type.
    if ($type == 'link') {
      $output .= '<div id="cart-form-buttons" class=""><div id="continue-shopping-link">'
               . $cs_element .'</div>'. drupal_render($form) .'</div>';
    }
    elseif ($type == 'button') {
      $output .= '<div id="cart-form-buttons" class=""><div class="col mm4 d3 _noPadding _hide-mobile _hide-tablet _noPadding"><div id="continue-shopping-btn">'
               . $cs_element .'</div></div><div class="col m3 mm4 d6 _hide-mobile"></div><div class="col m6 mm4 d3 _noPadding"><div id="update-checkout-buttons">'
               . drupal_render($form) .'</div>
			   
			   </div><div class="_clear"></div></div>
			   ';
    }
  }
  else {
    $output .= '<div id="cart-form-buttons"><div class="col m3 mm8 d9"></div><div class="col m6 mm4 d3 _noPadding">'. drupal_render($form) .'</div></div><div class="_clear"></div>';
  }
 
  return $output;
}
// checkout review zmeny 
//funkcia z uc_cart_pages.inc.php 
//cca 395r. zmena aby $panes mali v array anglicky nazov.
// + zmena v uc_discounts.module 775r - vyhodeteny riadok total
// + zmena v uc_checkout_tweaks.module 345r
function basic_uc_cart_checkout_review($panes, $form) {
	//var_dump($panes);
  drupal_add_css(drupal_get_path('module', 'uc_cart') .'/uc_cart.css');

  $output = check_markup(variable_get('uc_checkout_review_instructions', uc_get_message('review_instructions')), variable_get('uc_checkout_review_instructions_format', FILTER_FORMAT_DEFAULT), FALSE);
  
   $output .= '<div class="row wrap mt-1">';
  //submit button nad tabulkou		   
 $output .= '<div class="col mobile_noPadding _hide-desktop"><div class="review-button">'. $form .'</div></div>';
 
  //ak bankovy prevod tak ukaz detaily
  if ($panes['uc_checkout_tweaks_pane_payment']['1']) {
	  $output .= '<div class="col d12 mobile_noPadding">';
	  $output .= '<table id="review-table1" class="order-review-table1 card">';
	  $output .= '<tr class="pane-title-row"><td colspan="2">Údaje pre bankový prevod</tr></td>';
	  $output .= '<tr class="order inff"><td>'.$panes['uc_checkout_tweaks_pane_payment']['1']['data'].'</td></tr>';
	  $output .= '</table>';
	  $output .= '</div>';  
  }; 
 
//////tabulka1 
   $output .= '<div class="col d6 mobile_noPadding">';
  $output .= '<table id="review-table2" class="order-review-table1 card">';
  //tabulka nadpis
  $output .= '<tr class="pane-title-row"><td colspan="2">Údaje pre odoslanie</td></tr>';
  //doprava
  foreach ($panes['uc_checkout_tweaks_pane_preview'] as $dat) {
	  if ($dat['typ'] == 'shipping') {
		$output .= '<tr valign="top"><td class="meno">Spôsob dopravy</td><td class="popis">'.$dat['title'].'</td></tr>';
	  };
	};
  //platba
 if ($panes['uc_checkout_tweaks_pane_payment']['0']['method'] == 'cod') {
  $doplnkovy_text = '(platba pri prevzatí)';
  } elseif ($panes['uc_checkout_tweaks_pane_payment']['0']['method'] == 'gpwebpay_wps') {
	  $panes['uc_checkout_tweaks_pane_payment']['0']['data'] = 'Kartou online';
  }
  $output .= '<tr><td class="meno">'.$panes['uc_checkout_tweaks_pane_payment']['0']['title'].'</td><td class="popis">'.$panes['uc_checkout_tweaks_pane_payment']['0']['data'].' '.$doplnkovy_text.'</td></tr>';
  
  //email
  $output .= '<tr><td class="meno">'.$panes['uc_checkout_pane_customer']['0']['title'].'</td><td class="popis">'.$panes['uc_checkout_pane_customer']['0']['data'].'</td></tr>';
  
  //tel
  $output .= '<tr><td class="meno">Tel. číslo</td><td class="popis">'.$panes['uc_addresses_checkout_pane_shipping']['phone']['data'].'</td></tr>';
  
  //adresy
  $output .= '<tr class="pane-title-row"><td colspan="2">Adresa pre doručenie</td></tr>';
  $output .= '<tr><td colspan="2">'.$panes['uc_addresses_checkout_pane_shipping']['address']['data'].'</td></tr>';
  
  //ak su adr rovnake - nezobrazuj billing
	if ($panes['uc_addresses_checkout_pane_shipping'] != $panes['uc_addresses_checkout_pane_billing']){
	$output .= '<tr class="pane-title-row"><td colspan="2">Fakturačná adresa</td></tr>';
	$output .= '<tr><td colspan="2">'.$panes['uc_addresses_checkout_pane_billing']['address']['data'].'</td></tr>';
	};
  //poznamka
  if ($panes['uc_checkout_pane_comments']){
  $output .= '<tr class="pane-title-row"><td colspan="2">Poznámka k objedávke</td></tr>';
  $output .= '<tr><td colspan="2">'.$panes['uc_checkout_pane_comments']['0']['data'].'</td></tr>';
  };
  
  
  $output .= '</table>';
  $output .= '</div>';

///////////tabulka2
  $output .= '<div class="col d6 mobile_noPadding">';
  $output .= '<table id="review-table1" class="order-review-table1 card">';
  $output .= '<tr class="pane-title-row"><td colspan="2">Váš nákup</tr></td>';
  $output .= '<tr><td class="product-list" colspan="2">'.$panes['uc_discounts_checkout_pane_content']['0'].'</td></tr>';
  
  foreach ($panes['uc_checkout_tweaks_pane_preview'] as $dat) {
	  //vyhodeny medzisucet
	  if ($dat['typ'] != 'subtotal') {
		  if ($dat['typ'] == 'shipping') {
			  $output .= '<tr><td>Doprava</td><td class="price">' .$dat['data']. '</td></tr>';
		  };
		  if ($dat['id'] == 'total') {
			  $output .= '<tr><td></td></tr>';
			  $output .= '<tr class="total-row"><td>Celkom k úhrade</td><td class="price">' .$dat['data']. '</td></tr>';
		  };
	  };
	};
  $output .= '<tr><td colspan="2">'. $form .'</tr></td>';
  
  
  $output .= '</table>';
   //submit button pod tabulkou		   
 //$output .= '<div class="col d6 mobile_noPadding mt-1"><div class="review-button">'. $form .'</div></div>';
  
  $output .= '</div>';


  
 
  
 $output .= '</div>';
  

  return $output;
}
//////////////////////////////////////////////////////////////////////////
//overridnuty radio label aby bol pod radiom nie okolo neho
/*function basic_radio($element) {
	//var_dump($element);
  _form_set_class($element, array(
    'form-radio',
  ));
  $output = '<input type="radio" ';
  $output .= 'id="' . $element['#id'] . '" ';
  $output .= 'name="' . $element['#name'] . '" ';
  $output .= 'value="' . $element['#return_value'] . '" ';
  $output .= check_plain($element['#value']) == $element['#return_value'] ? ' checked="checked" ' : ' ';
  $output .= drupal_attributes($element['#attributes']) . ' />';
  if (!is_null($element['#title'])) {
//$output = '<label class="option" for="' . $element['#id'] . '">' . $output . ' ' . $element['#title'] . '</label>';
$output = $output . ' <label class="option" for="' . $element['#id'] . '"> ' . $element['#title'] . '</label>';
  }
  unset($element['#title']);
  return theme('form_element', $element, $output);
}*/


function basic_uc_cart_checkout_form($form) {
	
	$form['continue']['#button_type'] = 'button';
	$form['continue']['#attributes']['class'] = 'btn-loader pozriet btn-color-1';
	
	//discounts pane musi byt aktivna ale je skryta. vkladanie kodu je v cart
$form['panes']['uc_discounts']['#attributes']['class'] = '_hidden';

	unset($form['panes']['payment']['#type']);
	//$form['panes']['payment']['#type'] = 'markup';
	unset($form['panes']['simple_quote']['#type']);	
	unset($form['panes']['customer']['#type']);	
	unset($form['panes']['delivery']['#type']);
	unset($form['panes']['billing']['#type']);
	unset($form['panes']['checkout_preview']['#type']);
	unset($form['panes']['cart']['#type']);
	unset($form['panes']['payment']['payment_method']['#title']);
	unset($form['panes']['comments']['#type']);
	
	  /*global $user;
if (!(in_array('tester', $user->roles))  ){
  unset($form['panes']['payment']['payment_method']['gpwebpay_wps']);
  }*/
	
	
	$country_data = uc_get_country_data($match = array(), $sort = 'country_name');
	$home_country = 703; //CZ
	//var_dump($country_data);
	foreach ($country_data as $c) {
		if ($c[country_id] == $home_country) {
			$home_select = '<option value="' . $c[country_id] . '" selected="selected">' . t($c[country_name]) . '</option>';
		} else {
			$country_options .= '<option value="' . $c[country_id] . '">' . t($c[country_name]) . '</option>';
		}
	}
	$country_options = $home_select . $country_options;
  
  $form['panes']['customer']['#prefix'] = '<div class="col d7 mobile_noPadding"><div id="email-pane" class="email-wrap mb-1 col cardd"><div class = "panetitletext _f-infox ">Email</div><div class="panedesc mt-1 mb-1 _alignCenter">'. $form['panes']['customer']['#description'].'</div><div class="wrap">' ;

	$form['panes']['customer']['#suffix'] = '</div></div><div class="_clear"></div>';
  
  
  $form['panes']['payment']['#prefix'] = '<div id="payment-pane" class="payment-wrap mb-1 cardd"><div class = "panetitletext _f-infox "><span class="titlesel">Spôsob platby</span></div><div class="wrap">';
	$form['panes']['payment']['#suffix'] = '</div></div>';
	
	$form['panes']['simple_quote']['#prefix'] = '<div id="simple_quote-pane" class="delivery-wrap mb-1 cardd"><div class = "panetitletext _f-infox "><span class="titlesel">Spôsob dopravy</span></div>
	<label for="d-country">Vyberte krajinu doručenia zo zoznamu</label>
<select name="d-countr" id="d-countr">
  ' . $country_options . '
</select> 
	<div class="wrap"><div class="panedesc p-1">'. $form['panes']['simple_quote']['#description'] .'</div>' ;
	$form['panes']['simple_quote']['#suffix'] = '</div></div>';
	
	
	$form['panes']['delivery']['#prefix'] = '<div id="address-pane" class="customer-wrap mb-1 col cardd"><div class = "panetitletext _f-infox ">Adresa pre doručenie</div><div id="delivery-pane">';
	$form['panes']['delivery']['#suffix'] = '</div>';
	
	//pridam checkbox ktory ovlada billing checkbox (nepaci sa mi ze je to naopak - zafajknute od zaciatku)
	
	$form['panes']['billing']['#prefix'] = '<div id="billing-pane">';
	$form['panes']['billing']['#prefix'] .= '<input type="checkbox" id="billing_checkbox" class="billing-checkbox"><label style="display: inline;" for="billing_checkbox"> Chcem doplniť fakturačnú adresu</label><div>';
	
	$form['panes']['billing']['#suffix'] = '</div></div></div></div>';
	
		//uprava html fieldov u customera
	 $form['panes']['customer']['primary_email']['#hideformitem'] = TRUE;
	  $form['panes']['customer']['primary_email_confirm']['#hideformitem'] = TRUE;

	$form['panes']['cart']['#prefix'] = '<div class="col d5 mobile_noPadding stickey">
	<div class="_alignLeft _hide-mobile _hide-tablet _hide-tablet2 mb-1 _hidden">
			   <div class="_inline-block"><img style="height:25px;" class="resp" src="/files/misc/biome-heureka-min.png"></div>
			   <div class="_inline-block"><img style="height:25px;" class="resp" src="/files/misc/biome_bezp_naku.png"></div>
			   </div>
	<div class="preview-wrap mb-1 card col"><div class="panetitletext _f-infox "><span class="titlesel">' .$form['panes']['cart']['#title'].'</div>';
	$form['panes']['checkout_preview']['#suffix'] = '</div>';
	$form['panes']['uc_discounts']['#suffix'] = '</div>';
	
	//var_dump($form);
	//$form['panes']['customer']['primary_email']['#attributes']['placeholder'] = $form['panes']['customer']['primary_email']['#title'];
	
	//var_dump($form['panes']['customer']['primary_email']);
	$form['panes']['comments']['#prefix'] = '<div class="col"><input type="checkbox" id="comment_checkbox" class="checkout-checkbox"><label style="display: inline;" for="comment_checkbox"> Pridať poznámku k objednávke</label><div style="display:none;">' . $form['panes']['comments']['#description'];
	$form['panes']['comments']['#suffix'] = '</div></div>';
	
	drupal_add_js("\$(document).ready( function () { 
$('.checkout-checkbox:checkbox').change(function() {
	console.log('ehcekbox');
    // use the :checked selector to find any that are checked
	if  ($(this).is(':checked')) {
		 $(this).siblings('div').slideDown('slow');
	} else {
		$(this).siblings('div').slideUp('slow');
	}
    
 });

 if  ($('#edit-panes-billing-copy-address:checkbox').is(':checked')) {
		$('.billing-checkbox:checkbox').attr('checked', false);
	} else {
		$('.billing-checkbox:checkbox').attr('checked', true);
	}
 $('#edit-panes-billing-copy-address-wrapper').css('display','none');
	$('.billing-checkbox:checkbox').change(function() {
	if  ($(this).is(':checked')) {
		 $('#edit-panes-billing-copy-address').click();
	} else {
		$('#edit-panes-billing-copy-address').click();
	}
    
 });
 
 
	} );", 'inline');
	
	
  drupal_add_css(drupal_get_path('module', 'uc_cart') .'/uc_cart.css');

  $output = '<div id="checkout-instructions">'. check_markup(variable_get('uc_checkout_instructions', ''), variable_get('uc_checkout_instructions_format', FILTER_FORMAT_DEFAULT), FALSE) .'</div>';

  $output .= '<div class="row">';
  
  foreach (element_children($form['panes']) as $pane_id) {
		
    if (function_exists(($func = _checkout_pane_data($pane_id, 'callback')))) {
      $result = $func('theme', $form['panes'][$pane_id], NULL);
      if (!empty($result)) {
        $output .= $result;
        $form['panes'][$pane_id] = array();
				
      }
      else {
        $output .= drupal_render($form['panes'][$pane_id]);
      }
    }
    else {
      $output .= drupal_render($form['panes'][$pane_id]);
    }
  }

$output .= '</div>'; //row
  $output .= '<div id="checkout-form-bottom">'. drupal_render($form) .'</div>
  <div class="checkout-payment-assr cntr _hide-desktop" style="max-width:326px;">
 <div class="responsively-lazy" style="padding-bottom:20.4%;">
	<img src="/files/misc/biome_pay_logo-min.png" alt="Biome platobné možnosti" class="loaded"></div></div>
  ';

  

  return $output;
}
//prebrate z uc_discount
function basic_uc_discounts_cart_checkout_table($show_subtotal = FALSE) {
  $subtotal = 0;

  $discount_amount = uc_discounts_get_discount_amount_for_order('checkout');
  // Set up table header.
 /* $header = array(
    array('data' => '', 'class' => 'qty'),
    array('data' => t('Products'), 'class' => 'products'),
    array('data' => t('Price'), 'class' => 'price'),
  );*/

  $context = array();

  // Set up table rows.
  $contents = uc_cart_get_contents();
   
  foreach ($contents as $item) {
	  
    $price_info = array(
      'price' => $item->price,
      'qty' => $item->qty,
    );


    $context['revision'] = 'altered';
    $context['type'] = 'cart_item';
    $context['subject'] = array(
      'cart' => $contents,
      'cart_item' => $item * $discount_amount,
      'node' => node_load($item->nid),
    );

    $total = uc_price($price_info, $context);
	
    $subtotal += $total;

    $description = check_plain($item->title) . uc_product_get_description($item);

	$nid = $item->nid;
    //ak existuje zlava ku konkretnemu produktu, tak total je zlaveny total
	$total_row_disc = FALSE;
	$total_row = uc_price($item->price * $item->qty);
	
     if ($_SESSION['uc_discounts_product_discount'][$nid])
      {
	
	$total_row = '<del class="_f-danger">' . uc_price($item->price * $item->qty) . '</del> ';
	//celkova zlava na 1 riadku
    $total_row_disc = uc_price((($item->price) - ($_SESSION['uc_discounts_product_discount'][$nid])) * $item->qty);
         // var_dump($item);                                       
    }
	
	
	
    // Remove node from context to prevent the price from being altered.
    $context['revision'] = 'themed-original';
    $context['type'] = 'amount';
    unset($context['subject']);
	
	//rozdelujem a spajam array aby boli discounty na konci
	if (!$item->data['discount']){
		$rows_nodiscount[] = array(
      array('data' => t('@qty&times;', array('@qty' => $item->qty)), 'class' => 'qty'),
      array('data' => $description, 'class' => 'products'),
     // array('data' => uc_price($total, $context), 'class' => 'price'),
	 array('data' => $total_row . $total_row_disc, 'class' => 'price'),
	  
    );
		
	} else {
		$rows_discount[] = array(
      array('data' => t('@qty&times;', array('@qty' => $item->qty)), 'class' => 'qty'),
      array('data' => $description, 'class' => 'products'),
      array('data' => uc_price($total, $context), 'class' => 'price'),
	  
    );
		
	}

    $rows = array_merge($rows_nodiscount, (array)$rows_discount);
  }
  
  
  if ($_SESSION['uc_discounts_codes']) {
	 
	  $rows[] = array(
      array('data' => ''),
      array('data' => 'Kód:'. $_SESSION['uc_discounts_code'], 'align' => 'left'),
      array('data' => uc_price('-'.$_SESSION['uc_discounts_code_amount']), 'class' => 'price'),
    );
	  
  }
  $total_discount = $discount_amount + $_SESSION['uc_discounts_code_amount'];
  $subtotal = $subtotal - $total_discount;
  if ($_SESSION['uc_discounts_exists']) {
	  
	  $rows[] = array('data' => array(
      array('data' => '', 'class' => '_hidden'),
      array('data' => 'Spolu vrátane zliav', 'align' => 'left', 'colspan' => '2'),
      array('data' => uc_price($subtotal), 'class' => 'price'),
    ), 'class' => 'b-top');
	  
	  
	 
	  $rows[] = array(
      array('data' => '', 'class' => '_hidden'),
      array('data' => '<small>Uplatnené zľavy</small> <a class="slide-toggle v1"><small>(detail)</small></a><div style="display:none;">Zľavy spolu: '. uc_price($total_discount) .'<div class="uc-discounts-messages-container _alignLeft _cream" id="disc-messages"></div><small>Zľavy sú vypočítavené zo základnej ceny produktu</small></div>', 'align' => 'left', 'colspan' => '3'),
      array('data' => '', 'class' => '_hidden'),
    );
	  
  } else {
	  //normalny subtotal
	  $rows[] = array('data' => array(
      array('data' => '', 'class' => '_hidden'),
      array('data' => 'Spolu', 'align' => 'left', 'colspan' => '2'),
      array('data' => uc_price($subtotal), 'class' => 'price'),
    ), 'class' => 'b-top');
	  
  }
  
 //var_dump($rows);
  /*if ($discount_amount > 0) {
    $rows[] = array(
      array('data' => ''),
      array('data' => t('Discount:'), 'align' => 'right'),
      array('data' => uc_price($discount_amount, $context), 'class' => 'price'),
    );
    $subtotal = $subtotal - $discount_amount;
  }

  // Add the subtotal as the final row.
  if ($show_subtotal) {
    $context = array(
      'revision' => 'themed-original',
      'type' => 'amount',
    );
    $rows[] = array(
      'data' => array(array('data' => '<span id="subtotal-title">' . t('Subtotal:') . '</span> ' . uc_price($subtotal, $context), 'colspan' => 3, 'class' => 'subtotal')),
      'class' => 'subtotal',
    );
  }*/
//zobrate z uc discounts - vyhodeny subtotal a zlava z checkoutu
//var_dump($rows);
  return theme('table', $header, $rows, array('class' => 'cart-review mb-1'));
}

//overridnute html pre vytvaranie formy - porebujem na upravu fieldov v checkoute napr.
function basic_form_element($element, $value) {
//var_dump($element);
  $t = get_t();
  
 $small1 = $small2 = '';
 $textfieldlabel = '';
//  if (!empty($element['#hideformitem'])) {
//	 $small1 = '<small>';
//	 $small2 = '</small>';
//	  $output = '<div ';
//  } else {  
//  $output = '<div class="form-item"';
//  }
  if ($element['#type'] == 'textfield') {
	  $textfieldlabel = 'textfield_label';
	 $small1 = '<small>';
	 $small2 = '</small>';
	  $output = '<div class="textfield_wrapper form-item"';
  } else {  
  $output = '<div class="form-item"';
  }
  if (!empty($element['#id'])) {
    $output .= ' id="' . $element['#id'] . '-wrapper"';
  }
  $output .= ">\n";
  $required = !empty($element['#required']) ? '<span class="form-required" title="' . $t('This field is required.') . '">*</span>' : '';
  if (!empty($element['#title'])) {
    $title = $element['#title'];
    if (!empty($element['#id'])) {
      $output .= ' <label class="field_label ' . $textfieldlabel . '" for="' . $element['#id'] . '">'. $small1 . $t('!title: !required', array(
        '!title' => filter_xss_admin($title),
        '!required' => $required,
      )) . $small2 ."</label>\n";
    }
    else {
      $output .= ' <label>' . $t('!title: !required', array(
        '!title' => filter_xss_admin($title),
        '!required' => $required,
      )) . "</label>\n";
    }
  }
  $output .= " {$value}\n";
  if (!empty($element['#description'])) {
    $output .= ' <div class="description">' . $element['#description'] . "</div>\n";
  }
  $output .= "</div>\n";
  return $output;
}

/**
* Override theming of taxonomy pages
*/
function basic_taxonomy_term_page($tids, $result) {
  drupal_add_css(drupal_get_path('module', 'taxonomy') .'/taxonomy.css');

  $output = '';

  // Only display the description if we have a single term, to avoid clutter and confusion.
  if (count($tids) == 1) {

    $term = taxonomy_get_term($tids[0]);

    /*if ($children = taxonomy_get_children($tids[0])) {
      $output .= '<div class="subterms">';
      // $items = theme('directory_list_subterms', $children);
      foreach ($children as $child) {
        $items[] = l($child->name, "taxonomy/term/$child->tid");      }
      $title = t('Children of !term', array('!term' => $term->name));
      $output .= $title .': '. implode(', ', $items);
      $output .= '</div>';
    }*/

    $description = $term->description;

    // Check that a description is set.
    if (!empty($description)) {
      $output .= '<div class="taxonomy-term-description">';
      $output .= filter_xss_admin($description);
      $output .= '</div>';
    }
  }
// vyhodene lebo pri clankoch ukazovalo ze neobsahuje ziadne prispevky - aj tak to netreba lebo komplet taxonomy su overridnute
 // $output .= taxonomy_render_nodes($result);

  return $output;
}
//overridnute kvoli prepisu html input na button - prepisujem takto addtocartbuttony
function phptemplate_button($element) {
  // Make sure not to overwrite classes.
  if (isset($element['#attributes']['class'])) {
    $element['#attributes']['class'] = 'form-' . $element['#button_type'] . ' ' . $element['#attributes']['class'];
  }
  else {
    $element['#attributes']['class'] = 'form-' . $element['#button_type'];
  }

  if ($element['#button_type'] == 'button') {
    // return a fancy html button.
    return '<button type="' . $element['#type'].'" value="' . $element['#value'] .'" ' . (empty($element['#name']) ? '' : 'name="' . $element['#name'] . '" ') . 'id="' . $element['#id'] . '" ' . drupal_attributes($element['#attributes']) . ">" . (empty($element['#button_html']) ? '' : $element['#button_html']) . ' ' . check_plain($element['#value']) . "</button>\n";
  } else {
    // retain the normal functionality for anything else
    return '<input type="submit" ' . (empty($element['#name']) ? '' : 'name="' . $element['#name'] . '" ') . 'id="' . $element['#id'] . '" value="' . check_plain($element['#value']) . '" ' . drupal_attributes($element['#attributes']) . " />\n";
  }
}