<?php
/**
 * @file views-view-table.tpl.php
 * Template to display a view as a table.
 *
 * - $title : The title of this group of rows.  May be empty.
 * - $rows: An array of row items. Each row is an array of content
 *   keyed by field ID.
 * - $header: an array of headers(labels) for fields.
 * - $themed_rows: a array of rows with themed fields.
 * @ingroup views_templates
 */

// Short tags act bad below in the html so we print it here.
print '<?xml version="1.0" encoding="utf-8" ?>';
?>
<rss version="2.0" xmlns:g="http://base.google.com/ns/1.0">
<channel>
<?php foreach ($themed_rows as $count => $row): ?>
<?php //var_dump($row); ?>
  <item>
<?php foreach ($row as $field => $content): ?>
<?php 
//ID - ak je je farebny produkt - id nebude nid ale napr. model sf01-brown...
if ($field == 'nid' && !empty($row['model'])) {
	$content = preg_replace('/\./','',strtolower($row['model']));
}
//echo $field;
//var_dump($field);

//FARBA tag
if ($field == 'combination' && !empty($content)) {
	$content = preg_replace('/Farba: /','',$content);
	//odstrani newline
	$content = preg_replace( "/\r|\n/", "", $content );
}

//marza - rozdelenie do grup podla marze
if ($field == 'field_marza_value') {
	if ($content <= 15) {
		$content = '0-15';
	} elseif ($content >= 16 && $content <= 30) {
		$content = '16-30';
	} elseif ($content >= 31 && $content <= 40) {
		$content = '31-40';
	} elseif ($content >= 41 && $content <= 50) {
		$content = '41-50';
	} elseif ($content >= 51 && $content <= 60) {
		$content = '51-60';
	} elseif ($content >= 61 && $content <= 70) {
		$content = '61-70';
	} elseif ($content >= 71 && $content <= 80) {
		$content = '71-80';
	}
}

//--------title kombinovany start-----------------//
if ($field == 'field_toptitle_value') {
		if (!empty($content)){
			//vyhodi nazov a vytiahne vsetko za prvym |
			$a1 = strstr($content, '|');
			//vyhodi vsetky | aj s medzerou
			$toptitle = ' ' . preg_replace('/\| /','', $a1);
			//aby nezobrazovalo field
			$content = '';
		}
}
if ($field == 'title') {
	
	// Get the position of last space
	$last_space_position = strrpos($content, ' ');

	// The string without last word
	$text_without_last_word = substr($content, 0, $last_space_position);
	//nie vsetky produkty maju doplneny obsah v nazve, zistujem ktore
	$a2 = substr($content, $last_space_position);
	
	//ak title obsahuje cislo
	if (preg_match('~[0-9]+~', $a2)) {
		$content = $text_without_last_word . $toptitle;
	} else {
		$content . $toptitle;
	}
		
		//reset
		$toptitle = FALSE;
	
	//doplnena farba
	if ($row['combination'] && !empty($row['combination'])) {
		$farba = preg_replace('/Farba: /','',$row['combination']);
		//odstrani newline
		$farba = preg_replace( "/\r|\n/", "", $farba );
		$content = $content . ' ' . $farba;
	}
	
	
}
//-----------title kombinovany end-----------------//


//pojebane preklady do slovenciny a nedaju sa vypnut, treba rucne takto kurrrva

if ($field == 'path'){
	//tu prekladalo 'link' na 'odkaz';
	$xml_tag[$field] = 'link';
	
	//ak atributy - doplnam url o parameter s atributom
	if ($row['combination'] && !empty($row['combination'])) {
		//pouzivam php field na vytiahnutie oid
		$content = $content . '?color=' . $row['php'];		
	}
	
} 
if ($field == 'nothing_1') {$content = 'new';}
//kokot views tu napriklad najebal medzi podciarkovniky nejake divne html a gugl to nechcel zozrat. 2 hodiny vpici.krista
if ($field == 'field_p_pic_more_fid') {$xml_tag[$field] = 'additional_image_link';} 
//availability
$avail_date = FALSE;
if ($field == 'field_avail_date_value') {
	if (!empty($content)){
//echo $content;		
			if (strpos($content, 'x') !== false) {
				$content = 'out of stock';
			} else {
				$avail_date = $content;
				$content = 'preorder';
			}
		} else {
			$content = 'in stock';
		}
}
$dis_expiration = FALSE;
if ($field == 'discounted_price' && !empty($content)) {
	$dis = explode(':', $content);
	$content = $dis[0] .' EUR';
	if ($dis[1]){
		$dis_expiration = $dis[1];
	}
}
//ucinok davam empty a typ spajam s ucinkom
if ($field == 'field_ucinok_nid' || $field == 'field_prekoho_nid') {
	$content = '';
}
if ($field == 'field_typ_nid') {
	$crumb = 'Domov';
	if (!empty($row['field_prekoho_nid'])){
		if (strlen($row['field_prekoho_nid']) < 15) {
			$crumb .= ' > ' . $row['field_prekoho_nid'];
		}
	} 
	if (!empty($content)) {
	$crumb .= ' > ' . $content;	
	}
	$ucinok = explode('#', $row['field_ucinok_nid']);

	if ($ucinok[1]){
		$crumb .= ' > ' . $ucinok[1];
	}
	$content = $crumb;
} 
//GROUP - v pripade farieb SF01-black , necha iba SF01
if ($field == 'model') {
	$content = substr($content, 0, strpos($content, '-'));
}
//skryvam
if ($field == 'php') {
	$content = '';
}


//znacka sa berie z znacka field a ked je prazdny tak sa neukaze a automaticky sa pouziva znackax
?>
<?php if (!empty($content)): ?>
    <<?php print 'g:' . $xml_tag[$field]; ?>><?php print $content; ?></<?php print 'g:' . $xml_tag[$field]; ?>>
<?php if ($avail_date):?>
	<g:availability_date><?php echo $avail_date;?></g:availability_date>
<?php endif;?>
<?php if ($dis_expiration):?>
	<g:sale_price_effective_date><?php echo date("Y-m-d", $dis_expiration); ?></g:sale_price_effective_date>
<?php endif;?>
<?php endif;?>
<?php endforeach;?>
</item>
<?php endforeach; ?>
</channel>
</rss>
