<?php
/**
 * @file views-view.tpl.php
 * Main view template
 *
 * Variables available:
 * - $classes_array: An array of classes determined in
 *   template_preprocess_views_view(). Default classes are:
 *     .view
 *     .view-[css_name]
 *     .view-id-[view_name]
 *     .view-display-id-[display_name]
 *     .view-dom-id-[dom_id]
 * - $classes: A string version of $classes_array for use in the class attribute
 * - $css_name: A css-safe version of the view name.
 * - $css_class: The user-specified classes names, if any
 * - $header: The view header
 * - $footer: The view footer
 * - $rows: The results of the view query, if any
 * - $empty: The empty text to display if the view is empty
 * - $pager: The pager next/prev links to display, if any
 * - $exposed: Exposed widget form/info to display
 * - $feed_icon: Feed icon to display, if any
 * - $more: A link to view more, if any
 * - $admin_links: A rendered list of administrative links
 * - $admin_links_raw: A list of administrative links suitable for theme('links')
 *
 * @ingroup views_templates
 */

?>


<span class="-close" id="modalbox-close">✖</span>
<p style="text-align:center"><strong>A je to v košíku!</strong></p>

<div class="<?php print $classes; ?>">
  <?php if ($admin_links): ?>
    <div class="views-admin-links views-hide">
      <?php print $admin_links; ?>
    </div>
  <?php endif; ?>
  <?php if ($header): ?>
    <div class="view-header">
      <?php print $header; ?>
    </div>
  <?php endif; ?>

  
<?php 
	  $nid = $view->result['0']->nid;
	  $nodetype = $view->result['0']->node_type;
	  ?>
  
 <?php if ($nodetype == 'product' || $nodetype == 'giftbox'): ?>
<div class="modalcart-prod-wrap row">
  <?php // produkt vlozeny do kosika ?>

  <div class="modalcart-img">
	<?php print $view->field['field_p_pic_main_fid_1']->original_value;?>
  </div>
  <div class="modalcart-desc">
	  
	
		<span class="d-block"><strong><?php print $view->field['title']->original_value;?></strong></span>
		 <?php //print ('Cena: ' . $view->field['sell_price']->original_value);?>
		 <span class="akciacena"><?php // print $view->field['field_akcia_cena_value']->original_value;?></span>  
  </div> 
</div>
<?php endif;?>

<?php if ($nodetype == 'product_kit'): ?>
<?php
$kit_products = db_result(db_query("SELECT field_kit_products_value FROM {content_type_product_kit} WHERE nid = '$nid' "));
$cena_spolu = db_result(db_query("SELECT field_kit_cena_spolu_value FROM {content_type_product_kit} WHERE nid = '$nid' "));


//ak kit je spojeny s custom zlavou
if ($kit_products) {

	$products_details = explode(",", $kit_products);

	foreach ($products_details as $details) {
		$i++;
		$prod_data = explode(":", $details);

		$prod_nid = $prod_data[0];
		//potrebujem pre odporucane produkty
		$kit_nids .= $prod_nid . ',';
		
		$qty= $prod_data[1];
                $data = $prod_data[2];

		$product_url = drupal_get_path_alias("node/".$prod_nid);

		$fid = db_result(db_query("SELECT field_p_pic_main_fid FROM {content_field_p_pic_main} WHERE nid = '$prod_nid' "));
		$img = field_file_load($fid);
		//obrazky
		if ($qty > 1) {
			$html .= '<span class="prod-count">'. $qty .'x</span>';
		} 

		$html .= theme("imagecache", "cart", $img[filepath]);

		if ($i < count($products_details)) {
			$html .= '<span class="plus">+</span>';
		}
		//linky pod obrazkami
		$title = db_result(db_query('SELECT n.title FROM {node} n WHERE n.nid = %d', $prod_nid));
		
if ($data) {
$html_data = '(<span class="_f-danger">'.$data.'</span>)';
}
		$linky_html .= '<div>'.$qty.'x ' . $title .' ' . $html_data .'</div>';
		
	}
print $html . $linky_html;
// print ('<strong>Cena spolu: ' . $cena_spolu .' EUR</strong>');

} else {
//ak je to normalny kit
$kit_nid = $nid;
$query = "SELECT product_id,qty FROM {uc_product_kits} WHERE nid = '$kit_nid' ";
$result = db_query($query);

while ($row = $result->fetch_assoc()) {
	$products_details[] = array('nid' => $row['product_id'], 'qty' => $row['qty']);
}

foreach ($products_details as $details) {
$i++;
$nid = $details['nid'];

//potrebujem pre odporucane produkty
$kit_nids .= $nid . ',';

$qty = $details['qty'];
$product_url = drupal_get_path_alias("node/".$nid);

$fid = db_result(db_query("SELECT field_p_pic_main_fid FROM {content_field_p_pic_main} WHERE nid = '$nid' "));
$img = field_file_load($fid);

		//obrazky
		if ($qty > 1) {
			$html .= '<span class="prod-count">'. $qty .'x</span>';
		}
		$html .= theme("imagecache", "cart", $img[filepath]);
		if ($i < count($products_details)) {
			$html .= '<span class="plus">+</span>';
		}
		//linky pod obrazkami
		$title = db_result(db_query('SELECT n.title FROM {node} n WHERE n.nid = %d', $nid));
		
		$linky_html .= '<div>'.$qty.'x '. $title .'</div>';
}
print $html . $linky_html;
//print ('<strong>Cena spolu: ' . $cena_spolu .' EUR</strong>');
}
?>

	
	
	<?php endif; ?>


<div class="popupcartlinks row">
	<div class="_noPadding _floatRight _alignCenter col m6"><a class="popuptocart button d-block btn-loader" href=/cart>Prejsť do košíka ></a></div>
	<div class="_noPadding _floatLeft _alignCenter col m6"><a class="button d-block closemodal" href="#">< Pokračovať v nákupe</a></div>
	
</div>


  
  
<?php



//kontrola ci view je prazdne - zisti ci html obsahuje klasu views-row
$check = views_embed_view('addtocartpopup_odporucane', 'default',  $nid);
if(strpos($check, 'views-field-title') === false){ //view-content nemam na biome.sk tak ako na teste
	?><div class="modalcart-text _alignCenter"><strong>Často kupované spolu:</strong></div><?php
	
	if ($nodetype == 'product_kit') {
		
		$nids = substr($kit_nids, 0, -1);
		
    print views_embed_view('upsell_cart_pairs_popup', 'default',  $nids);} 
	else {
		print views_embed_view('upsell_cart_pairs_popup', 'default',  $nid);
	};
	
	
} else {
	?><div class="modalcart-text _alignCenter"><strong>Odporúčame dokúpiť:</strong></div><?php
	print views_embed_view('addtocartpopup_odporucane', 'default',  $nid);
}

?>


</div> <?php /* class view */ ?>

