<?php
/**
 * @file views-view.tpl.php
 * Main view template
 *
 * Variables available:
 * - $classes_array: An array of classes determined in
 *   template_preprocess_views_view(). Default classes are:
 *     .view
 *     .view-[css_name]
 *     .view-id-[view_name]
 *     .view-display-id-[display_name]
 *     .view-dom-id-[dom_id]
 * - $classes: A string version of $classes_array for use in the class attribute
 * - $css_name: A css-safe version of the view name.
 * - $css_class: The user-specified classes names, if any
 * - $header: The view header
 * - $footer: The view footer
 * - $rows: The results of the view query, if any
 * - $empty: The empty text to display if the view is empty
 * - $pager: The pager next/prev links to display, if any
 * - $exposed: Exposed widget form/info to display
 * - $feed_icon: Feed icon to display, if any
 * - $more: A link to view more, if any
 * - $admin_links: A rendered list of administrative links
 * - $admin_links_raw: A list of administrative links suitable for theme('links')
 *
 * @ingroup views_templates
 */
 //var_dump($rows);
 $view_object_id = 'id'.spl_object_hash($view);
 //ak v argumente najde ciarku - cize je viac produktov + position observer a animacia produktov dolava
 if (strpos($view->args[0], ',') !== false) {
	 //iba zadefinujem 
	 $multi = 1;
 }
?>


<div class="<?php print $classes .' '.$view_object_id; ?>">
  <?php if ($admin_links): ?>
    <div class="views-admin-links views-hide">
      <?php print $admin_links; ?>
    </div>
  <?php endif; ?>
  <?php if ($header): ?>
    <div class="view-header">
      <?php print $header; ?>
    </div>
  <?php endif; ?>


  <div class="amp_storyproduct _alignCenter <?php echo($multi) ? "multi":"single" ;?>">
  <div class="inner mb-1">
  
  <?php if ($multi): ?>
  <amp-position-observer on="enter:carouselTransition<?php echo $view_object_id;?>.start"
      intersection-ratios="0.3"
      layout="nodisplay">
    </amp-position-observer>
	
	<?php endif; ?>
  <?php if ($rows): ?>
   
      <?php print $rows; ?>

  <?php elseif ($empty): ?>
    <div class="view-empty">
      <?php print $empty; ?>
    </div>
  <?php endif; ?>
  
  </div>
  </div>


  <?php if ($footer): ?>
    <div class="view-footer">
      <?php print $footer; ?>
    </div>
  <?php endif; ?>


</div> 

<?php 
if ($multi): ?>


<amp-animation id="carouselTransition<?php echo $view_object_id;?>"
  layout="nodisplay">
  <script type="application/json">
    {
      "duration": "500ms",
      "fill": "both",
      "easing": "ease-in",
      "delay": "200ms",
      "animations": [{
        "selector": ".<?php echo $view_object_id;?> .inner",
        "keyframes": [{
          "transform": "translateX(-60%)"
        }]
      }]
    }
  </script>
</amp-animation>
<?php endif; ?>


