<?php
/**
 * @file views-view.tpl.php
 * Main view template
 *
 * Variables available:
 * - $classes_array: An array of classes determined in
 *   template_preprocess_views_view(). Default classes are:
 *     .view
 *     .view-[css_name]
 *     .view-id-[view_name]
 *     .view-display-id-[display_name]
 *     .view-dom-id-[dom_id]
 * - $classes: A string version of $classes_array for use in the class attribute
 * - $css_name: A css-safe version of the view name.
 * - $css_class: The user-specified classes names, if any
 * - $header: The view header
 * - $footer: The view footer
 * - $rows: The results of the view query, if any
 * - $empty: The empty text to display if the view is empty
 * - $pager: The pager next/prev links to display, if any
 * - $exposed: Exposed widget form/info to display
 * - $feed_icon: Feed icon to display, if any
 * - $more: A link to view more, if any
 * - $admin_links: A rendered list of administrative links
 * - $admin_links_raw: A list of administrative links suitable for theme('links')
 *
 * @ingroup views_templates
 */
?>
<?php $view = views_get_current_view();
  $total_rows = $view->total_rows;
  //var_dump($view);
  ?>
  
<?php if ($total_rows > 1): ?>  
<div class="<?php print $classes . ' ' . $css_class; ?> slider _posRel ">
<?php else: ?>
<div class="<?php print $classes; ?> ">
<?php endif ?>

<div class="pane-title">Súvisiace produkty</div>

  <?php if ($admin_links): ?>
    <div class="views-admin-links views-hide">
      <?php print $admin_links; ?>
    </div>
  <?php endif; ?>
  <?php if ($header): ?>
    <div class="view-header">
      <?php print $header; ?>
    </div>
  <?php endif; ?>

  

  

  
  <?php if ($rows): ?>
  
    <div class="inner">
      <?php print $rows; ?>
    </div>
	
	<?php if ($total_rows > 1): ?>
	<!--<button id="slideback" class="sliderbutton" type="button" style="display:none">&#8249;</button>-->
	<!--<button id="slide" class="sliderbutton" type="button" style="display:none">&#8250;</button>--> 
	<?php endif; ?>
	
	
  <?php elseif ($empty): ?>
    <div class="view-empty">
      <?php print $empty; ?>
    </div>
  <?php endif; ?>

  <?php if ($pager): ?>
    <?php print $pager; ?>
  <?php endif; ?>

  

  <?php if ($more): ?>
    <?php print $more; ?>
  <?php endif; ?>

  <?php if ($footer): ?>
    <div class="view-footer">
      <?php print $footer; ?>
    </div>
  <?php endif; ?>

  

</div> <?php /* class view */ ?>
<script type="text/javascript">
   slider_activate();
   //console.log('template');
</script>