<?php

/**
 * @file views-view-fields.tpl.php
 * Default simple view template to all the fields as a row.
 *
 * - $view: The view in use.
 * - $fields: an array of $field objects. Each one contains:
 *   - $field->content: The output of the field.
 *   - $field->raw: The raw data for the field, if it exists. This is NOT output safe.
 *   - $field->class: The safe class id to use.
 *   - $field->handler: The Views field handler object controlling this field. Do not use
 *     var_export to dump this object, as it can't handle the recursion.
 *   - $field->inline: Whether or not the field should be inline.
 *   - $field->inline_html: either div or span based on the above flag.
 *   - $field->separator: an optional separator that may appear before a field.
 * - $row: The raw result object from the query, with all data it fetched.
 *
 * @ingroup views_templates
 */
 //var_dump($fields);
 
 if (!function_exists('split_title')) {
	
	function split_title($str, $s){
	$a = explode(' #',$str);
	if ($a[1]) {
		return $a[$s];
	} else {return $str;}
	
	}
}
//cena produktu - berie do uvahy aj pripadne zlavy
if (!empty($fields['discounted_price']->content)){
	$dis = explode(':', $fields['discounted_price']->content);
	$product_price = $dis[0];

}else {
	$product_price = $fields['sell_price']->content;
}

?>

<?php 
//--------------------OBRAZOK

$fid = $fields['field_p_pic_main_fid']->raw;
$filepath = db_result(db_query("SELECT filepath FROM {files} WHERE (fid = '$fid') "));
$img_path = str_replace('files','', $filepath);
$img = '/files/imagecache/200' . $img_path;

//----------------DYNAMIC TITLE
$alias = drupal_get_path_alias('node/'. $fields['nid']->content);

//ak je vyplneny dynamic_title. Inak pouzivam normalny title
if (!empty($fields['field_dynamic_title_value']->content)) {

$dynamic_title_all = (explode(",",$fields['field_dynamic_title_value']->content));
//ak je vyplneny aj specialny title - na 5.  mieste (napr. pocas a po tehotenstve)
if ($dynamic_title_all[4]) {
	$spec = $dynamic_title_all[4];
} else {
	$spec='';
}



//ak ucinok v url tak doplnam dynamicky
if ($view->args[1] !== '') {
	// ak x tak sa nevyplna dynamicky ucinok 
	if ($dynamic_title_all[1] === 'x') {
		$dynamic_title = $dynamic_title_all[0] . ' ' . $spec . ' ' . $dynamic_title_all[2];
	//ak bude v ucinku na zaciatku * tak sa dynamicky ucinok nemeni	
	} elseif (strpos($dynamic_title_all[1], '*') === 0) {
		$dynamic_title = $dynamic_title_all[0] . ' ' . ltrim($dynamic_title_all[1], '*') . ' ' . $spec . ' ' . $dynamic_title_all[2];
		//inak pouzijem ucinok z url
	} else {
		$dynamic_title = $dynamic_title_all[0] . ' ' . strtolower(split_title($view->build_info['substitutions']['%2'],0)) . ' ' . $spec . ' ' . $dynamic_title_all[2];
	}

//inak pouzijem ucinok z dynamic_title
} else {
	//ak x tak nepouzijem
	if ($dynamic_title_all[1] === 'x') {
		$dynamic_title = $dynamic_title_all[0] . ' ' . $spec . ' ' . $dynamic_title_all[2];
	//ak bude v ucinku na zaciatku * tak sa dynamicky ucinok nemeni	
	} elseif (strpos($dynamic_title_all[1], '*') === 0) {
		$dynamic_title = $dynamic_title_all[0] . ' ' . ltrim($dynamic_title_all[1], '*') . ' ' . $spec . ' ' . $dynamic_title_all[2];
		//inak pouzijem ucinok z url
	} else {
		
		$dynamic_title = $dynamic_title_all[0] . ' ' . $dynamic_title_all[1] . ' ' . $spec . ' ' . $dynamic_title_all[2];
	}
 
}

//ak pre koho v url, doplnam dynamicky
if ($view->args[2] !== '') {
	// ak je vyplneny 
	if ($dynamic_title_all[3]) {
			//ak je prazdny	
		if ($dynamic_title_all[3] === '') {
		
			$dynamic_title .= ' ' . strtolower($view->build_info['substitutions']['%3']);	
		
		} 
		elseif ($dynamic_title_all[3] == 'x') { 
		
			$dynamic_title .= '';	
		
		}		
		else {
			
			$dynamic_title .= ' ' . strtolower($dynamic_title_all[3]);
					
		}
		
	} else {
		
		//ak nie je vyplneny, vyplni sa dynamicky
		$dynamic_title .= ' ' . strtolower($view->build_info['substitutions']['%3']);
	}
} else {
	//ak pre koho nie je v url ale chcem aj tak zobrazit u tych ktore to musia mat v nazve (sampon foligain pre zeny atd)
	if (($dynamic_title_all[3]) && ($dynamic_title_all[3] !== '') &&  ($dynamic_title_all[3] != 'x')) {
		$dynamic_title .= ' ' . $dynamic_title_all[3];
	}
	$dynamic_title .= '';
}
} else {
	$dynamic_title = $fields['title']->raw;
}

//---------------------- DESCRIPTION

//ak je v url ucinok
if ($view->args[1] !== '') {
	$current_ucinok_nid = $view->args[1];
	$prod_nid = $fields['nid']->content;	
	$dynamic_desc = db_result(db_query("SELECT nid FROM {content_type_produkt_ucinok} WHERE (field_ucinok_prod_nid = '$prod_nid') AND (field_ucinok_typ_ref_nid = '$current_ucinok_nid') "));
	
	if ($dynamic_desc) {
		$description_full = db_result(db_query("SELECT body FROM {node_revisions} WHERE nid = '$dynamic_desc' "));
		//rozdelujem popis
		$description_parts = explode("##", $description_full);
		$description = $description_parts[0];
	} else {
		$description = $fields['field_desc_short_tax_value']->content;
	}
	
} else {
	$description = $fields['field_desc_short_tax_value']->content;
}

//-------------AKO DOKAZE POMOCT

//ak ucinok v url ukazem linku, inak zobrazim iba short popis
if ($view->args[1] !== '') {
	$ako_link = '<a id="modal-inline-wrap-'. $fields['nid']->content . '" class="">Ako mi pomôže ' . strtolower(split_title($view->build_info['substitutions']['%2'],0)) . ' ?</a>';

}

//---------------- REVIEWS
preg_match('/(.*)-(.*)/', $fields['field_hodnotenie_value']->content, $matches);
?>







<div class="rev">
<div class="star_five">
	<div class="star_empty">
		<span><i class="material-icons">star_border</i></span>
		<span><i class="material-icons">star_border</i></span>
		<span><i class="material-icons">star_border</i></span>
		<span><i class="material-icons">star_border</i></span>
		<span><i class="material-icons">star_border</i></span>
	</div>
	<div class="star_full" style="width:<?php echo $matches[1]*20;?>%">
		<span><i class="material-icons">star</i></span>
		<span><i class="material-icons">star</i></span>
		<span><i class="material-icons">star</i></span>
		<span><i class="material-icons">star</i></span>
		<span><i class="material-icons">star</i></span>
	</div>
	</div>
	<?php 
		if ($matches[2] == 1) {$sklonovanie = 'hodnotenie';};
		if ($matches[2] >= 2 && $matches[2] <= 4) {$sklonovanie = 'hodnotenia';};
		if ($matches[2] > 4) {$sklonovanie = 'hodnotení';};

		//zobraz text iba ak je pocet hodnoteni aj priemer viac ako 0
		if ($matches[2] > 0 && $matches[1] > 0) {
		//echo '<span><a class="get-prod-info" id="' . $fields['nid']->content . '-reviews">'.$matches[2] . ' ' . $sklonovanie.'</a></span>';
		echo '<span><a class="slidepanel get-prod-info ' . $fields['nid']->content . '-reviews" data="navdrill-right-col-m10-d7" href="">'.$matches[2] . ' ' . $sklonovanie.'</a></span>';
		};
	?>
	</div>
	<div class="tax-prod-pic">
	<?php if ($fields['field_flags_value']->content): ?>
			<div class="flags _posAbs _alignLeft">
			<?php echo flag_format($fields['field_flags_value']->content); ?> 
			</div>
		<?php endif; ?>
	<a href="<?php echo $fields['path']->content; ?>">
	<div class="cntr" style="max-width:200px">
	<div class="responsively-lazy linear-background" style="padding-bottom:100%;">
		<img     
			src="<?php echo $img; ?>"
			srcset="data:image/gif;base64,R0lGODlhAQABAIAAAP///////yH5BAEKAAEALAAAAAABAAEAAAICTAEAOw=="
		 data-srcset="<?php echo $img; ?>"
		/>

	</div>
	</div>
	</a>
</div>

<div class="">
	<div class="help-top"></div>
	<div class="help-akcia"></div>



	<div class="tax-prod-info _alignLeft">
	<div class="prodlist-title"><?php echo '<a href="/'. $alias .'" title="'. $dynamic_title .'">'.$dynamic_title.'</a>'; ?></div>
	
	
	
	<?php // modal popis
		if ($description_parts[1]): ?>
	<?php echo '<div>'. $ako_link . '</div>'; ?>
	<div class="_hidden">
		 <div id="wrap-<?php echo $fields['nid']->content; ?>">
		 <div>
		 <?php echo '<h2 class="_alignCenter">' . $dynamic_title . '</br>Ako mi pomôže ' . strtolower(split_title($view->build_info['substitutions']['%2'],0)) . ' ?</h2>'; ?>
			<div><?php echo $description_parts[1]; ?></div>
			<?php  echo $fields['addtocartlink']->content; ?>
			
			<?php if ($is_admin): ?>
			<?php echo '<a class="button" target="_blank" href="/node/' . $dynamic_desc . '/edit">Edituj</a>'; ?>
			<?php endif; ?>
			</div>
		  </div>
	</div>
	<?php endif; ?>
	
<?php
	//vypocitava zlavnenu cenu kazdeho produktu
	//toto teraz neplati - vytvaram akoze produkt array - nastastie tato funkcia potrebuje iba sell price, inak by som musel nahravat celu node
	//$product = array();
	//$product['sell_price'] = 	
	
	if (!empty($fields['discounted_price']->content)): ?>
		<?php $dis = explode(':', $fields['discounted_price']->content);?>
		<div class="prodlist-ceny">
		<span class="m_price"><strong><span class="_f-danger">AKCIA!:</span> <del class="_f-danger"><?php echo sell_price_formatted($fields['sell_price']->content);?> EUR</del> <span class="sellprice"><?php echo sell_price_formatted($dis[0]);?> EUR</span></span></strong> <small><?php echo strip_tags($fields['field_dlzka_liecby_value']->content); ?></small> 
		</div>
	<?php else: ?> 
	<div class="prodlist-ceny">
	<span class="bezna"><?php echo $fields['field_bezna_cena_value']->content; ?></span>
	<span class="vasacena"><strong><?php echo $fields['sell_price']->content; ?></strong></span>
	<small><?php echo strip_tags($fields['field_dlzka_liecby_value']->content); ?></small>
	<div class="prodlist-akciacena"><span class="akciacena"><?php //echo strip_tags($fields['field_akcia_cena_value']->content); ?></span></div>
	</div>
	<?php endif; ?>
	
	


	<div class="prodlist-desc"><?php echo $description; ?></div>
	
	<small><?php echo dostupnost($fields['field_avail_date_value']->content); ?></small>
	
	<?php
		//doplnenie slova liek pre kategorie s ucinkom proti vyadavaniu vlasov
		
		if ($view->args[1] == '1753') {
		echo '<small>Liek bez receptu</small>';
		};
	?>
	</div>
	
	
	
	<?php //echo '<small>Účinok: '. str_replace("</span>","</span>, ",str_replace("div","span",$fields['field_ucinok_nid']->content)) . '</small>'; ?>
	
	<?php  $addtocart =  $fields['addtocartlink']->content; 
	//ak existuju atributy
	$attributes = FALSE;
	if (strpos($addtocart, 'attributes') !== FALSE) {
		$attributes = TRUE;
		echo '<div><a class="btn-color-1 button adt-open">Vybrať</a></div>';
	} else {
		echo $addtocart;
	}	
	
	?>	
	
	<?php
	//naspodu vyplujem addtocart formu ak atributy existuju
	if ($attributes) {
		echo '<div class="add-to-cart hasattribute col"><div class="button close">✖</div>';
		echo $addtocart;
		echo '</div>';
	}
	
	?>
	
</div>

